﻿using System;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using libSnesAssembler;
using libZh.My;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using SnesPatcher.My;

namespace libZh
{
	// Token: 0x020000DA RID: 218
	[StandardModule]
	public sealed class modCommonDebug
	{
		// Token: 0x1700016C RID: 364
		// (get) Token: 0x06000610 RID: 1552 RVA: 0x000055EB File Offset: 0x000037EB
		// (set) Token: 0x06000611 RID: 1553 RVA: 0x000055F7 File Offset: 0x000037F7
		public static frmDebugOut form_debug { get; [MethodImpl(MethodImplOptions.Synchronized)] set; } = null;

		// Token: 0x06000612 RID: 1554 RVA: 0x0001E730 File Offset: 0x0001C930
		public static frmDebugOut _dbgWin_new()
		{
			frmDebugOut frmDebugOut = new frmDebugOut();
			frmDebugOut.Show();
			return frmDebugOut;
		}

		// Token: 0x06000613 RID: 1555 RVA: 0x0001E754 File Offset: 0x0001C954
		public static void _dbgWin_print(frmDebugOut formDbg, string sTxt)
		{
			bool flag = formDbg != null;
			if (flag)
			{
				formDbg.txtDebug.AppendText(sTxt);
			}
		}

		// Token: 0x06000614 RID: 1556 RVA: 0x0001E754 File Offset: 0x0001C954
		public static void _dbgWin_clear(frmDebugOut formDbg, string sTxt)
		{
			bool flag = formDbg != null;
			if (flag)
			{
				formDbg.txtDebug.AppendText(sTxt);
			}
		}

		// Token: 0x06000615 RID: 1557 RVA: 0x0001E77C File Offset: 0x0001C97C
		public static void _dbgWin_destroy(frmDebugOut formDbg)
		{
			bool flag = formDbg != null;
			if (flag)
			{
				formDbg.Dispose();
				formDbg = null;
			}
		}

		// Token: 0x06000616 RID: 1558 RVA: 0x0001E7A4 File Offset: 0x0001C9A4
		public static void _debugShow()
		{
			bool flag = modCommonDebug.form_debug == null || modCommonDebug.form_debug.IsDisposed;
			if (flag)
			{
				modCommonDebug.form_debug = new frmDebugOut();
			}
			modCommonDebug.form_debug.Show();
		}

		// Token: 0x06000617 RID: 1559 RVA: 0x0001E7EC File Offset: 0x0001C9EC
		public static void _debugPrint(string sMsg)
		{
			bool visible = modCommonDebug.form_debug.Visible;
			if (visible)
			{
				modCommonDebug.form_debug.txtDebug.AppendText(sMsg);
			}
		}

		// Token: 0x06000618 RID: 1560 RVA: 0x0001E820 File Offset: 0x0001CA20
		public static void _debugClear()
		{
			bool visible = modCommonDebug.form_debug.Visible;
			if (visible)
			{
				modCommonDebug.form_debug.txtDebug.Text = "";
			}
		}

		// Token: 0x06000619 RID: 1561 RVA: 0x0001E858 File Offset: 0x0001CA58
		public static void _debugShowLog()
		{
			frmDebugOut frmDebugOut = new frmDebugOut();
			try
			{
				frmDebugOut.txtDebug.Text = libZh.My.MyProject.Computer.FileSystem.ReadAllText(MyApplicationRoot.outputLog);
				frmDebugOut.txtDebug.SelectionLength = 0;
				frmDebugOut.txtDebug.SelectionStart = 0;
				frmDebugOut.WindowState = FormWindowState.Maximized;
				frmDebugOut.ShowDialog();
			}
			catch (Exception ex)
			{
				Interaction.MsgBox("Couldn't open the debug log:\r\n\r\n" + ex.Message, MsgBoxStyle.OkOnly, null);
			}
		}

		// Token: 0x0600061A RID: 1562 RVA: 0x0001E8E0 File Offset: 0x0001CAE0
		public static void _debugDialog(string sTxt)
		{
			frmDebugOut frmDebugOut = new frmDebugOut();
			try
			{
				TextBox txtDebug = frmDebugOut.txtDebug;
				txtDebug.Text = sTxt;
				txtDebug.SelectionLength = 0;
				txtDebug.SelectionStart = 0;
				frmDebugOut.ShowDialog();
			}
			catch (Exception ex)
			{
				Interaction.MsgBox("Couldn't open the debug dialog:\r\n\r\n" + ex.Message, MsgBoxStyle.OkOnly, null);
			}
		}

		// Token: 0x0600061B RID: 1563 RVA: 0x000055FF File Offset: 0x000037FF
		public static void _debugPause()
		{
			modCommonDebug._bDebugPaused = true;
		}

		// Token: 0x0600061C RID: 1564 RVA: 0x0000560D File Offset: 0x0000380D
		public static void _debugResume()
		{
			modCommonDebug._bDebugPaused = false;
		}

		// Token: 0x0600061D RID: 1565 RVA: 0x0000561B File Offset: 0x0000381B
		public static void _debugStart()
		{
			modCommonDebug._bPrintDebug = true;
			modCommonDebug._bDebugPaused = false;
			libZh.My.MyProject.Computer.FileSystem.WriteAllText(MyApplicationRoot.outputLog, "", false);
		}

		// Token: 0x0600061E RID: 1566 RVA: 0x0000564D File Offset: 0x0000384D
		public static void _debugStop()
		{
			modCommonDebug._bPrintDebug = false;
			modCommonDebug._bDebugPaused = true;
		}

		// Token: 0x0600061F RID: 1567 RVA: 0x0001E960 File Offset: 0x0001CB60
		public static void _debugWrite(string sMsg)
		{
			if (Conversions.ToBoolean(Operators.AndObject(modCommonDebug._bPrintDebug, Operators.NotObject(modCommonDebug._bDebugPaused))))
			{
				object counter = 0;
				object loopObj = 0;
				if (compiler.offset != 12582912 && compiler.offset != 16777216)
				{
					libZh.My.MyProject.Computer.FileSystem.WriteAllText(MyApplicationRoot.outputLog, string.Format("${0:X6}\t", compiler.offset), true);
				}
				if (ObjectFlowControl.ForLoopControl.ForLoopInitObj(counter, 0, Operators.SubtractObject(modCommonDebug._debugIndent, 1), 1, ref loopObj, ref counter))
				{
					do
					{
						libZh.My.MyProject.Computer.FileSystem.WriteAllText(MyApplicationRoot.outputLog, "\t", true);
					}
					while (ObjectFlowControl.ForLoopControl.ForNextCheckObj(counter, loopObj, ref counter));
				}
				libZh.My.MyProject.Computer.FileSystem.WriteAllText(MyApplicationRoot.outputLog, sMsg.Trim(Environment.NewLine.ToCharArray()) + "\r\n", true);
			}
		}

		// Token: 0x06000620 RID: 1568 RVA: 0x0001EA58 File Offset: 0x0001CC58
		public static void _debugSectionStart(string sSection)
		{
			modCommonDebug._debugWrite("| " + sSection);
			modCommonDebug._debugWrite("-------------------------------------------------");
			bool flag = Conversions.ToBoolean(modCommonDebug._bPrintDebug);
			if (flag)
			{
				modCommonDebug._debugIndent = Operators.AddObject(modCommonDebug._debugIndent, 1);
			}
		}

		// Token: 0x06000621 RID: 1569 RVA: 0x0001EAAC File Offset: 0x0001CCAC
		public static void _debugSectionEnd()
		{
			bool flag = Conversions.ToBoolean(modCommonDebug._bPrintDebug);
			if (flag)
			{
				modCommonDebug._debugIndent = Operators.SubtractObject(modCommonDebug._debugIndent, 1);
				bool flag2 = Operators.ConditionalCompareObjectLess(modCommonDebug._debugIndent, 0, false);
				if (flag2)
				{
					modCommonDebug._debugIndent = 0;
				}
			}
			modCommonDebug._debugWrite("-------------------------------------------------");
		}

		// Token: 0x04000B9E RID: 2974
		public static object _bPrintDebug = false;

		// Token: 0x04000B9F RID: 2975
		public static object _bDebugPaused = false;

		// Token: 0x04000BA0 RID: 2976
		public static object _debugIndent = 0;
	}
}
