﻿using System;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;
using SnesPatcher;
using SnesPatcher.My;

namespace libZh
{
	// Token: 0x020000D5 RID: 213
	[DesignerGenerated]
	public partial class frmLoadBarForm : Form
	{
		// Token: 0x060005EC RID: 1516 RVA: 0x0001DEC8 File Offset: 0x0001C0C8
		public frmLoadBarForm()
		{
			base.Load += this.frmLoadBarForm_Load;
			base.Click += this.frmLoadBarForm_Click;
			this.formParent = frmSnesPatcher.instance;
			this.colLoadBars = new Collection<ctrFancyLoading>();
			this.bFinished = false;
			this.InitializeComponent();
		}

		// Token: 0x060005EF RID: 1519 RVA: 0x00004CB2 File Offset: 0x00002EB2
		private void frmLoadBarForm_Load(object sender, EventArgs e)
		{
		}

		// Token: 0x060005F0 RID: 1520 RVA: 0x0001E014 File Offset: 0x0001C214
		public ctrFancyLoading addLoadBar(int _iProgressTotal, bool bShowProgressUnits = false, Color color1 = default(Color))
		{
			ctrFancyLoading ctrFancyLoading = new ctrFancyLoading(_iProgressTotal, bShowProgressUnits, color1);
			this.colLoadBars.Add(ctrFancyLoading);
			base.Controls.Add(ctrFancyLoading);
			this.updateLoadBars();
			ctrFancyLoading.UpdateForegroundImage();
			return ctrFancyLoading;
		}

		// Token: 0x060005F1 RID: 1521 RVA: 0x0001E050 File Offset: 0x0001C250
		public ctrFancyLoading addLoadBar(int _iProgressTotal, Color _color1, Color _color2, bool bShowProgressUnits = false)
		{
			ctrFancyLoading ctrFancyLoading = new ctrFancyLoading(_iProgressTotal, _color1, _color2, bShowProgressUnits);
			this.colLoadBars.Add(ctrFancyLoading);
			base.Controls.Add(ctrFancyLoading);
			this.updateLoadBars();
			ctrFancyLoading.UpdateForegroundImage();
			ctrFancyLoading.Click += this.frmLoadBarForm_Click;
			return ctrFancyLoading;
		}

		// Token: 0x060005F2 RID: 1522 RVA: 0x0001E0A0 File Offset: 0x0001C2A0
		public void clearLoadBars()
		{
			this.bFinished = false;
			for (;;)
			{
				bool flag = this.colLoadBars.Count == 0;
				if (flag)
				{
					break;
				}
				ctrFancyLoading ctrFancyLoading = this.colLoadBars.First<ctrFancyLoading>();
				this.colLoadBars.Remove(ctrFancyLoading);
				base.Controls.Remove(ctrFancyLoading);
			}
			this.updateLoadBars();
		}

		// Token: 0x060005F3 RID: 1523 RVA: 0x0001E0FC File Offset: 0x0001C2FC
		public object removeLoadBar(ctrFancyLoading lBar)
		{
			this.colLoadBars.Remove(lBar);
			base.Controls.Remove(lBar);
			this.updateLoadBars();
			object result;
			return result;
		}

		// Token: 0x060005F4 RID: 1524 RVA: 0x0001E12C File Offset: 0x0001C32C
		private void updateLoadBars()
		{
			if (this.colLoadBars.Count > 0)
			{
				if (!base.Visible)
				{
					base.Show();
				}
				this.updateLoc();
			}
			else if (base.Visible)
			{
				base.Hide();
			}
			checked
			{
				for (int i = 0; i < this.colLoadBars.Count; i++)
				{
					this.colLoadBars[i].Top = 2 + i * 27;
					this.colLoadBars[i].Left = 2;
					this.colLoadBars[i].Height = 25;
				}
				base.Height = this.colLoadBars.Count * 27 + 2;
				this.MaximumSize = this.DefaultMaximumSize;
				this.MinimumSize = this.DefaultMinimumSize;
				this.updateLoc();
				this.MaximumSize = base.Size;
				this.MinimumSize = base.Size;
			}
		}

		// Token: 0x060005F5 RID: 1525 RVA: 0x0001E20C File Offset: 0x0001C40C
		private void updateLoc()
		{
			if (this.formParent != null)
			{
				base.ClientSize = new Size(this.formParent.ClientSize.Width, base.ClientSize.Height + (MyApplicationRoot.isRunningOnMono ? 6 : 0));
				base.Location = this.formParent.Location + new Size((this.formParent.Size.Width - base.Size.Width) / 2 - (MyApplicationRoot.isRunningOnMono ? 1 : 0), (this.formParent.Size.Height - base.Size.Height) / 2);
				for (int i = 0; i < this.colLoadBars.Count; i++)
				{
					this.colLoadBars[i].Width = base.Size.Width - (MyApplicationRoot.isRunningOnMono ? 10 : 4);
				}
			}
			this.Refresh();
		}

		// Token: 0x060005F6 RID: 1526 RVA: 0x0000551D File Offset: 0x0000371D
		public void finished()
		{
			this.bFinished = true;
			this.clearLoadBars();
		}

		// Token: 0x060005F7 RID: 1527 RVA: 0x0001E314 File Offset: 0x0001C514
		private void frmLoadBarForm_Click(object sender, EventArgs e)
		{
			bool flag = this.bFinished;
			if (flag)
			{
				this.clearLoadBars();
			}
		}

		// Token: 0x04000B96 RID: 2966
		public Form formParent;

		// Token: 0x04000B97 RID: 2967
		private const int const_loadBarHeight = 24;

		// Token: 0x04000B98 RID: 2968
		public Collection<ctrFancyLoading> colLoadBars;

		// Token: 0x04000B99 RID: 2969
		private bool bFinished;
	}
}
