﻿using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;
using SnesPatcher.My;

namespace libZh
{
	// Token: 0x020000D4 RID: 212
	[DesignerGenerated]
	public class ctrFancyLoading : UserControl
	{
		// Token: 0x060005CE RID: 1486 RVA: 0x0001D404 File Offset: 0x0001B604
		[DebuggerNonUserCode]
		protected override void Dispose(bool disposing)
		{
			try
			{
				bool flag = disposing && this.components != null;
				if (flag)
				{
					this.components.Dispose();
				}
			}
			finally
			{
				base.Dispose(disposing);
			}
		}

		// Token: 0x060005CF RID: 1487 RVA: 0x0001D460 File Offset: 0x0001B660
		[DebuggerStepThrough]
		private void InitializeComponent()
		{
			this.pnlBarForeground = new OutlinedPanel(this.color1, 1f);
			this.pnlBar = new Panel();
			this.lblProgress = new Label();
			this.lblLabel = new Label();
			this.lblPercentForeground = new OutlinedLabel();
			this.lblPercent = new OutlinedLabel();
			base.SuspendLayout();
			this.pnlBar.Anchor = (AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right);
			this.pnlBar.BackColor = Color.FromArgb(92, 92, 92);
			this.pnlBar.BorderStyle = BorderStyle.FixedSingle;
			this.pnlBar.Location = new Point(134, 2);
			this.pnlBar.Name = "pnlBar";
			this.pnlBar.Size = new Size(314, 19);
			this.pnlBar.TabIndex = 0;
			this.pnlBarForeground.Anchor = (AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right);
			this.pnlBarForeground.BackColor = this.color2;
			this.pnlBarForeground.BorderStyle = BorderStyle.None;
			this.pnlBarForeground.Location = new Point(0, 0);
			this.pnlBarForeground.Name = "pnlBarForeground";
			this.pnlBarForeground.Size = new Size(2, 19);
			this.pnlBarForeground.Visible = false;
			this.lblProgress.Anchor = (AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Right);
			this.lblProgress.BackColor = Color.FromArgb(48, 48, 48);
			this.lblProgress.BorderStyle = BorderStyle.FixedSingle;
			this.lblProgress.Font = new Font("Microsoft Sans Serif", 8.25f, FontStyle.Regular, GraphicsUnit.Point, 0);
			this.lblProgress.ForeColor = Color.White;
			this.lblProgress.Location = new Point(450, 2);
			this.lblProgress.Name = "lblProgress";
			this.lblProgress.Size = new Size(101, 19);
			this.lblProgress.TabIndex = 1;
			this.lblProgress.Text = " 1 / 3";
			this.lblProgress.TextAlign = ContentAlignment.MiddleCenter;
			this.lblLabel.Anchor = (AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left);
			this.lblLabel.BackColor = Color.FromArgb(48, 48, 48);
			this.lblLabel.BorderStyle = BorderStyle.FixedSingle;
			this.lblLabel.Font = new Font("Microsoft Sans Serif", 8.25f, FontStyle.Regular, GraphicsUnit.Point, 0);
			this.lblLabel.ForeColor = Color.White;
			this.lblLabel.Location = new Point(2, 2);
			this.lblLabel.Name = "lblLabel";
			this.lblLabel.Size = new Size(130, 19);
			this.lblLabel.TabIndex = 2;
			this.lblLabel.Text = "Working...";
			this.lblLabel.TextAlign = ContentAlignment.MiddleCenter;
			this.lblPercent.BackColor = Color.Transparent;
			this.lblPercent.Font = new Font("Consolas", 12f, FontStyle.Regular);
			this.lblPercent.ForeColor = Color.White;
			this.lblPercent.Location = new Point(0, 0);
			this.lblPercent.Name = "lblPercent";
			this.lblPercent.Size = new Size(0, 0);
			this.lblPercent.Text = string.Empty;
			this.lblPercentForeground.BackColor = Color.Transparent;
			this.lblPercentForeground.Font = new Font("Consolas", 12f, FontStyle.Regular);
			this.lblPercentForeground.ForeColor = Color.White;
			this.lblPercentForeground.Location = new Point(0, 0);
			this.lblPercentForeground.Name = "lblPercentForeground";
			this.lblPercentForeground.Size = new Size(0, 0);
			this.lblPercentForeground.Text = string.Empty;
			base.AutoScaleMode = AutoScaleMode.None;
			this.BackColor = (MyApplicationRoot.isRunningOnMono ? Color.FromArgb(64, 64, 64) : Color.Black);
			base.BorderStyle = BorderStyle.FixedSingle;
			base.Controls.Add(this.lblLabel);
			base.Controls.Add(this.lblProgress);
			this.pnlBarForeground.Controls.Add(this.lblPercentForeground);
			this.pnlBar.Controls.Add(this.pnlBarForeground);
			this.pnlBar.Controls.Add(this.lblPercent);
			base.Controls.Add(this.pnlBar);
			this.Cursor = Cursors.WaitCursor;
			base.Name = "ctrFancyLoading";
			base.Size = new Size(555, 25);
			base.ResumeLayout(false);
		}

		// Token: 0x17000162 RID: 354
		// (get) Token: 0x060005D0 RID: 1488 RVA: 0x000054C9 File Offset: 0x000036C9
		// (set) Token: 0x060005D1 RID: 1489 RVA: 0x0001D8F0 File Offset: 0x0001BAF0
		internal virtual Panel pnlBar
		{
			[CompilerGenerated]
			get
			{
				return this._pnlBar;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				PaintEventHandler value2 = new PaintEventHandler(this.pnlBar_Paint);
				Panel pnlBar = this._pnlBar;
				if (pnlBar != null)
				{
					pnlBar.Paint -= value2;
				}
				this._pnlBar = value;
				pnlBar = this._pnlBar;
				if (pnlBar != null)
				{
					pnlBar.Paint += value2;
				}
			}
		}

		// Token: 0x17000163 RID: 355
		// (get) Token: 0x060005D2 RID: 1490 RVA: 0x000054D1 File Offset: 0x000036D1
		// (set) Token: 0x060005D3 RID: 1491 RVA: 0x0001D934 File Offset: 0x0001BB34
		internal virtual Label lblProgress
		{
			[CompilerGenerated]
			get
			{
				return this._lblProgress;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.lblProgress_Click);
				Label lblProgress = this._lblProgress;
				if (lblProgress != null)
				{
					lblProgress.Click -= value2;
				}
				this._lblProgress = value;
				lblProgress = this._lblProgress;
				if (lblProgress != null)
				{
					lblProgress.Click += value2;
				}
			}
		}

		// Token: 0x17000164 RID: 356
		// (get) Token: 0x060005D4 RID: 1492 RVA: 0x000054DE File Offset: 0x000036DE
		// (set) Token: 0x060005D5 RID: 1493 RVA: 0x0001D980 File Offset: 0x0001BB80
		internal virtual Label lblLabel
		{
			[CompilerGenerated]
			get
			{
				return this._lblLabel;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.lblLabel_Click);
				Label lblLabel = this._lblLabel;
				if (lblLabel != null)
				{
					lblLabel.Click -= value2;
				}
				this._lblLabel = value;
				lblLabel = this._lblLabel;
				if (lblLabel != null)
				{
					lblLabel.Click += value2;
				}
			}
		}

		// Token: 0x17000165 RID: 357
		// (get) Token: 0x060005D6 RID: 1494 RVA: 0x0001D9CC File Offset: 0x0001BBCC
		// (set) Token: 0x060005D7 RID: 1495 RVA: 0x000054EB File Offset: 0x000036EB
		public string sLabel
		{
			get
			{
				return this.lblLabel.Text;
			}
			set
			{
				this.lblLabel.Text = value;
			}
		}

		// Token: 0x17000166 RID: 358
		// (get) Token: 0x060005D9 RID: 1497 RVA: 0x0001DA2C File Offset: 0x0001BC2C
		// (set) Token: 0x060005D8 RID: 1496 RVA: 0x0001D9EC File Offset: 0x0001BBEC
		public int Progress
		{
			get
			{
				return this.iProgress;
			}
			set
			{
				this.iProgress = value;
				bool flag = this.iProgress > this.iProgressTotal;
				if (flag)
				{
					this.iProgress = this.iProgressTotal;
				}
				this.updateGfx();
			}
		}

		// Token: 0x17000167 RID: 359
		// (get) Token: 0x060005DB RID: 1499 RVA: 0x0001DA48 File Offset: 0x0001BC48
		// (set) Token: 0x060005DA RID: 1498 RVA: 0x000054FB File Offset: 0x000036FB
		public int ProgressTotal
		{
			get
			{
				return this.iProgressTotal;
			}
			set
			{
				this.iProgressTotal = value;
			}
		}

		// Token: 0x060005DC RID: 1500 RVA: 0x0001DA64 File Offset: 0x0001BC64
		private void updateGfx()
		{
			float num = (float)((double)this.iProgress / (double)this.iProgressTotal);
			int value = checked((int)Math.Round(Math.Floor((double)(unchecked(num * 100f)))));
			this.pnlBarForeground.Visible = true;
			int width = (int)((float)this.pnlBar.ClientSize.Width * num);
			int width2 = this.pnlBarForeground.Width;
			this.pnlBarForeground.Size = new Size(width, this.pnlBar.ClientSize.Height);
			Font font = new Font("Consolas", 12f, FontStyle.Regular);
			string text = Conversions.ToString(value) + " %";
			Size size = TextRenderer.MeasureText(text, font);
			Point location = checked(new Point((int)Math.Round((double)(this.pnlBar.ClientSize.Width - size.Width) / 2.0), (int)Math.Round((double)(this.pnlBar.ClientSize.Height - size.Height) / 2.0)));
			this.lblProgress.Text = Conversions.ToString(this.iProgress) + " / " + Conversions.ToString(this.iProgressTotal);
			this.lblPercent.Text = text;
			this.lblPercent.Size = size;
			this.lblPercent.Location = location;
			this.lblPercentForeground.Text = text;
			this.lblPercentForeground.Size = size;
			this.lblPercentForeground.Location = location;
			this.pnlBarForeground.Invalidate(new Rectangle(width2 - 1, 0, 1, this.pnlBarForeground.Height), false);
			this.pnlBarForeground.Update();
		}

		// Token: 0x060005DD RID: 1501 RVA: 0x0001DC20 File Offset: 0x0001BE20
		public ctrFancyLoading(int _iProgressTotal, Color _color1, Color _color2, bool bShowProgressUnits = false)
		{
			this.iProgress = 0;
			this.iProgressTotal = 100;
			this.iSel = 0;
			this.bShowLabel = false;
			this.color1 = _color1;
			this.color2 = _color2;
			this.iProgressTotal = _iProgressTotal;
			this.InitializeComponent();
			if (!bShowProgressUnits)
			{
				this.lblProgress.Visible = false;
			}
		}

		// Token: 0x060005DE RID: 1502 RVA: 0x0001DC7C File Offset: 0x0001BE7C
		public ctrFancyLoading(int _iProgressTotal, bool bShowProgressUnits = false, Color _color1 = default(Color))
		{
			this.iProgress = 0;
			this.iProgressTotal = 100;
			this.iSel = 0;
			this.bShowLabel = false;
			if (_color1 == default(Color))
			{
				_color1 = Color.DarkSlateBlue;
			}
			this.color1 = _color1;
			this.color2 = Color.FromArgb(checked(_color1.ToArgb() - 2105376));
			this.iProgressTotal = _iProgressTotal;
			this.InitializeComponent();
			if (!bShowProgressUnits)
			{
				this.lblProgress.Visible = false;
			}
		}

		// Token: 0x060005DF RID: 1503 RVA: 0x00004CB2 File Offset: 0x00002EB2
		private void lblProgress_Click(object sender, EventArgs e)
		{
		}

		// Token: 0x060005E0 RID: 1504 RVA: 0x00002C0C File Offset: 0x00000E0C
		private void lblLabel_Click(object sender, EventArgs e)
		{
		}

		// Token: 0x060005E1 RID: 1505 RVA: 0x00002C0C File Offset: 0x00000E0C
		private void pnlBar_Paint(object sender, PaintEventArgs e)
		{
		}

		// Token: 0x060005E2 RID: 1506 RVA: 0x00002C0C File Offset: 0x00000E0C
		private void pnlBarForeground_Paint(object sender, PaintEventArgs e)
		{
		}

		// Token: 0x17000168 RID: 360
		// (get) Token: 0x060005E3 RID: 1507 RVA: 0x00005505 File Offset: 0x00003705
		// (set) Token: 0x060005E4 RID: 1508 RVA: 0x0001DD00 File Offset: 0x0001BF00
		internal virtual OutlinedPanel pnlBarForeground
		{
			[CompilerGenerated]
			get
			{
				return this._pnlBarForeground;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				PaintEventHandler value2 = new PaintEventHandler(this.pnlBarForeground_Paint);
				OutlinedPanel pnlBarForeground = this._pnlBarForeground;
				if (pnlBarForeground != null)
				{
					pnlBarForeground.Paint -= value2;
				}
				this._pnlBarForeground = value;
				pnlBarForeground = this._pnlBarForeground;
				if (pnlBarForeground != null)
				{
					pnlBarForeground.Paint += value2;
				}
			}
		}

		// Token: 0x060005E5 RID: 1509 RVA: 0x00002C0C File Offset: 0x00000E0C
		private void lblPercent_Click(object sender, EventArgs e)
		{
		}

		// Token: 0x17000169 RID: 361
		// (get) Token: 0x060005E6 RID: 1510 RVA: 0x0000550D File Offset: 0x0000370D
		// (set) Token: 0x060005E7 RID: 1511 RVA: 0x0001DD44 File Offset: 0x0001BF44
		internal virtual OutlinedLabel lblPercent
		{
			[CompilerGenerated]
			get
			{
				return this._lblPercent;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.lblPercent_Click);
				OutlinedLabel lblPercent = this._lblPercent;
				if (lblPercent != null)
				{
					lblPercent.Click -= value2;
				}
				this._lblPercent = value;
				lblPercent = this._lblPercent;
				if (lblPercent != null)
				{
					lblPercent.Click += value2;
				}
			}
		}

		// Token: 0x1700016A RID: 362
		// (get) Token: 0x060005E8 RID: 1512 RVA: 0x00005515 File Offset: 0x00003715
		// (set) Token: 0x060005E9 RID: 1513 RVA: 0x0001DD88 File Offset: 0x0001BF88
		internal virtual OutlinedLabel lblPercentForeground
		{
			[CompilerGenerated]
			get
			{
				return this._lblPercentForeground;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.lblPercentForeground_Click);
				OutlinedLabel lblPercentForeground = this._lblPercentForeground;
				if (lblPercentForeground != null)
				{
					lblPercentForeground.Click -= value2;
				}
				this._lblPercentForeground = value;
				lblPercentForeground = this._lblPercentForeground;
				if (lblPercentForeground != null)
				{
					lblPercentForeground.Click += value2;
				}
			}
		}

		// Token: 0x060005EA RID: 1514 RVA: 0x00002C0C File Offset: 0x00000E0C
		private void lblPercentForeground_Click(object sender, EventArgs e)
		{
		}

		// Token: 0x060005EB RID: 1515 RVA: 0x0001DDCC File Offset: 0x0001BFCC
		public void UpdateForegroundImage()
		{
			this.pnlBar.Size = new Size(checked(base.Size.Width - this.pnlBar.Location.X - 4), this.pnlBar.Size.Height);
			this.hatchedBitmap = new Bitmap(this.pnlBar.ClientSize.Width, this.pnlBar.ClientSize.Height);
			Graphics graphics = Graphics.FromImage(this.hatchedBitmap);
			RectangleF rect = new RectangleF(0f, 0f, (float)this.pnlBar.ClientSize.Width, (float)this.pnlBar.ClientSize.Height);
			Brush brush = new HatchBrush(HatchStyle.WideDownwardDiagonal, this.color1, this.color2);
			graphics.FillRectangle(brush, rect);
			graphics.Dispose();
			this.pnlBarForeground.BackgroundImage = this.hatchedBitmap;
		}

		// Token: 0x04000B86 RID: 2950
		private IContainer components;

		// Token: 0x04000B8A RID: 2954
		private int iProgress;

		// Token: 0x04000B8B RID: 2955
		private int iProgressTotal;

		// Token: 0x04000B8C RID: 2956
		private int iSel;

		// Token: 0x04000B8D RID: 2957
		public Color color1;

		// Token: 0x04000B8E RID: 2958
		public Color color2;

		// Token: 0x04000B8F RID: 2959
		public bool bShowLabel;

		// Token: 0x04000B90 RID: 2960
		private Panel _pnlBar;

		// Token: 0x04000B91 RID: 2961
		private OutlinedLabel _lblPercent;

		// Token: 0x04000B92 RID: 2962
		private OutlinedLabel _lblPercentForeground;

		// Token: 0x04000B93 RID: 2963
		private OutlinedPanel _pnlBarForeground;

		// Token: 0x04000B94 RID: 2964
		private Bitmap hatchedBitmap;
	}
}
