﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace libSnesAssembler
{
	// Token: 0x0200011F RID: 287
	[StandardModule]
	public sealed class modLinkerReadFiles
	{
		// Token: 0x0600076B RID: 1899 RVA: 0x00028254 File Offset: 0x00026454
		public static string trimLine(string sLine)
		{
			string result;
			if (sLine.Length == 0)
			{
				result = sLine;
			}
			else if (sLine[0] == '?')
			{
				if (sLine.IndexOf('\t') >= 0)
				{
					sLine = modString.stringTab(sLine, 4);
				}
				result = sLine.Trim();
			}
			else
			{
				int num = sLine.IndexOf('\'');
				if (num > 0)
				{
					sLine = sLine.Substring(0, checked(num - 1));
				}
				else if (num == 0)
				{
					sLine = "";
				}
				sLine = sLine.Replace('\t', ' ');
				sLine = sLine.Replace("{", "");
				sLine = sLine.Replace("}", "");
				result = sLine.Trim();
			}
			return result;
		}

		// Token: 0x0600076C RID: 1900 RVA: 0x000282F8 File Offset: 0x000264F8
		public static void readAsmFileContent(modAssemblerStructs.asmProject _pProject, Collection<modAssemblerStructs.AsmFileLine> cOut, string sPath, bool bAsm, int _level = 0)
		{
			bool flag = !bAsm;
			if (flag)
			{
				modProjectBuilder.cDebugDefFiles.Add(sPath);
			}
			bool flag2 = _level > 32;
			checked
			{
				if (flag2)
				{
					Interaction.MsgBox("FILE, stack overflow", MsgBoxStyle.OkOnly, null);
				}
				else
				{
					bool flag3 = _pProject.patchFile.fileExists(sPath);
					if (flag3)
					{
						string sString = _pProject.patchFile.fileText(sPath);
						string[] array = modString.splitLines(sString, false);
						int num = 0;
						bool flag4 = false;
						int num2 = 0;
						bool flag5 = false;
						SubInfo subInfo = null;
						bool flag6 = false;
						foreach (string text in array)
						{
							flag6 = false;
							bool flag7 = flag5;
							if (!flag7)
							{
								string text2 = modLinkerReadFiles.trimLine(text);
								bool flag8 = text2.Contains("^SKIPLINE^");
								if (flag8)
								{
									text2 = text2.Replace("^SKIPLINE^", "").Trim();
									num = num2;
								}
								modAssemblerStructs.AsmFileLine asmFileLine = new modAssemblerStructs.AsmFileLine(sPath, num, text, text2);
								string[] array3 = text2.Split(new char[]
								{
									' '
								});
								assemblerOpcodes.enum_linkerCmd enum_linkerCmd = assemblerOpcodes.enum_linkerCmd.NOT_LINK_CMD;
								bool flag9 = array3.Length > 0;
								if (flag9)
								{
									bool flag10 = assemblerOpcodes.dicLinkerCmd.ContainsKey(array3[0]);
									if (flag10)
									{
										enum_linkerCmd = assemblerOpcodes.dicLinkerCmd[array3[0]];
									}
								}
								bool flag11 = !flag4 | enum_linkerCmd == assemblerOpcodes.enum_linkerCmd.LINK_ENDIF;
								if (flag11)
								{
									asmFileLine.bActive = false;
									switch (enum_linkerCmd)
									{
									case assemblerOpcodes.enum_linkerCmd.NOT_LINK_CMD:
									{
										bool flag12 = text2.Length > 0;
										if (flag12)
										{
											asmFileLine.bActive = true;
											bool flag13 = text2.StartsWith("@OFF", StringComparison.OrdinalIgnoreCase);
											if (flag13)
											{
												bool flag14 = array3.Length > 1;
												if (flag14)
												{
													subInfo = new SubInfo(array3[1], sPath);
													modSubInfo.dicSubInfo.Add(subInfo.sName, subInfo);
													flag6 = true;
												}
											}
											cOut.Add(asmFileLine);
										}
										break;
									}
									case assemblerOpcodes.enum_linkerCmd.LINK_IF:
									{
										bool flag15 = array3.Length == 2;
										if (flag15)
										{
											bool flag16 = !_pProject.patchFile.optionOn(array3[1]);
											if (flag16)
											{
												flag4 = true;
											}
										}
										break;
									}
									case assemblerOpcodes.enum_linkerCmd.LINK_IFNOT:
									{
										bool flag17 = array3.Length == 2;
										if (flag17)
										{
											bool flag18 = _pProject.patchFile.optionOn(array3[1]);
											if (flag18)
											{
												flag4 = true;
											}
										}
										break;
									}
									case assemblerOpcodes.enum_linkerCmd.LINK_ENDIF:
										flag4 = false;
										break;
									case assemblerOpcodes.enum_linkerCmd.LINK_REQ:
									{
										int num3 = array3.Length;
										if (num3 != 1)
										{
											if (num3 != 2)
											{
												asmFileLine.setErrorMsg("Error, option name must be a single word");
											}
											else
											{
												bool flag19 = !_pProject.patchFile.optionOn(array3[1]);
												if (flag19)
												{
													flag5 = true;
												}
											}
										}
										else
										{
											asmFileLine.setErrorMsg("Error, no option name specified");
										}
										cOut.Add(asmFileLine);
										break;
									}
									case assemblerOpcodes.enum_linkerCmd.LINK_FILE:
									{
										string argFile = modProjectLinker.getArgFile(text2, sPath, _pProject);
										bool flag20 = argFile == null;
										if (flag20)
										{
											asmFileLine.setErrorMsg("Error, file doesn't exist");
										}
										cOut.Add(asmFileLine);
										bool flag21 = argFile != null;
										if (flag21)
										{
											modLinkerReadFiles.readAsmFileContent(_pProject, cOut, argFile, bAsm, _level + 1);
										}
										break;
									}
									case assemblerOpcodes.enum_linkerCmd.LINK_DIR:
										if (bAsm)
										{
											asmFileLine.setErrorMsg("Error, 'DIR' can only be used in definition files");
										}
										else
										{
											string argDir = modProjectLinker.getArgDir(text2, sPath, _pProject);
											bool flag22 = argDir == null;
											if (flag22)
											{
												asmFileLine.setErrorMsg("Error, directory doesn't exist");
											}
											else
											{
												Collection<string> dirFiles = _pProject.patchFile.getDirFiles(argDir);
												try
												{
													foreach (string item in dirFiles)
													{
														modProjectBuilder.cAsmFiles.Add(item);
													}
												}
												finally
												{
													IEnumerator<string> enumerator;
													if (enumerator != null)
													{
														enumerator.Dispose();
													}
												}
											}
										}
										cOut.Add(asmFileLine);
										break;
									case assemblerOpcodes.enum_linkerCmd.LINK_ASM:
										if (bAsm)
										{
											asmFileLine.setErrorMsg("Error, 'ASM' can only be used in definition files");
										}
										else
										{
											string argFile2 = modProjectLinker.getArgFile(text2, sPath, _pProject);
											bool flag23 = argFile2 != null;
											if (flag23)
											{
												modProjectBuilder.cAsmFiles.Add(argFile2);
											}
											else
											{
												asmFileLine.setErrorMsg("Error, file doesn't exist");
											}
										}
										cOut.Add(asmFileLine);
										break;
									case assemblerOpcodes.enum_linkerCmd.LINK_EXEC:
									{
										string argFile3 = modProjectLinker.getArgFile(text2, sPath, _pProject);
										bool flag24 = argFile3 != null;
										if (flag24)
										{
											modExecute.ShellAndWait(argFile3);
										}
										else
										{
											asmFileLine.setErrorMsg("Error, file doesn't exist");
										}
										cOut.Add(asmFileLine);
										break;
									}
									case assemblerOpcodes.enum_linkerCmd.LINK_SUBINFO:
									{
										bool flag25 = subInfo != null;
										if (flag25)
										{
											bool flag26 = text.Length > 1;
											if (flag26)
											{
												text = text.Substring(1);
											}
											subInfo.addInfoLine(text);
											flag6 = true;
										}
										break;
									}
									}
								}
								bool flag27 = !flag5;
								if (flag27)
								{
									num2 = num;
									num++;
								}
							}
							bool flag28 = !flag6;
							if (flag28)
							{
								bool flag29 = subInfo != null;
								if (flag29)
								{
									bool flag30 = modSubInfo.dicSubInfo.ContainsKey(subInfo.sName);
									if (flag30)
									{
										bool flag31 = subInfo.cInfoLines.Count == 0;
										if (flag31)
										{
											modSubInfo.dicSubInfo.Remove(subInfo.sName);
										}
									}
								}
								subInfo = null;
							}
						}
					}
					else
					{
						assemblerOpcodes.bError = true;
						modCommonDebug._debugWrite("\r\n\r\nERROR: Linking, file doesn't exist\r\n\r\n");
						Interaction.MsgBox("Error Linking, File Doesn't Exist: " + sPath, MsgBoxStyle.OkOnly, null);
					}
				}
			}
		}

		// Token: 0x04000DCC RID: 3532
		private const int CONST_FILE_STACK_LEVEL_MAX = 32;
	}
}
