﻿using System;
using System.ComponentModel;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace libSnesAssembler
{
	// Token: 0x02000114 RID: 276
	[StandardModule]
	public sealed class modAssemble
	{
		// Token: 0x0600073D RID: 1853 RVA: 0x00024088 File Offset: 0x00022288
		public static string assemble_applySplitter(ref bool bError, string argVal, assemblerOpcodes.enum_splitterType splitterType)
		{
			switch (splitterType)
			{
			case assemblerOpcodes.enum_splitterType.splitter_bank:
			{
				bool flag = argVal.Length == 6;
				if (flag)
				{
					return argVal.Substring(0, 2);
				}
				break;
			}
			case assemblerOpcodes.enum_splitterType.splitter_16:
			{
				bool flag2 = argVal.Length == 6;
				if (flag2)
				{
					return argVal.Substring(2, 4);
				}
				bool flag3 = argVal.Length == 4;
				if (flag3)
				{
					return argVal;
				}
				break;
			}
			case assemblerOpcodes.enum_splitterType.splitter_8:
			{
				bool flag4 = argVal.Length == 6;
				if (flag4)
				{
					return argVal.Substring(4, 2);
				}
				bool flag5 = argVal.Length == 4;
				if (flag5)
				{
					return argVal.Substring(2, 2);
				}
				bool flag6 = argVal.Length == 2;
				if (flag6)
				{
					return argVal;
				}
				break;
			}
			}
			bError = true;
			return "";
		}

		// Token: 0x0600073E RID: 1854 RVA: 0x00024184 File Offset: 0x00022384
		public static string assemble(modAssemblerStructs.asmProject project, string _str, bool _bPre, bool bShowErrors = false)
		{
			bool flag = _str == null || _str.Length == 0;
			string result;
			if (flag)
			{
				result = "";
			}
			else
			{
				modAsmReport.asmProgReport.progressStep();
				assemblerOpcodes.bError = false;
				bool flag2 = false;
				_str = _str.Trim();
				string text = modAssemble.assemble_Command(project, _str, _bPre, ref flag2);
				bool flag3 = flag2;
				if (flag3)
				{
					result = text;
				}
				else
				{
					bool bSkip_UntilEndIf = project.bSkip_UntilEndIf;
					if (bSkip_UntilEndIf)
					{
						flag2 = true;
						result = "";
					}
					else
					{
						string[] array = _str.Split(new char[]
						{
							' '
						});
						bool flag4 = array.Length > 1;
						if (flag4)
						{
							bool flag5 = array.Length > 3;
							if (flag5)
							{
								goto IL_444;
							}
							bool flag6 = array.Length == 3;
							bool flag8;
							assemblerOpcodes.enum_splitterType splitterType;
							if (flag6)
							{
								bool flag7 = array[2].StartsWith(":") && assemblerOpcodes.dicSplitters.ContainsKey(array[2]);
								if (!flag7)
								{
									goto IL_444;
								}
								flag8 = true;
								splitterType = assemblerOpcodes.dicSplitters[array[2]];
							}
							bool flag9 = array[1].StartsWith("$");
							string text2;
							if (flag9)
							{
								text2 = "$";
							}
							else
							{
								bool flag10 = array[1].StartsWith("#");
								if (flag10)
								{
									text2 = "#";
								}
								else
								{
									bool flag11 = array[1].StartsWith("*");
									if (!flag11)
									{
										goto IL_444;
									}
									text2 = "*";
									bool flag12 = flag8;
									if (flag12)
									{
										goto IL_444;
									}
								}
							}
							bool flag13 = array[1].Length > 1;
							if (!flag13)
							{
								goto IL_444;
							}
							string text3 = array[1].Substring(1);
							bool flag14 = Operators.CompareString(text2, "*", false) != 0;
							if (flag14)
							{
								bool flag15 = flag8;
								if (flag15)
								{
									text3 = modAssemble.assemble_applySplitter(ref assemblerOpcodes.bError, text3, splitterType);
									bool bError = assemblerOpcodes.bError;
									if (bError)
									{
										goto IL_444;
									}
								}
								string text4 = array[0] + " " + text2;
								bool flag16 = text3.Length == 2;
								string str;
								if (flag16)
								{
									str = text3;
									text4 += "1";
								}
								else
								{
									bool flag17 = text3.Length == 4;
									if (flag17)
									{
										str = text3.Substring(2, 2) + text3.Substring(0, 2);
										text4 += "2";
									}
									else
									{
										bool flag18 = text3.Length == 6;
										if (!flag18)
										{
											goto IL_444;
										}
										str = text3.Substring(4, 2) + text3.Substring(2, 2) + text3.Substring(0, 2);
										text4 += "3";
									}
								}
								bool flag19 = assemblerOpcodes.dicAsmCmd.ContainsKey(text4);
								if (flag19)
								{
									return assemblerOpcodes.dicAsmCmd[text4] + str;
								}
								goto IL_444;
							}
							else
							{
								bool flag20 = _str.Length > 4;
								if (flag20)
								{
									text = modProcOpcodes.asm_Branch(_str, _bPre, ref flag2);
									bool flag21 = flag2;
									if (flag21)
									{
										return text;
									}
									assemblerOpcodes.bError = false;
								}
							}
						}
						else
						{
							bool flag22 = array.Length > 0;
							if (flag22)
							{
								bool flag23 = assemblerOpcodes.dicAsmCmd.ContainsKey(array[0]);
								if (flag23)
								{
									modAssemble.asmDbg_Cmd = array[0];
									return assemblerOpcodes.dicAsmCmd[array[0]];
								}
							}
						}
						bool flag24 = _str.Length > 0;
						if (!flag24)
						{
							return "";
						}
						text = _str.Trim();
						text = text.Substring(0, 1);
						bool flag25 = Operators.CompareString(text, "/", false) == 0 | Operators.CompareString(text, "*", false) == 0 | Operators.CompareString(text, "'", false) == 0;
						if (flag25)
						{
							return "";
						}
						IL_444:
						assemblerOpcodes.bError = true;
						modCommonDebug._debugWrite("\r\n\r\nERROR: Unrecognized Command :" + _str + "\r\n\r\n");
						result = "<<_Unrecognized_Command_>>";
					}
				}
			}
			return result;
		}

		// Token: 0x0600073F RID: 1855 RVA: 0x00024600 File Offset: 0x00022800
		public static string assembleBackup(modAssemblerStructs.asmProject project, string _str, bool _bPre, bool bShowErrors = false)
		{
			bool flag = _str == null || _str.Length == 0;
			checked
			{
				string result;
				if (flag)
				{
					result = "";
				}
				else
				{
					bool flag2 = _str.StartsWith("l+x");
					if (flag2)
					{
						_str = _str;
					}
					modProjectBuilder.iAsm_Progress++;
					bool flag3 = modAssemble.bgAsmWorker != null;
					if (flag3)
					{
						int num = (int)Math.Round((double)(modProjectBuilder.iAsm_Progress * 100) / (double)(modProjectBuilder.iAsm_ProgressCount * 4));
						bool flag4 = num != modProjectBuilder.iAsm_ProgressPercent & num <= 100;
						if (flag4)
						{
							modProjectBuilder.iAsm_ProgressPercent = num;
							modAssemble.bgAsmWorker.ReportProgress(num);
						}
					}
					assemblerOpcodes.bError = false;
					bool flag5 = false;
					_str = _str.Trim();
					string text = modAssemble.assemble_Command(project, _str, _bPre, ref flag5);
					bool flag6 = flag5;
					if (flag6)
					{
						result = text;
					}
					else
					{
						bool bSkip_UntilEndIf = project.bSkip_UntilEndIf;
						if (bSkip_UntilEndIf)
						{
							flag5 = true;
							result = "";
						}
						else
						{
							bool flag7 = _str.Length > 4;
							if (flag7)
							{
								text = modProcOpcodes.asm_Branch(_str, _bPre, ref flag5);
								bool flag8 = flag5;
								if (flag8)
								{
									return text;
								}
								assemblerOpcodes.bError = false;
							}
							bool flag9 = _str.Length > 5;
							if (flag9)
							{
								text = modAssemble.assembleAbsImm(_str, _bPre, ref flag5);
								bool flag10 = flag5;
								if (flag10)
								{
									return text;
								}
							}
							bool flag11 = _str.Length > 4;
							if (flag11)
							{
								text = modProcOpcodes.asm_Single(_str, _bPre, ref flag5);
								bool flag12 = flag5;
								if (flag12)
								{
									return text;
								}
							}
							bool flag13 = _str.Length > 2;
							if (flag13)
							{
								string key = _str.Substring(0, 3);
								bool flag14 = assemblerOpcodes.dicAsmCmd.ContainsKey(key);
								if (flag14)
								{
									modAssemble.asmDbg_Cmd = key;
									return assemblerOpcodes.dicAsmCmd[key];
								}
							}
							bool flag15 = _str.Length > 0;
							if (flag15)
							{
								text = _str.Trim();
								text = text.Substring(0, 1);
								bool flag16 = Operators.CompareString(text, "/", false) == 0 | Operators.CompareString(text, "*", false) == 0 | Operators.CompareString(text, "'", false) == 0;
								if (flag16)
								{
									result = "";
								}
								else
								{
									assemblerOpcodes.bError = true;
									modCommonDebug._debugWrite("\r\n\r\nERROR: Unrecognized Command :" + _str + "\r\n\r\n");
									result = "<<_Unrecognized_Command_>>";
								}
							}
							else
							{
								result = "";
							}
						}
					}
				}
				return result;
			}
		}

		// Token: 0x06000740 RID: 1856 RVA: 0x0002489C File Offset: 0x00022A9C
		private static string assemble_Command(modAssemblerStructs.asmProject project, string _str, bool _bPre, ref bool bFound)
		{
			char c = _str[0];
			if (_str.Length >= 5)
			{
				if (c == '@')
				{
					if ((ushort)(_str[1] | ' ') == 111 && (ushort)(_str[2] | ' ') == 102 && (ushort)(_str[3] | ' ') == 102)
					{
						bFound = true;
						return modProcCommands.cmd_OFF(_str, _bPre);
					}
					return null;
				}
				else
				{
					c |= ' ';
					if (c == 'r')
					{
						if ((ushort)(_str[1] | ' ') == 97 && (ushort)(_str[2] | ' ') == 119)
						{
							bFound = true;
							return modProcCommands.cmd_RAW(_str, _bPre);
						}
						return null;
					}
					else if (c == 'c')
					{
						if ((ushort)(_str[1] | ' ') == 111 && (ushort)(_str[2] | ' ') == 112 && (ushort)(_str[3] | ' ') == 121)
						{
							bFound = true;
							return modProcCommands.cmd_COPY(_str, _bPre);
						}
						return null;
					}
					else
					{
						if (c == 'o')
						{
							c = (_str[1] | ' ');
							if (c == 'f')
							{
								if ((ushort)(_str[2] | ' ') == 102)
								{
									bFound = true;
									return modProcCommands.cmd_OFF(_str, _bPre);
								}
							}
							else if (c == 'p' && _str[2] == ' ')
							{
								bFound = true;
								return modProcCommands.cmd_OP(_str, _bPre);
							}
							return null;
						}
						if (c == 'e')
						{
							if ((ushort)(_str[1] | ' ') == 110 && (ushort)(_str[2] | ' ') == 100 && (ushort)(_str[3] | ' ') == 105 && (ushort)(_str[4] | ' ') == 102)
							{
								modCommonDebug._debugWrite("Assemble: ENDIF");
								bFound = true;
								project.bSkip_UntilEndIf = false;
								return "";
							}
							return null;
						}
						else if (c == 'a')
						{
							if ((ushort)(_str[1] | ' ') == 100 && (ushort)(_str[2] | ' ') == 114 && _str[3] == '.')
							{
								c = _str[4];
								if (c == '1')
								{
									if (_str.Length >= 6 && _str[5] == '6')
									{
										bFound = true;
										return modProcCommands.cmd_ADR_16(_str, _bPre);
									}
								}
								else
								{
									c |= ' ';
									if (c == 'l')
									{
										if (_str.Length >= 7 && (ushort)(_str[5] | ' ') == 111 && (ushort)(_str[6] | ' ') == 119)
										{
											bFound = true;
											return modProcCommands.cmd_ADR_LOW(_str, _bPre);
										}
									}
									else if (c == 'h')
									{
										if (_str.Length >= 8 && (ushort)(_str[5] | ' ') == 105 && (ushort)(_str[6] | ' ') == 103 && (ushort)(_str[7] | ' ') == 104)
										{
											bFound = true;
											return modProcCommands.cmd_ADR_HIGH(_str, _bPre);
										}
									}
									else if (c == 'b' && _str.Length >= 8 && (ushort)(_str[5] | ' ') == 97 && (ushort)(_str[6] | ' ') == 110 && (ushort)(_str[7] | ' ') == 107)
									{
										bFound = true;
										return modProcCommands.cmd_ADR_BANK(_str, _bPre);
									}
								}
							}
							return null;
						}
					}
				}
			}
			else
			{
				if (_str.Length < 3)
				{
					return null;
				}
				c |= ' ';
			}
			if (c == 'i' && (ushort)(_str[1] | ' ') == 102)
			{
				c = _str[2];
				if (c == ' ')
				{
					bFound = true;
					string[] array = _str.Split(new char[]
					{
						' '
					});
					modCommonDebug._debugWrite("Assemble: IF");
					if (array.Length == 2)
					{
						if (project.patchFile.optionOn(array[1]))
						{
							modCommonDebug._debugWrite("Option = true");
						}
						else
						{
							project.bSkip_UntilEndIf = true;
							modCommonDebug._debugWrite("Option = false");
						}
					}
					return "";
				}
				if (_str.Length >= 6 && (ushort)(c | ' ') == 110 && _str[5] == ' ' && (ushort)(_str[3] | ' ') == 111 && (ushort)(_str[4] | ' ') == 116)
				{
					bFound = true;
					string[] array2 = _str.Split(new char[]
					{
						' '
					});
					modCommonDebug._debugWrite("Assemble: IFNOT");
					if (array2.Length == 2)
					{
						if (project.patchFile.optionOn(array2[1]))
						{
							project.bSkip_UntilEndIf = true;
							modCommonDebug._debugWrite("Option = true");
						}
						else
						{
							modCommonDebug._debugWrite("Option = false");
						}
					}
					return "";
				}
			}
			return null;
		}

		// Token: 0x06000741 RID: 1857 RVA: 0x00024C88 File Offset: 0x00022E88
		public static string assembleBranch(string _str, bool _bPre, ref bool _bReturn)
		{
			string key = _str.Substring(0, 5);
			string left = _str.Substring(4, 1);
			bool flag = Operators.CompareString(left, "*", false) == 0;
			checked
			{
				if (flag)
				{
					bool flag2 = assemblerOpcodes.dicAsmCmd.ContainsKey(key);
					if (flag2)
					{
						if (_bPre)
						{
							_bReturn = true;
							return assemblerOpcodes.dicAsmCmd[key] + "??";
						}
						string key2 = _str.Substring(5, _str.Length - 5);
						bool flag3 = modAsmDefs.dicLabels.ContainsKey(key2);
						if (!flag3)
						{
							_bReturn = true;
							assemblerOpcodes.bError = true;
							modCommonDebug._debugWrite("\r\n\r\nERROR: Branch, no label\r\n\r\n");
							return "*ERROR, No label";
						}
						int currentPosition = modAssemble.getCurrentPosition();
						int num = modAsmDefs.dicLabels[key2];
						int num2 = num - (currentPosition + 2);
						string text = Conversion.Hex(num2);
						bool flag4 = num2 > 127;
						if (flag4)
						{
							_bReturn = true;
							assemblerOpcodes.bError = true;
							modCommonDebug._debugWrite("\r\n\r\nERROR: Branch too far\r\n\r\n");
							return "*ERROR, Too far";
						}
						bool flag5 = num2 < 0;
						if (flag5)
						{
							num2 = 256 - num2 * -1;
							bool flag6 = num2 < 128;
							if (flag6)
							{
								_bReturn = true;
								assemblerOpcodes.bError = true;
								modCommonDebug._debugWrite("\r\n\r\nERROR: Branch too far\r\n\r\n");
								return "*ERROR, Too far";
							}
						}
						text = Conversion.Hex(num2);
						bool flag7 = text.Length < 2;
						if (flag7)
						{
							text = "0" + text;
						}
						_bReturn = true;
						return assemblerOpcodes.dicAsmCmd[key] + " " + text;
					}
				}
				return "";
			}
		}

		// Token: 0x06000742 RID: 1858 RVA: 0x00024E48 File Offset: 0x00023048
		public static string assembleAbsImm(string _str, bool _bPre, ref bool _bReturn)
		{
			string str = _str.Substring(0, 5);
			string text = _str.Substring(5, checked(_str.Length - 5));
			int num = text.IndexOf(" ");
			bool flag = num > 1;
			if (flag)
			{
				text = text.Substring(0, num);
				text = text;
			}
			int length = text.Length;
			string str2 = "";
			string str3 = "";
			bool flag2 = length > 0;
			if (flag2)
			{
				bool flag3 = length == 2;
				if (flag3)
				{
					str2 = "1";
					str3 = _str.Substring(5, 2);
				}
				else
				{
					bool flag4 = length == 4;
					if (flag4)
					{
						str2 = "2";
						str3 = _str.Substring(7, 2) + " " + _str.Substring(5, 2);
					}
					else
					{
						bool flag5 = length == 6;
						if (flag5)
						{
							str2 = "3";
							str3 = string.Concat(new string[]
							{
								_str.Substring(9, 2),
								" ",
								_str.Substring(7, 2),
								" ",
								_str.Substring(5, 2)
							});
						}
					}
				}
			}
			bool flag6 = assemblerOpcodes.dicAsmCmd.ContainsKey(str + str2);
			string result;
			if (flag6)
			{
				_bReturn = true;
				result = assemblerOpcodes.dicAsmCmd[str + str2] + " " + str3;
			}
			else
			{
				result = "";
			}
			return result;
		}

		// Token: 0x06000743 RID: 1859 RVA: 0x00024FBC File Offset: 0x000231BC
		public static int getCurrentPosition()
		{
			string text = compiler.sTxtBytes.Trim();
			text = text.Replace("\r\n", "");
			text = text.Replace(" ", "");
			return checked((int)Math.Round((double)text.Length / 2.0));
		}

		// Token: 0x04000DA5 RID: 3493
		public static string asmDbg;

		// Token: 0x04000DA6 RID: 3494
		public static string asmDbg_Cmd;

		// Token: 0x04000DA7 RID: 3495
		public static string asmDbg_Bytes;

		// Token: 0x04000DA8 RID: 3496
		public static string asmDbg_Msg;

		// Token: 0x04000DA9 RID: 3497
		public static string asmDbg_Param;

		// Token: 0x04000DAA RID: 3498
		public static BackgroundWorker bgAsmWorker = null;
	}
}
