﻿using System;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using libZh;
using Microsoft.VisualBasic.CompilerServices;

namespace libSnesAssembler
{
	// Token: 0x02000128 RID: 296
	public class PatchGlobal
	{
		// Token: 0x060007AC RID: 1964 RVA: 0x0002BD58 File Offset: 0x00029F58
		public PatchGlobal()
		{
			this.sName = "";
			this.sValue = "";
			this.bEditable = false;
			this.bAddress = false;
			this.bConst = false;
			this.sFlagStrings = "";
			this.sEditValue = "";
			this.sFilePath = "";
			this.editType = PatchGlobal.enum_globalType.globalType_none;
		}

		// Token: 0x060007AD RID: 1965 RVA: 0x0002BDC0 File Offset: 0x00029FC0
		public PatchGlobal(string _sName, string _sValue, string _sFlags)
		{
			this.sName = "";
			this.sValue = "";
			this.bEditable = false;
			this.bAddress = false;
			this.bConst = false;
			this.sFlagStrings = "";
			this.sEditValue = "";
			this.sFilePath = "";
			this.editType = PatchGlobal.enum_globalType.globalType_none;
			this.sName = _sName;
			this.sValue = _sValue;
			string[] source = _sFlags.Split(new char[]
			{
				';'
			});
			bool flag = source.Contains("Editable");
			if (flag)
			{
				this.bEditable = true;
			}
		}

		// Token: 0x060007AE RID: 1966 RVA: 0x0002BE64 File Offset: 0x0002A064
		public static string validateEditValue(PatchGlobal.enum_globalType _type, string _sInput)
		{
			string result;
			if (_type == PatchGlobal.enum_globalType.globalType_none)
			{
				result = _sInput;
			}
			else
			{
				switch (_type)
				{
				case PatchGlobal.enum_globalType.globalType_hex_4bit:
					if ((_sInput == null || _sInput.Length == 0 || _sInput.Length > 1) | !modString.isHex(_sInput))
					{
						result = "0";
					}
					else
					{
						result = modString.hx(modString.hx(_sInput), 1);
					}
					break;
				case PatchGlobal.enum_globalType.globalType_hex_8bit:
					if ((_sInput == null || _sInput.Length == 0 || _sInput.Length > 2) | !modString.isHex(_sInput))
					{
						result = "00";
					}
					else
					{
						result = modString.hx(modString.hx(_sInput), 2);
					}
					break;
				case PatchGlobal.enum_globalType.globalType_hex_16bit:
					if ((_sInput == null || _sInput.Length == 0 || _sInput.Length > 4) | !modString.isHex(_sInput))
					{
						result = "0000";
					}
					else
					{
						result = modString.hx(modString.hx(_sInput), 4);
					}
					break;
				case PatchGlobal.enum_globalType.globalType_hex_24bit:
					if ((_sInput == null || _sInput.Length == 0 || _sInput.Length > 6) | !modString.isHex(_sInput))
					{
						result = "000000";
					}
					else
					{
						result = modString.hx(modString.hx(_sInput), 6);
					}
					break;
				default:
					result = "";
					break;
				}
			}
			return result;
		}

		// Token: 0x060007AF RID: 1967 RVA: 0x0002BF90 File Offset: 0x0002A190
		public static PatchGlobal patchGlobal_load(string sLine)
		{
			PatchGlobal patchGlobal = new PatchGlobal();
			string[] array = sLine.Split(new char[]
			{
				' '
			});
			bool flag = array.Length >= 4;
			PatchGlobal result;
			if (flag)
			{
				patchGlobal.sName = array[0];
				patchGlobal.editType = (PatchGlobal.enum_globalType)Conversions.ToInteger(array[1]);
				patchGlobal.sEditValue = array[2];
				patchGlobal.sValue = PatchGlobal.load_value(sLine);
				string[] array2 = patchGlobal.load_flagStrings(sLine);
				bool flag2 = array2 != null;
				if (flag2)
				{
					patchGlobal.applyFlagString(array2);
				}
				result = patchGlobal;
			}
			else
			{
				result = null;
			}
			return result;
		}

		// Token: 0x060007B0 RID: 1968 RVA: 0x0002C030 File Offset: 0x0002A230
		public static Collection<PatchGlobal> patchGlobal_loadAgl(string sFileText, string sFilePath)
		{
			Collection<PatchGlobal> collection = new Collection<PatchGlobal>();
			PatchGlobal patchGlobal = null;
			StringBuilder stringBuilder = new StringBuilder("");
			string[] array = modString.splitLines(sFileText, true);
			foreach (string text in array)
			{
				bool flag = text.StartsWith("DEF ", StringComparison.OrdinalIgnoreCase);
				if (flag)
				{
					bool flag2 = patchGlobal != null;
					if (flag2)
					{
						patchGlobal.sValue = stringBuilder.ToString();
						collection.Add(patchGlobal);
					}
					string[] array3 = text.Split(new char[]
					{
						' '
					});
					bool flag3 = array3.Count<string>() == 2;
					if (flag3)
					{
						patchGlobal = new PatchGlobal();
						patchGlobal.sFilePath = sFilePath;
						patchGlobal.sName = array3[1];
						patchGlobal.bEditable = false;
						stringBuilder = new StringBuilder("");
					}
				}
				else
				{
					bool flag4 = stringBuilder.Length > 0;
					if (flag4)
					{
						stringBuilder.Append("\r\n");
					}
					stringBuilder.Append(text);
				}
			}
			bool flag5 = patchGlobal != null;
			if (flag5)
			{
				patchGlobal.sValue = stringBuilder.ToString();
				collection.Add(patchGlobal);
			}
			return collection;
		}

		// Token: 0x060007B1 RID: 1969 RVA: 0x0002C174 File Offset: 0x0002A374
		private void applyFlagString(string[] a_sFlags)
		{
			bool flag = a_sFlags.Contains("Editable");
			if (flag)
			{
				this.bEditable = true;
			}
			bool flag2 = a_sFlags.Contains("Address");
			if (flag2)
			{
				this.bAddress = true;
			}
		}

		// Token: 0x060007B2 RID: 1970 RVA: 0x0002C1BC File Offset: 0x0002A3BC
		private static string load_value(string sLine)
		{
			MatchCollection matchCollection = modRegex.findDelimiter(sLine, "\"", "\"", true);
			bool flag = matchCollection.Count == 1;
			string result;
			if (flag)
			{
				result = matchCollection[0].Value.Replace("\\n", "\r\n").Replace("\"", "");
			}
			else
			{
				result = null;
			}
			return result;
		}

		// Token: 0x060007B3 RID: 1971 RVA: 0x0002C228 File Offset: 0x0002A428
		private string[] load_flagStrings(string sLine)
		{
			MatchCollection matchCollection = modRegex.findDelimiter(sLine, "(<)", "(>)", true);
			bool flag = matchCollection.Count == 1;
			string[] result;
			if (flag)
			{
				this.sFlagStrings = matchCollection[0].Value.Replace("(<)", "").Replace("(>)", "");
				result = this.sFlagStrings.Split(new char[]
				{
					';'
				});
			}
			else
			{
				result = null;
			}
			return result;
		}

		// Token: 0x060007B4 RID: 1972 RVA: 0x0002C2B0 File Offset: 0x0002A4B0
		public string patchGlobal_save()
		{
			bool flag = this.sEditValue == null || this.sEditValue.Length == 0;
			if (flag)
			{
				this.sEditValue = "0";
			}
			string str = string.Concat(new string[]
			{
				this.sName,
				" ",
				Conversions.ToString((int)this.editType),
				" ",
				this.sEditValue,
				" \"",
				this.sValue.Replace("\r\n", "\\n"),
				"\""
			});
			string text = "";
			bool flag2 = this.bEditable;
			if (flag2)
			{
				text = "Editable";
			}
			bool flag3 = this.bAddress;
			if (flag3)
			{
				bool flag4 = text.Length > 0;
				if (flag4)
				{
					text += ";";
				}
				text += "Address";
			}
			return str + "(<)" + text + "(>)";
		}

		// Token: 0x060007B5 RID: 1973 RVA: 0x0002C3C8 File Offset: 0x0002A5C8
		public void printDebug()
		{
			bool flag = this.bConst;
			if (flag)
			{
				modCommonDebug._debugSectionStart("CONST GLOBAL: " + this.sName);
				modCommonDebug._debugWrite("FILE:     \t" + this.sFilePath);
			}
			else
			{
				modCommonDebug._debugSectionStart("GLOBAL: " + this.sName);
			}
			modCommonDebug._debugWrite("EDITABLE: \t" + this.bEditable.ToString());
			modCommonDebug._debugWrite("TYPE:     \t" + Conversions.ToString((int)this.editType));
			modCommonDebug._debugWrite("INPUT:    \t\"" + this.sEditValue + "\"");
			string[] array = modString.splitLines(this.sValue, true);
			foreach (string str in array)
			{
				modCommonDebug._debugWrite("\t\"" + str + "\"");
			}
			modCommonDebug._debugSectionEnd();
		}

		// Token: 0x060007B6 RID: 1974 RVA: 0x0002C4CC File Offset: 0x0002A6CC
		public string getResult(string[] a_sParams)
		{
			string text = this.sValue.Replace("%x", this.sEditValue);
			bool flag = a_sParams != null && a_sParams.Count<string>() > 0;
			checked
			{
				if (flag)
				{
					int num = a_sParams.Count<string>() - 1;
					for (int i = 0; i <= num; i++)
					{
						text = text.Replace("%" + Conversions.ToString(modString.hx(Conversions.ToString(i))), a_sParams[i].Trim());
					}
				}
				string[] array = modString.splitLines(text, true);
				StringBuilder stringBuilder = new StringBuilder();
				foreach (string text2 in array)
				{
					text2 = modLinkerReadFiles.trimLine(text2);
					bool flag2 = text2 != null & text2.Length > 0;
					if (flag2)
					{
						bool flag3 = stringBuilder.Length > 0;
						if (flag3)
						{
							stringBuilder.Append("\r\n^SKIPLINE^");
						}
						stringBuilder.Append(text2);
					}
				}
				return stringBuilder.ToString();
			}
		}

		// Token: 0x04000DF5 RID: 3573
		public string sName;

		// Token: 0x04000DF6 RID: 3574
		public string sValue;

		// Token: 0x04000DF7 RID: 3575
		public bool bEditable;

		// Token: 0x04000DF8 RID: 3576
		public bool bAddress;

		// Token: 0x04000DF9 RID: 3577
		public bool bConst;

		// Token: 0x04000DFA RID: 3578
		public string sFlagStrings;

		// Token: 0x04000DFB RID: 3579
		public string sEditValue;

		// Token: 0x04000DFC RID: 3580
		public string sFilePath;

		// Token: 0x04000DFD RID: 3581
		public PatchGlobal.enum_globalType editType;

		// Token: 0x02000129 RID: 297
		public enum enum_globalType
		{
			// Token: 0x04000DFF RID: 3583
			globalType_none,
			// Token: 0x04000E00 RID: 3584
			globalType_hex_4bit,
			// Token: 0x04000E01 RID: 3585
			globalType_hex_8bit,
			// Token: 0x04000E02 RID: 3586
			globalType_hex_16bit,
			// Token: 0x04000E03 RID: 3587
			globalType_hex_24bit
		}
	}
}
