﻿using System;

namespace libSnesAssembler
{
	// Token: 0x0200012C RID: 300
	public class AsmProgress
	{
		// Token: 0x060007BE RID: 1982 RVA: 0x00005B5B File Offset: 0x00003D5B
		public void reset()
		{
			this.dProgressTotal = 0.0;
		}

		// Token: 0x060007BF RID: 1983 RVA: 0x0002C98C File Offset: 0x0002AB8C
		public AsmProgress clone()
		{
			AsmProgress asmProgress = new AsmProgress();
			AsmProgress asmProgress2 = asmProgress;
			asmProgress2.iCurrentProgress = this.iCurrentProgress;
			asmProgress2.iProgressCount = this.iProgressCount;
			asmProgress2.iProgressPercent = this.iProgressPercent;
			asmProgress2.sStateName = this.sStateName;
			asmProgress2.dStateTime = this.dStateTime;
			asmProgress2.bStateDone = this.bStateDone;
			asmProgress2.bNewState = this.bNewState;
			asmProgress2.dProgressTotal = this.dProgressTotal;
			return asmProgress;
		}

		// Token: 0x060007C0 RID: 1984 RVA: 0x0002CA10 File Offset: 0x0002AC10
		public AsmProgress()
		{
			this.iCurrentProgress = 0;
			this.iProgressCount = 1;
			this.iProgressPercent = 0;
			this.sStateName = null;
			this.iProgressStep = 0;
			this.iProgressStepCount = 0;
			this.dProgressWeight = 0;
			this.dProgressTotalLast = 0.0;
			this.dProgressTotal = 0.0;
			this.dStateTime = 0.0;
			this.bStateDone = false;
			this.bNewState = false;
			this.bWasteTime = false;
		}

		// Token: 0x060007C1 RID: 1985 RVA: 0x0002CA98 File Offset: 0x0002AC98
		public void startNewState(string _stateName, int _iProgressCount, int _iProgressWeight)
		{
			this.bNewState = true;
			this.bStateDone = false;
			this.sStateName = _stateName;
			this.iProgressCount = _iProgressCount;
			this.dProgressWeight = _iProgressWeight;
			this.iProgressStep = 0;
			this.iProgressStepCount = checked((int)Math.Round(Math.Ceiling((double)_iProgressCount / 100.0)));
			this.iCurrentProgress = 0;
			this.iProgressPercent = 0;
			this.dProgressTotalLast = this.dProgressTotal;
			if (this.dProgressWeight != 5)
			{
				modAsmReport.asmReport_report(this);
			}
			Console.WriteLine(_stateName);
		}

		// Token: 0x060007C2 RID: 1986 RVA: 0x0002CB1C File Offset: 0x0002AD1C
		public void progressStep()
		{
			checked
			{
				if (this.bWasteTime)
				{
					int num = 0;
					do
					{
						num = num;
						num++;
					}
					while (num <= 10000);
				}
				ref int ptr = ref this.iCurrentProgress;
				this.iCurrentProgress = ptr + 1;
				ptr = ref this.iProgressStep;
				this.iProgressStep = ptr + 1;
			}
			if (this.iProgressStep >= this.iProgressStepCount)
			{
				this.iProgressStep = 0;
				ref int ptr2 = ref this.iProgressPercent;
				this.iProgressPercent = checked(ptr2 + 1);
				ref double ptr3 = ref this.dProgressTotal;
				this.dProgressTotal = ptr3 + (double)this.dProgressWeight / 100.0;
				if (this.iProgressPercent > 100)
				{
					this.iProgressPercent = 100;
				}
				if (this.dProgressTotal > this.dProgressTotalLast + (double)this.dProgressWeight)
				{
					this.dProgressTotal = this.dProgressTotalLast + (double)this.dProgressWeight;
				}
				this.bNewState = false;
				this.bStateDone = false;
				if (this.dProgressWeight != 5)
				{
					modAsmReport.asmReport_report(this);
				}
				if ((this.iProgressPercent & 1) == 0)
				{
					Console.Write('.');
				}
			}
		}

		// Token: 0x060007C3 RID: 1987 RVA: 0x00005B6D File Offset: 0x00003D6D
		public void finishState()
		{
			this.bNewState = false;
			this.bStateDone = true;
			this.dProgressTotal = this.dProgressTotalLast + (double)this.dProgressWeight;
			if (this.dProgressWeight != 5)
			{
				modAsmReport.asmReport_report(this);
			}
			Console.WriteLine('!');
		}

		// Token: 0x04000E09 RID: 3593
		public int iCurrentProgress;

		// Token: 0x04000E0A RID: 3594
		public int iProgressCount;

		// Token: 0x04000E0B RID: 3595
		public int iProgressPercent;

		// Token: 0x04000E0C RID: 3596
		public string sStateName;

		// Token: 0x04000E0D RID: 3597
		public int iProgressStep;

		// Token: 0x04000E0E RID: 3598
		public int iProgressStepCount;

		// Token: 0x04000E0F RID: 3599
		public int dProgressWeight;

		// Token: 0x04000E10 RID: 3600
		public double dProgressTotalLast;

		// Token: 0x04000E11 RID: 3601
		public double dProgressTotal;

		// Token: 0x04000E12 RID: 3602
		public double dStateTime;

		// Token: 0x04000E13 RID: 3603
		public bool bStateDone;

		// Token: 0x04000E14 RID: 3604
		public bool bNewState;

		// Token: 0x04000E15 RID: 3605
		public bool bWasteTime;
	}
}
