﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using Microsoft.VisualBasic.MyServices;
using SnesPatcher.My;
using SnesPatcher.My.Resources;

namespace SnesPatcher
{
	// Token: 0x0200000C RID: 12
	[DesignerGenerated]
	public partial class frmIPS : Form
	{
		// Token: 0x06000036 RID: 54 RVA: 0x0000227A File Offset: 0x0000047A
		public frmIPS()
		{
			base.Load += this.frmIPS_Load;
			this.InitializeComponent();
		}

		// Token: 0x17000012 RID: 18
		// (get) Token: 0x06000039 RID: 57 RVA: 0x0000229A File Offset: 0x0000049A
		// (set) Token: 0x0600003A RID: 58 RVA: 0x000022A7 File Offset: 0x000004A7
		internal virtual OpenFileDialog dlgOpenFile { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000013 RID: 19
		// (get) Token: 0x0600003B RID: 59 RVA: 0x000022B0 File Offset: 0x000004B0
		// (set) Token: 0x0600003C RID: 60 RVA: 0x00007504 File Offset: 0x00005704
		internal virtual ListBox lstChain
		{
			[CompilerGenerated]
			get
			{
				return this._lstChain;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.lstChain_SelectedIndexChanged);
				ListBox lstChain = this._lstChain;
				if (lstChain != null)
				{
					lstChain.SelectedIndexChanged -= value2;
				}
				this._lstChain = value;
				lstChain = this._lstChain;
				if (lstChain != null)
				{
					lstChain.SelectedIndexChanged += value2;
				}
			}
		}

		// Token: 0x17000014 RID: 20
		// (get) Token: 0x0600003D RID: 61 RVA: 0x000022BD File Offset: 0x000004BD
		// (set) Token: 0x0600003E RID: 62 RVA: 0x000022CA File Offset: 0x000004CA
		internal virtual TextBox txtSelPatch { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000015 RID: 21
		// (get) Token: 0x0600003F RID: 63 RVA: 0x000022D3 File Offset: 0x000004D3
		// (set) Token: 0x06000040 RID: 64 RVA: 0x00007550 File Offset: 0x00005750
		internal virtual CheckBox chkSelNeedHeader
		{
			[CompilerGenerated]
			get
			{
				return this._chkSelNeedHeader;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.chkSelNeedHeader_CheckedChanged);
				CheckBox chkSelNeedHeader = this._chkSelNeedHeader;
				if (chkSelNeedHeader != null)
				{
					chkSelNeedHeader.CheckedChanged -= value2;
				}
				this._chkSelNeedHeader = value;
				chkSelNeedHeader = this._chkSelNeedHeader;
				if (chkSelNeedHeader != null)
				{
					chkSelNeedHeader.CheckedChanged += value2;
				}
			}
		}

		// Token: 0x17000016 RID: 22
		// (get) Token: 0x06000041 RID: 65 RVA: 0x000022E0 File Offset: 0x000004E0
		// (set) Token: 0x06000042 RID: 66 RVA: 0x0000759C File Offset: 0x0000579C
		internal virtual Button btnAddIPS
		{
			[CompilerGenerated]
			get
			{
				return this._btnAddIPS;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnAddIPS_Click);
				Button btnAddIPS = this._btnAddIPS;
				if (btnAddIPS != null)
				{
					btnAddIPS.Click -= value2;
				}
				this._btnAddIPS = value;
				btnAddIPS = this._btnAddIPS;
				if (btnAddIPS != null)
				{
					btnAddIPS.Click += value2;
				}
			}
		}

		// Token: 0x17000017 RID: 23
		// (get) Token: 0x06000043 RID: 67 RVA: 0x000022ED File Offset: 0x000004ED
		// (set) Token: 0x06000044 RID: 68 RVA: 0x000075E8 File Offset: 0x000057E8
		internal virtual Button btnRemoveSel
		{
			[CompilerGenerated]
			get
			{
				return this._btnRemoveSel;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnRemoveSel_Click);
				Button btnRemoveSel = this._btnRemoveSel;
				if (btnRemoveSel != null)
				{
					btnRemoveSel.Click -= value2;
				}
				this._btnRemoveSel = value;
				btnRemoveSel = this._btnRemoveSel;
				if (btnRemoveSel != null)
				{
					btnRemoveSel.Click += value2;
				}
			}
		}

		// Token: 0x17000018 RID: 24
		// (get) Token: 0x06000045 RID: 69 RVA: 0x000022FA File Offset: 0x000004FA
		// (set) Token: 0x06000046 RID: 70 RVA: 0x00007634 File Offset: 0x00005834
		internal virtual Button btnSelDown
		{
			[CompilerGenerated]
			get
			{
				return this._btnSelDown;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnSelDown_Click);
				Button btnSelDown = this._btnSelDown;
				if (btnSelDown != null)
				{
					btnSelDown.Click -= value2;
				}
				this._btnSelDown = value;
				btnSelDown = this._btnSelDown;
				if (btnSelDown != null)
				{
					btnSelDown.Click += value2;
				}
			}
		}

		// Token: 0x17000019 RID: 25
		// (get) Token: 0x06000047 RID: 71 RVA: 0x00002307 File Offset: 0x00000507
		// (set) Token: 0x06000048 RID: 72 RVA: 0x00007680 File Offset: 0x00005880
		internal virtual Button btnSelUp
		{
			[CompilerGenerated]
			get
			{
				return this._btnSelUp;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnSelUp_Click);
				Button btnSelUp = this._btnSelUp;
				if (btnSelUp != null)
				{
					btnSelUp.Click -= value2;
				}
				this._btnSelUp = value;
				btnSelUp = this._btnSelUp;
				if (btnSelUp != null)
				{
					btnSelUp.Click += value2;
				}
			}
		}

		// Token: 0x1700001A RID: 26
		// (get) Token: 0x06000049 RID: 73 RVA: 0x00002314 File Offset: 0x00000514
		// (set) Token: 0x0600004A RID: 74 RVA: 0x000076CC File Offset: 0x000058CC
		internal virtual Button btnOk
		{
			[CompilerGenerated]
			get
			{
				return this._btnOk;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnOk_Click);
				Button btnOk = this._btnOk;
				if (btnOk != null)
				{
					btnOk.Click -= value2;
				}
				this._btnOk = value;
				btnOk = this._btnOk;
				if (btnOk != null)
				{
					btnOk.Click += value2;
				}
			}
		}

		// Token: 0x0600004B RID: 75 RVA: 0x00007718 File Offset: 0x00005918
		private void btnSelUp_Click(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			checked
			{
				if (flag)
				{
					ListItem_Patch listItem_Patch = (ListItem_Patch)this.lstChain.SelectedItem;
					int selectedIndex = this.lstChain.SelectedIndex;
					bool flag2 = selectedIndex > 0;
					if (flag2)
					{
						this.lstChain.Items.Remove(listItem_Patch);
						this.lstChain.Items.Insert(selectedIndex - 1, listItem_Patch);
						this.lstChain.SelectedIndex = selectedIndex - 1;
					}
				}
			}
		}

		// Token: 0x0600004C RID: 76 RVA: 0x000077A0 File Offset: 0x000059A0
		private void btnSelDown_Click(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			checked
			{
				if (flag)
				{
					ListItem_Patch listItem_Patch = (ListItem_Patch)this.lstChain.SelectedItem;
					int selectedIndex = this.lstChain.SelectedIndex;
					bool flag2 = selectedIndex < this.lstChain.Items.Count - 1;
					if (flag2)
					{
						this.lstChain.Items.Remove(listItem_Patch);
						this.lstChain.Items.Insert(selectedIndex + 1, listItem_Patch);
						this.lstChain.SelectedIndex = selectedIndex + 1;
					}
				}
			}
		}

		// Token: 0x0600004D RID: 77 RVA: 0x00007838 File Offset: 0x00005A38
		private void btnRemoveSel_Click(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			if (flag)
			{
				ListItem_Patch value = (ListItem_Patch)this.lstChain.SelectedItem;
				this.lstChain.Items.Remove(value);
			}
		}

		// Token: 0x0600004E RID: 78 RVA: 0x00007880 File Offset: 0x00005A80
		private void btnAddIPS_Click(object sender, EventArgs e)
		{
			this.dlgOpenFile.Reset();
			this.dlgOpenFile.Filter = "IPS Patch (*.ips)|*.ips";
			this.dlgOpenFile.ShowDialog();
			string fileName = this.dlgOpenFile.FileName;
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			if (fileSystem.FileExists(fileName) && Operators.CompareString(fileSystem.GetFileInfo(fileName).Extension.ToLower(), ".ips", false) == 0)
			{
				ListItem_Patch listItem_Patch = new ListItem_Patch(fileName);
				if (e.GetHashCode() == 0 && Interaction.MsgBox("Does this patch require a rom header ?", MsgBoxStyle.YesNo, "Headered ?") == MsgBoxResult.Yes)
				{
					listItem_Patch.bNeedHeader = true;
				}
				this.lstChain.Items.Add(listItem_Patch);
			}
		}

		// Token: 0x0600004F RID: 79 RVA: 0x00007930 File Offset: 0x00005B30
		private void btnOk_Click(object sender, EventArgs e)
		{
			Collection collection = new Collection();
			try
			{
				foreach (object obj in this.lstChain.Items)
				{
					ListItem_Patch item = (ListItem_Patch)obj;
					collection.Add(item, null, null, null);
				}
			}
			finally
			{
				IEnumerator enumerator;
				if (enumerator is IDisposable)
				{
					(enumerator as IDisposable).Dispose();
				}
			}
			modPatchChain.setPatchChain(new PatchChain(collection, "", ""));
			base.Close();
		}

		// Token: 0x06000050 RID: 80 RVA: 0x000079C8 File Offset: 0x00005BC8
		private void frmIPS_Load(object sender, EventArgs e)
		{
			bool flag = modPatchChain.patchChain == null;
			if (flag)
			{
				Collection collection = new Collection();
				collection.Add(new ListItem_Patch(true), null, null, null);
				modPatchChain.setPatchChain(new PatchChain(collection, "", ""));
			}
			try
			{
				foreach (object obj in modPatchChain.patchChain.colPatches)
				{
					ListItem_Patch item = (ListItem_Patch)obj;
					this.lstChain.Items.Add(item);
				}
			}
			finally
			{
				IEnumerator enumerator;
				if (enumerator is IDisposable)
				{
					(enumerator as IDisposable).Dispose();
				}
			}
			this.chkSelNeedHeader.Enabled = false;
			this.btnRemoveSel.Enabled = false;
			this.btnSelDown.Enabled = false;
			this.btnSelUp.Enabled = false;
			this.lstChain.SelectedIndex = -1;
		}

		// Token: 0x06000051 RID: 81 RVA: 0x00007AC4 File Offset: 0x00005CC4
		private void lstChain_SelectedIndexChanged(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			if (flag)
			{
				ListItem_Patch listItem_Patch = (ListItem_Patch)this.lstChain.SelectedItem;
				this.txtSelPatch.Text = listItem_Patch.Name;
				this.btnSelUp.Enabled = true;
				this.btnSelDown.Enabled = true;
				bool bZPS = listItem_Patch.bZPS;
				if (bZPS)
				{
					this.chkSelNeedHeader.Checked = false;
					this.chkSelNeedHeader.Enabled = false;
					this.btnRemoveSel.Enabled = false;
				}
				else
				{
					this.chkSelNeedHeader.Enabled = true;
					this.chkSelNeedHeader.Checked = listItem_Patch.bNeedHeader;
					this.btnRemoveSel.Enabled = true;
				}
			}
			else
			{
				this.txtSelPatch.Text = "";
				this.chkSelNeedHeader.Enabled = false;
				this.btnRemoveSel.Enabled = false;
				this.btnSelUp.Enabled = false;
				this.btnSelDown.Enabled = false;
			}
		}

		// Token: 0x06000052 RID: 82 RVA: 0x00007BDC File Offset: 0x00005DDC
		private void chkSelNeedHeader_CheckedChanged(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			if (flag)
			{
				ListItem_Patch listItem_Patch = (ListItem_Patch)this.lstChain.SelectedItem;
				bool flag2 = !listItem_Patch.bZPS;
				if (flag2)
				{
					listItem_Patch.bNeedHeader = this.chkSelNeedHeader.Checked;
					int selectedIndex = this.lstChain.SelectedIndex;
					this.lstChain.Items.RemoveAt(selectedIndex);
					this.lstChain.Items.Insert(selectedIndex, listItem_Patch);
					this.lstChain.SelectedIndex = selectedIndex;
				}
			}
		}
	}
}
