﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using libSnesAssembler;
using Microsoft.VisualBasic.CompilerServices;

namespace SnesPatcher
{
	// Token: 0x0200000B RID: 11
	[DesignerGenerated]
	public partial class frmEditGlobal : Form
	{
		// Token: 0x17000010 RID: 16
		// (get) Token: 0x0600002C RID: 44 RVA: 0x00002220 File Offset: 0x00000420
		// (set) Token: 0x0600002D RID: 45 RVA: 0x00006A54 File Offset: 0x00004C54
		internal virtual Button btnOk
		{
			[CompilerGenerated]
			get
			{
				return this._btnOk;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnOk_Click);
				Button btnOk = this._btnOk;
				if (btnOk != null)
				{
					btnOk.Click -= value2;
				}
				this._btnOk = value;
				btnOk = this._btnOk;
				if (btnOk != null)
				{
					btnOk.Click += value2;
				}
			}
		}

		// Token: 0x17000011 RID: 17
		// (get) Token: 0x0600002E RID: 46 RVA: 0x0000222D File Offset: 0x0000042D
		// (set) Token: 0x0600002F RID: 47 RVA: 0x00006AA0 File Offset: 0x00004CA0
		internal virtual Button btnCancel
		{
			[CompilerGenerated]
			get
			{
				return this._btnCancel;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnCancel_Click);
				Button btnCancel = this._btnCancel;
				if (btnCancel != null)
				{
					btnCancel.Click -= value2;
				}
				this._btnCancel = value;
				btnCancel = this._btnCancel;
				if (btnCancel != null)
				{
					btnCancel.Click += value2;
				}
			}
		}

		// Token: 0x06000030 RID: 48 RVA: 0x0000223A File Offset: 0x0000043A
		public frmEditGlobal(AsmPatch _patch)
		{
			base.Load += this.frmEditGlobal_Load;
			this.cTxt = new Collection<TextBox>();
			this.InitializeComponent();
			this.patch = _patch;
		}

		// Token: 0x06000031 RID: 49 RVA: 0x00006AEC File Offset: 0x00004CEC
		private void frmEditGlobal_Load(object sender, EventArgs e)
		{
			base.Width = this.calculateWinWidth();
			int width = base.ClientRectangle.Width;
			int num = 15;
			checked
			{
				foreach (PatchGlobal patchGlobal in this.patch.dicGlobals.Values)
				{
					if (patchGlobal.bEditable)
					{
						TextBox textBox = new TextBox();
						TextBox textBox2 = textBox;
						textBox2.Left = 5 + this.iGlobalCharCount * 8 + 5;
						textBox2.Top = num;
						textBox2.Width = this.iMaxFieldWidth;
						textBox2.Height = 20;
						textBox2.Text = patchGlobal.sEditValue;
						textBox2.Tag = patchGlobal.sName;
						Label label = new Label();
						Label label2 = label;
						label2.AutoSize = false;
						label2.Left = 5;
						label2.Top = num;
						label2.Width = this.iGlobalCharCount * 8;
						label2.Height = 20;
						label2.Text = patchGlobal.sName.Replace("%", "").Replace("_", " ") + " :";
						label2.TextAlign = ContentAlignment.MiddleRight;
						label2.Font = new Font("Courier New", 8f);
						label2.BorderStyle = BorderStyle.None;
						base.Controls.Add(label);
						base.Controls.Add(textBox);
						this.cTxt.Add(textBox);
						num += textBox.Height + 1;
					}
				}
				num += 30;
				base.Height += num;
				Rectangle workingArea = Screen.FromControl(frmSnesPatcher.instance).WorkingArea;
				base.Height = Math.Min(base.Height, workingArea.Height - (base.Height - base.ClientSize.Height));
				base.Top = Math.Max(workingArea.Top, (int)Math.Round(unchecked((double)base.Top - (double)num / 2.0)));
				base.Left = (int)Math.Round(unchecked((double)base.Left - (double)(checked(base.Width - 300)) / 2.0));
				this.btnOk.Location = new Point(width - this.btnOk.Width - 32, num);
				this.btnCancel.Location = new Point(32, num);
				this.Refresh();
				this.MinimumSize = base.Size;
				this.MaximumSize = base.Size;
			}
		}

		// Token: 0x06000032 RID: 50 RVA: 0x00006D8C File Offset: 0x00004F8C
		private void btnOk_Click(object sender, EventArgs e)
		{
			try
			{
				foreach (TextBox textBox in this.cTxt)
				{
					this.patch.dicGlobals[Conversions.ToString(textBox.Tag)].sEditValue = PatchGlobal.validateEditValue(this.patch.dicGlobals[Conversions.ToString(textBox.Tag)].editType, textBox.Text);
				}
			}
			finally
			{
				IEnumerator<TextBox> enumerator;
				if (enumerator != null)
				{
					enumerator.Dispose();
				}
			}
			base.Close();
		}

		// Token: 0x06000033 RID: 51 RVA: 0x00002270 File Offset: 0x00000470
		private void btnCancel_Click(object sender, EventArgs e)
		{
			base.Close();
		}

		// Token: 0x06000034 RID: 52 RVA: 0x00006E34 File Offset: 0x00005034
		private int calculateWinWidth()
		{
			int num = 50;
			this.iGlobalCharCount = this.getMaxGlobalName();
			foreach (PatchGlobal patchGlobal in this.patch.dicGlobals.Values)
			{
				if (patchGlobal.bEditable && !string.IsNullOrEmpty(patchGlobal.sEditValue))
				{
					Size size = TextRenderer.MeasureText(patchGlobal.sEditValue, Control.DefaultFont);
					if (size.Width > this.iMaxFieldWidth)
					{
						this.iMaxFieldWidth = size.Width;
					}
				}
			}
			return checked(num + this.iMaxFieldWidth + this.iGlobalCharCount * 8);
		}

		// Token: 0x06000035 RID: 53 RVA: 0x00006EEC File Offset: 0x000050EC
		private int getMaxGlobalName()
		{
			int num = 0;
			try
			{
				foreach (PatchGlobal patchGlobal in this.patch.dicGlobals.Values)
				{
					bool bEditable = patchGlobal.bEditable;
					if (bEditable)
					{
						num = Math.Max(num, patchGlobal.sName.Length);
					}
				}
			}
			finally
			{
				Dictionary<string, PatchGlobal>.ValueCollection.Enumerator enumerator;
				((IDisposable)enumerator).Dispose();
			}
			return num;
		}

		// Token: 0x04000012 RID: 18
		private const int const_form_width_fix = 10;

		// Token: 0x04000013 RID: 19
		private const int const_labels_leftSpacing = 5;

		// Token: 0x04000014 RID: 20
		private const int const_labels_charWidth = 8;

		// Token: 0x04000015 RID: 21
		private const int const_txtBoxes_rightSpacing = 40;

		// Token: 0x04000016 RID: 22
		private const int const_txtBoxes_leftSpacing = 5;

		// Token: 0x04000017 RID: 23
		private const int const_txtBoxes_width = 100;

		// Token: 0x04000018 RID: 24
		private const int const_txtBoxes_height = 20;

		// Token: 0x04000019 RID: 25
		private const int const_globalEdit_height = 30;

		// Token: 0x0400001A RID: 26
		private Collection<TextBox> cTxt;

		// Token: 0x0400001B RID: 27
		private AsmPatch patch;

		// Token: 0x0400001C RID: 28
		private int iGlobalCharCount;

		// Token: 0x0400001D RID: 29
		public int iMaxFieldWidth;
	}
}
