﻿using System;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using libZh.My;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace libZh
{
	// Token: 0x02000094 RID: 148
	[StandardModule]
	public sealed class modCommonDebug
	{
		// Token: 0x17000155 RID: 341
		// (get) Token: 0x06000570 RID: 1392 RVA: 0x0001D740 File Offset: 0x0001B940
		// (set) Token: 0x06000571 RID: 1393 RVA: 0x0001D74C File Offset: 0x0001B94C
		public static frmDebugOut form_debug { get; [MethodImpl(MethodImplOptions.Synchronized)] set; } = null;

		// Token: 0x06000572 RID: 1394 RVA: 0x0001D754 File Offset: 0x0001B954
		public static frmDebugOut _dbgWin_new()
		{
			frmDebugOut frmDebugOut = new frmDebugOut();
			frmDebugOut.Show();
			return frmDebugOut;
		}

		// Token: 0x06000573 RID: 1395 RVA: 0x0001D77C File Offset: 0x0001B97C
		public static void _dbgWin_print(frmDebugOut formDbg, string sTxt)
		{
			bool flag = formDbg != null;
			if (flag)
			{
				formDbg.txtDebug.AppendText(sTxt);
			}
		}

		// Token: 0x06000574 RID: 1396 RVA: 0x0001D7A8 File Offset: 0x0001B9A8
		public static void _dbgWin_clear(frmDebugOut formDbg, string sTxt)
		{
			bool flag = formDbg != null;
			if (flag)
			{
				formDbg.txtDebug.AppendText(sTxt);
			}
		}

		// Token: 0x06000575 RID: 1397 RVA: 0x0001D7D4 File Offset: 0x0001B9D4
		public static void _dbgWin_destroy(frmDebugOut formDbg)
		{
			bool flag = formDbg != null;
			if (flag)
			{
				formDbg.Dispose();
				formDbg = null;
			}
		}

		// Token: 0x06000576 RID: 1398 RVA: 0x0001D800 File Offset: 0x0001BA00
		public static void _debugShow()
		{
			bool flag = modCommonDebug.form_debug == null || modCommonDebug.form_debug.IsDisposed;
			if (flag)
			{
				modCommonDebug.form_debug = new frmDebugOut();
			}
			modCommonDebug.form_debug.Show();
		}

		// Token: 0x06000577 RID: 1399 RVA: 0x0001D84C File Offset: 0x0001BA4C
		public static void _debugPrint(string sMsg)
		{
			bool visible = modCommonDebug.form_debug.Visible;
			if (visible)
			{
				modCommonDebug.form_debug.txtDebug.AppendText(sMsg);
			}
		}

		// Token: 0x06000578 RID: 1400 RVA: 0x0001D884 File Offset: 0x0001BA84
		public static void _debugClear()
		{
			bool visible = modCommonDebug.form_debug.Visible;
			if (visible)
			{
				modCommonDebug.form_debug.txtDebug.Text = "";
			}
		}

		// Token: 0x06000579 RID: 1401 RVA: 0x0001D8C0 File Offset: 0x0001BAC0
		public static void _debugShowLog()
		{
			frmDebugOut frmDebugOut = new frmDebugOut();
			try
			{
				frmDebugOut.txtDebug.Text = MyProject.Computer.FileSystem.ReadAllText("debug.txt");
				frmDebugOut.txtDebug.SelectionLength = 0;
				frmDebugOut.txtDebug.SelectionStart = 0;
				frmDebugOut.WindowState = FormWindowState.Maximized;
				frmDebugOut.ShowDialog();
			}
			catch (Exception ex)
			{
				Interaction.MsgBox("Couldn't open the debug log:\r\n\r\n" + ex.Message, MsgBoxStyle.OkOnly, null);
			}
		}

		// Token: 0x0600057A RID: 1402 RVA: 0x0001D960 File Offset: 0x0001BB60
		public static void _debugDialog(string sTxt)
		{
			frmDebugOut frmDebugOut = new frmDebugOut();
			try
			{
				TextBox txtDebug = frmDebugOut.txtDebug;
				txtDebug.Text = sTxt;
				txtDebug.SelectionLength = 0;
				txtDebug.SelectionStart = 0;
				frmDebugOut.ShowDialog();
			}
			catch (Exception ex)
			{
				Interaction.MsgBox("Couldn't open the debug dialog:\r\n\r\n" + ex.Message, MsgBoxStyle.OkOnly, null);
			}
		}

		// Token: 0x0600057B RID: 1403 RVA: 0x0001D9E0 File Offset: 0x0001BBE0
		public static void _debugPause()
		{
			modCommonDebug._bDebugPaused = true;
		}

		// Token: 0x0600057C RID: 1404 RVA: 0x0001D9F0 File Offset: 0x0001BBF0
		public static void _debugResume()
		{
			modCommonDebug._bDebugPaused = false;
		}

		// Token: 0x0600057D RID: 1405 RVA: 0x0001DA00 File Offset: 0x0001BC00
		public static void _debugStart()
		{
			modCommonDebug._bPrintDebug = true;
			modCommonDebug._bDebugPaused = false;
			MyProject.Computer.FileSystem.WriteAllText("debug.txt", "", false);
		}

		// Token: 0x0600057E RID: 1406 RVA: 0x0001DA34 File Offset: 0x0001BC34
		public static void _debugStop()
		{
			modCommonDebug._bPrintDebug = false;
			modCommonDebug._bDebugPaused = true;
		}

		// Token: 0x0600057F RID: 1407 RVA: 0x0001DA50 File Offset: 0x0001BC50
		public static void _debugWrite(string sMsg)
		{
			bool flag = Conversions.ToBoolean(Operators.AndObject(modCommonDebug._bPrintDebug, Operators.NotObject(modCommonDebug._bDebugPaused)));
			if (flag)
			{
				object counter;
				object loopObj;
				bool flag2 = ObjectFlowControl.ForLoopControl.ForLoopInitObj(counter, 0, Operators.SubtractObject(modCommonDebug._debugIndent, 1), 1, ref loopObj, ref counter);
				if (flag2)
				{
					do
					{
						MyProject.Computer.FileSystem.WriteAllText("debug.txt", "\t", true);
					}
					while (ObjectFlowControl.ForLoopControl.ForNextCheckObj(counter, loopObj, ref counter));
				}
				MyProject.Computer.FileSystem.WriteAllText("debug.txt", sMsg + "\r\n", true);
			}
		}

		// Token: 0x06000580 RID: 1408 RVA: 0x0001DAFC File Offset: 0x0001BCFC
		public static void _debugSectionStart(string sSection)
		{
			modCommonDebug._debugWrite("| " + sSection);
			modCommonDebug._debugWrite("-------------------------------------------------");
			bool flag = Conversions.ToBoolean(modCommonDebug._bPrintDebug);
			if (flag)
			{
				modCommonDebug._debugIndent = Operators.AddObject(modCommonDebug._debugIndent, 1);
			}
		}

		// Token: 0x06000581 RID: 1409 RVA: 0x0001DB54 File Offset: 0x0001BD54
		public static void _debugSectionEnd()
		{
			bool flag = Conversions.ToBoolean(modCommonDebug._bPrintDebug);
			if (flag)
			{
				modCommonDebug._debugIndent = Operators.SubtractObject(modCommonDebug._debugIndent, 1);
				bool flag2 = Operators.ConditionalCompareObjectLess(modCommonDebug._debugIndent, 0, false);
				if (flag2)
				{
					modCommonDebug._debugIndent = 0;
				}
			}
			modCommonDebug._debugWrite("-------------------------------------------------");
		}

		// Token: 0x04000922 RID: 2338
		public static object _bPrintDebug = false;

		// Token: 0x04000923 RID: 2339
		public static object _bDebugPaused = false;

		// Token: 0x04000924 RID: 2340
		public static object _debugIndent = 0;
	}
}
