﻿using System;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;

namespace libZh
{
	// Token: 0x02000090 RID: 144
	[DesignerGenerated]
	public partial class frmLoadBarForm : Form
	{
		// Token: 0x06000550 RID: 1360 RVA: 0x0001CE5C File Offset: 0x0001B05C
		public frmLoadBarForm()
		{
			base.Load += this.frmLoadBarForm_Load;
			base.Click += this.frmLoadBarForm_Click;
			this.formParent = null;
			this.colLoadBars = new Collection<ctrFancyLoading>();
			this.bFinished = false;
			this.InitializeComponent();
		}

		// Token: 0x06000553 RID: 1363 RVA: 0x0001CFA8 File Offset: 0x0001B1A8
		private void frmLoadBarForm_Load(object sender, EventArgs e)
		{
		}

		// Token: 0x06000554 RID: 1364 RVA: 0x0001CFAC File Offset: 0x0001B1AC
		public ctrFancyLoading addLoadBar(int _iProgressTotal, bool bShowProgressUnits = false, Color color1 = default(Color))
		{
			ctrFancyLoading ctrFancyLoading = new ctrFancyLoading(_iProgressTotal, bShowProgressUnits, color1);
			this.colLoadBars.Add(ctrFancyLoading);
			base.Controls.Add(ctrFancyLoading);
			this.updateLoadBars();
			return ctrFancyLoading;
		}

		// Token: 0x06000555 RID: 1365 RVA: 0x0001CFF0 File Offset: 0x0001B1F0
		public ctrFancyLoading addLoadBar(int _iProgressTotal, Color _color1, Color _color2, bool bShowProgressUnits = false)
		{
			ctrFancyLoading ctrFancyLoading = new ctrFancyLoading(_iProgressTotal, _color1, _color2, bShowProgressUnits);
			this.colLoadBars.Add(ctrFancyLoading);
			base.Controls.Add(ctrFancyLoading);
			this.updateLoadBars();
			ctrFancyLoading.Click += this.frmLoadBarForm_Click;
			return ctrFancyLoading;
		}

		// Token: 0x06000556 RID: 1366 RVA: 0x0001D04C File Offset: 0x0001B24C
		public void clearLoadBars()
		{
			this.bFinished = false;
			for (;;)
			{
				bool flag = this.colLoadBars.Count == 0;
				if (flag)
				{
					break;
				}
				ctrFancyLoading ctrFancyLoading = this.colLoadBars.First<ctrFancyLoading>();
				this.colLoadBars.Remove(ctrFancyLoading);
				base.Controls.Remove(ctrFancyLoading);
			}
			this.updateLoadBars();
		}

		// Token: 0x06000557 RID: 1367 RVA: 0x0001D0AC File Offset: 0x0001B2AC
		public object removeLoadBar(ctrFancyLoading lBar)
		{
			this.colLoadBars.Remove(lBar);
			base.Controls.Remove(lBar);
			this.updateLoadBars();
			object result;
			return result;
		}

		// Token: 0x06000558 RID: 1368 RVA: 0x0001D0E0 File Offset: 0x0001B2E0
		private void updateLoadBars()
		{
			bool flag = this.colLoadBars.Count > 0;
			if (flag)
			{
				bool flag2 = !base.Visible;
				if (flag2)
				{
					base.Show();
				}
				this.updateLoc();
			}
			else
			{
				bool visible = base.Visible;
				if (visible)
				{
					base.Hide();
				}
			}
			checked
			{
				int num = this.colLoadBars.Count - 1;
				for (int i = 0; i <= num; i++)
				{
					this.colLoadBars[i].Top = 2 + i * 27;
					this.colLoadBars[i].Width = base.Size.Width - 4;
					this.colLoadBars[i].Left = 2;
					this.colLoadBars[i].Height = 24;
				}
				base.Height = this.colLoadBars.Count * 27 + 1;
				this.updateLoc();
			}
		}

		// Token: 0x06000559 RID: 1369 RVA: 0x0001D1E8 File Offset: 0x0001B3E8
		private void updateLoc()
		{
			bool flag = this.formParent != null;
			if (flag)
			{
				Rectangle rect = modForms.form_getBounds(this.formParent);
				Rectangle rect2 = modForms.form_getBounds(this);
				base.Location = modRectangle.rectangle_setLocCentered(rect2, modRectangle.rectangle_getCenter(rect)).Location;
			}
			this.Refresh();
		}

		// Token: 0x0600055A RID: 1370 RVA: 0x0001D244 File Offset: 0x0001B444
		public void finished()
		{
			this.bFinished = true;
			this.clearLoadBars();
		}

		// Token: 0x0600055B RID: 1371 RVA: 0x0001D258 File Offset: 0x0001B458
		private void frmLoadBarForm_Click(object sender, EventArgs e)
		{
			bool flag = this.bFinished;
			if (flag)
			{
				this.clearLoadBars();
			}
		}

		// Token: 0x0400091A RID: 2330
		public Form formParent;

		// Token: 0x0400091B RID: 2331
		private const int const_loadBarHeight = 24;

		// Token: 0x0400091C RID: 2332
		public Collection<ctrFancyLoading> colLoadBars;

		// Token: 0x0400091D RID: 2333
		private bool bFinished;
	}
}
