﻿using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Text;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;

namespace libZh
{
	// Token: 0x0200008F RID: 143
	[DesignerGenerated]
	public class ctrFancyLoading : UserControl
	{
		// Token: 0x0600053C RID: 1340 RVA: 0x0001C550 File Offset: 0x0001A750
		[DebuggerNonUserCode]
		protected override void Dispose(bool disposing)
		{
			try
			{
				bool flag = disposing && this.components != null;
				if (flag)
				{
					this.components.Dispose();
				}
			}
			finally
			{
				base.Dispose(disposing);
			}
		}

		// Token: 0x0600053D RID: 1341 RVA: 0x0001C5AC File Offset: 0x0001A7AC
		[DebuggerStepThrough]
		private void InitializeComponent()
		{
			this.pnlBar = new Panel();
			this.lblProgress = new Label();
			this.lblLabel = new Label();
			base.SuspendLayout();
			this.pnlBar.Anchor = (AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right);
			this.pnlBar.BackColor = Color.FromArgb(92, 92, 92);
			this.pnlBar.BorderStyle = BorderStyle.FixedSingle;
			this.pnlBar.Location = new Point(134, 1);
			this.pnlBar.Name = "pnlBar";
			this.pnlBar.Size = new Size(314, 18);
			this.pnlBar.TabIndex = 0;
			this.lblProgress.Anchor = (AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Right);
			this.lblProgress.BackColor = Color.FromArgb(48, 48, 48);
			this.lblProgress.BorderStyle = BorderStyle.FixedSingle;
			this.lblProgress.Font = new Font("Microsoft Sans Serif", 8.25f, FontStyle.Regular, GraphicsUnit.Point, 0);
			this.lblProgress.ForeColor = Color.White;
			this.lblProgress.Location = new Point(450, 1);
			this.lblProgress.Name = "lblProgress";
			this.lblProgress.Size = new Size(101, 18);
			this.lblProgress.TabIndex = 1;
			this.lblProgress.Text = " 1 / 3";
			this.lblProgress.TextAlign = ContentAlignment.MiddleCenter;
			this.lblLabel.Anchor = (AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left);
			this.lblLabel.BackColor = Color.FromArgb(48, 48, 48);
			this.lblLabel.BorderStyle = BorderStyle.FixedSingle;
			this.lblLabel.Font = new Font("Microsoft Sans Serif", 8.25f, FontStyle.Regular, GraphicsUnit.Point, 0);
			this.lblLabel.ForeColor = Color.White;
			this.lblLabel.Location = new Point(2, 1);
			this.lblLabel.Name = "lblLabel";
			this.lblLabel.Size = new Size(130, 18);
			this.lblLabel.TabIndex = 2;
			this.lblLabel.Text = "Working...";
			this.lblLabel.TextAlign = ContentAlignment.MiddleCenter;
			base.AutoScaleMode = AutoScaleMode.None;
			this.BackColor = Color.Black;
			base.BorderStyle = BorderStyle.FixedSingle;
			base.Controls.Add(this.lblLabel);
			base.Controls.Add(this.lblProgress);
			base.Controls.Add(this.pnlBar);
			this.Cursor = Cursors.WaitCursor;
			base.Name = "ctrFancyLoading";
			base.Size = new Size(555, 23);
			base.ResumeLayout(false);
		}

		// Token: 0x1700014E RID: 334
		// (get) Token: 0x0600053E RID: 1342 RVA: 0x0001C880 File Offset: 0x0001AA80
		// (set) Token: 0x0600053F RID: 1343 RVA: 0x0001C890 File Offset: 0x0001AA90
		internal virtual Panel pnlBar
		{
			[CompilerGenerated]
			get
			{
				return this._pnlBar;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				PaintEventHandler value2 = new PaintEventHandler(this.pnlBar_Paint);
				Panel pnlBar = this._pnlBar;
				if (pnlBar != null)
				{
					pnlBar.Paint -= value2;
				}
				this._pnlBar = value;
				pnlBar = this._pnlBar;
				if (pnlBar != null)
				{
					pnlBar.Paint += value2;
				}
			}
		}

		// Token: 0x1700014F RID: 335
		// (get) Token: 0x06000540 RID: 1344 RVA: 0x0001C8E0 File Offset: 0x0001AAE0
		// (set) Token: 0x06000541 RID: 1345 RVA: 0x0001C8F0 File Offset: 0x0001AAF0
		internal virtual Label lblProgress
		{
			[CompilerGenerated]
			get
			{
				return this._lblProgress;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.lblProgress_Click);
				Label lblProgress = this._lblProgress;
				if (lblProgress != null)
				{
					lblProgress.Click -= value2;
				}
				this._lblProgress = value;
				lblProgress = this._lblProgress;
				if (lblProgress != null)
				{
					lblProgress.Click += value2;
				}
			}
		}

		// Token: 0x17000150 RID: 336
		// (get) Token: 0x06000542 RID: 1346 RVA: 0x0001C940 File Offset: 0x0001AB40
		// (set) Token: 0x06000543 RID: 1347 RVA: 0x0001C950 File Offset: 0x0001AB50
		internal virtual Label lblLabel
		{
			[CompilerGenerated]
			get
			{
				return this._lblLabel;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.lblLabel_Click);
				Label lblLabel = this._lblLabel;
				if (lblLabel != null)
				{
					lblLabel.Click -= value2;
				}
				this._lblLabel = value;
				lblLabel = this._lblLabel;
				if (lblLabel != null)
				{
					lblLabel.Click += value2;
				}
			}
		}

		// Token: 0x17000151 RID: 337
		// (get) Token: 0x06000544 RID: 1348 RVA: 0x0001C9A0 File Offset: 0x0001ABA0
		// (set) Token: 0x06000545 RID: 1349 RVA: 0x0001C9C4 File Offset: 0x0001ABC4
		public string sLabel
		{
			get
			{
				return this.lblLabel.Text;
			}
			set
			{
				this.lblLabel.Text = value;
			}
		}

		// Token: 0x17000152 RID: 338
		// (get) Token: 0x06000547 RID: 1351 RVA: 0x0001CA18 File Offset: 0x0001AC18
		// (set) Token: 0x06000546 RID: 1350 RVA: 0x0001C9D4 File Offset: 0x0001ABD4
		public int Progress
		{
			get
			{
				return this.iProgress;
			}
			set
			{
				this.iProgress = value;
				bool flag = this.iProgress > this.iProgressTotal;
				if (flag)
				{
					this.iProgress = this.iProgressTotal;
				}
				this.updateGfx();
			}
		}

		// Token: 0x17000153 RID: 339
		// (get) Token: 0x06000549 RID: 1353 RVA: 0x0001CA44 File Offset: 0x0001AC44
		// (set) Token: 0x06000548 RID: 1352 RVA: 0x0001CA38 File Offset: 0x0001AC38
		public int ProgressTotal
		{
			get
			{
				return this.iProgressTotal;
			}
			set
			{
				this.iProgressTotal = value;
			}
		}

		// Token: 0x0600054A RID: 1354 RVA: 0x0001CA64 File Offset: 0x0001AC64
		private void updateGfx()
		{
			float num = (float)((double)this.iProgress / (double)this.iProgressTotal);
			int num2 = checked((int)Math.Round(Math.Floor((double)(unchecked(num * 100f)))));
			this.pnlBar.BackgroundImage = new Bitmap(this.pnlBar.ClientSize.Width, this.pnlBar.ClientSize.Height);
			Graphics graphics = Graphics.FromImage(this.pnlBar.BackgroundImage);
			RectangleF rect = new RectangleF(0f, 0f, (float)this.pnlBar.ClientSize.Width * num, (float)this.pnlBar.ClientSize.Height);
			HatchBrush hatchBrush = new HatchBrush(HatchStyle.WideDownwardDiagonal, this.color1, this.color2);
			HatchBrush hatchBrush2 = new HatchBrush(HatchStyle.ForwardDiagonal, this.color1, this.color2);
			Brush brush = hatchBrush;
			int num3 = num2 & 4;
			graphics.FillRectangle(brush, rect);
			graphics.DrawRectangle(new Pen(Brushes.Black), rect.X, rect.Y, rect.Width - 1f, rect.Height - 1f);
			Font font = new Font("Consolas", 12.5f, FontStyle.Bold);
			string text = Conversions.ToString(num2) + " %";
			Size size = TextRenderer.MeasureText(text, font);
			graphics.TextRenderingHint = TextRenderingHint.ClearTypeGridFit;
			graphics.SmoothingMode = SmoothingMode.HighQuality;
			Point origin = checked(new Point((int)Math.Round((double)(this.pnlBar.ClientSize.Width - size.Width) / 2.0), (int)Math.Round((double)(this.pnlBar.ClientSize.Height - size.Height) / 2.0)));
			GraphicsPath graphicsPath = new GraphicsPath();
			graphicsPath.AddString(text, font.FontFamily, (int)font.Style, graphics.DpiY * font.Size / 72f, origin, new StringFormat());
			graphics.DrawPath(new Pen(Brushes.Black, 4f), graphicsPath);
			graphics.FillPath(Brushes.White, graphicsPath);
			graphics.Dispose();
			this.lblProgress.Text = Conversions.ToString(this.iProgress) + " / " + Conversions.ToString(this.iProgressTotal);
		}

		// Token: 0x0600054B RID: 1355 RVA: 0x0001CCC8 File Offset: 0x0001AEC8
		public ctrFancyLoading(int _iProgressTotal, Color _color1, Color _color2, bool bShowProgressUnits = false)
		{
			this.iProgress = 0;
			this.iProgressTotal = 100;
			this.iSel = 0;
			this.bShowLabel = false;
			this.color1 = _color1;
			this.color2 = _color2;
			this.iProgressTotal = _iProgressTotal;
			this.InitializeComponent();
			bool flag = !bShowProgressUnits;
			if (flag)
			{
				this.pnlBar.Size = new Size(checked(base.Size.Width - 6), this.pnlBar.Size.Height);
				this.lblProgress.Visible = false;
			}
		}

		// Token: 0x0600054C RID: 1356 RVA: 0x0001CD6C File Offset: 0x0001AF6C
		public ctrFancyLoading(int _iProgressTotal, bool bShowProgressUnits = false, Color _color1 = default(Color))
		{
			this.iProgress = 0;
			this.iProgressTotal = 100;
			this.iSel = 0;
			this.bShowLabel = false;
			bool flag = _color1 == default(Color);
			if (flag)
			{
				_color1 = Color.DarkSlateBlue;
			}
			this.color1 = _color1;
			checked
			{
				this.color2 = Color.FromArgb(_color1.ToArgb() - 2105376);
				this.iProgressTotal = _iProgressTotal;
				this.InitializeComponent();
				bool flag2 = !bShowProgressUnits;
				if (flag2)
				{
					this.pnlBar.Size = new Size(base.Size.Width - 6, this.pnlBar.Size.Height);
					this.lblProgress.Visible = false;
				}
				bool flag3 = !this.bShowLabel;
				if (flag3)
				{
				}
			}
		}

		// Token: 0x0600054D RID: 1357 RVA: 0x0001CE50 File Offset: 0x0001B050
		private void lblProgress_Click(object sender, EventArgs e)
		{
		}

		// Token: 0x0600054E RID: 1358 RVA: 0x0001CE54 File Offset: 0x0001B054
		private void lblLabel_Click(object sender, EventArgs e)
		{
		}

		// Token: 0x0600054F RID: 1359 RVA: 0x0001CE58 File Offset: 0x0001B058
		private void pnlBar_Paint(object sender, PaintEventArgs e)
		{
		}

		// Token: 0x0400090F RID: 2319
		private IContainer components;

		// Token: 0x04000913 RID: 2323
		private int iProgress;

		// Token: 0x04000914 RID: 2324
		private int iProgressTotal;

		// Token: 0x04000915 RID: 2325
		private int iSel;

		// Token: 0x04000916 RID: 2326
		public Color color1;

		// Token: 0x04000917 RID: 2327
		public Color color2;

		// Token: 0x04000918 RID: 2328
		public bool bShowLabel;
	}
}
