﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace libSnesAssembler
{
	// Token: 0x020000C6 RID: 198
	[StandardModule]
	public sealed class modProjectBuilder
	{
		// Token: 0x0600069E RID: 1694 RVA: 0x00027E08 File Offset: 0x00026008
		public static modAssemblerStructs.asmProject createAsmProject(string pathSourceRom, string pathDestRom, string pathProject, AsmPatch patchFile)
		{
			modAssemblerStructs.asmProject result = default(modAssemblerStructs.asmProject);
			result.pathSourceRom = pathSourceRom;
			result.pathDestRom = pathDestRom;
			result.pathProject = pathProject;
			result.patchFile = patchFile;
			modProjectBuilder.makeProject(ref result);
			return result;
		}

		// Token: 0x0600069F RID: 1695 RVA: 0x00027E54 File Offset: 0x00026054
		public static modAssemblerStructs.asmProject createAsmProject(string pathSourceRom, string pathDestRom, string pathProject)
		{
			AsmPatchBuilder asmPatchBuilder = new AsmPatchBuilder(pathProject, pathSourceRom, false);
			return modProjectBuilder.createAsmProject(pathSourceRom, pathDestRom, pathProject, new AsmPatch(asmPatchBuilder.sPathPatch)
			{
				bUsePatch = false
			});
		}

		// Token: 0x060006A0 RID: 1696 RVA: 0x00027E94 File Offset: 0x00026094
		private static void makeProject(ref modAssemblerStructs.asmProject project)
		{
			assemblerOpcodes.dicAsmCmd.Clear();
			modAsmDefs.dicAliases.Clear();
			modAsmDefs.dicBlocks.Clear();
			modAsmDefs.dicDef.Clear();
			modAsmDefs.dicLabels.Clear();
			modAsmDefs.dicRelative.Clear();
			modAsmDefs.colAsmBlocks.Clear();
			project.bSkip_UntilEndIf = false;
			modAssemble.asmDbg = "";
			modAssemble.asmDbg_Cmd = "";
			modAssemble.asmDbg_Bytes = "";
			modAssemble.asmDbg_Msg = "";
			modAssemble.asmDbg_Param = "";
			modAsmDefs.asmDbg_Defs = "";
			modAsmDefs.curRelative = null;
			assemblerOpcodes.bError = false;
			compiler.offset = 12582912;
			modAsmDefs.bPreparing = true;
			modCommonDebug._debugSectionStart("MAKE OPTIONS:");
			try
			{
				foreach (string text in project.patchFile.dicOptions.Keys)
				{
					modCommonDebug._debugWrite("OPTION CHOICE: " + project.patchFile.optionOn(text).ToString() + "  " + project.patchFile.dicOptions[text].sName);
				}
			}
			finally
			{
				Dictionary<string, PatchOption>.KeyCollection.Enumerator enumerator;
				((IDisposable)enumerator).Dispose();
			}
			modCommonDebug._debugSectionEnd();
			modCommonDebug._debugWrite("MAKE: Linking\r\n");
			modAssemblerStructs.AsmLinkedProject linked = modProjectLinker.linkProject(ref project);
			project.linked = linked;
			modCommonDebug._debugWrite("MAKE: SetDefininitions\r\n");
			bool flag = modAsmDefs.setDefinitions(project);
			if (flag)
			{
				modCommonDebug._debugWrite("MAKE: Compile\r\n");
				bool flag2 = modProjectBuilder.compileProject(ref project, ref linked);
				if (flag2)
				{
					modCommonDebug._debugWrite("MAKE: Assemble\r\n");
					bool flag3 = modProjectBuilder.assembleProject(ref project, ref linked);
					if (flag3)
					{
						project.state = modAssemblerStructs.asmProject.enumProjectState.success;
						modAssemble.bgAsmWorker.ReportProgress(100);
						modCommonDebug._debugSectionStart("MAKE: Success !");
						project.targetCRC32 = Crc32.getFileChecksum(project.pathDestRom);
						modCommonDebug._debugWrite("CRC32 : " + modString.hx(project.targetCRC32, 2));
						modCommonDebug._debugSectionEnd();
						return;
					}
					project.state = modAssemblerStructs.asmProject.enumProjectState.errorAssembling;
					Interaction.MsgBox("Error Assembling", MsgBoxStyle.OkOnly, null);
				}
				else
				{
					project.state = modAssemblerStructs.asmProject.enumProjectState.errorCompiling;
					Interaction.MsgBox("Error Compiling", MsgBoxStyle.OkOnly, null);
				}
			}
			else
			{
				project.state = modAssemblerStructs.asmProject.enumProjectState.errorDefining;
			}
			modCommonDebug._debugWrite("MAKE: ERROR\r\n");
		}

		// Token: 0x060006A1 RID: 1697 RVA: 0x00028108 File Offset: 0x00026308
		private static bool compileProject(ref modAssemblerStructs.asmProject project, ref modAssemblerStructs.AsmLinkedProject asmLink)
		{
			modAsmReport.asmProgReport.startNewState("Compiling", checked(asmLink.cAsm.Count * 2), 30);
			project.resultComp = compiler.compile_better(project, true);
			modAsmReport.asmProgReport.finishState();
			bool bError = assemblerOpcodes.bError;
			bool result;
			if (bError)
			{
				project.bError = true;
				project.bCompileError = true;
				result = false;
			}
			else
			{
				result = true;
			}
			return result;
		}

		// Token: 0x060006A2 RID: 1698 RVA: 0x00028180 File Offset: 0x00026380
		private static bool assembleProject(ref modAssemblerStructs.asmProject project, ref modAssemblerStructs.AsmLinkedProject asmLink)
		{
			modAsmReport.asmProgReport.startNewState("Assembling", checked(asmLink.cAsm.Count * 2), 30);
			try
			{
				foreach (object obj in modAsmDefs.colAsmBlocks)
				{
					modAssemblerStructs.AsmBlock asmBlock = (modAssemblerStructs.AsmBlock)obj;
					asmBlock.addr = asmBlock.baseAddr;
				}
			}
			finally
			{
				IEnumerator enumerator;
				if (enumerator is IDisposable)
				{
					(enumerator as IDisposable).Dispose();
				}
			}
			project.resultBuild = compiler.compile_better(project, false);
			modAsmReport.asmProgReport.finishState();
			bool flag = !assemblerOpcodes.bError;
			bool result;
			if (flag)
			{
				modAsmRom.writeToRom(ref project.pathDestRom);
				result = true;
			}
			else
			{
				result = false;
			}
			return result;
		}

		// Token: 0x04000999 RID: 2457
		public static Collection<string> cAsmFiles = new Collection<string>();

		// Token: 0x0400099A RID: 2458
		public static Collection<string> cDebugDefFiles = new Collection<string>();

		// Token: 0x0400099B RID: 2459
		public static int iAsm_ProgressCount;

		// Token: 0x0400099C RID: 2460
		public static int iAsm_Progress = 0;

		// Token: 0x0400099D RID: 2461
		public static int iAsm_ProgressPercent = 0;
	}
}
