﻿using System;
using libScriptEngine;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace libSnesAssembler
{
	// Token: 0x020000BD RID: 189
	[StandardModule]
	public sealed class modProcCommands
	{
		// Token: 0x06000676 RID: 1654 RVA: 0x00025590 File Offset: 0x00023790
		public static string cmd_OP(string s, bool bPre)
		{
			string text = "";
			bool flag = s.Length > "OP ".Length;
			if (flag)
			{
				text = s.Substring("OP ".Length);
			}
			bool flag2 = assemblerOpcodes.dicAsmCmd.ContainsKey(text);
			string result;
			if (flag2)
			{
				result = assemblerOpcodes.dicAsmCmd[text];
			}
			else
			{
				assemblerOpcodes.bError = true;
				string text2 = "OP: command '" + text + "' doesn't exist";
				modCommonDebug._debugWrite("ERROR " + text2);
				text2 = text2.Replace(" ", "_");
				result = "<<" + text2 + ">>";
			}
			return result;
		}

		// Token: 0x06000677 RID: 1655 RVA: 0x0002565C File Offset: 0x0002385C
		public static string cmd_RAW(string s, bool bPre)
		{
			checked
			{
				string text = Strings.Right(s, s.Length - 4);
				text = text.Replace(" ", "");
				text = text.Replace("\t", "");
				int num = 0;
				while (text.Length - num >= 0)
				{
					num += 2;
					bool flag = text.Length - num == 0;
					if (flag)
					{
						return text;
					}
				}
				assemblerOpcodes.bError = true;
				modCommonDebug._debugWrite("\r\n\r\nERROR: RAW, argument must have an even number of characters\r\n\r\n");
				return "<<_RAW:_there_must_be_an_even_number_of_digits>>";
			}
		}

		// Token: 0x06000678 RID: 1656 RVA: 0x000256F8 File Offset: 0x000238F8
		public static string cmd_COPY(string s, bool bPre)
		{
			checked
			{
				string[] array = Strings.Right(s, s.Length - 5).Split(new char[]
				{
					' '
				});
				bool flag = array.Length != 2;
				string result;
				if (flag)
				{
					result = "";
				}
				else
				{
					int num = modString.fromSnesAddr(array[0]);
					int num2 = modString.hx(array[1]);
					string text = "";
					int num3 = num2 - 1;
					for (int i = 0; i <= num3; i++)
					{
						text += modString.hx((int)modROM.rom[num + i], 2);
					}
					result = text;
				}
				return result;
			}
		}

		// Token: 0x06000679 RID: 1657 RVA: 0x000257A4 File Offset: 0x000239A4
		public static string cmd_OFF(string _str, bool _bPre)
		{
			string[] array = _str.Split(new char[]
			{
				' '
			});
			modAssemble.asmDbg_Msg = "Set Offset";
			bool flag = array.Length > 1;
			string result;
			if (flag)
			{
				string text = array[1];
				bool flag2 = text.StartsWith("!");
				if (flag2)
				{
					text = text.Substring(1);
				}
				bool flag3 = modAsmDefs.dicRelative.ContainsKey(text);
				if (flag3)
				{
					bool bDefined = modAsmDefs.dicRelative[text].bDefined;
					if (bDefined)
					{
						modAsmDefs.curRelative = modAsmDefs.dicRelative[text];
						compiler.offset = modAsmDefs.dicRelative[text].offset;
						compiler.funcOffset = compiler.offset;
					}
					else
					{
						modAsmDefs.curRelative = modAsmDefs.dicRelative[text];
						modAsmDefs.dicRelative[text].offset = modAsmDefs.dicRelative[text].asmBlock.addr;
						compiler.offset = modAsmDefs.dicRelative[text].asmBlock.addr;
						compiler.funcOffset = compiler.offset;
					}
					result = "";
				}
				else
				{
					bool flag4 = modAsmDefs.dicDef.ContainsKey(text);
					if (flag4)
					{
						text = modAsmDefs.dicDef[text];
					}
					bool flag5 = text.Length == 7;
					if (flag5)
					{
						int num = modString.hx(text.Substring(1, 6));
						bool flag6 = num != -1;
						if (flag6)
						{
							compiler.offset = num;
							result = "";
						}
						else
						{
							assemblerOpcodes.bError = true;
							modCommonDebug._debugWrite("\r\n\r\nERROR: Bad offset addr\r\n\r\n");
							result = "<< BAD OFFSET ADDR >>";
						}
					}
					else
					{
						assemblerOpcodes.bError = true;
						modCommonDebug._debugWrite("\r\n\r\nERROR: Bad offset Length\r\n\r\n");
						result = "<< BAD OFFSET LENGTH >>";
					}
				}
			}
			else
			{
				assemblerOpcodes.bError = true;
				modCommonDebug._debugWrite("\r\n\r\nERROR: No offset addr\r\n\r\n");
				result = "<< NO OFFSET ADDR >>";
			}
			return result;
		}

		// Token: 0x0600067A RID: 1658 RVA: 0x00025990 File Offset: 0x00023B90
		private static string get_ADR(string _str, bool _bPre, ref bool _bErr)
		{
			_bErr = false;
			string[] array = _str.Split(new char[]
			{
				' '
			});
			bool flag = array.Length > 1;
			string result;
			if (flag)
			{
				string text = array[1];
				bool flag2 = modAsmDefs.dicRelative.ContainsKey(text);
				if (flag2)
				{
					text = modString.hx(modAsmDefs.dicRelative[text].offset, 6);
					result = text;
				}
				else
				{
					bool flag3 = modAsmDefs.dicDef.ContainsKey(text);
					if (flag3)
					{
						text = modAsmDefs.dicDef[text];
					}
					bool flag4 = text.Length == 7;
					if (flag4)
					{
						int num = modString.hx(text.Substring(1, 6));
						bool flag5 = num != -1;
						if (flag5)
						{
							text = modString.hx(num, 6);
							result = text;
						}
						else
						{
							assemblerOpcodes.bError = true;
							modCommonDebug._debugWrite("\r\n\r\nERROR: Bad offset addr\r\n\r\n");
							_bErr = true;
							result = "<< BAD_OFFSET_ADDR >>";
						}
					}
					else
					{
						assemblerOpcodes.bError = true;
						_bErr = true;
						modCommonDebug._debugWrite("\r\n\r\nERROR: Bad offset Length\r\n\r\n");
						result = "<< BAD_OFFSET_LENGTH >>";
					}
				}
			}
			else
			{
				assemblerOpcodes.bError = true;
				_bErr = true;
				modCommonDebug._debugWrite("\r\n\r\nERROR: no offset addr\r\n\r\n");
				result = "<< NO_OFFSET_ADDR >>";
			}
			return result;
		}

		// Token: 0x0600067B RID: 1659 RVA: 0x00025ACC File Offset: 0x00023CCC
		public static string cmd_ADR_BANK(string _str, bool _bPre)
		{
			bool flag = false;
			string text = modProcCommands.get_ADR(_str, _bPre, ref flag);
			bool flag2 = !flag;
			string result;
			if (flag2)
			{
				result = text.Substring(0, 2);
			}
			else
			{
				result = text;
			}
			return result;
		}

		// Token: 0x0600067C RID: 1660 RVA: 0x00025B0C File Offset: 0x00023D0C
		public static string cmd_ADR_16(string _str, bool _bPre)
		{
			bool flag = false;
			string text = modProcCommands.get_ADR(_str, _bPre, ref flag);
			bool flag2 = !flag;
			string result;
			if (flag2)
			{
				result = text.Substring(4, 2) + text.Substring(2, 2);
			}
			else
			{
				result = text;
			}
			return result;
		}

		// Token: 0x0600067D RID: 1661 RVA: 0x00025B5C File Offset: 0x00023D5C
		public static string cmd_ADR_LOW(string _str, bool _bPre)
		{
			bool flag = false;
			string text = modProcCommands.get_ADR(_str, _bPre, ref flag);
			bool flag2 = !flag;
			string result;
			if (flag2)
			{
				result = text.Substring(4, 2);
			}
			else
			{
				result = text;
			}
			return result;
		}

		// Token: 0x0600067E RID: 1662 RVA: 0x00025B9C File Offset: 0x00023D9C
		public static string cmd_ADR_HIGH(string _str, bool _bPre)
		{
			bool flag = false;
			string text = modProcCommands.get_ADR(_str, _bPre, ref flag);
			bool flag2 = !flag;
			string result;
			if (flag2)
			{
				result = text.Substring(2, 2);
			}
			else
			{
				result = text;
			}
			return result;
		}
	}
}
