﻿using System;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using libZh;
using Microsoft.VisualBasic.CompilerServices;

namespace libSnesAssembler
{
	// Token: 0x020000CB RID: 203
	public class PatchGlobal
	{
		// Token: 0x060006D1 RID: 1745 RVA: 0x0002A850 File Offset: 0x00028A50
		public PatchGlobal()
		{
			this.sName = "";
			this.sValue = "";
			this.bEditable = false;
			this.bAddress = false;
			this.bConst = false;
			this.sFlagStrings = "";
			this.sEditValue = "";
			this.sFilePath = "";
			this.editType = PatchGlobal.enum_globalType.globalType_none;
		}

		// Token: 0x060006D2 RID: 1746 RVA: 0x0002A8BC File Offset: 0x00028ABC
		public PatchGlobal(string _sName, string _sValue, string _sFlags)
		{
			this.sName = "";
			this.sValue = "";
			this.bEditable = false;
			this.bAddress = false;
			this.bConst = false;
			this.sFlagStrings = "";
			this.sEditValue = "";
			this.sFilePath = "";
			this.editType = PatchGlobal.enum_globalType.globalType_none;
			this.sName = _sName;
			this.sValue = _sValue;
			string[] source = _sFlags.Split(new char[]
			{
				';'
			});
			bool flag = source.Contains("Editable");
			if (flag)
			{
				this.bEditable = true;
			}
		}

		// Token: 0x060006D3 RID: 1747 RVA: 0x0002A964 File Offset: 0x00028B64
		public static string validateEditValue(PatchGlobal.enum_globalType _type, string _sInput)
		{
			bool flag = _type == PatchGlobal.enum_globalType.globalType_none;
			string result;
			if (flag)
			{
				result = "";
			}
			else
			{
				switch (_type)
				{
				case PatchGlobal.enum_globalType.globalType_hex_4bit:
				{
					bool flag2 = (_sInput == null || _sInput.Length == 0 || _sInput.Length > 1) | !modString.isHex(_sInput);
					if (flag2)
					{
						result = "0";
					}
					else
					{
						result = modString.hx(modString.hx(_sInput), 1);
					}
					break;
				}
				case PatchGlobal.enum_globalType.globalType_hex_8bit:
				{
					bool flag3 = (_sInput == null || _sInput.Length == 0 || _sInput.Length > 2) | !modString.isHex(_sInput);
					if (flag3)
					{
						result = "00";
					}
					else
					{
						result = modString.hx(modString.hx(_sInput), 2);
					}
					break;
				}
				case PatchGlobal.enum_globalType.globalType_hex_16bit:
				{
					bool flag4 = (_sInput == null || _sInput.Length == 0 || _sInput.Length > 4) | !modString.isHex(_sInput);
					if (flag4)
					{
						result = "0000";
					}
					else
					{
						result = modString.hx(modString.hx(_sInput), 4);
					}
					break;
				}
				case PatchGlobal.enum_globalType.globalType_hex_24bit:
				{
					bool flag5 = (_sInput == null || _sInput.Length == 0 || _sInput.Length > 6) | !modString.isHex(_sInput);
					if (flag5)
					{
						result = "000000";
					}
					else
					{
						result = modString.hx(modString.hx(_sInput), 6);
					}
					break;
				}
				default:
					result = "";
					break;
				}
			}
			return result;
		}

		// Token: 0x060006D4 RID: 1748 RVA: 0x0002AB04 File Offset: 0x00028D04
		public static PatchGlobal patchGlobal_load(string sLine)
		{
			PatchGlobal patchGlobal = new PatchGlobal();
			string[] array = sLine.Split(new char[]
			{
				' '
			});
			bool flag = array.Length >= 4;
			PatchGlobal result;
			if (flag)
			{
				patchGlobal.sName = array[0];
				patchGlobal.editType = (PatchGlobal.enum_globalType)Conversions.ToInteger(array[1]);
				patchGlobal.sEditValue = array[2];
				patchGlobal.sValue = PatchGlobal.load_value(sLine);
				string[] array2 = patchGlobal.load_flagStrings(sLine);
				bool flag2 = array2 != null;
				if (flag2)
				{
					patchGlobal.applyFlagString(array2);
				}
				result = patchGlobal;
			}
			else
			{
				result = null;
			}
			return result;
		}

		// Token: 0x060006D5 RID: 1749 RVA: 0x0002ABA8 File Offset: 0x00028DA8
		public static Collection<PatchGlobal> patchGlobal_loadAgl(string sFileText, string sFilePath)
		{
			Collection<PatchGlobal> collection = new Collection<PatchGlobal>();
			PatchGlobal patchGlobal = null;
			StringBuilder stringBuilder = new StringBuilder("");
			string[] array = modString.splitLines(sFileText, true);
			foreach (string text in array)
			{
				bool flag = text.StartsWith("DEF ", StringComparison.OrdinalIgnoreCase);
				if (flag)
				{
					bool flag2 = patchGlobal != null;
					if (flag2)
					{
						patchGlobal.sValue = stringBuilder.ToString();
						collection.Add(patchGlobal);
					}
					string[] array3 = text.Split(new char[]
					{
						' '
					});
					bool flag3 = array3.Count<string>() == 2;
					if (flag3)
					{
						patchGlobal = new PatchGlobal();
						patchGlobal.sFilePath = sFilePath;
						patchGlobal.sName = array3[1];
						patchGlobal.bEditable = false;
						stringBuilder = new StringBuilder("");
					}
				}
				else
				{
					bool flag4 = stringBuilder.Length > 0;
					if (flag4)
					{
						stringBuilder.Append("\r\n");
					}
					stringBuilder.Append(text);
				}
			}
			bool flag5 = patchGlobal != null;
			if (flag5)
			{
				patchGlobal.sValue = stringBuilder.ToString();
				collection.Add(patchGlobal);
			}
			return collection;
		}

		// Token: 0x060006D6 RID: 1750 RVA: 0x0002ACF0 File Offset: 0x00028EF0
		private void applyFlagString(string[] a_sFlags)
		{
			bool flag = a_sFlags.Contains("Editable");
			if (flag)
			{
				this.bEditable = true;
			}
			bool flag2 = a_sFlags.Contains("Address");
			if (flag2)
			{
				this.bAddress = true;
			}
		}

		// Token: 0x060006D7 RID: 1751 RVA: 0x0002AD3C File Offset: 0x00028F3C
		private static string load_value(string sLine)
		{
			MatchCollection matchCollection = modRegex.findDelimiter(sLine, "\"", "\"", true);
			bool flag = matchCollection.Count == 1;
			string result;
			if (flag)
			{
				result = matchCollection[0].Value.Replace("\\n", "\r\n").Replace("\"", "");
			}
			else
			{
				result = null;
			}
			return result;
		}

		// Token: 0x060006D8 RID: 1752 RVA: 0x0002ADAC File Offset: 0x00028FAC
		private string[] load_flagStrings(string sLine)
		{
			MatchCollection matchCollection = modRegex.findDelimiter(sLine, "(<)", "(>)", true);
			bool flag = matchCollection.Count == 1;
			string[] result;
			if (flag)
			{
				this.sFlagStrings = matchCollection[0].Value.Replace("(<)", "").Replace("(>)", "");
				result = this.sFlagStrings.Split(new char[]
				{
					';'
				});
			}
			else
			{
				result = null;
			}
			return result;
		}

		// Token: 0x060006D9 RID: 1753 RVA: 0x0002AE38 File Offset: 0x00029038
		public string patchGlobal_save()
		{
			bool flag = this.sEditValue == null || this.sEditValue.Length == 0;
			if (flag)
			{
				this.sEditValue = "0";
			}
			string str = string.Concat(new string[]
			{
				this.sName,
				" ",
				Conversions.ToString((int)this.editType),
				" ",
				this.sEditValue,
				" \"",
				this.sValue.Replace("\r\n", "\\n"),
				"\""
			});
			string text = "";
			bool flag2 = this.bEditable;
			if (flag2)
			{
				text = "Editable";
			}
			bool flag3 = this.bAddress;
			if (flag3)
			{
				bool flag4 = text.Length > 0;
				if (flag4)
				{
					text += ";";
				}
				text += "Address";
			}
			return str + "(<)" + text + "(>)";
		}

		// Token: 0x060006DA RID: 1754 RVA: 0x0002AF54 File Offset: 0x00029154
		public void printDebug()
		{
			bool flag = this.bConst;
			if (flag)
			{
				modCommonDebug._debugSectionStart("CONST GLOBAL: " + this.sName);
				modCommonDebug._debugWrite("FILE:     \t" + this.sFilePath);
			}
			else
			{
				modCommonDebug._debugSectionStart("GLOBAL: " + this.sName);
			}
			modCommonDebug._debugWrite("EDITABLE: \t" + this.bEditable.ToString());
			modCommonDebug._debugWrite("TYPE:     \t" + Conversions.ToString((int)this.editType));
			modCommonDebug._debugWrite("INPUT:    \t\"" + this.sEditValue + "\"");
			string[] array = modString.splitLines(this.sValue, true);
			foreach (string str in array)
			{
				modCommonDebug._debugWrite("\t\"" + str + "\"");
			}
			modCommonDebug._debugSectionEnd();
		}

		// Token: 0x060006DB RID: 1755 RVA: 0x0002B05C File Offset: 0x0002925C
		public string getResult(string[] a_sParams)
		{
			string text = this.sValue.Replace("%x", this.sEditValue);
			bool flag = a_sParams != null && a_sParams.Count<string>() > 0;
			checked
			{
				if (flag)
				{
					int num = a_sParams.Count<string>() - 1;
					for (int i = 0; i <= num; i++)
					{
						text = text.Replace("%" + Conversions.ToString(modString.hx(Conversions.ToString(i))), a_sParams[i].Trim());
					}
				}
				string[] array = modString.splitLines(text, true);
				StringBuilder stringBuilder = new StringBuilder();
				foreach (string text2 in array)
				{
					text2 = modLinkerReadFiles.trimLine(text2);
					bool flag2 = text2 != null & text2.Length > 0;
					if (flag2)
					{
						bool flag3 = stringBuilder.Length > 0;
						if (flag3)
						{
							stringBuilder.Append("\r\n^SKIPLINE^");
						}
						stringBuilder.Append(text2);
					}
				}
				return stringBuilder.ToString();
			}
		}

		// Token: 0x040009BD RID: 2493
		public string sName;

		// Token: 0x040009BE RID: 2494
		public string sValue;

		// Token: 0x040009BF RID: 2495
		public bool bEditable;

		// Token: 0x040009C0 RID: 2496
		public bool bAddress;

		// Token: 0x040009C1 RID: 2497
		public bool bConst;

		// Token: 0x040009C2 RID: 2498
		public string sFlagStrings;

		// Token: 0x040009C3 RID: 2499
		public string sEditValue;

		// Token: 0x040009C4 RID: 2500
		public string sFilePath;

		// Token: 0x040009C5 RID: 2501
		public PatchGlobal.enum_globalType editType;

		// Token: 0x02000188 RID: 392
		public enum enum_globalType
		{
			// Token: 0x04000E83 RID: 3715
			globalType_none,
			// Token: 0x04000E84 RID: 3716
			globalType_hex_4bit,
			// Token: 0x04000E85 RID: 3717
			globalType_hex_8bit,
			// Token: 0x04000E86 RID: 3718
			globalType_hex_16bit,
			// Token: 0x04000E87 RID: 3719
			globalType_hex_24bit
		}
	}
}
