﻿using System;

namespace libSnesAssembler
{
	// Token: 0x020000CE RID: 206
	public class AsmProgress
	{
		// Token: 0x060006E3 RID: 1763 RVA: 0x0002B560 File Offset: 0x00029760
		public void reset()
		{
			this.dProgressTotal = 0.0;
		}

		// Token: 0x060006E4 RID: 1764 RVA: 0x0002B574 File Offset: 0x00029774
		public AsmProgress clone()
		{
			AsmProgress asmProgress = new AsmProgress();
			AsmProgress asmProgress2 = asmProgress;
			asmProgress2.iCurrentProgress = this.iCurrentProgress;
			asmProgress2.iProgressCount = this.iProgressCount;
			asmProgress2.iProgressPercent = this.iProgressPercent;
			asmProgress2.sStateName = this.sStateName;
			asmProgress2.dStateTime = this.dStateTime;
			asmProgress2.bStateDone = this.bStateDone;
			asmProgress2.bNewState = this.bNewState;
			asmProgress2.dProgressTotal = this.dProgressTotal;
			return asmProgress;
		}

		// Token: 0x060006E5 RID: 1765 RVA: 0x0002B5FC File Offset: 0x000297FC
		public AsmProgress()
		{
			this.iCurrentProgress = 0;
			this.iProgressCount = 1;
			this.iProgressPercent = 0;
			this.sStateName = null;
			this.iProgressStep = 0;
			this.iProgressStepCount = 0;
			this.dProgressWeight = 0;
			this.dProgressTotalLast = 0.0;
			this.dProgressTotal = 0.0;
			this.dStateTime = 0.0;
			this.bStateDone = false;
			this.bNewState = false;
			this.bWasteTime = false;
		}

		// Token: 0x060006E6 RID: 1766 RVA: 0x0002B688 File Offset: 0x00029888
		public void startNewState(string _stateName, int _iProgressCount, int _iProgressWeight)
		{
			this.bNewState = true;
			this.bStateDone = false;
			this.sStateName = _stateName;
			this.iProgressCount = _iProgressCount;
			this.dProgressWeight = _iProgressWeight;
			this.iProgressStep = 0;
			this.iProgressStepCount = checked((int)Math.Round(Math.Ceiling((double)_iProgressCount / 100.0)));
			this.iCurrentProgress = 0;
			this.iProgressPercent = 0;
			this.dProgressTotalLast = this.dProgressTotal;
			modAsmReport.asmReport_report(this);
		}

		// Token: 0x060006E7 RID: 1767 RVA: 0x0002B704 File Offset: 0x00029904
		public void progressStep()
		{
			bool flag = this.bWasteTime;
			bool flag2;
			checked
			{
				if (flag)
				{
					int num = 0;
					do
					{
						num = num;
						num++;
					}
					while (num <= 10000);
				}
				ref int ptr = ref this.iCurrentProgress;
				this.iCurrentProgress = ptr + 1;
				ptr = ref this.iProgressStep;
				this.iProgressStep = ptr + 1;
				flag2 = (this.iProgressStep >= this.iProgressStepCount);
			}
			if (flag2)
			{
				this.iProgressStep = 0;
				ref int ptr = ref this.iProgressPercent;
				this.iProgressPercent = checked(ptr + 1);
				ref double ptr2 = ref this.dProgressTotal;
				this.dProgressTotal = ptr2 + (double)this.dProgressWeight / 100.0;
				bool flag3 = this.iProgressPercent > 100;
				if (flag3)
				{
					this.iProgressPercent = 100;
				}
				bool flag4 = this.dProgressTotal > this.dProgressTotalLast + (double)this.dProgressWeight;
				if (flag4)
				{
					this.dProgressTotal = this.dProgressTotalLast + (double)this.dProgressWeight;
				}
				this.bNewState = false;
				this.bStateDone = false;
				modAsmReport.asmReport_report(this);
			}
		}

		// Token: 0x060006E8 RID: 1768 RVA: 0x0002B804 File Offset: 0x00029A04
		public void finishState()
		{
			this.bNewState = false;
			this.bStateDone = true;
			this.dProgressTotal = this.dProgressTotalLast + (double)this.dProgressWeight;
			modAsmReport.asmReport_report(this);
		}

		// Token: 0x040009CB RID: 2507
		public int iCurrentProgress;

		// Token: 0x040009CC RID: 2508
		public int iProgressCount;

		// Token: 0x040009CD RID: 2509
		public int iProgressPercent;

		// Token: 0x040009CE RID: 2510
		public string sStateName;

		// Token: 0x040009CF RID: 2511
		public int iProgressStep;

		// Token: 0x040009D0 RID: 2512
		public int iProgressStepCount;

		// Token: 0x040009D1 RID: 2513
		public int dProgressWeight;

		// Token: 0x040009D2 RID: 2514
		public double dProgressTotalLast;

		// Token: 0x040009D3 RID: 2515
		public double dProgressTotal;

		// Token: 0x040009D4 RID: 2516
		public double dStateTime;

		// Token: 0x040009D5 RID: 2517
		public bool bStateDone;

		// Token: 0x040009D6 RID: 2518
		public bool bNewState;

		// Token: 0x040009D7 RID: 2519
		public bool bWasteTime;
	}
}
