﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using libSnesAssembler.My;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using Microsoft.VisualBasic.FileIO;
using Microsoft.VisualBasic.MyServices;

namespace libSnesAssembler
{
	// Token: 0x020000C7 RID: 199
	public class AsmPatch
	{
		// Token: 0x060006A4 RID: 1700 RVA: 0x0002826C File Offset: 0x0002646C
		public AsmPatch(string sPath)
		{
			this.cFiles = new Dictionary<string, AsmPatchFile>();
			this.sPathRoot = "";
			this.sPathPatch = "";
			this.sVersion = "0";
			this.sChecksum = "0";
			this.sRomSize = "0";
			this.bUsePatch = true;
			this.bCompatible = false;
			this.iDefFileCount = 0;
			this.iAsmFileCount = 0;
			modCommonDebug._debugSectionStart("LOAD PATCH:");
			modCommonDebug._debugSectionStart("TARGET ROM INFO");
			this.sPathPatch = sPath;
			this.sPathRoot = MyProject.Computer.FileSystem.GetFileInfo(sPath).Directory.FullName;
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			this.dicOptions = new Dictionary<string, PatchOption>();
			this.dicGlobals = new Dictionary<string, PatchGlobal>();
			this.dicConstGlobals = new Dictionary<string, PatchGlobal>();
			StreamReader streamReader = fileSystem.OpenTextFileReader(sPath);
			string text = null;
			StringBuilder stringBuilder = new StringBuilder();
			int iProgressCount = modString.splitLines(fileSystem.ReadAllText(sPath), false).Count<string>();
			bool flag = false;
			bool flag2 = false;
			bool flag3 = false;
			bool flag4 = false;
			bool flag5 = false;
			while (!streamReader.EndOfStream & !flag)
			{
				string @string = streamReader.ReadLine();
				bool flag6 = Strings.StrComp(@string, "[PatchVersion]", CompareMethod.Binary) == 0;
				if (flag6)
				{
					flag = true;
				}
			}
			while (!streamReader.EndOfStream & !flag5)
			{
				string string2 = streamReader.ReadLine();
				bool flag7 = Strings.StrComp(string2, "[Checksum]", CompareMethod.Binary) == 0;
				if (flag7)
				{
					flag5 = true;
				}
				else
				{
					this.sVersion = string2;
					modCommonDebug._debugWrite("PATCH VERSION: " + this.sVersion);
					bool flag8 = Strings.StrComp(this.sVersion, AsmPatch.patcherVersion, CompareMethod.Binary) != 0;
					if (flag8)
					{
						this.bCompatible = false;
						return;
					}
					this.bCompatible = true;
				}
			}
			while (!streamReader.EndOfStream & !flag2)
			{
				string string3 = streamReader.ReadLine();
				bool flag9 = Strings.StrComp(string3, "[RomSize]", CompareMethod.Binary) == 0;
				if (flag9)
				{
					flag2 = true;
				}
				else
				{
					this.sChecksum = string3;
					modCommonDebug._debugWrite("CHECKSUM: " + this.sChecksum);
				}
			}
			while (!streamReader.EndOfStream & !flag3)
			{
				string string4 = streamReader.ReadLine();
				bool flag10 = Strings.StrComp(string4, "[Options]", CompareMethod.Binary) == 0;
				if (flag10)
				{
					flag3 = true;
				}
				else
				{
					this.sRomSize = string4;
					modCommonDebug._debugWrite("ROMSIZE: " + this.sRomSize);
				}
			}
			modCommonDebug._debugSectionEnd();
			modCommonDebug._debugSectionStart("PATCH OPTIONS");
			while (!streamReader.EndOfStream & !flag4)
			{
				string text2 = streamReader.ReadLine();
				bool flag11 = Strings.StrComp(text2, "[EndOptions]", CompareMethod.Binary) == 0;
				if (flag11)
				{
					flag4 = true;
				}
				else
				{
					this.dicOptions.Add(text2, new PatchOption(text2, false, ""));
					modCommonDebug._debugWrite("OPTION: " + text2);
				}
			}
			modCommonDebug._debugSectionEnd();
			bool flag12 = !streamReader.EndOfStream;
			if (flag12)
			{
				streamReader.ReadLine();
			}
			modCommonDebug._debugPause();
			modAsmReport.asmProgReport.startNewState("Loading Patch", iProgressCount, 5);
			modCommonDebug._debugSectionStart("PATCH FILES");
			bool flag13 = false;
			bool flag14 = false;
			checked
			{
				while (!streamReader.EndOfStream)
				{
					string text3 = streamReader.ReadLine();
					modAsmReport.asmProgReport.progressStep();
					bool flag15 = text3.Length > 1 && Operators.CompareString(Conversions.ToString(text3[0]), "&", false) == 0;
					if (flag15)
					{
						bool flag16 = text != null;
						if (flag16)
						{
							this.cFiles.Add(text, new AsmPatchFile(text, stringBuilder.ToString()));
							modCommonDebug._debugWrite("PATCHFILE: " + text);
						}
						text = text3.Substring(1);
						stringBuilder = new StringBuilder();
						flag14 = false;
						flag13 = false;
						bool flag17 = text.EndsWith(".adf");
						if (flag17)
						{
							flag14 = true;
						}
						else
						{
							bool flag18 = text.EndsWith(".asm");
							if (flag18)
							{
								flag13 = true;
							}
						}
					}
					else
					{
						stringBuilder.AppendLine(text3);
						bool flag19 = flag14;
						if (flag19)
						{
							ref int ptr = ref this.iDefFileCount;
							this.iDefFileCount = ptr + 1;
						}
						else
						{
							bool flag20 = flag13;
							if (flag20)
							{
								ref int ptr = ref this.iAsmFileCount;
								this.iAsmFileCount = ptr + 1;
							}
						}
					}
				}
				bool flag21 = text != null;
				if (flag21)
				{
					this.cFiles.Add(text, new AsmPatchFile(text, stringBuilder.ToString()));
					modCommonDebug._debugWrite("PATCHFILE: " + text);
				}
				streamReader.Close();
				modCommonDebug._debugSectionEnd();
				modAsmReport.asmProgReport.finishState();
				modCommonDebug._debugResume();
				this.patch_loadSettings();
				this.patch_loadConstGlobalFiles();
				modCommonDebug._debugSectionEnd();
			}
		}

		// Token: 0x060006A5 RID: 1701 RVA: 0x00028794 File Offset: 0x00026994
		private void patch_loadSettings()
		{
			modCommonDebug._debugSectionStart("PROJECT SETTINGS:");
			bool flag = this.fileExists("project.aps");
			if (flag)
			{
				string sString = this.fileText("project.aps");
				string[] array = modString.splitLines(sString, true);
				foreach (string text in array)
				{
					string[] array3 = text.Split(new char[]
					{
						' '
					});
					bool flag2 = array3[0].StartsWith("%") & array3[0].EndsWith("%");
					if (flag2)
					{
						PatchGlobal patchGlobal = PatchGlobal.patchGlobal_load(text);
						bool flag3 = patchGlobal != null;
						if (flag3)
						{
							bool flag4 = !this.dicGlobals.ContainsKey(patchGlobal.sName);
							if (flag4)
							{
								this.dicGlobals.Add(patchGlobal.sName, patchGlobal);
								patchGlobal.printDebug();
							}
						}
					}
					else
					{
						PatchOption patchOption = PatchOption.patchOption_load(text);
						bool flag5 = patchOption != null;
						if (flag5)
						{
							bool flag6 = !this.dicOptions.ContainsKey(patchOption.sName);
							if (flag6)
							{
								this.dicOptions.Add(patchOption.sName, patchOption);
								patchOption.printDebug();
							}
						}
					}
				}
			}
			modCommonDebug._debugSectionEnd();
		}

		// Token: 0x060006A6 RID: 1702 RVA: 0x00028900 File Offset: 0x00026B00
		private void patch_loadConstGlobalFiles()
		{
			modCommonDebug._debugSectionStart("PATH: LOAD AGL GLOBALS");
			try
			{
				foreach (KeyValuePair<string, AsmPatchFile> keyValuePair in this.cFiles)
				{
					bool flag = keyValuePair.Value.sPath.EndsWith(".agl");
					if (flag)
					{
						Collection<PatchGlobal> collection = PatchGlobal.patchGlobal_loadAgl(keyValuePair.Value.sText, "");
						try
						{
							foreach (PatchGlobal patchGlobal in collection)
							{
								bool flag2 = patchGlobal != null;
								if (flag2)
								{
									bool flag3 = !this.dicConstGlobals.ContainsKey(patchGlobal.sName);
									if (flag3)
									{
										this.dicConstGlobals.Add(patchGlobal.sName, patchGlobal);
										patchGlobal.printDebug();
									}
								}
							}
						}
						finally
						{
							IEnumerator<PatchGlobal> enumerator2;
							if (enumerator2 != null)
							{
								enumerator2.Dispose();
							}
						}
					}
				}
			}
			finally
			{
				Dictionary<string, AsmPatchFile>.Enumerator enumerator;
				((IDisposable)enumerator).Dispose();
			}
			modCommonDebug._debugSectionEnd();
		}

		// Token: 0x060006A7 RID: 1703 RVA: 0x00028A38 File Offset: 0x00026C38
		private string realPath(string sPath)
		{
			return this.sPathRoot + "\\" + sPath;
		}

		// Token: 0x060006A8 RID: 1704 RVA: 0x00028A64 File Offset: 0x00026C64
		public bool fileExists(string sPath)
		{
			bool flag = this.bUsePatch;
			bool result;
			if (flag)
			{
				result = this.cFiles.ContainsKey(sPath);
			}
			else
			{
				FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
				bool flag2 = fileSystem.FileExists(this.realPath(sPath));
				if (flag2)
				{
					result = true;
				}
				else
				{
					bool flag3 = fileSystem.DirectoryExists(this.realPath(sPath));
					if (flag3)
					{
						string name = fileSystem.GetDirectoryInfo(this.realPath(sPath)).Name;
						bool flag4 = fileSystem.FileExists(this.realPath(sPath) + "\\" + name + ".adf");
						if (flag4)
						{
							return true;
						}
					}
					result = false;
				}
			}
			return result;
		}

		// Token: 0x060006A9 RID: 1705 RVA: 0x00028B24 File Offset: 0x00026D24
		public string directoryExists(string sPath)
		{
			bool flag = this.bUsePatch;
			string result;
			if (flag)
			{
				try
				{
					foreach (string text in this.cFiles.Keys)
					{
						bool flag2 = text.StartsWith(sPath);
						if (flag2)
						{
							return Conversions.ToString(true);
						}
					}
				}
				finally
				{
					Dictionary<string, AsmPatchFile>.KeyCollection.Enumerator enumerator;
					((IDisposable)enumerator).Dispose();
				}
				result = Conversions.ToString(false);
			}
			else
			{
				result = Conversions.ToString(MyProject.Computer.FileSystem.DirectoryExists(this.realPath(sPath)));
			}
			return result;
		}

		// Token: 0x060006AA RID: 1706 RVA: 0x00028BE0 File Offset: 0x00026DE0
		public Collection<string> getDirFiles(string sPath)
		{
			Collection<string> collection = new Collection<string>();
			bool flag = this.bUsePatch;
			if (flag)
			{
				try
				{
					foreach (string text in this.cFiles.Keys)
					{
						bool flag2 = text.StartsWith(sPath);
						if (flag2)
						{
							bool flag3 = text.EndsWith(".asm");
							if (flag3)
							{
								collection.Add(text);
							}
						}
					}
				}
				finally
				{
					Dictionary<string, AsmPatchFile>.KeyCollection.Enumerator enumerator;
					((IDisposable)enumerator).Dispose();
				}
			}
			else
			{
				FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
				ReadOnlyCollection<string> files = fileSystem.GetFiles(this.realPath(sPath), Microsoft.VisualBasic.FileIO.SearchOption.SearchAllSubDirectories, new string[]
				{
					"*.asm"
				});
				try
				{
					foreach (string text2 in files)
					{
						bool flag4 = text2.EndsWith(".asm");
						if (flag4)
						{
							string item = text2.Substring(checked(this.sPathRoot.Length + 1));
							collection.Add(item);
						}
					}
				}
				finally
				{
					IEnumerator<string> enumerator2;
					if (enumerator2 != null)
					{
						enumerator2.Dispose();
					}
				}
			}
			return collection;
		}

		// Token: 0x060006AB RID: 1707 RVA: 0x00028D40 File Offset: 0x00026F40
		public string fileText(string sPath)
		{
			bool flag = this.bUsePatch;
			string result;
			if (flag)
			{
				result = this.replaceGlobals(this.cFiles[sPath].sText, 0);
			}
			else
			{
				FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
				bool flag2 = fileSystem.FileExists(this.realPath(sPath));
				if (flag2)
				{
					result = this.replaceGlobals(fileSystem.ReadAllText(this.realPath(sPath)), 0);
				}
				else
				{
					bool flag3 = fileSystem.DirectoryExists(this.realPath(sPath));
					if (flag3)
					{
						string name = fileSystem.GetDirectoryInfo(this.realPath(sPath)).Name;
						bool flag4 = fileSystem.FileExists(this.realPath(sPath) + "\\" + name + ".adf");
						if (flag4)
						{
							return this.replaceGlobals(fileSystem.ReadAllText(this.realPath(sPath) + "\\" + name + ".adf"), 0);
						}
					}
					result = "";
				}
			}
			return result;
		}

		// Token: 0x060006AC RID: 1708 RVA: 0x00028E4C File Offset: 0x0002704C
		public string replaceGlobals(string sIn, int stackLevel = 0)
		{
			return this.replaceGlobals_new(sIn, 0);
		}

		// Token: 0x060006AD RID: 1709 RVA: 0x00028E70 File Offset: 0x00027070
		public string replaceGlobals_new(string sIn, int stackLevel = 0)
		{
			StringBuilder stringBuilder = new StringBuilder(sIn);
			try
			{
				foreach (string text in this.dicGlobals.Keys)
				{
					bool flag = sIn.Contains(text);
					if (flag)
					{
						stringBuilder.Replace(text, this.dicGlobals[text].getResult(null));
					}
				}
			}
			finally
			{
				Dictionary<string, PatchGlobal>.KeyCollection.Enumerator enumerator;
				((IDisposable)enumerator).Dispose();
			}
			return stringBuilder.ToString();
		}

		// Token: 0x060006AE RID: 1710 RVA: 0x00028F10 File Offset: 0x00027110
		public bool optionOn(string sOption)
		{
			bool flag = this.bUsePatch;
			bool result;
			if (flag)
			{
				bool flag2 = this.dicOptions.ContainsKey(sOption);
				if (flag2)
				{
					result = this.dicOptions[sOption].bActive;
				}
				else
				{
					Interaction.MsgBox("Option doesn't exist ? : " + sOption, MsgBoxStyle.OkOnly, null);
					result = false;
				}
			}
			else
			{
				bool flag3 = this.dicOptions.ContainsKey(sOption);
				if (flag3)
				{
					result = this.dicOptions[sOption].bActive;
				}
				else
				{
					Interaction.MsgBox("Option doesn't exist ? : " + sOption, MsgBoxStyle.OkOnly, null);
					result = false;
				}
			}
			return result;
		}

		// Token: 0x0400099E RID: 2462
		private const int MAX_GLOBAL_STACK_LEVEL = 32;

		// Token: 0x0400099F RID: 2463
		public Dictionary<string, AsmPatchFile> cFiles;

		// Token: 0x040009A0 RID: 2464
		public string sPathRoot;

		// Token: 0x040009A1 RID: 2465
		public string sPathPatch;

		// Token: 0x040009A2 RID: 2466
		public Dictionary<string, PatchOption> dicOptions;

		// Token: 0x040009A3 RID: 2467
		public Dictionary<string, PatchGlobal> dicGlobals;

		// Token: 0x040009A4 RID: 2468
		public Dictionary<string, PatchGlobal> dicConstGlobals;

		// Token: 0x040009A5 RID: 2469
		public static string patcherVersion = "0.18";

		// Token: 0x040009A6 RID: 2470
		public string sVersion;

		// Token: 0x040009A7 RID: 2471
		public string sChecksum;

		// Token: 0x040009A8 RID: 2472
		public string sRomSize;

		// Token: 0x040009A9 RID: 2473
		public bool bUsePatch;

		// Token: 0x040009AA RID: 2474
		public bool bCompatible;

		// Token: 0x040009AB RID: 2475
		public int iDefFileCount;

		// Token: 0x040009AC RID: 2476
		public int iAsmFileCount;
	}
}
