﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using Microsoft.VisualBasic.MyServices;
using SnesPatcher.My;
using SnesPatcher.My.Resources;

namespace SnesPatcher
{
	// Token: 0x02000009 RID: 9
	[DesignerGenerated]
	public partial class frmIPS : Form
	{
		// Token: 0x06000022 RID: 34 RVA: 0x00002AB4 File Offset: 0x00000CB4
		public frmIPS()
		{
			base.Load += this.frmIPS_Load;
			this.InitializeComponent();
		}

		// Token: 0x1700000F RID: 15
		// (get) Token: 0x06000025 RID: 37 RVA: 0x000030A0 File Offset: 0x000012A0
		// (set) Token: 0x06000026 RID: 38 RVA: 0x000030B0 File Offset: 0x000012B0
		internal virtual OpenFileDialog dlgOpenFile { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000010 RID: 16
		// (get) Token: 0x06000027 RID: 39 RVA: 0x000030BC File Offset: 0x000012BC
		// (set) Token: 0x06000028 RID: 40 RVA: 0x000030CC File Offset: 0x000012CC
		internal virtual ListBox lstChain
		{
			[CompilerGenerated]
			get
			{
				return this._lstChain;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.lstChain_SelectedIndexChanged);
				ListBox lstChain = this._lstChain;
				if (lstChain != null)
				{
					lstChain.SelectedIndexChanged -= value2;
				}
				this._lstChain = value;
				lstChain = this._lstChain;
				if (lstChain != null)
				{
					lstChain.SelectedIndexChanged += value2;
				}
			}
		}

		// Token: 0x17000011 RID: 17
		// (get) Token: 0x06000029 RID: 41 RVA: 0x0000311C File Offset: 0x0000131C
		// (set) Token: 0x0600002A RID: 42 RVA: 0x0000312C File Offset: 0x0000132C
		internal virtual TextBox txtSelPatch { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000012 RID: 18
		// (get) Token: 0x0600002B RID: 43 RVA: 0x00003138 File Offset: 0x00001338
		// (set) Token: 0x0600002C RID: 44 RVA: 0x00003148 File Offset: 0x00001348
		internal virtual CheckBox chkSelNeedHeader
		{
			[CompilerGenerated]
			get
			{
				return this._chkSelNeedHeader;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.chkSelNeedHeader_CheckedChanged);
				CheckBox chkSelNeedHeader = this._chkSelNeedHeader;
				if (chkSelNeedHeader != null)
				{
					chkSelNeedHeader.CheckedChanged -= value2;
				}
				this._chkSelNeedHeader = value;
				chkSelNeedHeader = this._chkSelNeedHeader;
				if (chkSelNeedHeader != null)
				{
					chkSelNeedHeader.CheckedChanged += value2;
				}
			}
		}

		// Token: 0x17000013 RID: 19
		// (get) Token: 0x0600002D RID: 45 RVA: 0x00003198 File Offset: 0x00001398
		// (set) Token: 0x0600002E RID: 46 RVA: 0x000031A8 File Offset: 0x000013A8
		internal virtual Button btnAddIPS
		{
			[CompilerGenerated]
			get
			{
				return this._btnAddIPS;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnAddIPS_Click);
				Button btnAddIPS = this._btnAddIPS;
				if (btnAddIPS != null)
				{
					btnAddIPS.Click -= value2;
				}
				this._btnAddIPS = value;
				btnAddIPS = this._btnAddIPS;
				if (btnAddIPS != null)
				{
					btnAddIPS.Click += value2;
				}
			}
		}

		// Token: 0x17000014 RID: 20
		// (get) Token: 0x0600002F RID: 47 RVA: 0x000031F8 File Offset: 0x000013F8
		// (set) Token: 0x06000030 RID: 48 RVA: 0x00003208 File Offset: 0x00001408
		internal virtual Button btnRemoveSel
		{
			[CompilerGenerated]
			get
			{
				return this._btnRemoveSel;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnRemoveSel_Click);
				Button btnRemoveSel = this._btnRemoveSel;
				if (btnRemoveSel != null)
				{
					btnRemoveSel.Click -= value2;
				}
				this._btnRemoveSel = value;
				btnRemoveSel = this._btnRemoveSel;
				if (btnRemoveSel != null)
				{
					btnRemoveSel.Click += value2;
				}
			}
		}

		// Token: 0x17000015 RID: 21
		// (get) Token: 0x06000031 RID: 49 RVA: 0x00003258 File Offset: 0x00001458
		// (set) Token: 0x06000032 RID: 50 RVA: 0x00003268 File Offset: 0x00001468
		internal virtual Button btnSelDown
		{
			[CompilerGenerated]
			get
			{
				return this._btnSelDown;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnSelDown_Click);
				Button btnSelDown = this._btnSelDown;
				if (btnSelDown != null)
				{
					btnSelDown.Click -= value2;
				}
				this._btnSelDown = value;
				btnSelDown = this._btnSelDown;
				if (btnSelDown != null)
				{
					btnSelDown.Click += value2;
				}
			}
		}

		// Token: 0x17000016 RID: 22
		// (get) Token: 0x06000033 RID: 51 RVA: 0x000032B8 File Offset: 0x000014B8
		// (set) Token: 0x06000034 RID: 52 RVA: 0x000032C8 File Offset: 0x000014C8
		internal virtual Button btnSelUp
		{
			[CompilerGenerated]
			get
			{
				return this._btnSelUp;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnSelUp_Click);
				Button btnSelUp = this._btnSelUp;
				if (btnSelUp != null)
				{
					btnSelUp.Click -= value2;
				}
				this._btnSelUp = value;
				btnSelUp = this._btnSelUp;
				if (btnSelUp != null)
				{
					btnSelUp.Click += value2;
				}
			}
		}

		// Token: 0x17000017 RID: 23
		// (get) Token: 0x06000035 RID: 53 RVA: 0x00003318 File Offset: 0x00001518
		// (set) Token: 0x06000036 RID: 54 RVA: 0x00003328 File Offset: 0x00001528
		internal virtual Button btnOk
		{
			[CompilerGenerated]
			get
			{
				return this._btnOk;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnOk_Click);
				Button btnOk = this._btnOk;
				if (btnOk != null)
				{
					btnOk.Click -= value2;
				}
				this._btnOk = value;
				btnOk = this._btnOk;
				if (btnOk != null)
				{
					btnOk.Click += value2;
				}
			}
		}

		// Token: 0x06000037 RID: 55 RVA: 0x00003378 File Offset: 0x00001578
		private void btnSelUp_Click(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			checked
			{
				if (flag)
				{
					ListItem_Patch listItem_Patch = (ListItem_Patch)this.lstChain.SelectedItem;
					int selectedIndex = this.lstChain.SelectedIndex;
					bool flag2 = selectedIndex > 0;
					if (flag2)
					{
						this.lstChain.Items.Remove(listItem_Patch);
						this.lstChain.Items.Insert(selectedIndex - 1, listItem_Patch);
						this.lstChain.SelectedIndex = selectedIndex - 1;
					}
				}
			}
		}

		// Token: 0x06000038 RID: 56 RVA: 0x00003404 File Offset: 0x00001604
		private void btnSelDown_Click(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			checked
			{
				if (flag)
				{
					ListItem_Patch listItem_Patch = (ListItem_Patch)this.lstChain.SelectedItem;
					int selectedIndex = this.lstChain.SelectedIndex;
					bool flag2 = selectedIndex < this.lstChain.Items.Count - 1;
					if (flag2)
					{
						this.lstChain.Items.Remove(listItem_Patch);
						this.lstChain.Items.Insert(selectedIndex + 1, listItem_Patch);
						this.lstChain.SelectedIndex = selectedIndex + 1;
					}
				}
			}
		}

		// Token: 0x06000039 RID: 57 RVA: 0x000034A0 File Offset: 0x000016A0
		private void btnRemoveSel_Click(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			if (flag)
			{
				ListItem_Patch value = (ListItem_Patch)this.lstChain.SelectedItem;
				this.lstChain.Items.Remove(value);
			}
		}

		// Token: 0x0600003A RID: 58 RVA: 0x000034EC File Offset: 0x000016EC
		private void btnAddIPS_Click(object sender, EventArgs e)
		{
			this.dlgOpenFile.FileName = "";
			this.dlgOpenFile.ShowDialog();
			string fileName = this.dlgOpenFile.FileName;
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			bool flag = fileSystem.FileExists(fileName) && Operators.CompareString(fileSystem.GetFileInfo(fileName).Extension.ToLower(), ".ips", false) == 0;
			if (flag)
			{
				ListItem_Patch listItem_Patch = new ListItem_Patch(fileName);
				bool flag2 = Interaction.MsgBox("Does this patch require a rom header ?", MsgBoxStyle.YesNo, "Headered ?") == MsgBoxResult.Yes;
				if (flag2)
				{
					listItem_Patch.bNeedHeader = true;
				}
				this.lstChain.Items.Add(listItem_Patch);
			}
		}

		// Token: 0x0600003B RID: 59 RVA: 0x000035B0 File Offset: 0x000017B0
		private void btnOk_Click(object sender, EventArgs e)
		{
			Collection collection = new Collection();
			try
			{
				foreach (object obj in this.lstChain.Items)
				{
					ListItem_Patch item = (ListItem_Patch)obj;
					collection.Add(item, null, null, null);
				}
			}
			finally
			{
				IEnumerator enumerator;
				if (enumerator is IDisposable)
				{
					(enumerator as IDisposable).Dispose();
				}
			}
			modPatchChain.setPatchChain(new PatchChain(collection, "", ""));
			base.Close();
		}

		// Token: 0x0600003C RID: 60 RVA: 0x00003648 File Offset: 0x00001848
		private void frmIPS_Load(object sender, EventArgs e)
		{
			bool flag = modPatchChain.patchChain == null;
			if (flag)
			{
				Collection collection = new Collection();
				collection.Add(new ListItem_Patch(true), null, null, null);
				modPatchChain.setPatchChain(new PatchChain(collection, "", ""));
			}
			try
			{
				foreach (object obj in modPatchChain.patchChain.colPatches)
				{
					ListItem_Patch item = (ListItem_Patch)obj;
					this.lstChain.Items.Add(item);
				}
			}
			finally
			{
				IEnumerator enumerator;
				if (enumerator is IDisposable)
				{
					(enumerator as IDisposable).Dispose();
				}
			}
			this.chkSelNeedHeader.Enabled = false;
			this.btnRemoveSel.Enabled = false;
			this.btnSelDown.Enabled = false;
			this.btnSelUp.Enabled = false;
			this.lstChain.SelectedIndex = -1;
		}

		// Token: 0x0600003D RID: 61 RVA: 0x00003744 File Offset: 0x00001944
		private void lstChain_SelectedIndexChanged(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			if (flag)
			{
				ListItem_Patch listItem_Patch = (ListItem_Patch)this.lstChain.SelectedItem;
				this.txtSelPatch.Text = listItem_Patch.Name;
				this.btnSelUp.Enabled = true;
				this.btnSelDown.Enabled = true;
				bool bZPS = listItem_Patch.bZPS;
				if (bZPS)
				{
					this.chkSelNeedHeader.Checked = false;
					this.chkSelNeedHeader.Enabled = false;
					this.btnRemoveSel.Enabled = false;
				}
				else
				{
					this.chkSelNeedHeader.Enabled = true;
					this.chkSelNeedHeader.Checked = listItem_Patch.bNeedHeader;
					this.btnRemoveSel.Enabled = true;
				}
			}
			else
			{
				this.txtSelPatch.Text = "";
				this.chkSelNeedHeader.Enabled = false;
				this.btnRemoveSel.Enabled = false;
				this.btnSelUp.Enabled = false;
				this.btnSelDown.Enabled = false;
			}
		}

		// Token: 0x0600003E RID: 62 RVA: 0x00003860 File Offset: 0x00001A60
		private void chkSelNeedHeader_CheckedChanged(object sender, EventArgs e)
		{
			bool flag = this.lstChain.SelectedItem != null;
			if (flag)
			{
				ListItem_Patch listItem_Patch = (ListItem_Patch)this.lstChain.SelectedItem;
				bool flag2 = !listItem_Patch.bZPS;
				if (flag2)
				{
					listItem_Patch.bNeedHeader = this.chkSelNeedHeader.Checked;
					int selectedIndex = this.lstChain.SelectedIndex;
					this.lstChain.Items.RemoveAt(selectedIndex);
					this.lstChain.Items.Insert(selectedIndex, listItem_Patch);
					this.lstChain.SelectedIndex = selectedIndex;
				}
			}
		}
	}
}
