﻿using System;
using System.Windows.Forms;
using libZh;
using Microsoft.VisualBasic.MyServices;
using SnesPatcher.My;

namespace SnesPatcher
{
	// Token: 0x0200000E RID: 14
	public class ListItem_Patch
	{
		// Token: 0x1700002F RID: 47
		// (get) Token: 0x06000085 RID: 133 RVA: 0x00005ACC File Offset: 0x00003CCC
		public string Name
		{
			get
			{
				bool flag = this.bZPS;
				string result;
				if (flag)
				{
					result = "[******* ZPS *******]";
				}
				else
				{
					bool flag2 = this.bNeedHeader;
					string str;
					if (flag2)
					{
						str = "(H)";
					}
					else
					{
						str = "(h)";
					}
					result = str + " " + modFilePaths.getFileName(this.sPath_patchFile);
				}
				return result;
			}
		}

		// Token: 0x06000086 RID: 134 RVA: 0x00005B38 File Offset: 0x00003D38
		public ListItem_Patch(bool _bZPS)
		{
			this.bZPS = false;
			this.bNeedHeader = false;
			this.bZPS = _bZPS;
		}

		// Token: 0x06000087 RID: 135 RVA: 0x00005B58 File Offset: 0x00003D58
		public ListItem_Patch(string _sPath)
		{
			this.bZPS = false;
			this.bNeedHeader = false;
			this.sPath_patchFile = _sPath;
		}

		// Token: 0x06000088 RID: 136 RVA: 0x00005B78 File Offset: 0x00003D78
		public void applyPatch(string _sPath_Source, string _sPath_Dest)
		{
			bool flag = this.bZPS;
			if (flag)
			{
				this.applyPatch_ZPS(_sPath_Source, _sPath_Dest);
			}
			else
			{
				this.applyPatch_IPS(_sPath_Source, _sPath_Dest);
			}
		}

		// Token: 0x06000089 RID: 137 RVA: 0x00005BB4 File Offset: 0x00003DB4
		private void applyPatch_IPS(string _sPath_Source, string _sPath_Dest)
		{
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			IPS ips = new IPS(this.sPath_patchFile);
			byte[] rom = fileSystem.ReadAllBytes(_sPath_Source);
			byte[] data = ips.applyPatch(rom, this.bNeedHeader);
			fileSystem.WriteAllBytes(_sPath_Dest, data, false);
		}

		// Token: 0x0600008A RID: 138 RVA: 0x00005C04 File Offset: 0x00003E04
		private void applyPatch_ZPS(string _sPath_Source, string _sPath_Dest)
		{
			modZps_Async.applyZpsPatch_async(MyProject.Forms.frmSnesPatcher.zpsPatch, _sPath_Source, _sPath_Dest);
			while (!modZps_Async.bFinished)
			{
				Application.DoEvents();
			}
		}

		// Token: 0x0400004A RID: 74
		public string sPath_patchFile;

		// Token: 0x0400004B RID: 75
		public bool bZPS;

		// Token: 0x0400004C RID: 76
		public bool bNeedHeader;
	}
}
