@if (@$)==(@_) goto bat "<!--" @end/*
@echo off

set    _GAME_=Secret of Mana
set _PROJECT_=Turbo

:: check interpreter
if not n^t==nt goto :eof
set ~x9=
if "%~x9%~x9"=="~x9" setlocal enableextensions
if "%~x9%~x9"=="~x9" goto :eof
if not cmdextversion 2 exit/b
if "!~x9!~x9"=="~x9" ( setlocal disabledelayedexpansion
if "!~x9!~x9"=="~x9" exit/b
) else setlocal
if not defined TEMP exit/b
call& >nul set TEMP && if not errorlevel 1 exit/b
if not defined COMSPEC exit/b
if not defined USERPROFILE exit/b
2>nul set CD && exit/b || if not defined CD exit/b
2>nul set DATE && exit/b || if not defined DATE exit/b
2>nul set TIME && exit/b || if not defined TIME exit/b
2>nul set RANDOM && exit/b || if not defined RANDOM exit/b
2>nul set ERRORLEVEL && exit/b || if not defined ERRORLEVEL exit/b
2>nul set CMDCMDLINE && exit/b || if not defined CMDCMDLINE exit/b

:: check path
if not exist "%~nx0" cd /D "%~dp0"
if not exist "%~nx0" goto err_pth

:: check launch context
setlocal enabledelayedexpansion & set ""=^" & set "{=!CMDCMDLINE!"
if "!{:~-2,2!"=="""" set ""=:^" & goto ccl
if not "!{:~-2,1!"==" " goto ccl
(::
!=::!CMDCMDLINE:*:=*!!CMDCMDLINE:~0,1!)
set "}=^&" & call call/(%%}%%rem;%%%%CMDCMDLINE:**=*%%0%%%%
set "}=!CMDCMDLINE:^^=^!" & if "!}:~3,1!"==":" set ""=:^"
(::
!=::!CMDCMDLINE:~0,1!)
set "}=!{:/=/0!" & call(:^&rem;%%CMDCMDLINE:**=!}:%%=/1!%%
(:ccl:
!=::"!CMDCMDLINE:^^=^!"!CMDCMDLINE:/1=%%!!CMDCMDLINE:/0=/!)
endlocal & if not "%"%"=="" ( set ""="" ) else set ""=^"

:: syntactic sugar
set "^=(:)^
set "&&=||:&if;not;errorlevel;1;
set "||=||:&if;errorlevel;1;
set "if=call;&(if
set "or=call)&&(if
set "and=if
set "then=call)&if;errorlevel;1

:: check arguments
if not "%~3"=="" goto err_arg
if "%~1"=="echo" goto zps_bel
if not "%~1"=="" goto err_arg

:: prepare environment variables
setlocal enabledelayedexpansion & set "_=" & set "_AKA_="
for %%A in (!_GAME_!) do set "_=%%~A" & set "_AKA_=!_AKA_!!_:~0,1!"
endlocal & set "_AKA_=%_AKA_%"
call :strlen _AKA_ _AKA_.len
call :strlen _PROJECT_ _PROJECT_.len
if not defined ^" echo on & prompt;::$S$T$_
if not defined _OUT_ set "_OUT_=%_GAME_%, %_PROJECT_%.smc"
if defined _ZPS_ goto skip_zps
setlocal enabledelayedexpansion & set /a "_=%_AKA_.len%+%_PROJECT_.len%+2" & set "{=" & set "}=000000.zps"
for %%A in ("*.zps") do %^%
(
set "{=%%~A"
if "!{:~0,%_%!"=="%_AKA_% %_PROJECT_%." %^%
(
if "!{:~%_%,6!"=="zps" set "{=!{:~0,%_%!000000.zps"
if "!{:~%_%,6!" gtr "!}:~0,6!" set "}=!{:~%_%!"
)
)
if "%}%"=="000000.zps" set "}=zps"
endlocal & set "_ZPS_=%_AKA_% %_PROJECT_%.%}%"
:skip_zps
if defined _ROM_ goto skip_rom
setlocal & set /a "_=%_PROJECT_.len%+4" & set "{=" & set "}="
for %%A in ("%_GAME_%*.s?c") do set "}=%%~A"
setlocal enabledelayedexpansion & set "{=!}:~-%_%,%_PROJECT_.len%!"
endlocal & set "{=%{%"
if "%{%"=="%_PROJECT_%" for %%A in ("%_GAME_%*.s?c") do if not "%%~A"=="%}%" set "}=%%~A"
setlocal enabledelayedexpansion & set "{=!}:~-%_%,%_PROJECT_.len%!"
endlocal & set "{=%{%"
if "%{%"=="%_PROJECT_%" set "}="
if not exist "%}%" for %%A in ("%_AKA_%.s?c") do set "}=%%~A"
if not exist "%}%" set "}="
endlocal & set "_ROM_=%}%"
:skip_rom

:: check environment variables and files
if not exist "%_ZPS_%" goto err_zps
:: if not exist "%_ROM_%" goto err_rom

:: ---

if not defined ^" if not defined _PID_ set "_PID_=//%~n0" & goto zps_run

:: execute
cscript.exe //nologo //I "%~f0?.wsf" //Job:ZPS_Check
if errorlevel 6 goto err_vbs
if errorlevel 5 goto :eof
if errorlevel 4 goto :eof
if errorlevel 3 goto zps_key
if errorlevel 2 goto zps_act
if errorlevel 1 goto zps_run
goto err_vbs

:zps_key
if exist "%_ZPS_:~0,-4%.log" del "%_ZPS_:~0,-4%.log"
if exist "%_ZPS_:~0,-4%.smc" del "%_ZPS_:~0,-4%.smc"
if exist "ZPS_Debug.log" del "ZPS_Debug.log"
if exist "patched.smc" del "patched.smc"
start "" wscript.exe //nologo //I "%~f0?.wsf" //Job:ZPS_Wait
cscript.exe //nologo //I "%~f0?.wsf" //Job:ZPS_Sleep
cls
goto :eof

:zps_act
cls
goto :eof

:zps_run
if not exist "ZPS_Patcher.exe" goto err_exe
cscript.exe //nologo //I "%~f0?.wsf" //Job:ZPS_Launch
@if defined _CMD_ cscript.exe //nologo //I "%~f0?.wsf" //Job:ZPS_Sleep 1000
@if defined ^" cls
goto :eof

:zps_bel
echo %~2
cls
goto :eof

:: ---

:err_zps
echo;
echo !! An error occurred! [f%errorlevel%]
echo Required input ZPS file not found.
goto err_end

:err_rom
echo;
echo !! An error occurred! [f%errorlevel%]
echo Required input ROM file not found.
goto err_end

:err_pth
echo;
echo !! An error occurred! [d%errorlevel%]
echo Could not set current directory.
goto err_end

:err_exe
echo;
echo !! An error occurred! [e%errorlevel%]
echo Required executable not found.
echo;
echo "%~nx0" and "%_ZPS_%"
echo need to be in the same folder as
echo "ZPS_Patcher.exe" if run via %~n0
goto err_end

:err_arg
echo;
echo !! An error occurred! [b%errorlevel%]
echo Invalid batch script arguments.
goto err_end

:err_vbs
echo;
echo !! An error occurred! [c%errorlevel%]
echo The script returned an unexpected errorlevel.
goto err_end

:err_end
echo;
echo Press any key to exit . . .> con
pause > nul
cls
goto :eof

:: ---

:strlen
setlocal enabledelayedexpansion&set/a"}=0"&if "%~1" neq "" ^
if defined %~1 (for %%# in (4096 2048 1024 512 256 128 64 32 16)do ^
if "!%~1:~%%#,1!" neq "" set "%~1=!%~1:~%%#!"&set/a"}+=%%#")&^
set "%~1=!%~1!0FEDCBA9876543211"&set/a"}+=0x!%~1:~32,1!!%~1:~16,1!"
endlocal&set/a"%~2=%}%"&exit/b

-->
<package><job/>
<job id="ZPS_Check"><script language="VBScript">
Option Explicit
Dim iErrorlevel, oShell, oEnv, bWin, sName, sProcessId, oExec, i

iErrorlevel = 0

Set oShell = Nothing
Set oShell = CreateObject("WScript.Shell")
If Not oShell Is Nothing Then

Set oEnv = Nothing
Set oEnv = oShell.Environment("Process")
If Not oEnv Is Nothing Then

	iErrorlevel = 1

	If oEnv("_PID_") = "" Then

		For i=0 To 5
		bWin = oShell.AppActivate("Snes ZPS Patcher")
		If bWin = True Then Exit For
		' race condition, kludge
		bWin = oShell.AppActivate("Loading...")
		If bWin = True Then Exit For
		WScript.Sleep 100
		Next
		If bWin = True Then

			iErrorlevel = 2

			For i=0 To 5
			bWin = oShell.AppActivate("Loading...")
			If bWin = True Then Exit For
			WScript.Sleep 100
			Next
			If bWin = True Then

				iErrorlevel = 3

			End If ' bWin "Loading..."

		End If ' bWin "Snes ZPS Patcher"

		If iErrorlevel = 1 Then

			GetParentProcessInfo sName, sProcessId
			If StrComp(sName, "ZPS_Patcher.exe", vbTextCompare) = 0 Then

				oEnv("_PID_") = sProcessId

				iErrorlevel = 4

			End If

		End If

	Else

		iErrorlevel = 5

	End If

	If iErrorlevel = 4 Or iErrorlevel = 5 Then

		Set oExec = Nothing
		Set oExec = oShell.Exec("cscript.exe //nologo //I """ & WScript.ScriptFullName & """ //Job:ZPS_Wait")
		If Not oExec Is Nothing Then

			Do While oExec.Status = 0
			Do While Not oExec.StdOut.AtEndOfStream
			WScript.StdOut.Write oExec.StdOut.Read(1)
			If oExec.Status <> 0 Then Exit Do
			Loop
			Loop
			WScript.StdOut.Write oExec.StdOut.ReadAll()
			WScript.StdOut.Write oExec.StdErr.ReadAll()

		Set oExec = Nothing
		End If ' oExec Is Nothing

	End If

Set oEnv = Nothing
End If ' oEnv Is Nothing

Set oShell = Nothing
End If ' oShell Is Nothing

WScript.Quit(iErrorlevel)
' 0 = failure, critical error
' 1 = success, not running
' 2 = success, running
' 3 = success, patching
' 4 = success, patching nogui
' 5 = success, patching nogui helper
' 6 = failure, critical error

' ---

' https://stackoverflow.com/questions/38765334/in-a-vbscript-how-can-i-get-the-process-id-of-the-cmd-exe-in-which-the-vb-scrip
Sub GetParentProcessInfo(ByRef sName, ByRef sProcessId)
	' child, temporary
	With GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2:Win32_Process.Handle='" & CreateObject("WScript.Shell").Exec("rundll32.exe kernel32.dll,Sleep").ProcessId & "'")
		' vbscript, interpreter
		With GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2:Win32_Process.Handle='" & .ParentProcessId & "'")
			' batch, interpreter
			With GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2:Win32_Process.Handle='" & .ParentProcessId & "'")
				' parent
				With GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2:Win32_Process.Handle='" & .ParentProcessId & "'")
					sName = .Name
					sProcessId = .ProcessId
				End With
			End With
		End With
		.Terminate
	End With
End Sub
</script></job>
<job id="ZPS_Wait"><script language="VBScript">
Option Explicit
Dim iErrorlevel, oShell, oEnv, oFSO, oWMI, sGUI, bGUI, bSeen, bWin, sFileZPS, sFileROM, sFileOUT, sFileLOG, sPatched, sFileSFROM, sFileSearch, oClipboard, dInput, sNulls, iChksum, iFilePtr, hDebugLog, sDebugLog, sDebugMsg, a, i, j, s, z

iErrorlevel = 0

Set oShell = Nothing
Set oShell = CreateObject("WScript.Shell")
If Not oShell Is Nothing Then

Set oEnv = Nothing
Set oEnv = oShell.Environment("Process")
If Not oEnv Is Nothing Then

Set oFSO = Nothing
Set oFSO = CreateObject("Scripting.FileSystemObject")
If Not oFSO Is Nothing Then

	iErrorlevel = 1

	sGUI = oEnv("_PID_")
	bGUI = sGUI = ""
	If bGUI Then

		bSeen = False
		' 60 second timeout
		For i=0 To 10 * 60

			bWin = oShell.AppActivate("ZPS_Patcher")
			If bWin = True Then
			bSeen = True
			oShell.SendKeys "^{INSERT}{ESCAPE}", True
			End If ' bWin "ZPS_Patcher"

			bWin = oShell.AppActivate("Loading...")
			If bWin = False Then

				' missed msgbox safety
				For j=0 To 20
				bWin = oShell.AppActivate("ZPS_Patcher")
				If bWin <> bSeen Then Exit For
				WScript.Sleep 100
				Next
				If bWin = False Then

					iErrorlevel = 2

		Exit For

				End If ' bWin "ZPS_Patcher"

			End If ' bWin "Loading..."

		WScript.Sleep 100
		Next

	Else ' not bGUI

'		If Left(sGUI, 2) <> "//" Then
'		Set oWMI = Nothing
'		Set oWMI = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2")
'		If Not oWMI Is Nothing Then
'		' 60 second timeout
'		For i=0 To 10 * 60
'		If oWMI.ExecQuery("SELECT * FROM Win32_Process WHERE ProcessId=" & sGUI).Count = 0 Then Exit For
'		WScript.Sleep 100
'		Next
'		Set oWMI = Nothing
'		End If ' oWMI Is Nothing
'		End If ' sGUI ParentProcessId

		iErrorlevel = 2

	End If ' bGUI

	sFileZPS = oEnv.Item("_ZPS_")
	sFileROM = oEnv.Item("_ROM_")
	sFileOUT = oEnv.Item("_OUT_")
	sFileLOG = oFSO.GetBaseName(sFileZPS) & ".log"
	s = oFSO.GetExtensionName(sFileROM)
	If Len(s) = 0 Then s = "?"
	sPatched = oFSO.GetBaseName(sFileZPS) & "." & s
	sFileSFROM = Replace(Replace(oFSO.GetBaseName(sFileOUT) & ".sfrom", ",", ""), " ", "_")

	If iErrorlevel = 2 Then
		If oFSO.GetExtensionName(sPatched) = "?" Then
		sPatched = oFSO.GetBaseName(sPatched)
		For Each sFileSearch in oFSO.GetFolder(".").Files
			s = oFSO.GetExtensionName(sFileSearch)
			If StrComp(s, "zps", vbTextCompare) <> 0 Then
			If StrComp(s, "ini", vbTextCompare) <> 0 Then
			If StrComp(s, "log", vbTextCompare) <> 0 Then
				s = oFSO.GetBaseName(sFileSearch)
				If StrComp(s, sPatched, vbTextCompare) = 0 Then
					sPatched = oFSO.GetFileName(sFileSearch)
					Exit For
				End If
			End If
			End If
			End If
		Next
		End If
		If Not oFSO.FileExists(sPatched) Then sPatched = "patched.smc"
		If bGUI Then
		If Not oFSO.FileExists(sPatched) Then
			' last ditch effort
			Set oClipboard = Nothing
			Set oClipboard = CreateObject("htmlfile_FullWindowEmbed")
			If Not oClipboard Is Nothing Then
				s = oClipboard.parentWindow.clipboardData.getData("text")
				a = Split(s, vbLf)
				If UBound(a) = 9 Then
				s = Trim(Replace(a(4), vbCr, ""))
				If Left(s, 1) = "'" And Right(s, 1) = "'" Then
				sPatched = Mid(s, 2, Len(s) - 2)
				sFileOUT = oFSO.BuildPath(oFSO.GetParentFolderName(sPatched), sFileOUT)
				sFileSFROM = oFSO.BuildPath(oFSO.GetParentFolderName(sPatched), sFileSFROM)
				End If
				End If
			Set oClipboard = Nothing
			End If ' oClipboard Is Nothing
		End If
		End If ' bGUI
		If oFSO.FileExists(sPatched) Then
		If oFSO.FileExists(sFileOUT) Then
		On Error Resume Next
			z = oFSO.DeleteFile(sFileOUT, True)
		On Error GoTo 0
		End If
		If oFSO.FileExists(sFileOUT) Then
		Else

		On Error Resume Next
		For i=0 To 50
			Err.Clear
			z = oFSO.CopyFile(sPatched, sFileOUT, True)
			If Err.Number = 0 Then
			If oFSO.FileExists(sFileOUT) Then
				z = oFSO.DeleteFile(sPatched, True)
		If Err.Number = 0 Then Exit For
			End If ' FileExists()
			End If ' Err.Number
		WScript.Sleep 100
		Next
		On Error GoTo 0

		If oFSO.FileExists(sFileOUT) Then

			iErrorlevel = 3

			dInput = BinaryRead(sFileOUT)
			j = &H400000&
			If Len(dInput) = j Then
				sNulls = Chr(0)&Chr(0)&Chr(0)&Chr(0)
				sNulls = sNulls&sNulls&sNulls&sNulls
				sNulls = sNulls&sNulls&sNulls&sNulls
				sNulls = sNulls&sNulls&sNulls&sNulls
				i = &H300000&
				Do While i < j
					If Mid(dInput, i + 1, 256) <> sNulls Then Exit Do
					i = i + 256
				Loop
				If i = j Then
				j = &H300000&
				i = &H200000&
				Do While i < j
					If Mid(dInput, i + 1, 256) <> sNulls Then Exit Do
					i = i + 256
				Loop
				If i = j Then
					j = &H200000&
				End If ' 2MB

				' fix checksum
				If j = &H300000& Then
					iChksum = Asc(Mid(dInput, &HFFDE& + 1, 1))	_
						+ Asc(Mid(dInput, &HFFDE& + 2, 1)) * &H00000100&
					i = &H200000&
					Do While i < j
						iChksum = iChksum	_
							+ Asc(Mid(dInput, i +  1, 1)) + Asc(Mid(dInput, i +  2, 1))	_
							+ Asc(Mid(dInput, i +  3, 1)) + Asc(Mid(dInput, i +  4, 1))	_
							+ Asc(Mid(dInput, i +  5, 1)) + Asc(Mid(dInput, i +  6, 1))	_
							+ Asc(Mid(dInput, i +  7, 1)) + Asc(Mid(dInput, i +  8, 1))	_
							+ Asc(Mid(dInput, i +  9, 1)) + Asc(Mid(dInput, i + 10, 1))	_
							+ Asc(Mid(dInput, i + 11, 1)) + Asc(Mid(dInput, i + 12, 1))	_
							+ Asc(Mid(dInput, i + 13, 1)) + Asc(Mid(dInput, i + 14, 1))	_
							+ Asc(Mid(dInput, i + 15, 1)) + Asc(Mid(dInput, i + 16, 1))	_
							+ Asc(Mid(dInput, i + 17, 1)) + Asc(Mid(dInput, i + 18, 1))	_
							+ Asc(Mid(dInput, i + 19, 1)) + Asc(Mid(dInput, i + 20, 1))	_
							+ Asc(Mid(dInput, i + 21, 1)) + Asc(Mid(dInput, i + 22, 1))	_
							+ Asc(Mid(dInput, i + 23, 1)) + Asc(Mid(dInput, i + 24, 1))	_
							+ Asc(Mid(dInput, i + 25, 1)) + Asc(Mid(dInput, i + 26, 1))	_
							+ Asc(Mid(dInput, i + 27, 1)) + Asc(Mid(dInput, i + 28, 1))	_
							+ Asc(Mid(dInput, i + 29, 1)) + Asc(Mid(dInput, i + 30, 1))	_
							+ Asc(Mid(dInput, i + 31, 1)) + Asc(Mid(dInput, i + 32, 1))
							i = i + 32
					Loop
					iChksum = iChksum And &H0000FFFF&

					iFilePtr = &HFFDC&
					dInput =  Left(dInput, iFilePtr)	_
						& DWORDtoString(&H00010000& * iChksum + &H0000FFFF& - iChksum)	_
						& Right(dInput, Len(dInput) - iFilePtr)
				End If ' checksum

				If BinaryWrite(sFileOUT, Left(dInput, j)) = j Then

					iErrorlevel = 4

				Else

					iErrorlevel = 5

				End If ' BinaryWrite
				End If ' 3MB

				If Mid(dInput, &HFFEC& + 1, 2) <> Chr(&H04)&Chr(&H80) Or Mid(dInput, &HFFFC& + 1, 2) <> Chr(&H04)&Chr(&H80) Then

					If Mid(dInput, &HFFEC& + &H200& + 1, 2) = Chr(&H04)&Chr(&H80) And Mid(dInput, &HFFFC& + &H200& + 1, 2) = Chr(&H04)&Chr(&H80) Then
						sDebugMsg = "Headered Input ROM Detected" & vbCrLf & vbCrLf	_
							&   "Output ROM will crash and not be functional" & vbCrLf & vbCrLf	_
							&   "Remove 512-byte copier header and try again"
					ElseIf Mid(dInput, &HFFEC& + &H30& + 1, 2) = Chr(&H04)&Chr(&H80) And Mid(dInput, &HFFFC& + &H30& + 1, 2) = Chr(&H04)&Chr(&H80) Then
						sDebugMsg = "Headered Input ROM Detected" & vbCrLf & vbCrLf	_
							&   "Output ROM will crash and not be functional" & vbCrLf & vbCrLf	_
							&   "Remove 48-byte SFROM header and try again"
					ElseIf Mid(dInput, &HFFEC& + &H60& + 1, 2) = Chr(&H04)&Chr(&H80) And Mid(dInput, &HFFFC& + &H60& + 1, 2) = Chr(&H04)&Chr(&H80) Then
						sDebugMsg = "Headered Input ROM Detected" & vbCrLf & vbCrLf	_
							&   "Output ROM will crash and not be functional" & vbCrLf & vbCrLf	_
							&   "Remove 96-byte SFROM header and try again"
					Else
						sDebugMsg = "Invalid Input ROM Detected" & vbCrLf & vbCrLf	_
							&   "Output ROM will crash and not be functional" & vbCrLf & vbCrLf	_
							&   "Locate the correct ROM and try again"
					End If
					If bGUI Then
					z = MsgBox(sDebugMsg, vbOKOnly + vbCritical, "ZPS_ERROR")
					Else
					TryStdOutWrite vbCrLf & sDebugMsg & vbCrLf
					End If

					iErrorlevel = 5

				End If ' Header Check

'				If oFSO.FileExists(sFileSFROM) Then z = oFSO.DeleteFile(sFileSFROM, True)

				If Mid(dInput, &H81F78& + 1, 2) = Chr(0)&Chr(0) Then

					iFilePtr = &H0&

'					' standard SFROM layout
'					If BinaryWrite(sFileSFROM, _
'						  DWORDtoString(&H00000100&)	_
'						& DWORDtoString(&H60& + j)	_
'						& DWORDtoString(&H30&)	_
'						& DWORDtoString(&H30& + j)	_
'						& DWORDtoString(&H60& + j)	_
'						& DWORDtoString(&H30& + j)	_
'						& DWORDtoString(&H60& + j)	_
'						& DWORDtoString(&H0&)	_
'						& DWORDtoString(&H4B& + j)	_
'						& "WUP-JBXE"	_
'						& DWORDtoString(&H0&)	_
'						_
'						& Left(dInput, j)	_
'						_
'						& Chr(60)	_
'						& DWORDtoString(j)	_
'						& DWORDtoString(&H0&)	_
'						& DWORDtoString(&H0&)	_
'						& Left(DWORDtoString(&H10B0&), 2)	_
'						& Chr(3)	_
'						_
'						& Chr(65)	_
'						& Chr(&H15)	_
'						& Chr(&H00)	_
'						& Left(sNulls, 8)	_
'						& DWORDtoString(&H0&)	_
'						& DWORDtoString(&H00000001&)	_
'						& Left(sNulls, 13)	_
'					) = j + &H60& Then

'					' merged SFROM header and footer
'					If BinaryWrite(sFileSFROM, _
'						  DWORDtoString(&H00000100&)	_
'						& DWORDtoString(&H60& + j)	_
'						& DWORDtoString(&H60&)	_
'						& DWORDtoString(&H60& + j)	_
'						& DWORDtoString(&H60& + j)	_
'						& DWORDtoString(&H30&)	_
'						& DWORDtoString(&H60& + j)	_
'						& DWORDtoString(&H0&)	_
'						& DWORDtoString(&H4B&)	_
'						& "WUP-JBXE"	_
'						& DWORDtoString(&H0&)	_
'						_
'						& Chr(60)	_
'						& DWORDtoString(j)	_
'						& DWORDtoString(&H0&)	_
'						& DWORDtoString(&H0&)	_
'						& Left(DWORDtoString(&H10B0&), 2)	_
'						& Chr(3)	_
'						_
'						& Chr(65)	_
'						& Chr(&H15)	_
'						& Chr(&H00)	_
'						& Left(sNulls, 8)	_
'						& DWORDtoString(&H0&)	_
'						& DWORDtoString(&H00000001&)	_
'						& Left(sNulls, 13)	_
'						_
'						& Left(dInput, j)	_
'					) = j + &H60& Then

					' merged SFROM header and footer padded to SMC header size
					If BinaryWrite(sFileSFROM, _
						  DWORDtoString(&H00000100&)	_
						& DWORDtoString(&H200& + j)	_
						& DWORDtoString(&H200&)	_
						& DWORDtoString(&H200& + j)	_
						& DWORDtoString(&H200& + j)	_
						& DWORDtoString(&H30&)	_
						& DWORDtoString(&H200& + j)	_
						& DWORDtoString(&H0&)	_
						& DWORDtoString(&H4B&)	_
						& CountedString("WUP-JBXE")	_
						& DWORDtoString(&H0&)	_
						_
						&  BYTEtoString(60)	_
						& DWORDtoString(j)	_
						& DWORDtoString(&H0&)	_
						& DWORDtoString(&H0&)	_
						&  WORDtoString(&H10B0&)	_
						&  BYTEtoString(3)	_
						_
						&  BYTEtoString(65)	_
						&  BYTEtoString(&H15)	_
						&  BYTEtoString(&H00)	_
						& CountedString(Left(sNulls, 8))	_
						& DWORDtoString(&H0&)	_
						& DWORDtoString(&H00000001&)	_
						& CountedString(Left(sNulls, &H30& + &H30& - iFilePtr))	_
						_
						& Left(sNulls&sNulls, &H200& - iFilePtr) 	_
						_
						& Left(dInput, j)	_
					) = j + &H200& Then

						If iErrorlevel = 3 Then iErrorlevel = 4

					Else

						iErrorlevel = 5

					End If ' BinaryWrite

				End If ' SFROM
			End If ' 4MB
		End If ' FileExists()
		End If ' !FileExists()
		End If ' FileExists()
	End If ' iErrorlevel

	sDebugMsg = ""
	If Not oFSO.FileExists(sFileLOG) Then sFileLOG = "ZPS_Debug.log"
	If oFSO.FileExists(sFileLOG) Then
		Set hDebugLog = oFSO.OpenTextFile(sFileLOG, 1)
		bSeen = False
		Do While Not hDebugLog.AtEndOfStream
			sDebugLog = Trim(hDebugLog.ReadLine())
			If Len(sDebugLog) > 0 Then
				If bSeen Then
					If InStr(sDebugLog, "ERROR:") <> 0 Then
					If InStr(sDebugMsg, sDebugLog) = 0 Then
						sDebugMsg = sDebugMsg & sDebugLog & vbCrLf
					End If
					End If
				ElseIf sDebugLog = "MAKE: SetDefininitions" Then
					bSeen = True
				End If
			End If
		Loop
		If Len(sDebugMsg) > 0 Then
			If iErrorlevel = 3 Or iErrorlevel = 4 Then

				iErrorlevel = 6

			End If
		End If
	End If

	If iErrorlevel = 3 Or iErrorlevel = 4 Then
		If bGUI Then
		' ding sound, kludge
		bWin = oShell.AppActivate("Snes ZPS Patcher")
		If bWin = True Then oShell.SendKeys "%`", True
		End If
	Else
		' beep sound
		If bGUI Then
		z = oShell.Run("""" & Left(WScript.ScriptFullName, InStrRev(WScript.ScriptFullName, "?") - 1) & """ echo " & Chr(7), 0, True)
		Else
		TryStdOutWrite Chr(7)
		End If
	End If

	If Len(sDebugMsg) > 0 Then
		If bGUI Then
		z = MsgBox(sDebugMsg, vbOKOnly + vbCritical, "ZPS_ERROR")
		Else
		TryStdOutWrite vbCrLf & sFileLOG & vbCrLf & sDebugMsg
		End If
	ElseIf iErrorlevel = 3 Or iErrorlevel = 4 Then
		If Len(sFileROM) > 0 Then
		If oFSO.FileExists("flips.exe") Then
		If oFSO.FileExists(sFileROM) Then
		z = oShell.Run("flips.exe --create --ips """ & sFileROM & """ """ & sFileOUT & """ """ & oFSO.GetBaseName(sFileOUT) & ".ips""", 1, True)
		End If
		End If
		End If
	End If

	If bGUI Then
		If InStr(1, oEnv.Item("_CMD_"), "//apply", vbTextCompare) > 0 Then
		' close window
		bWin = oShell.AppActivate("Snes ZPS Patcher")
		If bWin = True Then oShell.SendKeys "(% )c", True
		End If
	Else
		TryStdOutWrite vbCrLf & Left(WScript.ScriptName, InStrRev(WScript.ScriptName, "?") - 1)
		If iErrorlevel = 3 Or iErrorlevel = 4 Then
		TryStdOutWrite " Finished" & vbCrLf
		Else
		TryStdOutWrite " iErrorlevel = " & iErrorlevel & vbCrLf
		End If
	End If

Set oFSO = Nothing
End If ' oFSO Is Nothing

Set oEnv = Nothing
End If ' oEnv Is Nothing

Set oShell = Nothing
End If ' oShell Is Nothing

WScript.Quit(iErrorlevel)
' 0 = failure, critical error
' 1 = failure, wait
' 2 = failure, not renamed
' 3 = success, not resized
' 4 = success, resized
' 5 = failure, ??? resized
' 6 = failure, debug log
' 7 = failure, critical error

' ---

Sub TryStdOutWrite(sInput)
	On Error Resume Next
	WScript.StdOut.Write sInput
	On Error GoTo 0
End Sub
Function CountedString(sInput)
	CountedString = sInput
	iFilePtr = iFilePtr + Len(sInput)
End Function
Function DWORDtoString(iInput)
	If iInput > &H7FFFFFFF& Then iInput = iInput - 4294967296
	DWORDtoString =   Chr(CByte((iInput And &H000000FF&) / &H00000001&)) _
			& Chr(CByte((iInput And &H0000FF00&) / &H00000100&)) _
			& Chr(CByte((iInput And &H00FF0000&) / &H00010000&)) _
			& Chr(CByte((iInput And &H7F000000&) / &H01000000& - (iInput < 0) * &H80))
	iFilePtr = iFilePtr + 4
End Function
Function  WORDtoString(iInput)
	If iInput > &H7FFFFFFF& Then iInput = iInput - 4294967296
	 WORDtoString =   Chr(CByte((iInput And &H000000FF&) / &H00000001&)) _
			& Chr(CByte((iInput And &H0000FF00&) / &H00000100&))
	iFilePtr = iFilePtr + 2
End Function
Function  BYTEtoString(iInput)
	If iInput > &H7FFFFFFF& Then iInput = iInput - 4294967296
	 BYTEtoString =   Chr(CByte((iInput And &H000000FF&) / &H00000001&))
	iFilePtr = iFilePtr + 1
End Function
' https://stackoverflow.com/questions/6060529/read-and-write-binary-file-in-vbscript
Function BinaryRead(strPath)
'	Dim oFSO : Set oFSO = CreateObject("Scripting.FileSystemObject")
	Dim oFile : Set oFile = oFSO.GetFile(strPath)
	If IsNull(oFile) Then
'		MsgBox("File not found: " & vbCrLf & strPath)
		BinaryRead = ""
		Exit Function
	End If

	With oFile.OpenAsTextStream()
		BinaryRead = .Read(oFile.Size)
		.Close
	End With
End Function
Function BinaryWrite(strPath, strBinary)
'	Dim oFSO : Set oFSO = CreateObject("Scripting.FileSystemObject")
	Err.Clear
	On Error Resume Next
	Dim oTxtStream : Set oTxtStream = oFSO.CreateTextFile(strPath)
	If Err.Number <> 0 Then
	On Error GoTo 0
'		MsgBox(Err.Description)
		BinaryWrite = 0
		Exit Function
	End If
	On Error GoTo 0

	With oTxtStream
		.Write(strBinary)
		.Close
	End With
	Set oTxtStream = Nothing

	Dim oFile : Set oFile = oFSO.GetFile(strPath)
	If IsNull(oFile) Then
'		MsgBox("File not found: " & vbCrLf & strPath)
		BinaryWrite = 0
		Exit Function
	End If
	BinaryWrite = oFile.Size
End Function
</script></job>
<job id="ZPS_Launch"><script language="VBScript">
Option Explicit
Dim iErrorlevel, oShell, oEnv, oFSO, oRegExp, sFileZPS, sFileROM, sFileOUT, sFileLOG, sExec, sArgs, oExec, bROM, bWin, fTimer, i, z

iErrorlevel = 0

Set oShell = Nothing
Set oShell = CreateObject("WScript.Shell")
If Not oShell Is Nothing Then

Set oEnv = Nothing
Set oEnv = oShell.Environment("Process")
If Not oEnv Is Nothing Then

Set oFSO = Nothing
Set oFSO = CreateObject("Scripting.FileSystemObject")
If Not oFSO Is Nothing Then

Set oRegExp = Nothing
Set oRegExp = CreateObject("VBScript.RegExp")
If Not oRegExp Is Nothing Then
oRegExp.Global = True
oRegExp.Pattern = "[\+\^\%\~\(\)\{\}\[\]]"

	iErrorlevel = 1

	sFileZPS = oEnv("_ZPS_")
	sFileROM = oEnv("_ROM_")
	sFileOUT = oEnv("_OUT_")
	sFileLOG = oFSO.GetBaseName(sFileZPS) & ".log"

	sExec = "ZPS_Patcher.exe """ & sFileZPS & """ "
	sArgs = Trim(oEnv("_CMD_"))

	If oFSO.FileExists(sFileLOG) Then
		If InStr(1, sArgs, "//debug", vbTextCompare) = 0 Then sArgs = sArgs & " //debug"
		If InStr(1, sArgs, "//verbose", vbTextCompare) = 0 Then sArgs = sArgs & " //verbose"
	End If

	If oFSO.FileExists(sFileROM) Then sExec = sExec & """" & sFileROM & """ "

	If Not oEnv("_PID_") = "" Then
		If InStr(1, sArgs, "//nogui", vbTextCompare) = 0 Then sArgs = sArgs & " //nogui"

	If Not CheckDotNet() Then
		WScript.StdOut.WriteLine vbCrLf	_
			& "Warning: .NET Framework 4.5.2 Not Detected" & vbCrLf	_
			& "If ZPS_Patcher.exe crashes, this may be the cause."
	End If

	Set oExec = Nothing
	Set oExec = oShell.Exec(Trim(sExec & sArgs))
	If Not oExec Is Nothing Then

		WScript.StdOut.WriteLine ""
		Do While oExec.Status = 0
		Do While Not oExec.StdOut.AtEndOfStream
		WScript.StdOut.Write oExec.StdOut.Read(1)
		If oExec.Status <> 0 Then Exit Do
		Loop
		Loop
		WScript.StdOut.Write oExec.StdOut.ReadAll()
		WScript.StdOut.Write oExec.StdErr.ReadAll()

	Set oExec = Nothing
	End If ' oExec Is Nothing

		iErrorlevel = 4

	Else ' Not //nogui

	If Not CheckDotNet() Then
		z = MsgBox("Warning: .NET Framework 4.5.2 Not Detected" & vbCrLf	_
			&  "If ZPS_Patcher.exe crashes, this may be the cause."	_
			, vbOKOnly + vbExclamation, "ZPS_ERROR")
	End If

	Set oExec = Nothing
	Set oExec = oShell.Exec(Trim(sExec & sArgs))
	If Not oExec Is Nothing Then

		iErrorlevel = 2

		bROM = False
		If Len(sFileROM) > 0 Then
		If oFSO.FileExists(sFileROM) Then
			bROM = True
		End If 
		End If 

		Do While oExec.Status = 0

			For i=0 To 100
			fTimer = Timer
			bWin = oShell.AppActivate(oExec.ProcessID)
			fTimer = Timer - fTimer
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			If fTimer <= 0.01 * i Then If bWin = True Then Exit For
			Next
		If bWin = False Then Exit Do

		bWin = oShell.AppActivate("Snes ZPS Patcher V0.18")
		If bWin = False Then Exit Do
		bWin = oShell.AppActivate("Snes ZPS Patcher V0.18+ 0x")
		If bWin = False Then

			For i=0 To 100
			fTimer = Timer
			bWin = oShell.AppActivate(oExec.ProcessID)
			fTimer = Timer - fTimer
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			If fTimer <= 0.01 * i Then If bWin = True Then Exit For
			Next
		If bWin = False Then Exit Do

			oShell.SendKeys "{ENTER}", True
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do

			For i=0 To 100
			fTimer = Timer
			bWin = oShell.AppActivate(oExec.ProcessID)
			fTimer = Timer - fTimer
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			If fTimer <= 0.01 * i Then If bWin = True Then Exit For
			Next
		If bWin = False Then Exit Do

			oShell.SendKeys "{F6}{F6}""", True
			oShell.SendKeys oRegExp.Replace(oFSO.GetParentFolderName(WScript.ScriptFullName), "{$&}"), True
			oShell.SendKeys """{ENTER}", True
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do

			For i=0 To 100
			fTimer = Timer
			bWin = oShell.AppActivate(oExec.ProcessID)
			fTimer = Timer - fTimer
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			If fTimer <= 0.01 * i Then If bWin = True Then Exit For
			Next
		If bWin = False Then Exit Do

			oShell.SendKeys "{F6}{F6}""", True
			oShell.SendKeys oRegExp.Replace(sFileZPS, "{$&}"), True
			oShell.SendKeys """{ENTER}", True
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do

			For i=0 To 20
			bWin = oShell.AppActivate("Open")
			If bWin = False Then Exit For
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			Next
		If bWin = True Then Exit Do

			For i=0 To 5
			bWin = oShell.AppActivate(oExec.ProcessID)
			If bWin = True Then Exit For
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			Next
		If bWin = False Then Exit Do

			iErrorlevel = 3

			For i=0 To 100
			fTimer = Timer
			bWin = oShell.AppActivate(oExec.ProcessID)
			fTimer = Timer - fTimer
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			If fTimer <= 0.01 * i Then If bWin = True Then Exit For
			Next
		If bWin = False Then Exit Do

			oShell.SendKeys "{TAB}{TAB}", True

		If bROM Then

			oShell.SendKeys "{ENTER}", True
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do

			For i=0 To 100
			fTimer = Timer
			bWin = oShell.AppActivate(oExec.ProcessID)
			fTimer = Timer - fTimer
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			If fTimer <= 0.01 * i Then If bWin = True Then Exit For
			Next
		If bWin = False Then Exit Do

			oShell.SendKeys "{F6}{F6}""", True
			oShell.SendKeys oRegExp.Replace(sFileROM, "{$&}"), True
			oShell.SendKeys """{ENTER}", True
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do

			For i=0 To 20
			bWin = oShell.AppActivate("Open")
			If bWin = False Then Exit For
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			Next
		If bWin = True Then Exit Do

			For i=0 To 100
			fTimer = Timer
			bWin = oShell.AppActivate(oExec.ProcessID)
			fTimer = Timer - fTimer
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			If fTimer <= 0.01 * i Then If bWin = True Then Exit For
			Next
		If bWin = False Then Exit Do

		End If ' bROM

		Else
			oShell.SendKeys "{TAB}{TAB}", True
		End If ' bWin "Snes ZPS Patcher V0.18+ 0x"

		If bROM Then
			oShell.SendKeys "{TAB}{TAB}", True
		'	oShell.SendKeys "{TAB}" & sFileOUT & "+{TAB}", True
			If InStr(1, sArgs, "//apply", vbTextCompare) > 0 Then
			WScript.Sleep 100
		If oExec.Status <> 0 Then Exit Do
			oShell.SendKeys " ", True
			End If
		End If ' bROM
		If oExec.Status <> 0 Then Exit Do

				iErrorlevel = 4

		Exit Do
		Loop ' oExec Running

	If iErrorlevel = 4 Then
		If InStr(1, sArgs, "//apply", vbTextCompare) = 0 Then
		' ding sound, kludge
		bWin = oShell.AppActivate(oExec.ProcessID)
		If bWin = True Then oShell.SendKeys "%`", True
		End If
	Else
		' beep sound
		z = oShell.Run("""" & Left(WScript.ScriptFullName, InStrRev(WScript.ScriptFullName, "?") - 1) & """ echo " & Chr(7), 0, True)
	End If

	If InStr(1, sArgs, "//verbose", vbTextCompare) > 0 Then
		Do While oExec.Status = 0
		Do While Not oExec.StdOut.AtEndOfStream
		WScript.StdOut.Write oExec.StdOut.Read(1)
		If oExec.Status <> 0 Then Exit Do
		Loop
		Loop
		WScript.StdOut.Write oExec.StdOut.ReadAll()
		WScript.StdOut.Write oExec.StdErr.ReadAll()
	End If

	Set oExec = Nothing
	End If ' oExec Is Nothing

	End If ' //nogui

Set oRegExp = Nothing
End If ' oRegExp Is Nothing

Set oFSO = Nothing
End If ' oFSO Is Nothing

Set oEnv = Nothing
End If ' oEnv Is Nothing

Set oShell = Nothing
End If ' oShell Is Nothing

WScript.Quit(iErrorlevel)
' 0 = failure, critical error
' 1 = failure, exec
' 2 = failure, automation
' 3 = failure, automation
' 4 = success
' 5 = failure, critical error

' ---

Function CheckDotNet()
	Dim DotNet : DotNet = "_NOT_FOUND_"
	On Error Resume Next
	DotNet = oShell.RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\.NETFramework\v4.0.30319\SKUs\.NETFramework,Version=v4.5.2\")
	On Error GoTo 0
	CheckDotNet = Not DotNet = "_NOT_FOUND_"
End Function
</script></job>
<job id="ZPS_Sleep"><script language="VBScript">
Option Explicit
Dim i : i = 100
If WScript.Arguments.Count > 0 Then
If IsNumeric(WScript.Arguments(0)) Then
i = WScript.Arguments(0)
End If
End If
WScript.Sleep i
</script></job>
</package>
<!--
:eof *///-->
