﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;
using Microsoft.VisualBasic.CompilerServices;

namespace libZh
{
	// Token: 0x02000104 RID: 260
	[StandardModule]
	public sealed class modWindows
	{
		// Token: 0x060006EE RID: 1774
		[DllImport("user32.dll")]
		public static extern bool MoveWindow(IntPtr hWnd, int x, int y, int nWidth, int nHeight, bool bRepaint);

		// Token: 0x060006EF RID: 1775
		[DllImport("user32.dll")]
		public static extern bool IsChild(IntPtr hWndParent, IntPtr hWnd);

		// Token: 0x060006F0 RID: 1776
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern bool ShowWindow(IntPtr hwnd, modWindows.ShowWindowCommands nCmdShow);

		// Token: 0x060006F1 RID: 1777
		[DllImport("user32.dll")]
		public static extern bool GetWindowPlacement(IntPtr hWnd, ref modWindowPlacement.WINDOWPLACEMENT lpwndpl);

		// Token: 0x060006F2 RID: 1778
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

		// Token: 0x060006F3 RID: 1779
		[DllImport("user32.dll", CharSet = CharSet.Auto, EntryPoint = "FindWindow", SetLastError = true)]
		public static extern IntPtr FindWindowByClass(string lpClassName, IntPtr zero);

		// Token: 0x060006F4 RID: 1780
		[DllImport("user32.dll", CharSet = CharSet.Auto, EntryPoint = "FindWindow", SetLastError = true)]
		public static extern IntPtr FindWindowByCaption(IntPtr zero, string lpWindowName);

		// Token: 0x060006F5 RID: 1781
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern IntPtr FindWindowEx(IntPtr parentHandle, IntPtr childAfter, string lclassName, string windowTitle);

		// Token: 0x060006F6 RID: 1782 RVA: 0x00023B28 File Offset: 0x00021D28
		public static IntPtr FindWindowExByIndex(IntPtr hWndParent, string sClass, int index)
		{
			bool flag = index == 0;
			checked
			{
				IntPtr result;
				if (flag)
				{
					result = hWndParent;
				}
				else
				{
					int num = 0;
					IntPtr intPtr = IntPtr.Zero;
					do
					{
						intPtr = modWindows.FindWindowEx(hWndParent, intPtr, sClass, null);
						bool flag2 = intPtr != IntPtr.Zero;
						if (flag2)
						{
							num++;
						}
					}
					while (num < index && intPtr != IntPtr.Zero);
					result = intPtr;
				}
				return result;
			}
		}

		// Token: 0x060006F7 RID: 1783
		[DllImport("user32.dll", SetLastError = true)]
		public static extern IntPtr SetActiveWindow(IntPtr hWnd);

		// Token: 0x060006F8 RID: 1784
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, IntPtr wParam, IntPtr lParam);

		// Token: 0x060006F9 RID: 1785
		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, IntPtr wParam, ref StringBuilder lParam);

		// Token: 0x060006FA RID: 1786
		[DllImport("user32.dll", CharSet = CharSet.Ansi, ExactSpelling = true, SetLastError = true)]
		public static extern bool BlockInput(bool fBlockIt);

		// Token: 0x060006FB RID: 1787
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern bool SetForegroundWindow(IntPtr hWnd);

		// Token: 0x060006FC RID: 1788
		[DllImport("user32.dll", CharSet = CharSet.Ansi, EntryPoint = "GetWindowTextA", ExactSpelling = true, SetLastError = true)]
		public static extern int GetWindowText(IntPtr hwnd, StringBuilder lpString, int cch);

		// Token: 0x060006FD RID: 1789
		[DllImport("user32.dll", CharSet = CharSet.Ansi, EntryPoint = "SetWindowTextA", ExactSpelling = true, SetLastError = true)]
		public static extern long SetWindowText(long hwnd, [MarshalAs(UnmanagedType.VBByRefStr)] ref string lpString);

		// Token: 0x060006FE RID: 1790
		[DllImport("user32.dll", CharSet = CharSet.Unicode)]
		public static extern int GetScrollPos(IntPtr hWnd, int nBar);

		// Token: 0x060006FF RID: 1791
		[DllImport("user32.dll", CharSet = CharSet.Unicode)]
		public static extern int SetScrollPos(IntPtr hWnd, int nBar, int nPos, bool bRedraw);

		// Token: 0x06000700 RID: 1792
		[DllImport("user32.dll", CharSet = CharSet.Auto, ExactSpelling = true)]
		public static extern bool IsWindow(IntPtr hWnd);

		// Token: 0x06000701 RID: 1793
		[DllImport("user32.dll")]
		public static extern bool GetWindowRect(HandleRef hWnd, ref modRect.RECT lpRect);

		// Token: 0x06000702 RID: 1794
		[DllImport("user32.dll", CharSet = CharSet.Auto, ExactSpelling = true)]
		public static extern IntPtr GetParent(IntPtr hWnd);

		// Token: 0x06000703 RID: 1795
		[DllImport("user32.dll")]
		public static extern IntPtr GetDesktopWindow();

		// Token: 0x06000704 RID: 1796
		[DllImport("user32.dll", SetLastError = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		public static extern bool IsWindowVisible(IntPtr hWnd);

		// Token: 0x06000705 RID: 1797
		[DllImport("user32.dll")]
		public static extern IntPtr WindowFromPoint(Point p);

		// Token: 0x06000706 RID: 1798
		[DllImport("user32.dll", SetLastError = true)]
		public static extern uint GetWindowThreadProcessId(IntPtr hwnd, ref IntPtr lpdwProcessId);

		// Token: 0x06000707 RID: 1799
		[DllImport("user32.dll")]
		public static extern bool GetGUIThreadInfo(uint idThread, ref modWindows.GUITHREADINFO lpgui);

		// Token: 0x04000D78 RID: 3448
		private const int SB_HORZ = 0;

		// Token: 0x04000D79 RID: 3449
		private const int SB_VERT = 1;

		// Token: 0x02000105 RID: 261
		public enum ShowWindowCommands
		{
			// Token: 0x04000D7B RID: 3451
			Hide,
			// Token: 0x04000D7C RID: 3452
			Normal,
			// Token: 0x04000D7D RID: 3453
			ShowMinimized,
			// Token: 0x04000D7E RID: 3454
			Maximize,
			// Token: 0x04000D7F RID: 3455
			ShowMaximized = 3,
			// Token: 0x04000D80 RID: 3456
			ShowNoActivate,
			// Token: 0x04000D81 RID: 3457
			Show,
			// Token: 0x04000D82 RID: 3458
			Minimize,
			// Token: 0x04000D83 RID: 3459
			ShowMinNoActive,
			// Token: 0x04000D84 RID: 3460
			ShowNA,
			// Token: 0x04000D85 RID: 3461
			Restore,
			// Token: 0x04000D86 RID: 3462
			ShowDefault,
			// Token: 0x04000D87 RID: 3463
			ForceMinimize
		}

		// Token: 0x02000106 RID: 262
		public struct GUITHREADINFO
		{
			// Token: 0x04000D88 RID: 3464
			public int cbSize;

			// Token: 0x04000D89 RID: 3465
			public int flags;

			// Token: 0x04000D8A RID: 3466
			public IntPtr hwndActive;

			// Token: 0x04000D8B RID: 3467
			public IntPtr hwndFocus;

			// Token: 0x04000D8C RID: 3468
			public IntPtr hwndCapture;

			// Token: 0x04000D8D RID: 3469
			public IntPtr hwndMenuOwner;

			// Token: 0x04000D8E RID: 3470
			public IntPtr hwndMoveSize;

			// Token: 0x04000D8F RID: 3471
			public IntPtr hwndCaret;

			// Token: 0x04000D90 RID: 3472
			public Rectangle rcCaret;
		}
	}
}
