﻿using System;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace libZh
{
	// Token: 0x020000F9 RID: 249
	[StandardModule]
	public sealed class modWinUse
	{
		// Token: 0x060006D3 RID: 1747 RVA: 0x00023674 File Offset: 0x00021874
		public static bool WinActiveWait(string _sTitle, int _iTimeout)
		{
			IntPtr intPtr = modWindows.FindWindow(null, _sTitle);
			bool flag = intPtr == IntPtr.Zero;
			checked
			{
				bool result;
				if (flag)
				{
					result = false;
				}
				else
				{
					StringBuilder stringBuilder = new StringBuilder(100);
					int windowText = modWindows.GetWindowText(intPtr, stringBuilder, stringBuilder.Capacity);
					bool flag2 = windowText == 0;
					if (flag2)
					{
						result = false;
					}
					else
					{
						string title = stringBuilder.ToString();
						int num = 0;
						try
						{
							Interaction.AppActivate(title);
							return true;
						}
						catch (Exception ex)
						{
						}
						for (;;)
						{
							bool flag3 = num >= _iTimeout;
							if (flag3)
							{
								break;
							}
							Thread.Sleep(100);
							num += 100;
							try
							{
								Interaction.AppActivate(title);
								return true;
							}
							catch (Exception ex2)
							{
							}
						}
						result = false;
					}
				}
				return result;
			}
		}

		// Token: 0x060006D4 RID: 1748 RVA: 0x00023774 File Offset: 0x00021974
		public static FormWindowState getWindowState(IntPtr hwnd)
		{
			modWindowPlacement.WINDOWPLACEMENT windowplacement = default(modWindowPlacement.WINDOWPLACEMENT);
			windowplacement.Length = Marshal.SizeOf<modWindowPlacement.WINDOWPLACEMENT>(windowplacement);
			modWindows.GetWindowPlacement(hwnd, ref windowplacement);
			FormWindowState result;
			switch (windowplacement.showCmd)
			{
			case 1:
				result = FormWindowState.Normal;
				break;
			case 2:
				result = FormWindowState.Minimized;
				break;
			case 3:
				result = FormWindowState.Maximized;
				break;
			default:
				Interaction.MsgBox("getWindowState() couldn't retreive the window's state", MsgBoxStyle.OkOnly, null);
				result = FormWindowState.Normal;
				break;
			}
			return result;
		}

		// Token: 0x060006D5 RID: 1749 RVA: 0x000237D8 File Offset: 0x000219D8
		public static IntPtr getActiveWindow()
		{
			modWindows.GUITHREADINFO guithreadinfo = default(modWindows.GUITHREADINFO);
			guithreadinfo.cbSize = Marshal.SizeOf<modWindows.GUITHREADINFO>(guithreadinfo);
			IntPtr result;
			if (modWindows.GetGUIThreadInfo(0U, ref guithreadinfo))
			{
				result = guithreadinfo.hwndActive;
			}
			else
			{
				result = IntPtr.Zero;
			}
			return result;
		}
	}
}
