﻿using System;
using System.Diagnostics;
using System.IO;
using libSnesAssembler;
using libZh.My;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using SnesPatcher.My;

namespace libZh
{
	// Token: 0x020000F8 RID: 248
	[StandardModule]
	public sealed class modExecute
	{
		// Token: 0x060006CF RID: 1743 RVA: 0x000234D4 File Offset: 0x000216D4
		public static void ShellAndWait(string ProcessPath)
		{
			if (MyApplicationRoot.nogui && modAsmReport.asmProgReport.dProgressWeight == 10)
			{
				MyApplicationRoot.execList.Add(ProcessPath);
				return;
			}
			try
			{
				Process process = new Process();
				process.StartInfo.WorkingDirectory = libZh.My.MyProject.Computer.FileSystem.GetParentPath(Path.GetFullPath(ProcessPath));
				process.StartInfo.FileName = ProcessPath;
				process.StartInfo.WindowStyle = ProcessWindowStyle.Normal;
				process.StartInfo.UseShellExecute = !MyApplicationRoot.nogui;
				process.Start();
				process.WaitForExit();
				process.Close();
			}
			catch (Exception)
			{
				MyApplicationRoot.MsgBox("Could not start process " + ProcessPath, MsgBoxStyle.OkOnly, "Error", 1000);
			}
		}

		// Token: 0x060006D0 RID: 1744 RVA: 0x00023598 File Offset: 0x00021798
		public static Process ShellProc(string ProcessPath)
		{
			try
			{
				Process process = new Process();
				process.StartInfo.WorkingDirectory = libZh.My.MyProject.Computer.FileSystem.GetParentPath(ProcessPath);
				process.StartInfo.FileName = ProcessPath;
				process.StartInfo.WindowStyle = ProcessWindowStyle.Normal;
				process.Start();
				return process;
			}
			catch (Exception ex)
			{
				Interaction.MsgBox("Could not start process " + ProcessPath, MsgBoxStyle.OkOnly, "Error");
			}
			return null;
		}

		// Token: 0x060006D1 RID: 1745 RVA: 0x00023634 File Offset: 0x00021834
		public static void ShellRun(string _sPath, string _sArguments = null)
		{
			FileInfo fileInfo = libZh.My.MyProject.Computer.FileSystem.GetFileInfo(_sPath);
			Process.Start(new ProcessStartInfo(fileInfo.FullName, _sArguments)
			{
				WorkingDirectory = fileInfo.DirectoryName
			});
		}
	}
}
