﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace libZh
{
	// Token: 0x020001BA RID: 442
	public class OutlinedPanel : Panel
	{
		// Token: 0x0600095E RID: 2398 RVA: 0x000062ED File Offset: 0x000044ED
		public OutlinedPanel()
		{
			this.outlineThickness = 1f;
			this.brushColor = Color.Black;
			this.brush = new SolidBrush(this.brushColor);
		}

		// Token: 0x0600095F RID: 2399 RVA: 0x0000631C File Offset: 0x0000451C
		protected override void OnPaint(PaintEventArgs e)
		{
			base.OnPaint(e);
			e.Graphics.DrawRectangle(new Pen(this.brush, this.outlineThickness), new Rectangle(0, 0, base.Width - 1, base.Height - 1));
		}

		// Token: 0x06000960 RID: 2400 RVA: 0x00006358 File Offset: 0x00004558
		public OutlinedPanel(Color brushColor, float outlineThickness = 1f)
		{
			this.outlineThickness = outlineThickness;
			this.brushColor = brushColor;
			this.brush = new SolidBrush(brushColor);
		}

		// Token: 0x04000F4F RID: 3919
		public float outlineThickness;

		// Token: 0x04000F50 RID: 3920
		public Color brushColor;

		// Token: 0x04000F51 RID: 3921
		private Brush brush;
	}
}
