﻿using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Text;
using System.Windows.Forms;

namespace libZh
{
	// Token: 0x020001B9 RID: 441
	public class OutlinedLabel : Label
	{
		// Token: 0x0600095C RID: 2396 RVA: 0x000062CF File Offset: 0x000044CF
		public OutlinedLabel()
		{
			this.font = new Font("Consolas", 12f, FontStyle.Regular);
		}

		// Token: 0x0600095D RID: 2397 RVA: 0x00036538 File Offset: 0x00034738
		protected override void OnPaint(PaintEventArgs e)
		{
			e.Graphics.TextRenderingHint = TextRenderingHint.ClearTypeGridFit;
			e.Graphics.SmoothingMode = SmoothingMode.HighQuality;
			GraphicsPath graphicsPath = new GraphicsPath();
			graphicsPath.AddString(this.Text, this.font.FontFamily, (int)this.font.Style, (float)((int)(e.Graphics.DpiY * this.font.Size / 72f)), new Point(1, 0), new StringFormat());
			e.Graphics.DrawPath(new Pen(Brushes.Black, 4f), graphicsPath);
			graphicsPath.Dispose();
			base.OnPaint(e);
		}

		// Token: 0x04000F4E RID: 3918
		private Font font;
	}
}
