﻿using System;
using System.Collections;
using System.Collections.ObjectModel;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using SnesPatcher.My;

namespace libSnesAssembler
{
	// Token: 0x02000123 RID: 291
	[StandardModule]
	public sealed class modProjectBuilder
	{
		// Token: 0x06000778 RID: 1912 RVA: 0x00028E7C File Offset: 0x0002707C
		public static modAssemblerStructs.asmProject createAsmProject(string pathSourceRom, string pathDestRom, string pathProject, AsmPatch patchFile)
		{
			modAssemblerStructs.asmProject asmProject = new modAssemblerStructs.asmProject
			{
				pathSourceRom = pathSourceRom,
				pathDestRom = pathDestRom,
				pathProject = pathProject,
				patchFile = patchFile
			};
			if (MyApplicationRoot.debug || asmProject.patchFile.dicOptions.ContainsKey("DEBUG"))
			{
				modCommonDebug._debugStart();
			}
			modProjectBuilder.makeProject(ref asmProject);
			modCommonDebug._debugStop();
			return asmProject;
		}

		// Token: 0x06000779 RID: 1913 RVA: 0x00028EE4 File Offset: 0x000270E4
		public static modAssemblerStructs.asmProject createAsmProject(string pathSourceRom, string pathDestRom, string pathProject)
		{
			AsmPatchBuilder asmPatchBuilder = new AsmPatchBuilder(pathProject, pathSourceRom, false);
			return modProjectBuilder.createAsmProject(pathSourceRom, pathDestRom, pathProject, new AsmPatch(asmPatchBuilder.sPathPatch)
			{
				bUsePatch = false
			});
		}

		// Token: 0x0600077A RID: 1914 RVA: 0x00028F20 File Offset: 0x00027120
		private static void makeProject(ref modAssemblerStructs.asmProject project)
		{
			assemblerOpcodes.dicAsmCmd.Clear();
			modAsmDefs.dicAliases.Clear();
			modAsmDefs.dicBlocks.Clear();
			modAsmDefs.dicDef.Clear();
			modAsmDefs.dicLabels.Clear();
			modAsmDefs.dicRelative.Clear();
			modAsmDefs.colAsmBlocks.Clear();
			project.bSkip_UntilEndIf = false;
			modAssemble.asmDbg = "";
			modAssemble.asmDbg_Cmd = "";
			modAssemble.asmDbg_Bytes = "";
			modAssemble.asmDbg_Msg = "";
			modAssemble.asmDbg_Param = "";
			modAsmDefs.asmDbg_Defs = "";
			modAsmDefs.curRelative = null;
			assemblerOpcodes.bError = false;
			compiler.offset = 12582912;
			modAsmDefs.bPreparing = true;
			modCommonDebug._debugSectionStart("MAKE OPTIONS:");
			foreach (string text in project.patchFile.dicOptions.Keys)
			{
				modCommonDebug._debugWrite("OPTION CHOICE: " + project.patchFile.optionOn(text).ToString() + "  " + project.patchFile.dicOptions[text].sName);
			}
			modCommonDebug._debugSectionEnd();
			modCommonDebug._debugWrite("MAKE: Linking\r\n");
			modAssemblerStructs.AsmLinkedProject linked = modProjectLinker.linkProject(ref project);
			project.linked = linked;
			modCommonDebug._debugWrite("MAKE: SetDefininitions\r\n");
			if (modAsmDefs.setDefinitions(project))
			{
				modCommonDebug._debugWrite("MAKE: Compile\r\n");
				if (modProjectBuilder.compileProject(ref project, ref linked))
				{
					modCommonDebug._debugWrite("MAKE: Assemble\r\n");
					if (modProjectBuilder.assembleProject(ref project, ref linked))
					{
						project.state = modAssemblerStructs.asmProject.enumProjectState.success;
						if (!MyApplicationRoot.nogui)
						{
							modAssemble.bgAsmWorker.ReportProgress(100);
						}
						modCommonDebug._debugSectionStart("MAKE: Success !");
						project.targetCRC32 = Crc32.getFileChecksum(project.pathDestRom);
						modCommonDebug._debugWrite("CRC32 : " + modString.hx(project.targetCRC32, 2));
						modCommonDebug._debugSectionEnd();
						return;
					}
					project.state = modAssemblerStructs.asmProject.enumProjectState.errorAssembling;
					MyApplicationRoot.MsgBox("Error Assembling", MsgBoxStyle.OkOnly, null, 2000);
				}
				else
				{
					project.state = modAssemblerStructs.asmProject.enumProjectState.errorCompiling;
					MyApplicationRoot.MsgBox("Error Compiling", MsgBoxStyle.OkOnly, null, 2000);
				}
			}
			else
			{
				project.state = modAssemblerStructs.asmProject.enumProjectState.errorDefining;
			}
			modCommonDebug._debugWrite("MAKE: ERROR\r\n");
		}

		// Token: 0x0600077B RID: 1915 RVA: 0x00029164 File Offset: 0x00027364
		private static bool compileProject(ref modAssemblerStructs.asmProject project, ref modAssemblerStructs.AsmLinkedProject asmLink)
		{
			modAsmReport.asmProgReport.startNewState("Compiling", checked(asmLink.cAsm.Count * 2), 30);
			project.resultComp = compiler.compile_better(project, true);
			modAsmReport.asmProgReport.finishState();
			bool bError = assemblerOpcodes.bError;
			bool result;
			if (bError)
			{
				project.bError = true;
				project.bCompileError = true;
				result = false;
			}
			else
			{
				result = true;
			}
			return result;
		}

		// Token: 0x0600077C RID: 1916 RVA: 0x000291D8 File Offset: 0x000273D8
		private static bool assembleProject(ref modAssemblerStructs.asmProject project, ref modAssemblerStructs.AsmLinkedProject asmLink)
		{
			modAsmReport.asmProgReport.startNewState("Assembling", checked(asmLink.cAsm.Count * 2), 30);
			try
			{
				foreach (object obj in modAsmDefs.colAsmBlocks)
				{
					modAssemblerStructs.AsmBlock asmBlock = (modAssemblerStructs.AsmBlock)obj;
					asmBlock.addr = asmBlock.baseAddr;
				}
			}
			finally
			{
				IEnumerator enumerator;
				if (enumerator is IDisposable)
				{
					(enumerator as IDisposable).Dispose();
				}
			}
			project.resultBuild = compiler.compile_better(project, false);
			modAsmReport.asmProgReport.finishState();
			bool flag = !assemblerOpcodes.bError;
			bool result;
			if (flag)
			{
				modAsmRom.writeToRom(ref project.pathDestRom);
				result = true;
			}
			else
			{
				result = false;
			}
			return result;
		}

		// Token: 0x04000DD1 RID: 3537
		public static Collection<string> cAsmFiles = new Collection<string>();

		// Token: 0x04000DD2 RID: 3538
		public static Collection<string> cDebugDefFiles = new Collection<string>();

		// Token: 0x04000DD3 RID: 3539
		public static int iAsm_ProgressCount;

		// Token: 0x04000DD4 RID: 3540
		public static int iAsm_Progress = 0;

		// Token: 0x04000DD5 RID: 3541
		public static int iAsm_ProgressPercent = 0;
	}
}
