﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using libSnesAssembler.My;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using Microsoft.VisualBasic.FileIO;
using Microsoft.VisualBasic.MyServices;
using SnesPatcher;
using SnesPatcher.My;

namespace libSnesAssembler
{
	// Token: 0x02000124 RID: 292
	public class AsmPatch
	{
		// Token: 0x0600077F RID: 1919 RVA: 0x000292B8 File Offset: 0x000274B8
		public AsmPatch(string sPath)
		{
			this.cFiles = new Dictionary<string, AsmPatchFile>();
			this.sPathRoot = "";
			this.sPathPatch = "";
			this.sVersion = "0";
			this.sChecksum = "0";
			this.sRomSize = "0";
			this.bUsePatch = true;
			this.bCompatible = false;
			this.iDefFileCount = 0;
			this.iAsmFileCount = 0;
			modCommonDebug._debugSectionStart("LOAD PATCH:");
			modCommonDebug._debugSectionStart("TARGET ROM INFO");
			this.sPathPatch = sPath;
			this.sPathRoot = libSnesAssembler.My.MyProject.Computer.FileSystem.GetFileInfo(sPath).Directory.FullName;
			FileSystemProxy fileSystem = libSnesAssembler.My.MyProject.Computer.FileSystem;
			this.dicOptions = new Dictionary<string, PatchOption>();
			this.dicGlobals = new Dictionary<string, PatchGlobal>();
			this.dicConstGlobals = new Dictionary<string, PatchGlobal>();
			StreamReader streamReader = fileSystem.OpenTextFileReader(sPath);
			string text = null;
			StringBuilder stringBuilder = new StringBuilder();
			int iProgressCount = modString.splitLines(fileSystem.ReadAllText(sPath), false).Count<string>();
			bool flag = false;
			bool flag2 = false;
			bool flag3 = false;
			bool flag4 = false;
			bool flag5 = false;
			while (!streamReader.EndOfStream & !flag)
			{
				if (Strings.StrComp(streamReader.ReadLine(), "[PatchVersion]", CompareMethod.Binary) == 0)
				{
					flag = true;
				}
			}
			while (!streamReader.EndOfStream & !flag5)
			{
				string text2 = streamReader.ReadLine();
				if (Strings.StrComp(text2, "[Checksum]", CompareMethod.Binary) == 0)
				{
					flag5 = true;
				}
				else
				{
					this.sVersion = text2.Replace("+", "");
					modCommonDebug._debugWrite("PATCH VERSION: " + this.sVersion);
					if (Strings.StrComp(this.sVersion.Replace("¹", "1"), AsmPatch.patcherVersion, CompareMethod.Text) != 0)
					{
						this.bCompatible = false;
						return;
					}
					this.bCompatible = true;
				}
			}
			while (!streamReader.EndOfStream & !flag2)
			{
				string @string = streamReader.ReadLine();
				if (Strings.StrComp(@string, "[RomSize]", CompareMethod.Binary) == 0)
				{
					flag2 = true;
				}
				else
				{
					this.sChecksum = @string;
					modCommonDebug._debugWrite("CHECKSUM: " + this.sChecksum);
				}
			}
			while (!streamReader.EndOfStream & !flag3)
			{
				string string2 = streamReader.ReadLine();
				if (Strings.StrComp(string2, "[Options]", CompareMethod.Binary) == 0)
				{
					flag3 = true;
				}
				else
				{
					this.sRomSize = string2;
					modCommonDebug._debugWrite("ROMSIZE: " + this.sRomSize);
				}
			}
			modCommonDebug._debugSectionEnd();
			modCommonDebug._debugSectionStart("PATCH OPTIONS");
			while (!streamReader.EndOfStream & !flag4)
			{
				string text3 = streamReader.ReadLine();
				if (Strings.StrComp(text3, "[EndOptions]", CompareMethod.Binary) == 0)
				{
					flag4 = true;
				}
				else
				{
					this.dicOptions.Add(text3, new PatchOption(text3, false, ""));
					modCommonDebug._debugWrite("OPTION: " + text3);
				}
			}
			modCommonDebug._debugSectionEnd();
			if (!streamReader.EndOfStream)
			{
				streamReader.ReadLine();
			}
			modCommonDebug._debugPause();
			modAsmReport.asmProgReport.startNewState("Loading Patch", iProgressCount, 5);
			modCommonDebug._debugSectionStart("PATCH FILES");
			bool flag6 = false;
			bool flag7 = false;
			checked
			{
				while (!streamReader.EndOfStream)
				{
					string text4 = streamReader.ReadLine();
					modAsmReport.asmProgReport.progressStep();
					if (text4.Length > 1 && Operators.CompareString(Conversions.ToString(text4[0]), "&", false) == 0)
					{
						if (text != null)
						{
							this.cFiles.Add(text, new AsmPatchFile(text, stringBuilder.ToString()));
							modCommonDebug._debugWrite("PATCHFILE: " + text);
						}
						text = text4.Substring(1);
						stringBuilder = new StringBuilder();
						flag7 = false;
						flag6 = false;
						if (text.EndsWith(".adf"))
						{
							flag7 = true;
						}
						else if (text.EndsWith(".asm"))
						{
							flag6 = true;
						}
					}
					else
					{
						stringBuilder.AppendLine(text4);
						if (flag7)
						{
							ref int ptr = ref this.iDefFileCount;
							this.iDefFileCount = ptr + 1;
						}
						else if (flag6)
						{
							ref int ptr2 = ref this.iAsmFileCount;
							this.iAsmFileCount = ptr2 + 1;
						}
					}
				}
				if (text != null)
				{
					this.cFiles.Add(text, new AsmPatchFile(text, stringBuilder.ToString()));
					modCommonDebug._debugWrite("PATCHFILE: " + text);
				}
				streamReader.Close();
				modCommonDebug._debugSectionEnd();
				modAsmReport.asmProgReport.finishState();
				modCommonDebug._debugResume();
				this.patch_loadSettings();
				this.patch_loadConstGlobalFiles();
				if (!MyApplicationRoot.noload)
				{
					List<string> configData = MyApplicationRoot.ReadConfigFile(sPath.Substring(0, sPath.LastIndexOf(".")) + ".ini");
					string text5 = "{unknown}";
					foreach (string key in this.dicOptions.Keys)
					{
						string text6 = this.dicOptions[key].sName.Replace("=", "\\");
						if (text6.StartsWith("["))
						{
							text5 = text6.Replace("[", "").Replace("]", "");
							text6 = "{" + text5 + "}";
						}
						this.dicOptions[key].bActive = (MyApplicationRoot.LoadSetting(text5, text6, this.dicOptions[key].bActive ? "1" : "0", configData) != "0");
					}
					text5 = "Advanced Options";
					foreach (string key2 in this.dicGlobals.Keys)
					{
						if (this.dicGlobals[key2].bEditable && this.dicGlobals[key2].editType != PatchGlobal.enum_globalType.globalType_none)
						{
							string text7 = this.dicGlobals[key2].sName.Replace("=", "\\").Replace("%", "");
							if (!text7.StartsWith("["))
							{
								string text8 = MyApplicationRoot.LoadSetting(text5, text7, this.dicGlobals[key2].sEditValue, configData);
								if ((this.dicGlobals[key2].editType == PatchGlobal.enum_globalType.globalType_hex_4bit && text8.Length == 1) || (this.dicGlobals[key2].editType == PatchGlobal.enum_globalType.globalType_hex_8bit && text8.Length == 2) || (this.dicGlobals[key2].editType == PatchGlobal.enum_globalType.globalType_hex_16bit && text8.Length == 4) || (this.dicGlobals[key2].editType == PatchGlobal.enum_globalType.globalType_hex_24bit && text8.Length == 6))
								{
									this.dicGlobals[key2].sEditValue = text8;
								}
								else
								{
									Console.Write("unknown PatchGlobal.editType");
								}
							}
						}
					}
					if (!MyApplicationRoot.noChain)
					{
						Directory.SetCurrentDirectory(this.sPathRoot);
						text5 = "Patch Chain";
						int num = 0;
						bool flag8 = false;
						Collection collection = new Collection();
						for (int i = 0; i <= 99; i++)
						{
							string text9 = MyApplicationRoot.LoadSetting(text5, i.ToString("D2"), "", configData);
							if (string.IsNullOrEmpty(text9))
							{
								break;
							}
							if (text9.Length < 6 || text9[1] != '=')
							{
								num = -1;
								break;
							}
							string path = text9.Substring(2);
							if (!File.Exists(path))
							{
								num = -1;
								break;
							}
							ListItem_Patch listItem_Patch;
							if (text9[0] == 'Z')
							{
								if (flag8)
								{
									num = -1;
									break;
								}
								flag8 = true;
								listItem_Patch = new ListItem_Patch(true);
							}
							else if (text9[0] == 'h')
							{
								listItem_Patch = new ListItem_Patch(Path.GetFullPath(path));
							}
							else
							{
								if (text9[0] != 'H')
								{
									num = -1;
									break;
								}
								listItem_Patch = new ListItem_Patch(Path.GetFullPath(path));
								listItem_Patch.bNeedHeader = true;
							}
							collection.Add(listItem_Patch, null, null, null);
							num++;
						}
						if (num != 0)
						{
							if (flag8 && num > 1)
							{
								if (modPatchChain.patchChain == null)
								{
									modPatchChain.setPatchChain(new PatchChain(collection, "", ""));
								}
								else
								{
									modPatchChain.patchChain.colPatches = collection;
								}
							}
							else
							{
								MyApplicationRoot.MsgBox("Error Loading patch chain from config file", MsgBoxStyle.OkOnly, "Error", 5000);
							}
						}
						Directory.SetCurrentDirectory(AppContext.BaseDirectory);
					}
				}
				if (!string.IsNullOrEmpty(MyApplicationRoot.boolString))
				{
					int num2 = 0;
					int num3 = 0;
					byte b = 0;
					foreach (string key3 in this.dicOptions.Keys)
					{
						if (this.dicOptions[key3].iDevProgress != 0)
						{
							if (num3 == 0)
							{
								if (num2 >= MyApplicationRoot.boolString.Length)
								{
									break;
								}
								b = Convert.ToByte(MyApplicationRoot.boolString.Substring(num2, 2), 16);
								num2 += 2;
								num3 = 8;
							}
							num3--;
							this.dicOptions[key3].bActive = (((int)b & 1 << num3) != 0);
						}
					}
				}
				if (!string.IsNullOrEmpty(MyApplicationRoot.nibbleString))
				{
					int num4 = 0;
					foreach (string key4 in this.dicGlobals.Keys)
					{
						if (this.dicGlobals[key4].bEditable && this.dicGlobals[key4].editType != PatchGlobal.enum_globalType.globalType_none)
						{
							switch (this.dicGlobals[key4].editType)
							{
							case PatchGlobal.enum_globalType.globalType_hex_4bit:
								if (MyApplicationRoot.nibbleString.Length - num4 >= 1)
								{
									this.dicGlobals[key4].sEditValue = MyApplicationRoot.nibbleString.Substring(num4, 1);
								}
								num4++;
								break;
							case PatchGlobal.enum_globalType.globalType_hex_8bit:
								if (MyApplicationRoot.nibbleString.Length - num4 >= 2)
								{
									this.dicGlobals[key4].sEditValue = MyApplicationRoot.nibbleString.Substring(num4, 2);
								}
								num4 += 2;
								break;
							case PatchGlobal.enum_globalType.globalType_hex_16bit:
								if (MyApplicationRoot.nibbleString.Length - num4 >= 4)
								{
									this.dicGlobals[key4].sEditValue = MyApplicationRoot.nibbleString.Substring(num4, 4);
								}
								num4 += 4;
								break;
							case PatchGlobal.enum_globalType.globalType_hex_24bit:
								if (MyApplicationRoot.nibbleString.Length - num4 >= 6)
								{
									this.dicGlobals[key4].sEditValue = MyApplicationRoot.nibbleString.Substring(num4, 6);
								}
								num4 += 6;
								break;
							default:
								Console.Write("unknown PatchGlobal.editType");
								break;
							}
							if (num4 >= MyApplicationRoot.nibbleString.Length)
							{
								break;
							}
						}
					}
				}
				modCommonDebug._debugSectionEnd();
			}
		}

		// Token: 0x06000780 RID: 1920 RVA: 0x00029DB0 File Offset: 0x00027FB0
		private void patch_loadSettings()
		{
			modCommonDebug._debugSectionStart("PROJECT SETTINGS:");
			bool flag = this.fileExists("project.aps");
			if (flag)
			{
				string sString = this.fileText("project.aps");
				string[] array = modString.splitLines(sString, true);
				foreach (string text in array)
				{
					string[] array3 = text.Split(new char[]
					{
						' '
					});
					bool flag2 = array3[0].StartsWith("%") & array3[0].EndsWith("%");
					if (flag2)
					{
						PatchGlobal patchGlobal = PatchGlobal.patchGlobal_load(text);
						bool flag3 = patchGlobal != null;
						if (flag3)
						{
							bool flag4 = !this.dicGlobals.ContainsKey(patchGlobal.sName);
							if (flag4)
							{
								this.dicGlobals.Add(patchGlobal.sName, patchGlobal);
								patchGlobal.printDebug();
							}
						}
					}
					else
					{
						PatchOption patchOption = PatchOption.patchOption_load(text);
						bool flag5 = patchOption != null;
						if (flag5)
						{
							bool flag6 = !this.dicOptions.ContainsKey(patchOption.sName);
							if (flag6)
							{
								this.dicOptions.Add(patchOption.sName, patchOption);
								patchOption.printDebug();
							}
						}
					}
				}
			}
			modCommonDebug._debugSectionEnd();
		}

		// Token: 0x06000781 RID: 1921 RVA: 0x00029F18 File Offset: 0x00028118
		private void patch_loadConstGlobalFiles()
		{
			modCommonDebug._debugSectionStart("PATH: LOAD AGL GLOBALS");
			try
			{
				foreach (KeyValuePair<string, AsmPatchFile> keyValuePair in this.cFiles)
				{
					bool flag = keyValuePair.Value.sPath.EndsWith(".agl");
					if (flag)
					{
						Collection<PatchGlobal> collection = PatchGlobal.patchGlobal_loadAgl(keyValuePair.Value.sText, "");
						try
						{
							foreach (PatchGlobal patchGlobal in collection)
							{
								bool flag2 = patchGlobal != null;
								if (flag2)
								{
									bool flag3 = !this.dicConstGlobals.ContainsKey(patchGlobal.sName);
									if (flag3)
									{
										this.dicConstGlobals.Add(patchGlobal.sName, patchGlobal);
										patchGlobal.printDebug();
									}
								}
							}
						}
						finally
						{
							IEnumerator<PatchGlobal> enumerator2;
							if (enumerator2 != null)
							{
								enumerator2.Dispose();
							}
						}
					}
				}
			}
			finally
			{
				Dictionary<string, AsmPatchFile>.Enumerator enumerator;
				((IDisposable)enumerator).Dispose();
			}
			modCommonDebug._debugSectionEnd();
		}

		// Token: 0x06000782 RID: 1922 RVA: 0x0002A050 File Offset: 0x00028250
		private string realPath(string sPath)
		{
			return this.sPathRoot + "\\" + sPath;
		}

		// Token: 0x06000783 RID: 1923 RVA: 0x0002A078 File Offset: 0x00028278
		public bool fileExists(string sPath)
		{
			bool flag = this.bUsePatch;
			bool result;
			if (flag)
			{
				result = this.cFiles.ContainsKey(sPath);
			}
			else
			{
				FileSystemProxy fileSystem = libSnesAssembler.My.MyProject.Computer.FileSystem;
				bool flag2 = fileSystem.FileExists(this.realPath(sPath));
				if (flag2)
				{
					result = true;
				}
				else
				{
					bool flag3 = fileSystem.DirectoryExists(this.realPath(sPath));
					if (flag3)
					{
						string name = fileSystem.GetDirectoryInfo(this.realPath(sPath)).Name;
						bool flag4 = fileSystem.FileExists(this.realPath(sPath) + "\\" + name + ".adf");
						if (flag4)
						{
							return true;
						}
					}
					result = false;
				}
			}
			return result;
		}

		// Token: 0x06000784 RID: 1924 RVA: 0x0002A134 File Offset: 0x00028334
		public string directoryExists(string sPath)
		{
			bool flag = this.bUsePatch;
			string result;
			if (flag)
			{
				try
				{
					foreach (string text in this.cFiles.Keys)
					{
						bool flag2 = text.StartsWith(sPath);
						if (flag2)
						{
							return Conversions.ToString(true);
						}
					}
				}
				finally
				{
					Dictionary<string, AsmPatchFile>.KeyCollection.Enumerator enumerator;
					((IDisposable)enumerator).Dispose();
				}
				result = Conversions.ToString(false);
			}
			else
			{
				result = Conversions.ToString(libSnesAssembler.My.MyProject.Computer.FileSystem.DirectoryExists(this.realPath(sPath)));
			}
			return result;
		}

		// Token: 0x06000785 RID: 1925 RVA: 0x0002A1F0 File Offset: 0x000283F0
		public Collection<string> getDirFiles(string sPath)
		{
			Collection<string> collection = new Collection<string>();
			bool flag = this.bUsePatch;
			if (flag)
			{
				try
				{
					foreach (string text in this.cFiles.Keys)
					{
						bool flag2 = text.StartsWith(sPath);
						if (flag2)
						{
							bool flag3 = text.EndsWith(".asm");
							if (flag3)
							{
								collection.Add(text);
							}
						}
					}
				}
				finally
				{
					Dictionary<string, AsmPatchFile>.KeyCollection.Enumerator enumerator;
					((IDisposable)enumerator).Dispose();
				}
			}
			else
			{
				FileSystemProxy fileSystem = libSnesAssembler.My.MyProject.Computer.FileSystem;
				ReadOnlyCollection<string> files = fileSystem.GetFiles(this.realPath(sPath), Microsoft.VisualBasic.FileIO.SearchOption.SearchAllSubDirectories, new string[]
				{
					"*.asm"
				});
				try
				{
					foreach (string text2 in files)
					{
						bool flag4 = text2.EndsWith(".asm");
						if (flag4)
						{
							string item = text2.Substring(checked(this.sPathRoot.Length + 1));
							collection.Add(item);
						}
					}
				}
				finally
				{
					IEnumerator<string> enumerator2;
					if (enumerator2 != null)
					{
						enumerator2.Dispose();
					}
				}
			}
			return collection;
		}

		// Token: 0x06000786 RID: 1926 RVA: 0x0002A350 File Offset: 0x00028550
		public string fileText(string sPath)
		{
			bool flag = this.bUsePatch;
			string result;
			if (flag)
			{
				result = this.replaceGlobals(this.cFiles[sPath].sText, 0);
			}
			else
			{
				FileSystemProxy fileSystem = libSnesAssembler.My.MyProject.Computer.FileSystem;
				bool flag2 = fileSystem.FileExists(this.realPath(sPath));
				if (flag2)
				{
					result = this.replaceGlobals(fileSystem.ReadAllText(this.realPath(sPath)), 0);
				}
				else
				{
					bool flag3 = fileSystem.DirectoryExists(this.realPath(sPath));
					if (flag3)
					{
						string name = fileSystem.GetDirectoryInfo(this.realPath(sPath)).Name;
						bool flag4 = fileSystem.FileExists(this.realPath(sPath) + "\\" + name + ".adf");
						if (flag4)
						{
							return this.replaceGlobals(fileSystem.ReadAllText(this.realPath(sPath) + "\\" + name + ".adf"), 0);
						}
					}
					result = "";
				}
			}
			return result;
		}

		// Token: 0x06000787 RID: 1927 RVA: 0x0002A458 File Offset: 0x00028658
		public string replaceGlobals(string sIn, int stackLevel = 0)
		{
			return this.replaceGlobals_new(sIn, 0);
		}

		// Token: 0x06000788 RID: 1928 RVA: 0x0002A478 File Offset: 0x00028678
		public string replaceGlobals_new(string sIn, int stackLevel = 0)
		{
			int num = sIn.IndexOf('%');
			if (num >= 0)
			{
				int count = sIn.LastIndexOf('%') - num + 1;
				StringBuilder stringBuilder = new StringBuilder(sIn);
				foreach (string text in this.dicGlobals.Keys)
				{
					if (MyApplicationRoot.FastIndexOf(sIn, text, num, count) >= 0)
					{
						stringBuilder.Replace(text, this.dicGlobals[text].getResult(null));
					}
				}
				return stringBuilder.ToString();
			}
			return sIn;
		}

		// Token: 0x06000789 RID: 1929 RVA: 0x0002A51C File Offset: 0x0002871C
		public bool optionOn(string sOption)
		{
			bool result;
			if (this.bUsePatch)
			{
				if (this.dicOptions.ContainsKey(sOption))
				{
					result = this.dicOptions[sOption].bActive;
				}
				else
				{
					MyApplicationRoot.MsgBox("Option doesn't exist ? : " + sOption, MsgBoxStyle.OkOnly, null, 2000);
					result = false;
				}
			}
			else if (this.dicOptions.ContainsKey(sOption))
			{
				result = this.dicOptions[sOption].bActive;
			}
			else
			{
				MyApplicationRoot.MsgBox("Option doesn't exist ? : " + sOption, MsgBoxStyle.OkOnly, null, 2000);
				result = false;
			}
			return result;
		}

		// Token: 0x04000DD6 RID: 3542
		private const int MAX_GLOBAL_STACK_LEVEL = 32;

		// Token: 0x04000DD7 RID: 3543
		public Dictionary<string, AsmPatchFile> cFiles;

		// Token: 0x04000DD8 RID: 3544
		public string sPathRoot;

		// Token: 0x04000DD9 RID: 3545
		public string sPathPatch;

		// Token: 0x04000DDA RID: 3546
		public Dictionary<string, PatchOption> dicOptions;

		// Token: 0x04000DDB RID: 3547
		public Dictionary<string, PatchGlobal> dicGlobals;

		// Token: 0x04000DDC RID: 3548
		public Dictionary<string, PatchGlobal> dicConstGlobals;

		// Token: 0x04000DDD RID: 3549
		public static string patcherVersion = "0.18";

		// Token: 0x04000DDE RID: 3550
		public string sVersion;

		// Token: 0x04000DDF RID: 3551
		public string sChecksum;

		// Token: 0x04000DE0 RID: 3552
		public string sRomSize;

		// Token: 0x04000DE1 RID: 3553
		public bool bUsePatch;

		// Token: 0x04000DE2 RID: 3554
		public bool bCompatible;

		// Token: 0x04000DE3 RID: 3555
		public int iDefFileCount;

		// Token: 0x04000DE4 RID: 3556
		public int iAsmFileCount;
	}
}
