﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using libSnesAssembler;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using Microsoft.VisualBasic.MyServices;
using SnesPatcher.My;

namespace SnesPatcher
{
	// Token: 0x02000013 RID: 19
	[StandardModule]
	public sealed class modPatchChain
	{
		// Token: 0x060000A4 RID: 164 RVA: 0x0000270F File Offset: 0x0000090F
		public static void setPatchChain(PatchChain _chain)
		{
			modPatchChain.patchChain = _chain;
		}

		// Token: 0x060000A5 RID: 165 RVA: 0x00009C50 File Offset: 0x00007E50
		public static void applyPatchChain(PatchChain _chain = null)
		{
			if (!MyApplicationRoot.nosave)
			{
				string path = MyApplicationRoot.outputLog.Substring(0, MyApplicationRoot.outputLog.LastIndexOf(".")) + ".ini";
				List<string> list = MyApplicationRoot.ReadConfigFile(path);
				for (int i = 0; i < list.Count; i++)
				{
					if (list[i] == "[Patch Chain]")
					{
						do
						{
							list.RemoveAt(i);
							if (i >= list.Count)
							{
								break;
							}
						}
						while (list[i][0] != '[');
						break;
					}
				}
				AsmPatch asmPatch = MyApplicationRoot.nogui ? MyApplicationRoot.noguiPatch : MyProject.Forms.frmSnesPatcher.zpsPatch;
				string text = "{unknown}";
				foreach (string key in asmPatch.dicOptions.Keys)
				{
					if (asmPatch.dicOptions[key].bAvailable && asmPatch.dicOptions[key].iDevProgress != 0)
					{
						string text2 = asmPatch.dicOptions[key].sName.Replace("=", "\\");
						if (text2.StartsWith("["))
						{
							text = text2.Replace("[", "").Replace("]", "");
							text2 = "{" + text + "}";
						}
						MyApplicationRoot.SaveSetting(text, text2, asmPatch.dicOptions[key].bActive ? "1" : "0", list);
					}
				}
				text = "Advanced Options";
				foreach (string key2 in asmPatch.dicGlobals.Keys)
				{
					if (asmPatch.dicGlobals[key2].bEditable && asmPatch.dicGlobals[key2].editType != PatchGlobal.enum_globalType.globalType_none)
					{
						string text3 = asmPatch.dicGlobals[key2].sName.Replace("=", "\\").Replace("%", "");
						if (!text3.StartsWith("["))
						{
							MyApplicationRoot.SaveSetting(text, text3, asmPatch.dicGlobals[key2].sEditValue, list);
						}
					}
				}
				if (modPatchChain.patchChain.colPatches.Count > 1)
				{
					text = "Patch Chain";
					int num = 0;
					foreach (object obj in modPatchChain.patchChain.colPatches)
					{
						ListItem_Patch listItem_Patch = (ListItem_Patch)obj;
						if (listItem_Patch.bZPS)
						{
							MyApplicationRoot.SaveSetting(text, num.ToString("D2"), "Z=" + Path.GetFileName(MyApplicationRoot.nogui ? MyApplicationRoot.loadedZPS : MyProject.Forms.frmSnesPatcher.zpsPatch.sPathPatch), list);
						}
						else if (Path.GetDirectoryName(listItem_Patch.sPath_patchFile) != Path.GetDirectoryName(MyApplicationRoot.nogui ? MyApplicationRoot.loadedZPS : MyProject.Forms.frmSnesPatcher.zpsPatch.sPathPatch))
						{
							MyApplicationRoot.SaveSetting(text, num.ToString("D2"), (listItem_Patch.bNeedHeader ? "H=" : "h=") + listItem_Patch.sPath_patchFile, list);
						}
						else
						{
							MyApplicationRoot.SaveSetting(text, num.ToString("D2"), (listItem_Patch.bNeedHeader ? "H=" : "h=") + Path.GetFileName(listItem_Patch.sPath_patchFile), list);
						}
						num++;
					}
				}
				MyApplicationRoot.WriteConfigFile(path, list);
			}
			if (_chain == null)
			{
				_chain = modPatchChain.patchChain;
			}
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			string sPath_Source = _chain.sPath_SourceRom;
			foreach (object obj2 in _chain.colPatches)
			{
				((ListItem_Patch)obj2).applyPatch(sPath_Source, _chain.sPath_OutputRom);
				sPath_Source = _chain.sPath_OutputRom;
			}
			MyApplicationRoot.MsgBox("Finished !\r\n'" + _chain.sPath_OutputRom + "'\r\nSuccessfully created !", MsgBoxStyle.OkOnly, Process.GetCurrentProcess().ProcessName);
		}

		// Token: 0x04000056 RID: 86
		public static PatchChain patchChain;
	}
}
