﻿using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using libSnesAssembler;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using Microsoft.VisualBasic.MyServices;
using SnesPatcher.My;

namespace SnesPatcher
{
	// Token: 0x0200000D RID: 13
	[DesignerGenerated]
	public partial class frmSnesPatcher : Form
	{
		// Token: 0x06000053 RID: 83 RVA: 0x00002321 File Offset: 0x00000521
		public frmSnesPatcher()
		{
			base.Load += this.frmSnesPatcher_Load;
			this.InitializeComponent();
			frmSnesPatcher.instance = this;
		}

		// Token: 0x06000054 RID: 84 RVA: 0x00002347 File Offset: 0x00000547
		[MethodImpl(MethodImplOptions.NoInlining | MethodImplOptions.NoOptimization)]
		private void frmSnesPatcher_Load(object sender, EventArgs e)
		{
			Console.WriteLine("Creating Patcher Window");
			this.Text = "Snes ZPS Patcher V0.18+ 0x04";
			if (Strings.StrComp("0.18", AsmPatch.patcherVersion, CompareMethod.Binary) != 0)
			{
				Interaction.MsgBox("Error, wrong version of libRomHacking.dll", MsgBoxStyle.Critical, "Error");
				ProjectData.EndApp();
			}
		}

		// Token: 0x06000055 RID: 85 RVA: 0x00002387 File Offset: 0x00000587
		private void btnSelectPath_Click(object sender, EventArgs e)
		{
			this.dlgOpenFile.Reset();
			this.dlgOpenFile.Filter = "ZPS Patch (*.zps)|*.zps";
			this.dlgOpenFile.ShowDialog();
			this.SelectPath(this.dlgOpenFile.FileName);
		}

		// Token: 0x06000056 RID: 86 RVA: 0x000023C1 File Offset: 0x000005C1
		private void Button2_Click(object sender, EventArgs e)
		{
			this.dlgOpenFile.Reset();
			this.dlgOpenFile.Filter = "Input ROM (*.smc;*.sfc)|*.smc;*.sfc|All Files (*.*)|*.*";
			this.dlgOpenFile.ShowDialog();
			this.AddRomData(this.dlgOpenFile.FileName);
		}

		// Token: 0x06000057 RID: 87 RVA: 0x00007C74 File Offset: 0x00005E74
		private void updateMatch()
		{
			if (!string.IsNullOrEmpty(this.txtCRC_patch.Text) && !string.IsNullOrEmpty(this.txtCRC_rom.Text))
			{
				if (modString.hx(this.txtCRC_patch.Text) == modString.hx(this.txtCRC_rom.Text))
				{
					this.lblCRC32.BackColor = Color.PaleGreen;
				}
				else
				{
					this.lblCRC32.BackColor = Color.Red;
				}
			}
			if (!string.IsNullOrEmpty(this.txtSize_patch.Text) && !string.IsNullOrEmpty(this.txtSize_rom.Text))
			{
				if (modString.hx(this.txtSize_patch.Text) == modString.hx(this.txtSize_rom.Text))
				{
					this.lblFileSize.BackColor = Color.PaleGreen;
				}
				else
				{
					this.lblFileSize.BackColor = Color.Red;
				}
			}
			if (this.zpsPatch == null || !this.zpsPatch.bCompatible)
			{
				this.btnApply.Enabled = false;
			}
			if (string.IsNullOrEmpty(this.txtFile_result.Text) && !string.IsNullOrEmpty(this.txtFile_patch.Text) && !string.IsNullOrEmpty(this.txtFile_rom.Text))
			{
				this.SetOutputROMName();
			}
		}

		// Token: 0x06000058 RID: 88 RVA: 0x00007DB0 File Offset: 0x00005FB0
		private void btnApply_Click(object sender, EventArgs e)
		{
			this.btnSelectPath.Enabled = false;
			base.Enabled = false;
			MyApplicationRoot.outputLog = this.zpsPatch.sPathPatch.Substring(0, this.zpsPatch.sPathPatch.LastIndexOf(".")) + ".log";
			this.path_destination = MyProject.Computer.FileSystem.GetFileInfo(this.path_source).Directory.FullName + Path.DirectorySeparatorChar.ToString() + this.txtFile_result.Text;
			if (modPatchChain.patchChain == null)
			{
				Collection collection = new Collection();
				collection.Add(new ListItem_Patch(true), null, null, null);
				modPatchChain.setPatchChain(new PatchChain(collection, "", ""));
			}
			modPatchChain.patchChain.sPath_SourceRom = this.path_source;
			modPatchChain.patchChain.sPath_OutputRom = this.path_destination;
			Directory.SetCurrentDirectory(this.zpsPatch.sPathRoot);
			modPatchChain.applyPatchChain(null);
			Directory.SetCurrentDirectory(AppContext.BaseDirectory);
			base.Enabled = true;
		}

		// Token: 0x06000059 RID: 89 RVA: 0x00007EC0 File Offset: 0x000060C0
		private void bgwPatcher_DoWork(object sender, DoWorkEventArgs e)
		{
			this.zpsPatch.bUsePatch = true;
			modAssemblerStructs.asmProject asmProject = modProjectBuilder.createAsmProject(this.path_source, this.path_destination, "", this.zpsPatch);
		}

		// Token: 0x0600005A RID: 90 RVA: 0x000023FB File Offset: 0x000005FB
		private void bgwPatcher_ProgressChanged(object sender, ProgressChangedEventArgs e)
		{
			this.barProgress.Value = e.ProgressPercentage;
		}

		// Token: 0x0600005B RID: 91 RVA: 0x00002410 File Offset: 0x00000610
		private void bgwPatcher_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
		{
			Interaction.MsgBox("The patched rom has sucesfully been created :\r\n\r\n" + this.path_destination, MsgBoxStyle.OkOnly, null);
			modCommonDebug._debugStop();
		}

		// Token: 0x0600005C RID: 92 RVA: 0x00007EF8 File Offset: 0x000060F8
		private void lstOptions_ItemCheck(object sender, ItemCheckEventArgs e)
		{
			if (e.CurrentValue == CheckState.Indeterminate)
			{
				e.NewValue = CheckState.Indeterminate;
				return;
			}
			object objectValue = RuntimeHelpers.GetObjectValue(this.lstOptions.Items[e.Index]);
			this.zpsPatch.dicOptions[Conversions.ToString(objectValue)].bActive = (e.NewValue == CheckState.Checked);
		}

		// Token: 0x0600005D RID: 93 RVA: 0x00007F58 File Offset: 0x00006158
		private void lstOptions_SelectedIndexChanged(object sender, EventArgs e)
		{
			bool flag = this.lstOptions.SelectedIndex > -1;
			if (flag)
			{
				object objectValue = RuntimeHelpers.GetObjectValue(this.lstOptions.SelectedItem);
				bool flag2 = this.zpsPatch.dicOptions.ContainsKey(Conversions.ToString(objectValue));
				if (flag2)
				{
					PatchOption patchOption = this.zpsPatch.dicOptions[Conversions.ToString(objectValue)];
					this.txtDescripton.Text = "[" + patchOption.sName + "] :\r\n" + patchOption.sDescription;
				}
			}
		}

		// Token: 0x0600005E RID: 94 RVA: 0x0000242F File Offset: 0x0000062F
		private void btnDef_Click(object sender, EventArgs e)
		{
			base.Enabled = false;
			frmEditGlobal frmEditGlobal = new frmEditGlobal(this.zpsPatch);
			frmEditGlobal.ShowDialog();
			frmEditGlobal.Dispose();
			base.Enabled = true;
		}

		// Token: 0x0600005F RID: 95 RVA: 0x00002456 File Offset: 0x00000656
		private void btnEditChain_Click(object sender, EventArgs e)
		{
			base.Enabled = false;
			MyProject.Forms.frmIPS.ShowDialog();
			MyProject.Forms.frmIPS.Dispose();
			base.Enabled = true;
		}

		// Token: 0x1700001B RID: 27
		// (get) Token: 0x06000062 RID: 98 RVA: 0x00002485 File Offset: 0x00000685
		// (set) Token: 0x06000063 RID: 99 RVA: 0x00008FB4 File Offset: 0x000071B4
		internal virtual Button btnSelectPath
		{
			[CompilerGenerated]
			get
			{
				return this._btnSelectPath;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnSelectPath_Click);
				Button btnSelectPath = this._btnSelectPath;
				if (btnSelectPath != null)
				{
					btnSelectPath.Click -= value2;
				}
				this._btnSelectPath = value;
				btnSelectPath = this._btnSelectPath;
				if (btnSelectPath != null)
				{
					btnSelectPath.Click += value2;
				}
			}
		}

		// Token: 0x1700001C RID: 28
		// (get) Token: 0x06000064 RID: 100 RVA: 0x00002492 File Offset: 0x00000692
		// (set) Token: 0x06000065 RID: 101 RVA: 0x0000249F File Offset: 0x0000069F
		internal virtual TextBox txtFile_patch { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001D RID: 29
		// (get) Token: 0x06000066 RID: 102 RVA: 0x000024A8 File Offset: 0x000006A8
		// (set) Token: 0x06000067 RID: 103 RVA: 0x000024B5 File Offset: 0x000006B5
		internal virtual TextBox txtFile_rom { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001E RID: 30
		// (get) Token: 0x06000068 RID: 104 RVA: 0x000024BE File Offset: 0x000006BE
		// (set) Token: 0x06000069 RID: 105 RVA: 0x00009000 File Offset: 0x00007200
		internal virtual Button btnRom
		{
			[CompilerGenerated]
			get
			{
				return this._btnRom;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.Button2_Click);
				Button btnRom = this._btnRom;
				if (btnRom != null)
				{
					btnRom.Click -= value2;
				}
				this._btnRom = value;
				btnRom = this._btnRom;
				if (btnRom != null)
				{
					btnRom.Click += value2;
				}
			}
		}

		// Token: 0x1700001F RID: 31
		// (get) Token: 0x0600006A RID: 106 RVA: 0x000024CB File Offset: 0x000006CB
		// (set) Token: 0x0600006B RID: 107 RVA: 0x000024D8 File Offset: 0x000006D8
		internal virtual TextBox txtFile_result { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000020 RID: 32
		// (get) Token: 0x0600006C RID: 108 RVA: 0x000024E1 File Offset: 0x000006E1
		// (set) Token: 0x0600006D RID: 109 RVA: 0x0000904C File Offset: 0x0000724C
		internal virtual Button btnApply
		{
			[CompilerGenerated]
			get
			{
				return this._btnApply;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnApply_Click);
				Button btnApply = this._btnApply;
				if (btnApply != null)
				{
					btnApply.Click -= value2;
				}
				this._btnApply = value;
				btnApply = this._btnApply;
				if (btnApply != null)
				{
					btnApply.Click += value2;
				}
			}
		}

		// Token: 0x17000021 RID: 33
		// (get) Token: 0x0600006E RID: 110 RVA: 0x000024EE File Offset: 0x000006EE
		// (set) Token: 0x0600006F RID: 111 RVA: 0x000024FB File Offset: 0x000006FB
		internal virtual TextBox txtCRC_patch { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000022 RID: 34
		// (get) Token: 0x06000070 RID: 112 RVA: 0x00002504 File Offset: 0x00000704
		// (set) Token: 0x06000071 RID: 113 RVA: 0x00002511 File Offset: 0x00000711
		internal virtual TextBox txtCRC_rom { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000023 RID: 35
		// (get) Token: 0x06000072 RID: 114 RVA: 0x0000251A File Offset: 0x0000071A
		// (set) Token: 0x06000073 RID: 115 RVA: 0x00002527 File Offset: 0x00000727
		internal virtual TextBox txtSize_rom { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000024 RID: 36
		// (get) Token: 0x06000074 RID: 116 RVA: 0x00002530 File Offset: 0x00000730
		// (set) Token: 0x06000075 RID: 117 RVA: 0x0000253D File Offset: 0x0000073D
		internal virtual TextBox txtSize_patch { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000025 RID: 37
		// (get) Token: 0x06000076 RID: 118 RVA: 0x00002546 File Offset: 0x00000746
		// (set) Token: 0x06000077 RID: 119 RVA: 0x00002553 File Offset: 0x00000753
		internal virtual Label lblCRC32 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000026 RID: 38
		// (get) Token: 0x06000078 RID: 120 RVA: 0x0000255C File Offset: 0x0000075C
		// (set) Token: 0x06000079 RID: 121 RVA: 0x00002569 File Offset: 0x00000769
		internal virtual Label lblFileSize { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000027 RID: 39
		// (get) Token: 0x0600007A RID: 122 RVA: 0x00002572 File Offset: 0x00000772
		// (set) Token: 0x0600007B RID: 123 RVA: 0x00009098 File Offset: 0x00007298
		internal virtual CheckedListBox lstOptions
		{
			[CompilerGenerated]
			get
			{
				return this._lstOptions;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				ItemCheckEventHandler value2 = new ItemCheckEventHandler(this.lstOptions_ItemCheck);
				EventHandler value3 = new EventHandler(this.lstOptions_SelectedIndexChanged);
				CheckedListBox lstOptions = this._lstOptions;
				if (lstOptions != null)
				{
					lstOptions.ItemCheck -= value2;
					lstOptions.SelectedIndexChanged -= value3;
				}
				this._lstOptions = value;
				lstOptions = this._lstOptions;
				if (lstOptions != null)
				{
					lstOptions.ItemCheck += value2;
					lstOptions.SelectedIndexChanged += value3;
				}
			}
		}

		// Token: 0x17000028 RID: 40
		// (get) Token: 0x0600007C RID: 124 RVA: 0x0000257F File Offset: 0x0000077F
		// (set) Token: 0x0600007D RID: 125 RVA: 0x0000258C File Offset: 0x0000078C
		internal virtual OpenFileDialog dlgOpenFile { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000029 RID: 41
		// (get) Token: 0x0600007E RID: 126 RVA: 0x00002595 File Offset: 0x00000795
		// (set) Token: 0x0600007F RID: 127 RVA: 0x000090FC File Offset: 0x000072FC
		internal virtual BackgroundWorker bgwPatcher
		{
			[CompilerGenerated]
			get
			{
				return this._bgwPatcher;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				DoWorkEventHandler value2 = new DoWorkEventHandler(this.bgwPatcher_DoWork);
				ProgressChangedEventHandler value3 = new ProgressChangedEventHandler(this.bgwPatcher_ProgressChanged);
				RunWorkerCompletedEventHandler value4 = new RunWorkerCompletedEventHandler(this.bgwPatcher_RunWorkerCompleted);
				BackgroundWorker bgwPatcher = this._bgwPatcher;
				if (bgwPatcher != null)
				{
					bgwPatcher.DoWork -= value2;
					bgwPatcher.ProgressChanged -= value3;
					bgwPatcher.RunWorkerCompleted -= value4;
				}
				this._bgwPatcher = value;
				bgwPatcher = this._bgwPatcher;
				if (bgwPatcher != null)
				{
					bgwPatcher.DoWork += value2;
					bgwPatcher.ProgressChanged += value3;
					bgwPatcher.RunWorkerCompleted += value4;
				}
			}
		}

		// Token: 0x1700002A RID: 42
		// (get) Token: 0x06000080 RID: 128 RVA: 0x000025A2 File Offset: 0x000007A2
		// (set) Token: 0x06000081 RID: 129 RVA: 0x000025AF File Offset: 0x000007AF
		internal virtual ProgressBar barProgress { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700002B RID: 43
		// (get) Token: 0x06000082 RID: 130 RVA: 0x000025B8 File Offset: 0x000007B8
		// (set) Token: 0x06000083 RID: 131 RVA: 0x000025C5 File Offset: 0x000007C5
		internal virtual Label lblPatchVersion { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700002C RID: 44
		// (get) Token: 0x06000084 RID: 132 RVA: 0x000025CE File Offset: 0x000007CE
		// (set) Token: 0x06000085 RID: 133 RVA: 0x000025DB File Offset: 0x000007DB
		internal virtual TextBox txtPatchVersion { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700002D RID: 45
		// (get) Token: 0x06000086 RID: 134 RVA: 0x000025E4 File Offset: 0x000007E4
		// (set) Token: 0x06000087 RID: 135 RVA: 0x000025F1 File Offset: 0x000007F1
		internal virtual TextBox txtDescripton { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700002E RID: 46
		// (get) Token: 0x06000088 RID: 136 RVA: 0x000025FA File Offset: 0x000007FA
		// (set) Token: 0x06000089 RID: 137 RVA: 0x0000917C File Offset: 0x0000737C
		internal virtual Button btnDef
		{
			[CompilerGenerated]
			get
			{
				return this._btnDef;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnDef_Click);
				Button btnDef = this._btnDef;
				if (btnDef != null)
				{
					btnDef.Click -= value2;
				}
				this._btnDef = value;
				btnDef = this._btnDef;
				if (btnDef != null)
				{
					btnDef.Click += value2;
				}
			}
		}

		// Token: 0x1700002F RID: 47
		// (get) Token: 0x0600008A RID: 138 RVA: 0x00002607 File Offset: 0x00000807
		// (set) Token: 0x0600008B RID: 139 RVA: 0x000091C8 File Offset: 0x000073C8
		internal virtual Button btnEditChain
		{
			[CompilerGenerated]
			get
			{
				return this._btnEditChain;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnEditChain_Click);
				Button btnEditChain = this._btnEditChain;
				if (btnEditChain != null)
				{
					btnEditChain.Click -= value2;
				}
				this._btnEditChain = value;
				btnEditChain = this._btnEditChain;
				if (btnEditChain != null)
				{
					btnEditChain.Click += value2;
				}
			}
		}

		// Token: 0x17000030 RID: 48
		// (get) Token: 0x0600008C RID: 140 RVA: 0x00002614 File Offset: 0x00000814
		// (set) Token: 0x0600008D RID: 141 RVA: 0x00002621 File Offset: 0x00000821
		internal virtual Label lblOutputFile { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000031 RID: 49
		// (get) Token: 0x0600008E RID: 142 RVA: 0x0000262A File Offset: 0x0000082A
		// (set) Token: 0x0600008F RID: 143 RVA: 0x00002637 File Offset: 0x00000837
		internal virtual SplitContainer pnlSplit { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x06000090 RID: 144 RVA: 0x00009214 File Offset: 0x00007414
		public void SelectPath(string fileName)
		{
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			if (fileSystem.FileExists(fileName) && Operators.CompareString(fileSystem.GetFileInfo(fileName).Extension, ".zps", false) == 0)
			{
				this.zpsPatch = new AsmPatch(fileName);
				this.txtPatchVersion.ReadOnly = false;
				this.txtPatchVersion.Text = "V" + this.zpsPatch.sVersion;
				this.txtPatchVersion.ReadOnly = true;
				if (Strings.StrComp(this.zpsPatch.sVersion, "0.18", CompareMethod.Binary) != 0)
				{
					this.lblPatchVersion.BackColor = Color.Red;
				}
				else
				{
					this.lblPatchVersion.BackColor = Color.PaleGreen;
				}
				this.txtFile_patch.ReadOnly = false;
				this.txtFile_patch.Text = fileSystem.GetFileInfo(fileName).Name;
				this.txtFile_patch.ReadOnly = true;
				this.txtCRC_patch.ReadOnly = false;
				this.txtCRC_patch.Text = this.zpsPatch.sChecksum;
				this.txtCRC_patch.ReadOnly = true;
				this.txtSize_patch.ReadOnly = false;
				this.txtSize_patch.Text = this.zpsPatch.sRomSize;
				this.txtSize_patch.ReadOnly = true;
				this.lstOptions.Items.Clear();
				foreach (string text in this.zpsPatch.dicOptions.Keys)
				{
					if (this.zpsPatch.dicOptions[text].bAvailable)
					{
						CheckState check = CheckState.Unchecked;
						if (this.zpsPatch.dicOptions[text].bActive)
						{
							check = CheckState.Checked;
						}
						if (this.zpsPatch.dicOptions[text].iDevProgress == 0)
						{
							check = CheckState.Indeterminate;
						}
						this.lstOptions.Items.Add(text, check);
					}
				}
				this.btnRom.Enabled = true;
				this.btnDef.Enabled = true;
				if (!string.IsNullOrEmpty(this.path_source))
				{
					this.btnApply.Enabled = true;
					this.btnEditChain.Enabled = true;
				}
				if (!string.IsNullOrEmpty(this.txtFile_rom.Text))
				{
					this.SetOutputROMName();
				}
			}
			this.updateMatch();
		}

		// Token: 0x06000091 RID: 145 RVA: 0x00009474 File Offset: 0x00007674
		public void AddRomData(string fileName)
		{
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			if (fileSystem.FileExists(fileName))
			{
				this.txtFile_rom.ReadOnly = false;
				this.txtFile_rom.Text = fileSystem.GetFileInfo(fileName).Name;
				this.txtFile_rom.ReadOnly = true;
				this.txtCRC_rom.ReadOnly = false;
				this.txtCRC_rom.Text = modString.hx(Crc32.getFileChecksum(fileName), 8);
				this.txtCRC_rom.ReadOnly = true;
				this.txtSize_rom.ReadOnly = false;
				this.txtSize_rom.Text = modString.hx(Convert.ToUInt32(fileSystem.GetFileInfo(fileName).Length), 2);
				this.txtSize_rom.ReadOnly = true;
				this.path_source = fileName;
				if (this.zpsPatch == null || string.IsNullOrEmpty(this.zpsPatch.sPathPatch))
				{
					this.btnSelectPath.Enabled = true;
				}
				else if (!string.IsNullOrEmpty(this.zpsPatch.sPathPatch))
				{
					this.btnApply.Enabled = true;
					this.btnEditChain.Enabled = true;
				}
			}
			this.updateMatch();
		}

		// Token: 0x06000092 RID: 146 RVA: 0x00002640 File Offset: 0x00000840
		protected override void OnShown(EventArgs e)
		{
			base.OnShown(e);
			if (MyApplicationRoot.apply)
			{
				this.btnApply_Click(null, null);
			}
		}

		// Token: 0x06000093 RID: 147 RVA: 0x00009590 File Offset: 0x00007790
		private void SetOutputROMName()
		{
			string extension = Path.GetExtension(this.txtFile_rom.Text);
			this.txtFile_result.Text = Path.GetFileNameWithoutExtension(this.txtFile_patch.Text) + extension;
		}

		// Token: 0x04000028 RID: 40
		public AsmPatch zpsPatch;

		// Token: 0x04000029 RID: 41
		public string path_source;

		// Token: 0x0400002A RID: 42
		public string path_destination;

		// Token: 0x0400002B RID: 43
		private const string sVersion = "0.18";

		// Token: 0x04000044 RID: 68
		public static frmSnesPatcher instance;
	}
}
