﻿using System;
using System.CodeDom.Compiler;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Runtime.CompilerServices;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using libSnesAssembler;
using libZh;
using Microsoft.VisualBasic;

namespace SnesPatcher.My
{
	// Token: 0x020001B4 RID: 436
	[GeneratedCode("MyTemplate", "11.0.0.0")]
	[EditorBrowsable(EditorBrowsableState.Never)]
	public class MyApplicationRoot
	{
		// Token: 0x06000945 RID: 2373 RVA: 0x000357E0 File Offset: 0x000339E0
		[STAThread]
		[DebuggerHidden]
		[EditorBrowsable(EditorBrowsableState.Advanced)]
		[MethodImpl(MethodImplOptions.NoInlining | MethodImplOptions.NoOptimization)]
		internal static void Main(string[] Args)
		{
			MyApplicationRoot.isRunningOnMono = (Type.GetType("Mono.Runtime") != null);
			Directory.SetCurrentDirectory(AppContext.BaseDirectory);
			if (Args == null || Args.Length == 0)
			{
				if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
				{
					MyApplicationRoot.FreeConsole();
				}
				MyApplication.Main(Args);
				return;
			}
			MyApplicationRoot.ProcessArgs(Args);
		}

		// Token: 0x06000946 RID: 2374 RVA: 0x00035834 File Offset: 0x00033A34
		private static void ProcessArgs(string[] Args)
		{
			int[] array = (int[])Enum.GetValues(typeof(CheckState));
			bool flag = false;
			for (int i = 0; i < Args.Length; i++)
			{
				if (Args[i].Length <= 6 && Args[i].Length >= 2)
				{
					if (Args[i][1] == Args[i][0])
					{
						if (Args[i][0] == '/' || Args[i][0] == '-')
						{
							if (Args[i].Length == 3)
							{
								if (Args[i][2] == 'h' || Args[i][2] == '?')
								{
									flag = true;
								}
							}
							else if (Args[i].Length == 6 && Args[i][2] == 'h' && Args[i][3] == 'e' && Args[i][4] == 'l' && Args[i][5] == 'p')
							{
								flag = true;
							}
						}
					}
					else if (Args[i][0] == '/' || Args[i][0] == '-')
					{
						if (Args[i].Length == 2)
						{
							if (Args[i][1] == 'h' || Args[i][1] == '?')
							{
								flag = true;
							}
						}
						else if (Args[i].Length == 5 && Args[i][1] == 'h' && Args[i][2] == 'e' && Args[i][3] == 'l' && Args[i][4] == 'p')
						{
							flag = true;
						}
					}
				}
				if (flag)
				{
					Console.Write("Applies ZPS patches to SNES ROM files\n\nZPS_Patcher.exe [options] \"ZPS Patch.zps\" \"Input ROM.smc\" \"Output ROM.smc\"\nPut quotation marks (\"\") around file names that contain spaces\nThe ZPS patch and any IPS patches will be applied in the order provided\n\noptions:\n//help    = show this help message\n//nogui   = execute the patcher without a window\n//apply   = apply patch immediately after the window shows\n//header  = next IPS file will apply header compensation\n//verbose = show console output\n//debug   = enable output of debug log file\n//nosave  = disable saving config file\n//noload  = disable loading config file\n//xFF...  = checkbox bitstream to specify options\n//yFF...  = hexadecimal string to specify advanced options\n");
					return;
				}
				if (Args[i].Length > 2 && Args[i][0] == '/' && Args[i][1] == '/')
				{
					string a = Args[i].Substring(2).ToLower();
					if (a == "nogui")
					{
						MyApplicationRoot.nogui = true;
					}
					else if (a == "apply")
					{
						MyApplicationRoot.apply = true;
					}
					else if (a == "debug")
					{
						MyApplicationRoot.debug = true;
					}
					else if (a == "nosave")
					{
						MyApplicationRoot.nosave = true;
					}
					else if (a == "noload")
					{
						MyApplicationRoot.noload = true;
					}
					else if (a == "verbose")
					{
						MyApplicationRoot.verbose = true;
					}
					else if (a == "header")
					{
						MyApplicationRoot.headerFlag = i;
					}
					else if (Args[i].Length >= 4 && Args[i][2] == 'x')
					{
						MyApplicationRoot.boolString = Args[i].Substring(3).ToUpper() + (((Args[i].Length & 1) == 0) ? "0" : "");
						for (int j = 0; j < MyApplicationRoot.boolString.Length; j++)
						{
							if (MyApplicationRoot.boolString[j] < '0' || MyApplicationRoot.boolString[j] > 'F' || (MyApplicationRoot.boolString[j] > '9' && MyApplicationRoot.boolString[j] < 'A'))
							{
								Console.WriteLine(string.Format("Invalid Command Line Argument //x...{0}...: invalid hex value", MyApplicationRoot.boolString[j]));
								return;
							}
						}
					}
					else
					{
						if (Args[i].Length < 4 || Args[i][2] != 'y')
						{
							Console.WriteLine(string.Format("Invalid Command Line Argument \"{0}\": unknown argument", Args[i]));
							return;
						}
						MyApplicationRoot.nibbleString = Args[i].Substring(3).ToUpper();
						for (int k = 0; k < MyApplicationRoot.nibbleString.Length; k++)
						{
							if (MyApplicationRoot.nibbleString[k] < '0' || MyApplicationRoot.nibbleString[k] > 'F' || (MyApplicationRoot.nibbleString[k] > '9' && MyApplicationRoot.nibbleString[k] < 'A'))
							{
								Console.WriteLine(string.Format("Invalid Command Line Argument //y...{0}...: invalid hex value", MyApplicationRoot.nibbleString[k]));
								return;
							}
						}
					}
				}
				else if (Args[i].Length > 4 && Args[i].Substring(Args[i].Length - 4).ToLower() == ".ips")
				{
					if (!File.Exists(Args[i]))
					{
						Console.WriteLine(string.Format("Invalid Command Line Argument \"{0}\": the IPS file was not found", Args[i]));
						return;
					}
					if (modPatchChain.patchChain == null)
					{
						Collection collection = new Collection();
						collection.Add(new ListItem_Patch(true), "zps", null, null);
						modPatchChain.setPatchChain(new PatchChain(collection, "", ""));
					}
					Args[i] = Path.GetFullPath(Args[i]);
					ListItem_Patch listItem_Patch = new ListItem_Patch(Args[i]);
					listItem_Patch.bNeedHeader = (i == MyApplicationRoot.headerFlag + 1);
					if (string.IsNullOrEmpty(MyApplicationRoot.loadedZPS))
					{
						modPatchChain.patchChain.colPatches.Add(listItem_Patch, null, "zps", null);
					}
					else
					{
						modPatchChain.patchChain.colPatches.Add(listItem_Patch, null, null, null);
					}
					MyApplicationRoot.noChain = true;
				}
				else if (Args[i].Length > 4 && Args[i].Substring(Args[i].Length - 4).ToLower() == ".zps")
				{
					if (!string.IsNullOrEmpty(MyApplicationRoot.loadedZPS))
					{
						Console.WriteLine(string.Format("Invalid Command Line Argument \"{0}\": only 1 ZPS file allowed", Args[i]));
						return;
					}
					if (!File.Exists(Args[i]))
					{
						Console.WriteLine(string.Format("Invalid Command Line Argument \"{0}\": the ZPS file was not found", Args[i]));
						return;
					}
					Args[i] = Path.GetFullPath(Args[i]);
					MyApplicationRoot.loadedZPS = Args[i];
					MyApplicationRoot.outputLog = MyApplicationRoot.loadedZPS.Substring(0, MyApplicationRoot.loadedZPS.LastIndexOf(".")) + ".log";
				}
				else if (string.IsNullOrEmpty(MyApplicationRoot.loadedROM))
				{
					if (!File.Exists(Args[i]))
					{
						Console.WriteLine(string.Format("Invalid Command Line Argument \"{0}\": the input ROM file was not found", Args[i]));
						return;
					}
					Args[i] = Path.GetFullPath(Args[i]);
					MyApplicationRoot.loadedROM = Args[i];
				}
				else
				{
					if (!string.IsNullOrEmpty(MyApplicationRoot.outputROM))
					{
						Console.WriteLine(string.Format("Invalid Command Line Argument \"{0}\": only 2 ROM files allowed (input/output)", Args[i]));
						return;
					}
					Args[i] = Path.GetFullPath(Args[i]);
					MyApplicationRoot.outputROM = Args[i];
					if (i == MyApplicationRoot.headerFlag + 1)
					{
						Console.WriteLine(string.Format("Invalid Command Line Argument \"{0}\": IPS file MUST follow //header", Args[i]));
						return;
					}
				}
			}
			if (MyApplicationRoot.nogui)
			{
				bool flag2 = true;
				if (string.IsNullOrEmpty(MyApplicationRoot.loadedZPS))
				{
					flag2 = false;
					Console.WriteLine("A ZPS file was not provided in the command line.");
				}
				if (string.IsNullOrEmpty(MyApplicationRoot.loadedROM))
				{
					flag2 = false;
					Console.WriteLine("An input ROM file was not provided in the command line.");
				}
				if (string.IsNullOrEmpty(MyApplicationRoot.outputROM) && !string.IsNullOrEmpty(MyApplicationRoot.loadedZPS))
				{
					string text = Path.GetExtension(MyApplicationRoot.loadedROM);
					if (text != null && text == string.Empty)
					{
						text = ".smc";
					}
					MyApplicationRoot.outputROM = MyApplicationRoot.loadedZPS.Substring(0, MyApplicationRoot.loadedZPS.LastIndexOf(".")) + text;
				}
				if (flag2)
				{
					if (modPatchChain.patchChain == null)
					{
						Collection collection2 = new Collection();
						collection2.Add(new ListItem_Patch(true), null, null, null);
						modPatchChain.setPatchChain(new PatchChain(collection2, MyApplicationRoot.loadedROM, MyApplicationRoot.outputROM));
					}
					else
					{
						modPatchChain.patchChain.sPath_SourceRom = MyApplicationRoot.loadedROM;
						modPatchChain.patchChain.sPath_OutputRom = MyApplicationRoot.outputROM;
					}
					MyApplicationRoot.noguiPatch = new AsmPatch(MyApplicationRoot.loadedZPS);
					MyApplicationRoot.execList = new List<string>();
					Directory.SetCurrentDirectory(Path.GetDirectoryName(MyApplicationRoot.loadedZPS));
					modPatchChain.applyPatchChain(null);
					for (int l = 0; l < MyApplicationRoot.execList.Count; l++)
					{
						modExecute.ShellAndWait(MyApplicationRoot.execList[l]);
					}
					Directory.SetCurrentDirectory(AppContext.BaseDirectory);
				}
				return;
			}
			if (!MyApplicationRoot.verbose && RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
			{
				MyApplicationRoot.FreeConsole();
			}
			if (string.IsNullOrEmpty(MyApplicationRoot.loadedZPS) || string.IsNullOrEmpty(MyApplicationRoot.loadedROM))
			{
				MyApplicationRoot.apply = false;
			}
			MyApplication.Main(Args);
		}

		// Token: 0x06000947 RID: 2375
		[DllImport("kernel32.dll", ExactSpelling = true, SetLastError = true)]
		private static extern bool FreeConsole();

		// Token: 0x0600094A RID: 2378 RVA: 0x00035FFC File Offset: 0x000341FC
		public static void SaveSetting(string sectionName, string keyName, string keyValue, List<string> configData)
		{
			bool flag = false;
			for (int i = 0; i < configData.Count; i++)
			{
				string text = configData[i].Trim();
				if (text.Length > 1 && !text.StartsWith(";"))
				{
					if (!flag)
					{
						if (text.StartsWith("["))
						{
							int num = text.IndexOf(']');
							if (num == -1)
							{
								num = text.Length;
							}
							if (text.Substring(1, num - 1) == sectionName)
							{
								flag = true;
							}
						}
					}
					else
					{
						if (text.StartsWith("["))
						{
							configData.Insert(i, keyName + "=" + keyValue);
							return;
						}
						int num2 = text.IndexOf('=');
						if (num2 != -1 && text.Substring(0, num2).Trim() == keyName)
						{
							configData[i] = configData[i].Substring(0, configData[i].IndexOf('=')) + "=" + keyValue;
							return;
						}
					}
				}
			}
			if (!flag)
			{
				configData.Add("[" + sectionName + "]");
			}
			configData.Add(keyName + "=" + keyValue);
		}

		// Token: 0x0600094B RID: 2379 RVA: 0x00036128 File Offset: 0x00034328
		public static List<string> ReadConfigFile(string path)
		{
			List<string> list = new List<string>();
			if (File.Exists(path))
			{
				using (StreamReader streamReader = new StreamReader(path, Encoding.UTF8))
				{
					string item;
					while ((item = streamReader.ReadLine()) != null)
					{
						list.Add(item);
					}
				}
			}
			return list;
		}

		// Token: 0x0600094C RID: 2380 RVA: 0x00036180 File Offset: 0x00034380
		public static void WriteConfigFile(string path, List<string> data)
		{
			try
			{
				File.WriteAllLines(path, data);
			}
			catch (Exception ex)
			{
				Console.WriteLine("Unable to write to config file: " + ex.GetType());
			}
		}

		// Token: 0x0600094D RID: 2381 RVA: 0x000361C0 File Offset: 0x000343C0
		public static string LoadSetting(string sectionName, string keyName, string defaultValue, List<string> configData)
		{
			bool flag = false;
			for (int i = 0; i < configData.Count; i++)
			{
				string text = configData[i].Trim();
				if (text.Length > 2 && !text.StartsWith(";"))
				{
					if (!flag)
					{
						if (text.StartsWith("["))
						{
							int num = text.IndexOf(']');
							if (num == -1)
							{
								num = text.Length;
							}
							if (text.Substring(1, num - 1) == sectionName)
							{
								flag = true;
							}
						}
					}
					else
					{
						if (text.StartsWith("["))
						{
							return defaultValue;
						}
						int num2 = text.IndexOf('=');
						if (num2 != -1 && text.Substring(0, num2).Trim() == keyName)
						{
							configData.RemoveAt(i);
							return text.Substring(num2 + 1).Trim();
						}
					}
				}
			}
			return defaultValue;
		}

		// Token: 0x0600094E RID: 2382 RVA: 0x000062C4 File Offset: 0x000044C4
		public static MsgBoxResult MsgBox(string Prompt, MsgBoxStyle Buttons = MsgBoxStyle.OkOnly, string Title = null)
		{
			return MyApplicationRoot.MsgBox(Prompt, Buttons, Title, 0);
		}

		// Token: 0x0600094F RID: 2383 RVA: 0x00036298 File Offset: 0x00034498
		public static MsgBoxResult MsgBox(string Prompt, MsgBoxStyle Buttons = MsgBoxStyle.OkOnly, string Title = null, int timer = 0)
		{
			modCommonDebug._debugWrite(Prompt);
			if (MyApplicationRoot.nogui)
			{
				Console.WriteLine(Prompt);
				return MsgBoxResult.Ok;
			}
			if (MyApplicationRoot.verbose)
			{
				Console.WriteLine(Prompt);
			}
			if (frmSnesPatcher.instance != null && frmSnesPatcher.instance.InvokeRequired)
			{
				return (MsgBoxResult)frmSnesPatcher.instance.Invoke(new MyApplicationRoot.MsgBoxSafeDelegate(MyApplicationRoot.MsgBoxSafe), new object[]
				{
					Prompt,
					Buttons,
					Title,
					timer
				});
			}
			return MyApplicationRoot.MsgBoxSafe(Prompt, Buttons, Title, timer);
		}

		// Token: 0x06000950 RID: 2384 RVA: 0x00036320 File Offset: 0x00034520
		private static MsgBoxResult MsgBoxSafe(string Prompt, MsgBoxStyle Buttons, string Title, int timer)
		{
			if (Title == null)
			{
				Title = "Error";
			}
			if (timer > 0)
			{
				Form form = new Form
				{
					Size = new Size(0, 0)
				};
				Task.Delay(timer).ContinueWith(delegate(Task t)
				{
					for (int i = 0; i < form.OwnedForms.Length; i++)
					{
						form.OwnedForms[i].Close();
					}
					form.Close();
				}, TaskScheduler.FromCurrentSynchronizationContext());
				MessageBox.Show(form, Prompt, Title, (MessageBoxButtons)Buttons);
			}
			else
			{
				MessageBox.Show(frmSnesPatcher.instance, Prompt, Title, (MessageBoxButtons)Buttons);
			}
			return MsgBoxResult.Ok;
		}

		// Token: 0x06000951 RID: 2385 RVA: 0x00036398 File Offset: 0x00034598
		public static int FastIndexOf(string source, string pattern, int startIndex, int count)
		{
			if (pattern == null)
			{
				throw new ArgumentNullException();
			}
			if (pattern.Length == 0)
			{
				return 0;
			}
			if (pattern.Length == 1)
			{
				return source.IndexOf(pattern[0], startIndex, count);
			}
			int num = count - pattern.Length + 1;
			if (num < 1)
			{
				return -1;
			}
			char value = pattern[0];
			char c = pattern[1];
			int i = source.IndexOf(value, startIndex, num);
			num += startIndex;
			while (i >= 0)
			{
				if (source[i + 1] != c)
				{
					i = source.IndexOf(value, ++i, num - i);
				}
				else
				{
					bool flag = true;
					for (int j = 2; j < pattern.Length; j++)
					{
						if (source[i + j] != pattern[j])
						{
							flag = false;
							break;
						}
					}
					if (flag)
					{
						return i;
					}
					i = source.IndexOf(value, ++i, num - i);
				}
			}
			return -1;
		}

		// Token: 0x04000F3A RID: 3898
		public static string loadedZPS;

		// Token: 0x04000F3B RID: 3899
		public static string loadedROM;

		// Token: 0x04000F3C RID: 3900
		public static string outputROM;

		// Token: 0x04000F3D RID: 3901
		public static bool apply;

		// Token: 0x04000F3E RID: 3902
		public static AsmPatch noguiPatch;

		// Token: 0x04000F3F RID: 3903
		public static bool nogui;

		// Token: 0x04000F40 RID: 3904
		public static bool debug;

		// Token: 0x04000F41 RID: 3905
		public static bool nosave;

		// Token: 0x04000F42 RID: 3906
		public static bool noload;

		// Token: 0x04000F43 RID: 3907
		public static string outputLog;

		// Token: 0x04000F44 RID: 3908
		public static string boolString;

		// Token: 0x04000F45 RID: 3909
		public static bool verbose;

		// Token: 0x04000F46 RID: 3910
		public static string nibbleString;

		// Token: 0x04000F47 RID: 3911
		private static int headerFlag = -2;

		// Token: 0x04000F48 RID: 3912
		public static bool noChain = false;

		// Token: 0x04000F49 RID: 3913
		public static List<string> execList;

		// Token: 0x04000F4A RID: 3914
		public static bool isRunningOnMono;

		// Token: 0x020001B5 RID: 437
		// (Invoke) Token: 0x06000953 RID: 2387
		private delegate MsgBoxResult MsgBoxSafeDelegate(string Prompt, MsgBoxStyle Buttons, string Title, int timer);
	}
}
