﻿using System;
using System.IO;
using System.Windows.Forms;
using libZh;
using Microsoft.VisualBasic.MyServices;
using SnesPatcher.My;

namespace SnesPatcher
{
	// Token: 0x02000011 RID: 17
	public class ListItem_Patch
	{
		// Token: 0x17000032 RID: 50
		// (get) Token: 0x0600009D RID: 157 RVA: 0x00009B5C File Offset: 0x00007D5C
		public string Name
		{
			get
			{
				bool flag = this.bZPS;
				string result;
				if (flag)
				{
					result = "[******* ZPS *******]";
				}
				else
				{
					bool flag2 = this.bNeedHeader;
					string str;
					if (flag2)
					{
						str = "(H)";
					}
					else
					{
						str = "(h)";
					}
					result = str + " " + modFilePaths.getFileName(this.sPath_patchFile);
				}
				return result;
			}
		}

		// Token: 0x0600009E RID: 158 RVA: 0x00002678 File Offset: 0x00000878
		public ListItem_Patch(bool _bZPS)
		{
			this.bZPS = false;
			this.bNeedHeader = false;
			this.bZPS = _bZPS;
		}

		// Token: 0x0600009F RID: 159 RVA: 0x00002697 File Offset: 0x00000897
		public ListItem_Patch(string _sPath)
		{
			this.bZPS = false;
			this.bNeedHeader = false;
			this.sPath_patchFile = _sPath;
		}

		// Token: 0x060000A0 RID: 160 RVA: 0x00009BC4 File Offset: 0x00007DC4
		public void applyPatch(string _sPath_Source, string _sPath_Dest)
		{
			bool flag = this.bZPS;
			if (flag)
			{
				this.applyPatch_ZPS(_sPath_Source, _sPath_Dest);
			}
			else
			{
				this.applyPatch_IPS(_sPath_Source, _sPath_Dest);
			}
		}

		// Token: 0x060000A1 RID: 161 RVA: 0x00009BF4 File Offset: 0x00007DF4
		private void applyPatch_IPS(string _sPath_Source, string _sPath_Dest)
		{
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			IPS ips = new IPS(this.sPath_patchFile);
			byte[] rom = fileSystem.ReadAllBytes(_sPath_Source);
			Console.WriteLine("Applying IPS: " + Path.GetFileNameWithoutExtension(this.sPath_patchFile));
			byte[] data = ips.applyPatch(rom, this.bNeedHeader);
			fileSystem.WriteAllBytes(_sPath_Dest, data, false);
		}

		// Token: 0x060000A2 RID: 162 RVA: 0x000026B6 File Offset: 0x000008B6
		private void applyPatch_ZPS(string _sPath_Source, string _sPath_Dest)
		{
			if (MyApplicationRoot.nogui)
			{
				modZps_Async.applyZpsPatch_async_nogui(MyApplicationRoot.noguiPatch, _sPath_Source, _sPath_Dest);
				return;
			}
			modZps_Async.applyZpsPatch_async(MyProject.Forms.frmSnesPatcher.zpsPatch, _sPath_Source, _sPath_Dest);
			while (!modZps_Async.bFinished)
			{
				Application.DoEvents();
			}
		}

		// Token: 0x04000050 RID: 80
		public string sPath_patchFile;

		// Token: 0x04000051 RID: 81
		public bool bZPS;

		// Token: 0x04000052 RID: 82
		public bool bNeedHeader;
	}
}
