﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;
using Microsoft.VisualBasic.CompilerServices;

namespace libZh
{
	// Token: 0x020000B0 RID: 176
	[StandardModule]
	public sealed class modWindows
	{
		// Token: 0x0600063E RID: 1598
		[DllImport("user32.dll")]
		public static extern bool MoveWindow(IntPtr hWnd, int x, int y, int nWidth, int nHeight, bool bRepaint);

		// Token: 0x0600063F RID: 1599
		[DllImport("user32.dll")]
		public static extern bool IsChild(IntPtr hWndParent, IntPtr hWnd);

		// Token: 0x06000640 RID: 1600
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern bool ShowWindow(IntPtr hwnd, modWindows.ShowWindowCommands nCmdShow);

		// Token: 0x06000641 RID: 1601
		[DllImport("user32.dll")]
		public static extern bool GetWindowPlacement(IntPtr hWnd, ref modWindowPlacement.WINDOWPLACEMENT lpwndpl);

		// Token: 0x06000642 RID: 1602
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

		// Token: 0x06000643 RID: 1603
		[DllImport("user32.dll", CharSet = CharSet.Auto, EntryPoint = "FindWindow", SetLastError = true)]
		public static extern IntPtr FindWindowByClass(string lpClassName, IntPtr zero);

		// Token: 0x06000644 RID: 1604
		[DllImport("user32.dll", CharSet = CharSet.Auto, EntryPoint = "FindWindow", SetLastError = true)]
		public static extern IntPtr FindWindowByCaption(IntPtr zero, string lpWindowName);

		// Token: 0x06000645 RID: 1605
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern IntPtr FindWindowEx(IntPtr parentHandle, IntPtr childAfter, string lclassName, string windowTitle);

		// Token: 0x06000646 RID: 1606 RVA: 0x00022D48 File Offset: 0x00020F48
		public static IntPtr FindWindowExByIndex(IntPtr hWndParent, string sClass, int index)
		{
			bool flag = index == 0;
			checked
			{
				IntPtr result;
				if (flag)
				{
					result = hWndParent;
				}
				else
				{
					int num = 0;
					IntPtr intPtr = IntPtr.Zero;
					do
					{
						intPtr = modWindows.FindWindowEx(hWndParent, intPtr, sClass, null);
						bool flag2 = intPtr != IntPtr.Zero;
						if (flag2)
						{
							num++;
						}
					}
					while (num < index && intPtr != IntPtr.Zero);
					result = intPtr;
				}
				return result;
			}
		}

		// Token: 0x06000647 RID: 1607
		[DllImport("user32.dll", SetLastError = true)]
		public static extern IntPtr SetActiveWindow(IntPtr hWnd);

		// Token: 0x06000648 RID: 1608
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, IntPtr wParam, IntPtr lParam);

		// Token: 0x06000649 RID: 1609
		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, IntPtr wParam, ref StringBuilder lParam);

		// Token: 0x0600064A RID: 1610
		[DllImport("user32", CharSet = CharSet.Ansi, ExactSpelling = true, SetLastError = true)]
		public static extern bool BlockInput(bool fBlockIt);

		// Token: 0x0600064B RID: 1611
		[DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
		public static extern bool SetForegroundWindow(IntPtr hWnd);

		// Token: 0x0600064C RID: 1612
		[DllImport("user32", CharSet = CharSet.Ansi, EntryPoint = "GetWindowTextA", ExactSpelling = true, SetLastError = true)]
		public static extern int GetWindowText(IntPtr hwnd, StringBuilder lpString, int cch);

		// Token: 0x0600064D RID: 1613
		[DllImport("user32", CharSet = CharSet.Ansi, EntryPoint = "SetWindowTextA", ExactSpelling = true, SetLastError = true)]
		public static extern long SetWindowText(long hwnd, [MarshalAs(UnmanagedType.VBByRefStr)] ref string lpString);

		// Token: 0x0600064E RID: 1614
		[DllImport("user32.dll", CharSet = CharSet.Unicode)]
		public static extern int GetScrollPos(IntPtr hWnd, int nBar);

		// Token: 0x0600064F RID: 1615
		[DllImport("user32.dll", CharSet = CharSet.Unicode)]
		public static extern int SetScrollPos(IntPtr hWnd, int nBar, int nPos, bool bRedraw);

		// Token: 0x06000650 RID: 1616
		[DllImport("user32.dll", CharSet = CharSet.Auto, ExactSpelling = true)]
		public static extern bool IsWindow(IntPtr hWnd);

		// Token: 0x06000651 RID: 1617
		[DllImport("user32.dll")]
		public static extern bool GetWindowRect(HandleRef hWnd, ref modRect.RECT lpRect);

		// Token: 0x06000652 RID: 1618
		[DllImport("user32.dll", CharSet = CharSet.Auto, ExactSpelling = true)]
		public static extern IntPtr GetParent(IntPtr hWnd);

		// Token: 0x06000653 RID: 1619
		[DllImport("user32.dll")]
		public static extern IntPtr GetDesktopWindow();

		// Token: 0x06000654 RID: 1620
		[DllImport("user32.dll", SetLastError = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		public static extern bool IsWindowVisible(IntPtr hWnd);

		// Token: 0x06000655 RID: 1621
		[DllImport("user32.dll")]
		public static extern IntPtr WindowFromPoint(Point p);

		// Token: 0x06000656 RID: 1622
		[DllImport("user32.dll", SetLastError = true)]
		public static extern uint GetWindowThreadProcessId(IntPtr hwnd, ref IntPtr lpdwProcessId);

		// Token: 0x06000657 RID: 1623
		[DllImport("user32.dll")]
		public static extern bool GetGUIThreadInfo(uint idThread, ref modWindows.GUITHREADINFO lpgui);

		// Token: 0x04000973 RID: 2419
		private const int SB_HORZ = 0;

		// Token: 0x04000974 RID: 2420
		private const int SB_VERT = 1;

		// Token: 0x0200017F RID: 383
		public enum ShowWindowCommands
		{
			// Token: 0x04000E50 RID: 3664
			Hide,
			// Token: 0x04000E51 RID: 3665
			Normal,
			// Token: 0x04000E52 RID: 3666
			ShowMinimized,
			// Token: 0x04000E53 RID: 3667
			Maximize,
			// Token: 0x04000E54 RID: 3668
			ShowMaximized = 3,
			// Token: 0x04000E55 RID: 3669
			ShowNoActivate,
			// Token: 0x04000E56 RID: 3670
			Show,
			// Token: 0x04000E57 RID: 3671
			Minimize,
			// Token: 0x04000E58 RID: 3672
			ShowMinNoActive,
			// Token: 0x04000E59 RID: 3673
			ShowNA,
			// Token: 0x04000E5A RID: 3674
			Restore,
			// Token: 0x04000E5B RID: 3675
			ShowDefault,
			// Token: 0x04000E5C RID: 3676
			ForceMinimize
		}

		// Token: 0x02000180 RID: 384
		public struct GUITHREADINFO
		{
			// Token: 0x04000E5D RID: 3677
			public int cbSize;

			// Token: 0x04000E5E RID: 3678
			public int flags;

			// Token: 0x04000E5F RID: 3679
			public IntPtr hwndActive;

			// Token: 0x04000E60 RID: 3680
			public IntPtr hwndFocus;

			// Token: 0x04000E61 RID: 3681
			public IntPtr hwndCapture;

			// Token: 0x04000E62 RID: 3682
			public IntPtr hwndMenuOwner;

			// Token: 0x04000E63 RID: 3683
			public IntPtr hwndMoveSize;

			// Token: 0x04000E64 RID: 3684
			public IntPtr hwndCaret;

			// Token: 0x04000E65 RID: 3685
			public Rectangle rcCaret;
		}
	}
}
