﻿using System;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace libZh
{
	// Token: 0x020000AB RID: 171
	[StandardModule]
	public sealed class modWinUse
	{
		// Token: 0x06000628 RID: 1576 RVA: 0x0002284C File Offset: 0x00020A4C
		public static bool WinActiveWait(string _sTitle, int _iTimeout)
		{
			IntPtr intPtr = modWindows.FindWindow(null, _sTitle);
			bool flag = intPtr == IntPtr.Zero;
			checked
			{
				bool result;
				if (flag)
				{
					result = false;
				}
				else
				{
					StringBuilder stringBuilder = new StringBuilder(100);
					int windowText = modWindows.GetWindowText(intPtr, stringBuilder, stringBuilder.Capacity);
					bool flag2 = windowText == 0;
					if (flag2)
					{
						result = false;
					}
					else
					{
						string title = stringBuilder.ToString();
						int num = 0;
						try
						{
							Interaction.AppActivate(title);
							return true;
						}
						catch (Exception ex)
						{
						}
						for (;;)
						{
							bool flag3 = num >= _iTimeout;
							if (flag3)
							{
								break;
							}
							Thread.Sleep(100);
							num += 100;
							try
							{
								Interaction.AppActivate(title);
								return true;
							}
							catch (Exception ex2)
							{
							}
						}
						result = false;
					}
				}
				return result;
			}
		}

		// Token: 0x06000629 RID: 1577 RVA: 0x0002294C File Offset: 0x00020B4C
		public static FormWindowState getWindowState(IntPtr hwnd)
		{
			modWindowPlacement.WINDOWPLACEMENT windowplacement;
			int length = windowplacement;
			Marshal.SizeOf();
			windowplacement.Length = length;
			bool windowPlacement = modWindows.GetWindowPlacement(hwnd, ref windowplacement);
			FormWindowState result;
			switch (windowplacement.showCmd)
			{
			case 1:
				result = FormWindowState.Normal;
				break;
			case 2:
				result = FormWindowState.Minimized;
				break;
			case 3:
				result = FormWindowState.Maximized;
				break;
			default:
				Interaction.MsgBox("getWindowState() couldn't retreive the window's state", MsgBoxStyle.OkOnly, null);
				result = FormWindowState.Normal;
				break;
			}
			return result;
		}

		// Token: 0x0600062A RID: 1578 RVA: 0x000229CC File Offset: 0x00020BCC
		public static IntPtr getActiveWindow()
		{
			modWindows.GUITHREADINFO guithreadinfo = default(modWindows.GUITHREADINFO);
			int cbSize = guithreadinfo;
			Marshal.SizeOf();
			guithreadinfo.cbSize = cbSize;
			bool guithreadInfo = modWindows.GetGUIThreadInfo(0U, ref guithreadinfo);
			IntPtr result;
			if (guithreadInfo)
			{
				result = guithreadinfo.hwndActive;
			}
			else
			{
				result = IntPtr.Zero;
			}
			return result;
		}
	}
}
