﻿using System;
using System.ComponentModel;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;

namespace libSnesAssembler
{
	// Token: 0x020000B9 RID: 185
	[StandardModule]
	public sealed class modAssemble
	{
		// Token: 0x06000667 RID: 1639 RVA: 0x00022F7C File Offset: 0x0002117C
		public static string assemble_applySplitter(ref bool bError, string argVal, assemblerOpcodes.enum_splitterType splitterType)
		{
			switch (splitterType)
			{
			case assemblerOpcodes.enum_splitterType.splitter_bank:
			{
				bool flag = argVal.Length == 6;
				if (flag)
				{
					return argVal.Substring(0, 2);
				}
				break;
			}
			case assemblerOpcodes.enum_splitterType.splitter_16:
			{
				bool flag2 = argVal.Length == 6;
				if (flag2)
				{
					return argVal.Substring(2, 4);
				}
				bool flag3 = argVal.Length == 4;
				if (flag3)
				{
					return argVal;
				}
				break;
			}
			case assemblerOpcodes.enum_splitterType.splitter_8:
			{
				bool flag4 = argVal.Length == 6;
				if (flag4)
				{
					return argVal.Substring(4, 2);
				}
				bool flag5 = argVal.Length == 4;
				if (flag5)
				{
					return argVal.Substring(2, 2);
				}
				bool flag6 = argVal.Length == 2;
				if (flag6)
				{
					return argVal;
				}
				break;
			}
			}
			bError = true;
			return "";
		}

		// Token: 0x06000668 RID: 1640 RVA: 0x0002307C File Offset: 0x0002127C
		public static string assemble(modAssemblerStructs.asmProject project, string _str, bool _bPre, bool bShowErrors = false)
		{
			bool flag = _str == null || _str.Length == 0;
			string result;
			if (flag)
			{
				result = "";
			}
			else
			{
				modAsmReport.asmProgReport.progressStep();
				assemblerOpcodes.bError = false;
				bool flag2 = false;
				_str = _str.Trim();
				string text = modAssemble.assemble_Command(project, _str, _bPre, ref flag2);
				bool flag3 = flag2;
				if (flag3)
				{
					result = text;
				}
				else
				{
					bool bSkip_UntilEndIf = project.bSkip_UntilEndIf;
					if (bSkip_UntilEndIf)
					{
						flag2 = true;
						result = "";
					}
					else
					{
						string[] array = _str.Split(new char[]
						{
							' '
						});
						bool flag4 = array.Length > 1;
						if (flag4)
						{
							bool flag5 = array.Length > 3;
							if (flag5)
							{
								goto IL_444;
							}
							bool flag6 = array.Length == 3;
							bool flag8;
							assemblerOpcodes.enum_splitterType splitterType;
							if (flag6)
							{
								bool flag7 = array[2].StartsWith(":") && assemblerOpcodes.dicSplitters.ContainsKey(array[2]);
								if (!flag7)
								{
									goto IL_444;
								}
								flag8 = true;
								splitterType = assemblerOpcodes.dicSplitters[array[2]];
							}
							bool flag9 = array[1].StartsWith("$");
							string text2;
							if (flag9)
							{
								text2 = "$";
							}
							else
							{
								bool flag10 = array[1].StartsWith("#");
								if (flag10)
								{
									text2 = "#";
								}
								else
								{
									bool flag11 = array[1].StartsWith("*");
									if (!flag11)
									{
										goto IL_444;
									}
									text2 = "*";
									bool flag12 = flag8;
									if (flag12)
									{
										goto IL_444;
									}
								}
							}
							bool flag13 = array[1].Length > 1;
							if (!flag13)
							{
								goto IL_444;
							}
							string text3 = array[1].Substring(1);
							bool flag14 = Operators.CompareString(text2, "*", false) != 0;
							if (flag14)
							{
								bool flag15 = flag8;
								if (flag15)
								{
									text3 = modAssemble.assemble_applySplitter(ref assemblerOpcodes.bError, text3, splitterType);
									bool bError = assemblerOpcodes.bError;
									if (bError)
									{
										goto IL_444;
									}
								}
								string text4 = array[0] + " " + text2;
								bool flag16 = text3.Length == 2;
								string str;
								if (flag16)
								{
									str = text3;
									text4 += "1";
								}
								else
								{
									bool flag17 = text3.Length == 4;
									if (flag17)
									{
										str = text3.Substring(2, 2) + text3.Substring(0, 2);
										text4 += "2";
									}
									else
									{
										bool flag18 = text3.Length == 6;
										if (!flag18)
										{
											goto IL_444;
										}
										str = text3.Substring(4, 2) + text3.Substring(2, 2) + text3.Substring(0, 2);
										text4 += "3";
									}
								}
								bool flag19 = assemblerOpcodes.dicAsmCmd.ContainsKey(text4);
								if (flag19)
								{
									return assemblerOpcodes.dicAsmCmd[text4] + str;
								}
								goto IL_444;
							}
							else
							{
								bool flag20 = _str.Length > 4;
								if (flag20)
								{
									text = modProcOpcodes.asm_Branch(_str, _bPre, ref flag2);
									bool flag21 = flag2;
									if (flag21)
									{
										return text;
									}
									assemblerOpcodes.bError = false;
								}
							}
						}
						else
						{
							bool flag22 = array.Length > 0;
							if (flag22)
							{
								bool flag23 = assemblerOpcodes.dicAsmCmd.ContainsKey(array[0]);
								if (flag23)
								{
									modAssemble.asmDbg_Cmd = array[0];
									return assemblerOpcodes.dicAsmCmd[array[0]];
								}
							}
						}
						bool flag24 = _str.Length > 0;
						if (!flag24)
						{
							return "";
						}
						text = _str.Trim();
						text = text.Substring(0, 1);
						bool flag25 = Operators.CompareString(text, "/", false) == 0 | Operators.CompareString(text, "*", false) == 0 | Operators.CompareString(text, "'", false) == 0;
						if (flag25)
						{
							return "";
						}
						IL_444:
						assemblerOpcodes.bError = true;
						modCommonDebug._debugWrite("\r\n\r\nERROR: Unrecognized Command :" + _str + "\r\n\r\n");
						result = "<<_Unrecognized_Command_>>";
					}
				}
			}
			return result;
		}

		// Token: 0x06000669 RID: 1641 RVA: 0x000234FC File Offset: 0x000216FC
		public static string assembleBackup(modAssemblerStructs.asmProject project, string _str, bool _bPre, bool bShowErrors = false)
		{
			bool flag = _str == null || _str.Length == 0;
			checked
			{
				string result;
				if (flag)
				{
					result = "";
				}
				else
				{
					bool flag2 = _str.StartsWith("l+x");
					if (flag2)
					{
						_str = _str;
					}
					modProjectBuilder.iAsm_Progress++;
					bool flag3 = modAssemble.bgAsmWorker != null;
					if (flag3)
					{
						int num = (int)Math.Round((double)(modProjectBuilder.iAsm_Progress * 100) / (double)(modProjectBuilder.iAsm_ProgressCount * 4));
						bool flag4 = num != modProjectBuilder.iAsm_ProgressPercent & num <= 100;
						if (flag4)
						{
							modProjectBuilder.iAsm_ProgressPercent = num;
							modAssemble.bgAsmWorker.ReportProgress(num);
						}
					}
					assemblerOpcodes.bError = false;
					bool flag5 = false;
					_str = _str.Trim();
					string text = modAssemble.assemble_Command(project, _str, _bPre, ref flag5);
					bool flag6 = flag5;
					if (flag6)
					{
						result = text;
					}
					else
					{
						bool bSkip_UntilEndIf = project.bSkip_UntilEndIf;
						if (bSkip_UntilEndIf)
						{
							flag5 = true;
							result = "";
						}
						else
						{
							bool flag7 = _str.Length > 4;
							if (flag7)
							{
								text = modProcOpcodes.asm_Branch(_str, _bPre, ref flag5);
								bool flag8 = flag5;
								if (flag8)
								{
									return text;
								}
								assemblerOpcodes.bError = false;
							}
							bool flag9 = _str.Length > 5;
							if (flag9)
							{
								text = modAssemble.assembleAbsImm(_str, _bPre, ref flag5);
								bool flag10 = flag5;
								if (flag10)
								{
									return text;
								}
							}
							bool flag11 = _str.Length > 4;
							if (flag11)
							{
								text = modProcOpcodes.asm_Single(_str, _bPre, ref flag5);
								bool flag12 = flag5;
								if (flag12)
								{
									return text;
								}
							}
							bool flag13 = _str.Length > 2;
							if (flag13)
							{
								string key = _str.Substring(0, 3);
								bool flag14 = assemblerOpcodes.dicAsmCmd.ContainsKey(key);
								if (flag14)
								{
									modAssemble.asmDbg_Cmd = key;
									return assemblerOpcodes.dicAsmCmd[key];
								}
							}
							bool flag15 = _str.Length > 0;
							if (flag15)
							{
								text = _str.Trim();
								text = text.Substring(0, 1);
								bool flag16 = Operators.CompareString(text, "/", false) == 0 | Operators.CompareString(text, "*", false) == 0 | Operators.CompareString(text, "'", false) == 0;
								if (flag16)
								{
									result = "";
								}
								else
								{
									assemblerOpcodes.bError = true;
									modCommonDebug._debugWrite("\r\n\r\nERROR: Unrecognized Command :" + _str + "\r\n\r\n");
									result = "<<_Unrecognized_Command_>>";
								}
							}
							else
							{
								result = "";
							}
						}
					}
				}
				return result;
			}
		}

		// Token: 0x0600066A RID: 1642 RVA: 0x0002379C File Offset: 0x0002199C
		private static string assemble_Command(modAssemblerStructs.asmProject project, string _str, bool _bPre, ref bool bFound)
		{
			bool flag = _str.Length > 4;
			if (flag)
			{
				bool flag2 = _str.StartsWith("ENDIF", StringComparison.CurrentCultureIgnoreCase);
				if (flag2)
				{
					modCommonDebug._debugWrite("Assemble: ENDIF");
					bFound = true;
					project.bSkip_UntilEndIf = false;
					return "";
				}
				bool flag3 = _str.StartsWith("OP ", StringComparison.CurrentCultureIgnoreCase);
				if (flag3)
				{
					bFound = true;
					return modProcCommands.cmd_OP(_str, _bPre);
				}
				bool flag4 = _str.StartsWith("raw", StringComparison.CurrentCultureIgnoreCase);
				if (flag4)
				{
					bFound = true;
					return modProcCommands.cmd_RAW(_str, _bPre);
				}
				bool flag5 = _str.StartsWith("off", StringComparison.CurrentCultureIgnoreCase) | _str.StartsWith("@off", StringComparison.CurrentCultureIgnoreCase);
				if (flag5)
				{
					bFound = true;
					return modProcCommands.cmd_OFF(_str, _bPre);
				}
				bool flag6 = _str.StartsWith("copy", StringComparison.CurrentCultureIgnoreCase);
				if (flag6)
				{
					bFound = true;
					return modProcCommands.cmd_COPY(_str, _bPre);
				}
				bool flag7 = _str.StartsWith("ADR.BANK", StringComparison.CurrentCultureIgnoreCase);
				if (flag7)
				{
					bFound = true;
					return modProcCommands.cmd_ADR_BANK(_str, _bPre);
				}
				bool flag8 = _str.StartsWith("ADR.16", StringComparison.CurrentCultureIgnoreCase);
				if (flag8)
				{
					bFound = true;
					return modProcCommands.cmd_ADR_16(_str, _bPre);
				}
				bool flag9 = _str.StartsWith("ADR.HIGH", StringComparison.CurrentCultureIgnoreCase);
				if (flag9)
				{
					bFound = true;
					return modProcCommands.cmd_ADR_HIGH(_str, _bPre);
				}
				bool flag10 = _str.StartsWith("ADR.LOW", StringComparison.CurrentCultureIgnoreCase);
				if (flag10)
				{
					bFound = true;
					return modProcCommands.cmd_ADR_LOW(_str, _bPre);
				}
			}
			bool flag11 = _str.StartsWith("IF ", StringComparison.CurrentCultureIgnoreCase);
			string result;
			if (flag11)
			{
				bFound = true;
				string[] array = _str.Split(new char[]
				{
					' '
				});
				modCommonDebug._debugWrite("Assemble: IF");
				bool flag12 = array.Length == 2;
				if (flag12)
				{
					bool flag13 = project.patchFile.optionOn(array[1]);
					if (flag13)
					{
						modCommonDebug._debugWrite("Option = true");
					}
					else
					{
						project.bSkip_UntilEndIf = true;
						modCommonDebug._debugWrite("Option = false");
					}
				}
				result = "";
			}
			else
			{
				bool flag14 = _str.StartsWith("IFNOT ", StringComparison.CurrentCultureIgnoreCase);
				if (flag14)
				{
					bFound = true;
					string[] array2 = _str.Split(new char[]
					{
						' '
					});
					modCommonDebug._debugWrite("Assemble: IFNOT");
					bool flag15 = array2.Length == 2;
					if (flag15)
					{
						bool flag16 = project.patchFile.optionOn(array2[1]);
						if (flag16)
						{
							project.bSkip_UntilEndIf = true;
							modCommonDebug._debugWrite("Option = true");
						}
						else
						{
							modCommonDebug._debugWrite("Option = false");
						}
					}
					result = "";
				}
				else
				{
					result = null;
				}
			}
			return result;
		}

		// Token: 0x0600066B RID: 1643 RVA: 0x00023A7C File Offset: 0x00021C7C
		public static string assembleBranch(string _str, bool _bPre, ref bool _bReturn)
		{
			string key = _str.Substring(0, 5);
			string left = _str.Substring(4, 1);
			bool flag = Operators.CompareString(left, "*", false) == 0;
			checked
			{
				if (flag)
				{
					bool flag2 = assemblerOpcodes.dicAsmCmd.ContainsKey(key);
					if (flag2)
					{
						if (_bPre)
						{
							_bReturn = true;
							return assemblerOpcodes.dicAsmCmd[key] + "??";
						}
						string key2 = _str.Substring(5, _str.Length - 5);
						bool flag3 = modAsmDefs.dicLabels.ContainsKey(key2);
						if (!flag3)
						{
							_bReturn = true;
							assemblerOpcodes.bError = true;
							modCommonDebug._debugWrite("\r\n\r\nERROR: Branch, no label\r\n\r\n");
							return "*ERROR, No label";
						}
						int currentPosition = modAssemble.getCurrentPosition();
						int num = modAsmDefs.dicLabels[key2];
						int num2 = num - (currentPosition + 2);
						string text = Conversion.Hex(num2);
						bool flag4 = num2 > 127;
						if (flag4)
						{
							_bReturn = true;
							assemblerOpcodes.bError = true;
							modCommonDebug._debugWrite("\r\n\r\nERROR: Branch too far\r\n\r\n");
							return "*ERROR, Too far";
						}
						bool flag5 = num2 < 0;
						if (flag5)
						{
							num2 = 256 - num2 * -1;
							bool flag6 = num2 < 128;
							if (flag6)
							{
								_bReturn = true;
								assemblerOpcodes.bError = true;
								modCommonDebug._debugWrite("\r\n\r\nERROR: Branch too far\r\n\r\n");
								return "*ERROR, Too far";
							}
						}
						text = Conversion.Hex(num2);
						bool flag7 = text.Length < 2;
						if (flag7)
						{
							text = "0" + text;
						}
						_bReturn = true;
						return assemblerOpcodes.dicAsmCmd[key] + " " + text;
					}
				}
				return "";
			}
		}

		// Token: 0x0600066C RID: 1644 RVA: 0x00023C40 File Offset: 0x00021E40
		public static string assembleAbsImm(string _str, bool _bPre, ref bool _bReturn)
		{
			string str = _str.Substring(0, 5);
			string text = _str.Substring(5, checked(_str.Length - 5));
			int num = text.IndexOf(" ");
			bool flag = num > 1;
			if (flag)
			{
				text = text.Substring(0, num);
				text = text;
			}
			int length = text.Length;
			string str2 = "";
			string str3 = "";
			bool flag2 = length > 0;
			if (flag2)
			{
				bool flag3 = length == 2;
				if (flag3)
				{
					str2 = "1";
					str3 = _str.Substring(5, 2);
				}
				else
				{
					bool flag4 = length == 4;
					if (flag4)
					{
						str2 = "2";
						str3 = _str.Substring(7, 2) + " " + _str.Substring(5, 2);
					}
					else
					{
						bool flag5 = length == 6;
						if (flag5)
						{
							str2 = "3";
							str3 = string.Concat(new string[]
							{
								_str.Substring(9, 2),
								" ",
								_str.Substring(7, 2),
								" ",
								_str.Substring(5, 2)
							});
						}
					}
				}
			}
			bool flag6 = assemblerOpcodes.dicAsmCmd.ContainsKey(str + str2);
			string result;
			if (flag6)
			{
				_bReturn = true;
				result = assemblerOpcodes.dicAsmCmd[str + str2] + " " + str3;
			}
			else
			{
				result = "";
			}
			return result;
		}

		// Token: 0x0600066D RID: 1645 RVA: 0x00023DB8 File Offset: 0x00021FB8
		public static int getCurrentPosition()
		{
			string text = compiler.sTxtBytes.Trim();
			text = text.Replace("\r\n", "");
			text = text.Replace(" ", "");
			return checked((int)Math.Round((double)text.Length / 2.0));
		}

		// Token: 0x0400097C RID: 2428
		public static string asmDbg;

		// Token: 0x0400097D RID: 2429
		public static string asmDbg_Cmd;

		// Token: 0x0400097E RID: 2430
		public static string asmDbg_Bytes;

		// Token: 0x0400097F RID: 2431
		public static string asmDbg_Msg;

		// Token: 0x04000980 RID: 2432
		public static string asmDbg_Param;

		// Token: 0x04000981 RID: 2433
		public static BackgroundWorker bgAsmWorker = null;
	}
}
