﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using libSnesAssembler;
using libZh;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.CompilerServices;
using Microsoft.VisualBasic.MyServices;
using SnesPatcher.My;

namespace SnesPatcher
{
	// Token: 0x0200000A RID: 10
	[DesignerGenerated]
	public partial class frmSnesPatcher : Form
	{
		// Token: 0x0600003F RID: 63 RVA: 0x000038FC File Offset: 0x00001AFC
		public frmSnesPatcher()
		{
			base.Load += this.frmSnesPatcher_Load;
			this.InitializeComponent();
		}

		// Token: 0x06000040 RID: 64 RVA: 0x0000391C File Offset: 0x00001B1C
		[MethodImpl(MethodImplOptions.NoInlining | MethodImplOptions.NoOptimization)]
		private void frmSnesPatcher_Load(object sender, EventArgs e)
		{
			this.Text = "Snes ZPS Patcher V0.18";
			bool flag = Strings.StrComp("0.18", AsmPatch.patcherVersion, CompareMethod.Binary) != 0;
			if (flag)
			{
				Interaction.MsgBox("Error, wrong version of libRomHacking.dll", MsgBoxStyle.Critical, "Error");
				ProjectData.EndApp();
			}
		}

		// Token: 0x06000041 RID: 65 RVA: 0x00003970 File Offset: 0x00001B70
		private void btnSelectPath_Click(object sender, EventArgs e)
		{
			this.dlgOpenFile.ShowDialog();
			string fileName = this.dlgOpenFile.FileName;
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			bool flag = fileSystem.FileExists(fileName);
			if (flag)
			{
				bool flag2 = Operators.CompareString(fileSystem.GetFileInfo(fileName).Extension, ".zps", false) == 0;
				if (flag2)
				{
					this.zpsPatch = new AsmPatch(fileName);
					this.txtPatchVersion.ReadOnly = false;
					this.txtPatchVersion.Text = "V" + this.zpsPatch.sVersion;
					this.txtPatchVersion.ReadOnly = true;
					bool flag3 = Strings.StrComp(this.zpsPatch.sVersion, "0.18", CompareMethod.Binary) != 0;
					if (flag3)
					{
						this.lblPatchVersion.BackColor = Color.Red;
					}
					else
					{
						this.lblPatchVersion.BackColor = Color.PaleGreen;
					}
					this.txtFile_patch.ReadOnly = false;
					this.txtFile_patch.Text = fileSystem.GetFileInfo(fileName).Name;
					this.txtFile_patch.ReadOnly = true;
					this.txtCRC_patch.ReadOnly = false;
					this.txtCRC_patch.Text = this.zpsPatch.sChecksum;
					this.txtCRC_patch.ReadOnly = true;
					this.txtSize_patch.ReadOnly = false;
					this.txtSize_patch.Text = this.zpsPatch.sRomSize;
					this.txtSize_patch.ReadOnly = true;
					this.lstOptions.Items.Clear();
					try
					{
						foreach (string text in this.zpsPatch.dicOptions.Keys)
						{
							bool bAvailable = this.zpsPatch.dicOptions[text].bAvailable;
							if (bAvailable)
							{
								this.lstOptions.Items.Add(text, true);
							}
						}
					}
					finally
					{
						Dictionary<string, PatchOption>.KeyCollection.Enumerator enumerator;
						((IDisposable)enumerator).Dispose();
					}
					this.btnRom.Enabled = true;
					this.btnDef.Enabled = true;
				}
			}
		}

		// Token: 0x06000042 RID: 66 RVA: 0x00003BB8 File Offset: 0x00001DB8
		private void Button2_Click(object sender, EventArgs e)
		{
			this.dlgOpenFile.ShowDialog();
			string fileName = this.dlgOpenFile.FileName;
			FileSystemProxy fileSystem = MyProject.Computer.FileSystem;
			bool flag = fileSystem.FileExists(fileName);
			if (flag)
			{
				this.txtFile_rom.ReadOnly = false;
				this.txtFile_rom.Text = fileSystem.GetFileInfo(fileName).Name;
				this.txtFile_rom.ReadOnly = true;
				this.txtCRC_rom.ReadOnly = false;
				this.txtCRC_rom.Text = modString.hx(Crc32.getFileChecksum(fileName), 8);
				this.txtCRC_rom.ReadOnly = true;
				this.txtSize_rom.ReadOnly = false;
				this.txtSize_rom.Text = modString.hx(Convert.ToUInt32(fileSystem.GetFileInfo(fileName).Length), 2);
				this.txtSize_rom.ReadOnly = true;
				this.btnApply.Enabled = true;
				this.btnEditChain.Enabled = true;
				this.path_source = fileName;
			}
			this.updateMatch();
		}

		// Token: 0x06000043 RID: 67 RVA: 0x00003CCC File Offset: 0x00001ECC
		private void updateMatch()
		{
			bool flag = modString.hx(this.txtCRC_patch.Text) == modString.hx(this.txtCRC_rom.Text);
			if (flag)
			{
				this.lblCRC32.BackColor = Color.PaleGreen;
			}
			else
			{
				this.lblCRC32.BackColor = Color.Red;
			}
			bool flag2 = modString.hx(this.txtSize_patch.Text) == modString.hx(this.txtSize_rom.Text);
			if (flag2)
			{
				this.lblFileSize.BackColor = Color.PaleGreen;
			}
			else
			{
				this.lblFileSize.BackColor = Color.Red;
			}
			this.txtFile_result.Text = "patched.smc";
		}

		// Token: 0x06000044 RID: 68 RVA: 0x00003D98 File Offset: 0x00001F98
		private void btnApply_Click(object sender, EventArgs e)
		{
			this.path_destination = MyProject.Computer.FileSystem.GetFileInfo(this.path_source).Directory.FullName + "\\" + this.txtFile_result.Text;
			bool flag = modPatchChain.patchChain == null;
			if (flag)
			{
				Collection collection = new Collection();
				collection.Add(new ListItem_Patch(true), null, null, null);
				modPatchChain.setPatchChain(new PatchChain(collection, "", ""));
			}
			modPatchChain.patchChain.sPath_SourceRom = this.path_source;
			modPatchChain.patchChain.sPath_OutputRom = this.path_destination;
			modPatchChain.applyPatchChain(null);
		}

		// Token: 0x06000045 RID: 69 RVA: 0x00003E48 File Offset: 0x00002048
		private void bgwPatcher_DoWork(object sender, DoWorkEventArgs e)
		{
			this.zpsPatch.bUsePatch = true;
			modAssemblerStructs.asmProject asmProject = modProjectBuilder.createAsmProject(this.path_source, this.path_destination, "", this.zpsPatch);
		}

		// Token: 0x06000046 RID: 70 RVA: 0x00003E84 File Offset: 0x00002084
		private void bgwPatcher_ProgressChanged(object sender, ProgressChangedEventArgs e)
		{
			this.barProgress.Value = e.ProgressPercentage;
		}

		// Token: 0x06000047 RID: 71 RVA: 0x00003E9C File Offset: 0x0000209C
		private void bgwPatcher_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
		{
			Interaction.MsgBox("The patched rom has sucesfully been created :\r\n\r\n" + this.path_destination, MsgBoxStyle.OkOnly, null);
			modCommonDebug._debugStop();
		}

		// Token: 0x06000048 RID: 72 RVA: 0x00003EC0 File Offset: 0x000020C0
		private void lstOptions_ItemCheck(object sender, ItemCheckEventArgs e)
		{
			object objectValue = RuntimeHelpers.GetObjectValue(this.lstOptions.Items[e.Index]);
			this.zpsPatch.dicOptions[Conversions.ToString(objectValue)].bActive = (e.NewValue == CheckState.Checked);
		}

		// Token: 0x06000049 RID: 73 RVA: 0x00003F14 File Offset: 0x00002114
		private void lstOptions_SelectedIndexChanged(object sender, EventArgs e)
		{
			bool flag = this.lstOptions.SelectedIndex > -1;
			if (flag)
			{
				object objectValue = RuntimeHelpers.GetObjectValue(this.lstOptions.SelectedItem);
				bool flag2 = this.zpsPatch.dicOptions.ContainsKey(Conversions.ToString(objectValue));
				if (flag2)
				{
					PatchOption patchOption = this.zpsPatch.dicOptions[Conversions.ToString(objectValue)];
					this.txtDescripton.Text = "[" + patchOption.sName + "] :\r\n" + patchOption.sDescription;
				}
			}
		}

		// Token: 0x0600004A RID: 74 RVA: 0x00003FAC File Offset: 0x000021AC
		private void btnDef_Click(object sender, EventArgs e)
		{
			frmEditGlobal frmEditGlobal = new frmEditGlobal(this.zpsPatch);
			frmEditGlobal.ShowDialog();
		}

		// Token: 0x0600004B RID: 75 RVA: 0x00003FD4 File Offset: 0x000021D4
		private void btnEditChain_Click(object sender, EventArgs e)
		{
			MyProject.Forms.frmIPS.ShowDialog();
			MyProject.Forms.frmIPS.Dispose();
		}

		// Token: 0x17000018 RID: 24
		// (get) Token: 0x0600004E RID: 78 RVA: 0x00005064 File Offset: 0x00003264
		// (set) Token: 0x0600004F RID: 79 RVA: 0x00005074 File Offset: 0x00003274
		internal virtual Button btnSelectPath
		{
			[CompilerGenerated]
			get
			{
				return this._btnSelectPath;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnSelectPath_Click);
				Button btnSelectPath = this._btnSelectPath;
				if (btnSelectPath != null)
				{
					btnSelectPath.Click -= value2;
				}
				this._btnSelectPath = value;
				btnSelectPath = this._btnSelectPath;
				if (btnSelectPath != null)
				{
					btnSelectPath.Click += value2;
				}
			}
		}

		// Token: 0x17000019 RID: 25
		// (get) Token: 0x06000050 RID: 80 RVA: 0x000050C4 File Offset: 0x000032C4
		// (set) Token: 0x06000051 RID: 81 RVA: 0x000050D4 File Offset: 0x000032D4
		internal virtual TextBox txtFile_patch { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001A RID: 26
		// (get) Token: 0x06000052 RID: 82 RVA: 0x000050E0 File Offset: 0x000032E0
		// (set) Token: 0x06000053 RID: 83 RVA: 0x000050F0 File Offset: 0x000032F0
		internal virtual TextBox txtFile_rom { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001B RID: 27
		// (get) Token: 0x06000054 RID: 84 RVA: 0x000050FC File Offset: 0x000032FC
		// (set) Token: 0x06000055 RID: 85 RVA: 0x0000510C File Offset: 0x0000330C
		internal virtual Button btnRom
		{
			[CompilerGenerated]
			get
			{
				return this._btnRom;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.Button2_Click);
				Button btnRom = this._btnRom;
				if (btnRom != null)
				{
					btnRom.Click -= value2;
				}
				this._btnRom = value;
				btnRom = this._btnRom;
				if (btnRom != null)
				{
					btnRom.Click += value2;
				}
			}
		}

		// Token: 0x1700001C RID: 28
		// (get) Token: 0x06000056 RID: 86 RVA: 0x0000515C File Offset: 0x0000335C
		// (set) Token: 0x06000057 RID: 87 RVA: 0x0000516C File Offset: 0x0000336C
		internal virtual TextBox txtFile_result { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001D RID: 29
		// (get) Token: 0x06000058 RID: 88 RVA: 0x00005178 File Offset: 0x00003378
		// (set) Token: 0x06000059 RID: 89 RVA: 0x00005188 File Offset: 0x00003388
		internal virtual Button btnApply
		{
			[CompilerGenerated]
			get
			{
				return this._btnApply;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnApply_Click);
				Button btnApply = this._btnApply;
				if (btnApply != null)
				{
					btnApply.Click -= value2;
				}
				this._btnApply = value;
				btnApply = this._btnApply;
				if (btnApply != null)
				{
					btnApply.Click += value2;
				}
			}
		}

		// Token: 0x1700001E RID: 30
		// (get) Token: 0x0600005A RID: 90 RVA: 0x000051D8 File Offset: 0x000033D8
		// (set) Token: 0x0600005B RID: 91 RVA: 0x000051E8 File Offset: 0x000033E8
		internal virtual TextBox txtCRC_patch { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001F RID: 31
		// (get) Token: 0x0600005C RID: 92 RVA: 0x000051F4 File Offset: 0x000033F4
		// (set) Token: 0x0600005D RID: 93 RVA: 0x00005204 File Offset: 0x00003404
		internal virtual TextBox txtCRC_rom { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000020 RID: 32
		// (get) Token: 0x0600005E RID: 94 RVA: 0x00005210 File Offset: 0x00003410
		// (set) Token: 0x0600005F RID: 95 RVA: 0x00005220 File Offset: 0x00003420
		internal virtual TextBox txtSize_rom { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000021 RID: 33
		// (get) Token: 0x06000060 RID: 96 RVA: 0x0000522C File Offset: 0x0000342C
		// (set) Token: 0x06000061 RID: 97 RVA: 0x0000523C File Offset: 0x0000343C
		internal virtual TextBox txtSize_patch { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000022 RID: 34
		// (get) Token: 0x06000062 RID: 98 RVA: 0x00005248 File Offset: 0x00003448
		// (set) Token: 0x06000063 RID: 99 RVA: 0x00005258 File Offset: 0x00003458
		internal virtual Label lblCRC32 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000023 RID: 35
		// (get) Token: 0x06000064 RID: 100 RVA: 0x00005264 File Offset: 0x00003464
		// (set) Token: 0x06000065 RID: 101 RVA: 0x00005274 File Offset: 0x00003474
		internal virtual Label lblFileSize { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000024 RID: 36
		// (get) Token: 0x06000066 RID: 102 RVA: 0x00005280 File Offset: 0x00003480
		// (set) Token: 0x06000067 RID: 103 RVA: 0x00005290 File Offset: 0x00003490
		internal virtual CheckedListBox lstOptions
		{
			[CompilerGenerated]
			get
			{
				return this._lstOptions;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				ItemCheckEventHandler value2 = new ItemCheckEventHandler(this.lstOptions_ItemCheck);
				EventHandler value3 = new EventHandler(this.lstOptions_SelectedIndexChanged);
				CheckedListBox lstOptions = this._lstOptions;
				if (lstOptions != null)
				{
					lstOptions.ItemCheck -= value2;
					lstOptions.SelectedIndexChanged -= value3;
				}
				this._lstOptions = value;
				lstOptions = this._lstOptions;
				if (lstOptions != null)
				{
					lstOptions.ItemCheck += value2;
					lstOptions.SelectedIndexChanged += value3;
				}
			}
		}

		// Token: 0x17000025 RID: 37
		// (get) Token: 0x06000068 RID: 104 RVA: 0x000052F8 File Offset: 0x000034F8
		// (set) Token: 0x06000069 RID: 105 RVA: 0x00005308 File Offset: 0x00003508
		internal virtual OpenFileDialog dlgOpenFile { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000026 RID: 38
		// (get) Token: 0x0600006A RID: 106 RVA: 0x00005314 File Offset: 0x00003514
		// (set) Token: 0x0600006B RID: 107 RVA: 0x00005324 File Offset: 0x00003524
		internal virtual BackgroundWorker bgwPatcher
		{
			[CompilerGenerated]
			get
			{
				return this._bgwPatcher;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				DoWorkEventHandler value2 = new DoWorkEventHandler(this.bgwPatcher_DoWork);
				ProgressChangedEventHandler value3 = new ProgressChangedEventHandler(this.bgwPatcher_ProgressChanged);
				RunWorkerCompletedEventHandler value4 = new RunWorkerCompletedEventHandler(this.bgwPatcher_RunWorkerCompleted);
				BackgroundWorker bgwPatcher = this._bgwPatcher;
				if (bgwPatcher != null)
				{
					bgwPatcher.DoWork -= value2;
					bgwPatcher.ProgressChanged -= value3;
					bgwPatcher.RunWorkerCompleted -= value4;
				}
				this._bgwPatcher = value;
				bgwPatcher = this._bgwPatcher;
				if (bgwPatcher != null)
				{
					bgwPatcher.DoWork += value2;
					bgwPatcher.ProgressChanged += value3;
					bgwPatcher.RunWorkerCompleted += value4;
				}
			}
		}

		// Token: 0x17000027 RID: 39
		// (get) Token: 0x0600006C RID: 108 RVA: 0x000053A8 File Offset: 0x000035A8
		// (set) Token: 0x0600006D RID: 109 RVA: 0x000053B8 File Offset: 0x000035B8
		internal virtual ProgressBar barProgress { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000028 RID: 40
		// (get) Token: 0x0600006E RID: 110 RVA: 0x000053C4 File Offset: 0x000035C4
		// (set) Token: 0x0600006F RID: 111 RVA: 0x000053D4 File Offset: 0x000035D4
		internal virtual Label lblPatchVersion { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000029 RID: 41
		// (get) Token: 0x06000070 RID: 112 RVA: 0x000053E0 File Offset: 0x000035E0
		// (set) Token: 0x06000071 RID: 113 RVA: 0x000053F0 File Offset: 0x000035F0
		internal virtual TextBox txtPatchVersion { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700002A RID: 42
		// (get) Token: 0x06000072 RID: 114 RVA: 0x000053FC File Offset: 0x000035FC
		// (set) Token: 0x06000073 RID: 115 RVA: 0x0000540C File Offset: 0x0000360C
		internal virtual TextBox txtDescripton { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700002B RID: 43
		// (get) Token: 0x06000074 RID: 116 RVA: 0x00005418 File Offset: 0x00003618
		// (set) Token: 0x06000075 RID: 117 RVA: 0x00005428 File Offset: 0x00003628
		internal virtual Button btnDef
		{
			[CompilerGenerated]
			get
			{
				return this._btnDef;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnDef_Click);
				Button btnDef = this._btnDef;
				if (btnDef != null)
				{
					btnDef.Click -= value2;
				}
				this._btnDef = value;
				btnDef = this._btnDef;
				if (btnDef != null)
				{
					btnDef.Click += value2;
				}
			}
		}

		// Token: 0x1700002C RID: 44
		// (get) Token: 0x06000076 RID: 118 RVA: 0x00005478 File Offset: 0x00003678
		// (set) Token: 0x06000077 RID: 119 RVA: 0x00005488 File Offset: 0x00003688
		internal virtual Button btnEditChain
		{
			[CompilerGenerated]
			get
			{
				return this._btnEditChain;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnEditChain_Click);
				Button btnEditChain = this._btnEditChain;
				if (btnEditChain != null)
				{
					btnEditChain.Click -= value2;
				}
				this._btnEditChain = value;
				btnEditChain = this._btnEditChain;
				if (btnEditChain != null)
				{
					btnEditChain.Click += value2;
				}
			}
		}

		// Token: 0x1700002D RID: 45
		// (get) Token: 0x06000078 RID: 120 RVA: 0x000054D8 File Offset: 0x000036D8
		// (set) Token: 0x06000079 RID: 121 RVA: 0x000054E8 File Offset: 0x000036E8
		internal virtual Label lblOutputFile { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700002E RID: 46
		// (get) Token: 0x0600007A RID: 122 RVA: 0x000054F4 File Offset: 0x000036F4
		// (set) Token: 0x0600007B RID: 123 RVA: 0x00005504 File Offset: 0x00003704
		internal virtual SplitContainer pnlSplit { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x04000023 RID: 35
		public AsmPatch zpsPatch;

		// Token: 0x04000024 RID: 36
		public string path_source;

		// Token: 0x04000025 RID: 37
		public string path_destination;

		// Token: 0x04000026 RID: 38
		private const string sVersion = "0.18";
	}
}
