﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.CompilerServices;
using System.Windows.Forms;
using libSnesAssembler;
using Microsoft.VisualBasic.CompilerServices;

namespace SnesPatcher
{
	// Token: 0x02000008 RID: 8
	[DesignerGenerated]
	public partial class frmEditGlobal : Form
	{
		// Token: 0x1700000D RID: 13
		// (get) Token: 0x06000018 RID: 24 RVA: 0x00002600 File Offset: 0x00000800
		// (set) Token: 0x06000019 RID: 25 RVA: 0x00002610 File Offset: 0x00000810
		internal virtual Button btnOk
		{
			[CompilerGenerated]
			get
			{
				return this._btnOk;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnOk_Click);
				Button btnOk = this._btnOk;
				if (btnOk != null)
				{
					btnOk.Click -= value2;
				}
				this._btnOk = value;
				btnOk = this._btnOk;
				if (btnOk != null)
				{
					btnOk.Click += value2;
				}
			}
		}

		// Token: 0x1700000E RID: 14
		// (get) Token: 0x0600001A RID: 26 RVA: 0x00002660 File Offset: 0x00000860
		// (set) Token: 0x0600001B RID: 27 RVA: 0x00002670 File Offset: 0x00000870
		internal virtual Button btnCancel
		{
			[CompilerGenerated]
			get
			{
				return this._btnCancel;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.btnCancel_Click);
				Button btnCancel = this._btnCancel;
				if (btnCancel != null)
				{
					btnCancel.Click -= value2;
				}
				this._btnCancel = value;
				btnCancel = this._btnCancel;
				if (btnCancel != null)
				{
					btnCancel.Click += value2;
				}
			}
		}

		// Token: 0x0600001C RID: 28 RVA: 0x000026C0 File Offset: 0x000008C0
		public frmEditGlobal(AsmPatch _patch)
		{
			base.Load += this.frmEditGlobal_Load;
			this.cTxt = new Collection<TextBox>();
			this.InitializeComponent();
			this.patch = _patch;
		}

		// Token: 0x0600001D RID: 29 RVA: 0x000026F8 File Offset: 0x000008F8
		private void frmEditGlobal_Load(object sender, EventArgs e)
		{
			base.Width = this.calculateWinWidth();
			int width = base.ClientRectangle.Width;
			int num = 15;
			checked
			{
				try
				{
					foreach (PatchGlobal patchGlobal in this.patch.dicGlobals.Values)
					{
						bool bEditable = patchGlobal.bEditable;
						if (bEditable)
						{
							TextBox textBox = new TextBox();
							TextBox textBox2 = textBox;
							textBox2.Left = 5 + this.iGlobalCharCount * 8 + 5;
							textBox2.Top = num;
							textBox2.Width = 100;
							textBox2.Height = 20;
							textBox2.Text = patchGlobal.sEditValue;
							textBox2.Tag = patchGlobal.sName;
							Label label = new Label();
							Label label2 = label;
							label2.AutoSize = false;
							label2.Left = 5;
							label2.Top = num;
							label2.Width = this.iGlobalCharCount * 8;
							label2.Height = 20;
							label2.Text = patchGlobal.sName.Replace("%", "").Replace("_", " ") + " :";
							label2.TextAlign = ContentAlignment.MiddleRight;
							label2.Font = new Font("Courier New", 8f);
							label2.BorderStyle = BorderStyle.None;
							base.Controls.Add(label);
							base.Controls.Add(textBox);
							this.cTxt.Add(textBox);
							num += textBox.Height + 1;
						}
					}
				}
				finally
				{
					Dictionary<string, PatchGlobal>.ValueCollection.Enumerator enumerator;
					((IDisposable)enumerator).Dispose();
				}
				num += 30;
				base.Height += num;
				base.Top = (int)Math.Round(unchecked((double)base.Top - (double)num / 2.0));
				base.Left = (int)Math.Round(unchecked((double)base.Left - (double)(checked(base.Width - 300)) / 2.0));
			}
		}

		// Token: 0x0600001E RID: 30 RVA: 0x00002938 File Offset: 0x00000B38
		private void btnOk_Click(object sender, EventArgs e)
		{
			try
			{
				foreach (TextBox textBox in this.cTxt)
				{
					this.patch.dicGlobals[Conversions.ToString(textBox.Tag)].sEditValue = PatchGlobal.validateEditValue(this.patch.dicGlobals[Conversions.ToString(textBox.Tag)].editType, textBox.Text);
				}
			}
			finally
			{
				IEnumerator<TextBox> enumerator;
				if (enumerator != null)
				{
					enumerator.Dispose();
				}
			}
			base.Close();
		}

		// Token: 0x0600001F RID: 31 RVA: 0x000029E0 File Offset: 0x00000BE0
		private void btnCancel_Click(object sender, EventArgs e)
		{
			base.Close();
		}

		// Token: 0x06000020 RID: 32 RVA: 0x000029EC File Offset: 0x00000BEC
		private int calculateWinWidth()
		{
			int num = 150;
			this.iGlobalCharCount = this.getMaxGlobalName();
			return checked(num + this.iGlobalCharCount * 8);
		}

		// Token: 0x06000021 RID: 33 RVA: 0x00002A24 File Offset: 0x00000C24
		private int getMaxGlobalName()
		{
			int num = 0;
			try
			{
				foreach (PatchGlobal patchGlobal in this.patch.dicGlobals.Values)
				{
					bool bEditable = patchGlobal.bEditable;
					if (bEditable)
					{
						num = Math.Max(num, patchGlobal.sName.Length);
					}
				}
			}
			finally
			{
				Dictionary<string, PatchGlobal>.ValueCollection.Enumerator enumerator;
				((IDisposable)enumerator).Dispose();
			}
			return num;
		}

		// Token: 0x0400000E RID: 14
		private const int const_form_width_fix = 10;

		// Token: 0x0400000F RID: 15
		private const int const_labels_leftSpacing = 5;

		// Token: 0x04000010 RID: 16
		private const int const_labels_charWidth = 8;

		// Token: 0x04000011 RID: 17
		private const int const_txtBoxes_rightSpacing = 40;

		// Token: 0x04000012 RID: 18
		private const int const_txtBoxes_leftSpacing = 5;

		// Token: 0x04000013 RID: 19
		private const int const_txtBoxes_width = 100;

		// Token: 0x04000014 RID: 20
		private const int const_txtBoxes_height = 20;

		// Token: 0x04000015 RID: 21
		private const int const_globalEdit_height = 30;

		// Token: 0x04000016 RID: 22
		private Collection<TextBox> cTxt;

		// Token: 0x04000017 RID: 23
		private AsmPatch patch;

		// Token: 0x04000018 RID: 24
		private int iGlobalCharCount;
	}
}
