--Written by ComboKyo
--For Bizhawk 2.8 with the BSNES Core.
--How to use:
--Open Bizhawk, Open ROM Ultra Clayfighter, Click Tools -> Lua Console, drag Lua file into Lua Console Window
--Automatically works. Pause during a fight to view options.
--Hitbox colors: Black = Block, Blue = Hit, Red = Standard Attack, Orange = Flatten Attack, Yellow = Launcher, Purple = Cutting Attack

function inputdisplayoptions()

-- Change these values to move the button displays to a different area of the screen.

-- Menu coordinates are in pixels. SNES resolution is X(256), Y(224).
--	X = 0 starting at the left. Positive values move right.
--	Y = 0 starting at the top. 	Positive values move down.
--	The number in brackets [] is that player's display value.

--Full Menu offset
	displayx[1]	= 0
	displayy[1]	= 215
	displayx[2]	= 128
	displayy[2]	= 215

--Moves the d-pad menu by that many pixels from the offset
	dpadx[1]	= 0
	dpady[1]	= 0
	dpadx[2]	= 0
	dpady[2]	= 0

-- Increases the length (in pixels (game ticks)) of the input chart for the d-pad and shoulder buttons for player []
	gdpadgridwidth[1] = 51
	gdpadgridwidth[2] = 51
	
--Moves the face button menu by that many pixels from the offset
	buttonsx[1]	= 63
	buttonsy[1]	= 0
	buttonsx[2]	= 63
	buttonsy[2]	= 0

-- Increases the length (in pixels (game ticks)) of the input chart for face buttons for player []
	gbuttongridwidth[1] = 51
	gbuttongridwidth[2] = 51

--Preconfigured settings. Delete the --s and add --s to any other configurations below it to enable:
	-- Defaults for Gundam Wing: Endless Duel. Sets charts to 51 pixels in length. Buttons to the right of d-pad. 1P and 2P. Here in case self adjustments erase previous defaults.
--displayx[1]	= 0;	displayy[1]	= 215;	displayx[2]	= 128;	displayy[2]	= 215;	dpadx[1]	= 0;	dpady[1]	= 0;	dpadx[2]	= 0;	dpady[2]	= 0;	dpadgridwidth[1] = 51;	dpadgridwidth[2] = 51;	buttonsx[1]	= 63;	buttonsy[1]	= 0;	buttonsx[2]	= 63;	buttonsy[2]	= 0;	buttongridwidth[1] = 51;	buttongridwidth[2] = 51
	-- Inputs at top of screen. D-pad and buttons stacked on top of each other. Input tracking length set to almost half screen.
--displayx[1]	= 0; displayy[1]	= 0; displayx[2]	= 128; displayy[2]	= 0;	dpadx[1]	= 0;	dpady[1]	= 0;	dpadx[2]	= 0;	dpady[2]	= 0;	dpadgridwidth[1] = 101;	dpadgridwidth[2] = 101;	buttonsx[1]	= 0;	buttonsy[1]	= 9;	buttonsx[2]	= 0;	buttonsy[2]	= 9;	buttongridwidth[1] = 101;	buttongridwidth[2] = 101

	
-- Button Colors for both players.
-- To set separate button colors for Players 1 and 2, create two copies of Button Idle and Button Press.
--   Change the "i" in buttoncolorp[i] to 1 for P1 and change the duplicate "i" to 2. Then, adjust hex colors. 
	for i = 1, 2, 1 do
	-- Button Idle
		buttoncolorp[i][1][1]	= 0xFF606060 -- Up
		buttoncolorp[i][1][2]	= 0xFF606060 -- Down
		buttoncolorp[i][1][3]	= 0xFF606060 -- Left
		buttoncolorp[i][1][4]	= 0xFF606060 -- Right
		buttoncolorp[i][1][5]	= 0xFFC30110 -- A
		buttoncolorp[i][1][6]	= 0xFFDEB019 -- B
		buttoncolorp[i][1][7]	= 0xFF408FFF -- X
		buttoncolorp[i][1][8]	= 0xFF028247 -- Y
		buttoncolorp[i][1][9]	= 0xFF909090 -- L
		buttoncolorp[i][1][10]	= 0xFF909090 -- R
		buttoncolorp[i][1][11]	= 0xFF383838 -- Start
		buttoncolorp[i][1][12]	= 0xFF383838 -- Select

	--Button Press
		buttoncolorp[i][2][1]	= 0xFFFFFFFF
		buttoncolorp[i][2][2]	= 0xFFFFFFFF
		buttoncolorp[i][2][3]	= 0xFF00B0FF
		buttoncolorp[i][2][4]	= 0xFFFF4F00
		buttoncolorp[i][2][5]	= 0xFFFF91B0
		buttoncolorp[i][2][6]	= 0xFFFFF0B9
		buttoncolorp[i][2][7]	= 0xFFB1CFF7--0xFF013FB7
		buttoncolorp[i][2][8]	= 0xFF92E2A7
		buttoncolorp[i][2][9]	= 0xFF00FF00
		buttoncolorp[i][2][10]	= 0xFFFF0060
		buttoncolorp[i][2][11]	= 0xFFFFFFFF
		buttoncolorp[i][2][12]	= 0xFFFFFFFF
		buttonborder			= 0xFF404040
	end

end

memory.usememorydomain("WRAM")
previoushealthp1 = 0
previoushealthp2 = 0
--
option = {}
for i = 1,11, 1 do
	option[i] = -1
end
option[2] = 01
option[3] = 01
option[4] = 01
--
menuselect = 1
drawhitbox = {}; drawhitbox[1] = 0; drawhitbox[2] = 0
gametime = {}; gametime[1] = 0; gametime[2] = 0
playerstateoffset = 0x57
animframe = {}; stateno = {}
characterid = {}; 
playeroffset = 1
posx = {}; posy = {}; facingleft = {}; standstateturn = {}
function globals()
	for i = 1, 20, 1 do
		characterid[i] = mainmemory.read_u8(0x7A6 + (playerstateoffset * (i-1)))
	end
	if characterid[1] == 0x2B or characterid[1] == 0x2C or characterid[1] == 0x07 then
		playeroffset = 1
	else
		playeroffset = 2
	end
	for i = 0, 1, 1 do
		posx[i+1] = mainmemory.read_s16_le(0x761 + playerstateoffset*playeroffset*i)
		posy[i+1] = mainmemory.read_s16_le(0x764 + playerstateoffset*playeroffset*i)
		animframe[i+1] = mainmemory.read_u8(0x784 + playerstateoffset*playeroffset*i)
		stateno[i+1] = mainmemory.read_u8(0x77A + playerstateoffset*playeroffset*i)
		facingleft[i+1] = bit.band(mainmemory.read_u8(0x797 + playerstateoffset*playeroffset*i), 0x40) == 0x40
	end
	gametime[2] = gametime[1]
	gametime[1] = mainmemory.read_s16_le(0x7A)
	if gametime[1] == gametime[2] + 1 or (gametime[1] == 0 and gametime[2] == 0xFFFF) then
		inamatch = true else inamatch = false
	end
	if mainmemory.read_u8(0x1FF4) == 0x70 or mainmemory.read_u8(0x1FF4) == 0x47 then
		gamepause = true else gamepause = false
	end
	pcamx	= mainmemory.read_s16_le(0x3E)
	pcamy	= mainmemory.read_s16_le(0x704)
	combop1 = mainmemory.read_u16_le(0x17B6)
	combop2 = mainmemory.read_u16_le(0x17B8)
	healthp1 = mainmemory.read_s16_le(0x3AA8)
	healthp2 = mainmemory.read_s16_le(0x3AAC)
	healthbarp1 = mainmemory.read_s16_le(0x3AAA)
	healthbarp2 = mainmemory.read_s16_le(0x3AAE)
	totaldamagep1 =	previoushealthp1 - healthp1
	totaldamagep2 =	previoushealthp2 - healthp2
	drawhitbox[2] = drawhitbox[1]
	drawhitbox[1] = mainmemory.read_u8(0xAE)
	if (drawhitbox[1] ~= drawhitbox[2]) and (drawhitbox[1] == drawhitbox[2] + 2 or (drawhitbox[1] == 0 and drawhitbox[2] == 62)) then
		hitboxenable = true else hitboxenable = false
	end
	brightness = mainmemory.read_u8(0x317E)
	standstateturn[1] = (stateno[1] == 0 and 
						((posx[1] < posx[2] and facingleft[1] == true) or 
						 (posx[1] > posx[2] and facingleft[1] == false)) )
	standstateturn[2] = (stateno[2] == 0 and 
						((posx[2] < posx[1] and facingleft[2] == true) or 
						 (posx[2] > posx[1] and facingleft[2] == false)) )
end

function lateglobals()
	if combop1 == 0 and ((stateno[2] < 0x30 or stateno[2] > 0x41) and standstateturn[2] == false ) then previoushealthp2 = mainmemory.read_s16_le(0x3AAC) end
	if combop2 == 0 and ((stateno[1] < 0x30 or stateno[1] > 0x41) and standstateturn[1] == false ) then previoushealthp1 = mainmemory.read_s16_le(0x3AA8) end
end

local function combocounter()
	if combop1 > 1 then	gui.drawText(  12, 50, combop1 .. " Hits", 0xFFFF8000, 0x20000000) end
	if combop2 > 1 then gui.drawText( 196, 50, combop2 .. " Hits", 0xFFFF8000, 0x20000000) end
end

local function damagedisplay()
	if (combop1 > 0 or (stateno[2] >= 0x30 and stateno[2] <= 0x41) or standstateturn[2] ) and previoushealthp2 > healthp2 then
		gui.drawBox(143 + previoushealthp2,
					26,
					143 + healthp2,
					30,
					0xFFFF0000, 0xFFFF0000)
		gui.pixelText((totaldamagep2<10 and 1 or 0) * 4 + 135 + previoushealthp2, 25, totaldamagep2, 0xFFFFFFFF, 0x20000000)
	end
	if (combop2 > 0 or (stateno[1] >= 0x30 and stateno[1] <= 0x41) or standstateturn[1] ) and previoushealthp1 > healthp1 then
		gui.drawBox(15 + previoushealthp1,
					26,
					15 + healthp1,
					30,
					0xFFFF0000, 0xFFFF0000)
		gui.pixelText((totaldamagep1<10 and 1 or 0) * 4 + 007 + previoushealthp1, 25, totaldamagep1, 0xFFFFFFFF, 0x20000000)
	end
end

local function setHP()
	if (combop2 == 0 and healthp1 < 0x60 and ((stateno[1] < 0x30 or stateno[1] > 0x41) and 
			standstateturn[1] == false) ) or healthp1 <= 0 then mainmemory.write_u8(0x3AA8, healthp1+1) end
	if (combop1 == 0 and healthp2 < 0x60 and ((stateno[2] < 0x30 or stateno[2] > 0x41) and 
			standstateturn[2] == false) ) or healthp2 <= 0 then mainmemory.write_u8(0x3AAC, healthp2+1) end
end

local function playertest()

	if hitboxenable then
	if mainmemory.read_u8(0x3AAC) > 0 then
	for k = 0, 19, 1 do
		bboxoffset = 0x215E + (0x80 * k)
		bboxtotal = mainmemory.read_u16_le(bboxoffset)
	if bboxtotal ~= 0 and bboxtotal <= 0x0B then
--		gui.pixelText(007, k * 8 + 30, k, 0xFFFFFFFF, 0x20000000)
	for i = 0, bboxtotal-1, 1 do
		local pstart 	= 0x2160 + (0x80 * k) + (0x0A * i)

		local pposy    	= mainmemory.read_s16_le(pstart)
		local pposx    	= (mainmemory.read_s16_le(pstart + 0x02)+0x400) % 0x800 - 0x400
		local pposy2    = mainmemory.read_s16_le(pstart + 0x04) 
		local pposx2    = (mainmemory.read_s16_le(pstart + 0x06)+0x400) % 0x800 - 0x400
		local boxprop1	= mainmemory.read_u8(pstart + 0x08)
		local boxprop2	= mainmemory.read_u8(pstart + 0x09)
		
		local boxborder
		local boxfill
		
		if boxprop1 == 4 or boxprop1 == 6 or boxprop1 == 7 then
			boxborder	= 0xFFFF0000 + -- Default
							((boxprop1 == 6 and 1 or 0) * 0x000000FF) + 	-- Cut
							((boxprop2 == 0x70 and 1 or 0) * 0x00008000) + 	-- Flatten
							((boxprop1 == 7 and 1 or 0) * 0x00008000) + 	-- 
							((boxprop2 >= 0x40 and boxprop2 < 0x70 and 1 or 0) * 0x0000FF00) -- Launches
			boxfill  	= 0x20FF0000 + 
							((boxprop1 == 6 and 1 or 0) * 0x000000FF) + 
							((boxprop2 == 0x70 and 1 or 0) * 0x00008000) + 	-- Flatten
							((boxprop1 == 7 and 1 or 0) * 0x00008000) + 
							((boxprop2 >= 0x40 and boxprop2 < 0x70 and 1 or 0) * 0x0000FF00) -- Launches
		elseif boxprop1 == 5 then -- and boxprop2 == 0x10 then 
			boxborder	= 0xFF000000
			boxfill  	= 0x20000000
		else
			boxborder	= 0xFF0000FF
			boxfill  	= 0x200000FF
		end

		if bit.band(boxprop2, 0x80) == 0x80 then boxfill = boxfill + 0x80000000 end

		gui.drawBox(pposx-pcamx,
					pposy-pcamy-64,
					pposx2-pcamx,
					pposy2-pcamy-64,
					boxborder, boxfill)
	end
	end
	end
	end
	end
end

function inputpress()
	buttons = joypad.get()
	if buttons["P1 Up"] == true then
		buttonp1up = buttonp1up + 1
	else
		buttonp1up	= 0
	end
	if buttons["P1 Down"] == true then
		buttonp1down = buttonp1down + 1
	else
		buttonp1down 		= 0
	end
	if buttons["P1 Left"] == true then
		buttonp1left = buttonp1left + 1
	else
		buttonp1left		= 0
	end
	if buttons["P1 Right"] == true then
		buttonp1right = buttonp1right + 1
	else
		buttonp1right 		= 0
	end
	if buttons["P1 A"] == true then
		buttonp1a = buttonp1a + 1
	else
		buttonp1a 		= 0
	end
	if buttons["P1 Y"] == true then
		buttonp1y = buttonp1y + 1
	else
		buttonp1y 		= 0
	end
	if buttons["P1 B"] == true then
		buttonp1b = buttonp1b + 1
	else
		buttonp1b 		= 0
	end
	if buttons["P1 L"] == true then
		buttonp1l = buttonp1l + 1
	else
		buttonp1l 		= 0
	end
	if buttons["P1 R"] == true then
		buttonp1r = buttonp1r + 1
	else
		buttonp1r 		= 0
	end
	if buttons["P1 Select"] == true then
		buttonp1select = buttonp1select + 1
	else
		buttonp1select 		= 0
	end
	if buttons["P1 Start"] == true then
		buttonp1start = buttonp1start + 1
	else
		buttonp1start 		= 0
	end
	if buttons["P2 Up"] == true then
		buttonp2up = buttonp2up + 1
	else
		buttonp2up	= 0
	end
	if buttons["P2 Down"] == true then
		buttonp2down = buttonp2down + 1
	else
		buttonp2down 		= 0
	end
	if buttons["P2 Left"] == true then
		buttonp2left = buttonp2left + 1
	else
		buttonp2left		= 0
	end
	if buttons["P2 Right"] == true then
		buttonp2right = buttonp2right + 1
	else
		buttonp2right 		= 0
	end
	if buttons["P2 A"] == true then
		buttonp2a = buttonp2a + 1
	else
		buttonp2a 		= 0
	end
	if buttons["P2 Y"] == true then
		buttonp2y = buttonp2y + 1
	else
		buttonp2y 		= 0
	end
	if buttons["P2 B"] == true then
		buttonp2b = buttonp2b + 1
	else
		buttonp2b 		= 0
	end
	if buttons["P2 L"] == true then
		buttonp2l = buttonp2l + 1
	else
		buttonp2l 		= 0
	end
	if buttons["P2 R"] == true then
		buttonp2r = buttonp2r + 1
	else
		buttonp2r 		= 0
	end
	if buttons["P2 Select"] == true then
		buttonp2select = buttonp2select + 1
	else
		buttonp2select 		= 0
	end
	if buttons["P2 Start"] == true then
		buttonp2start = buttonp2start + 1
	else
		buttonp2start 		= 0
	end

end

totalinputframes = 500
inputoffset = {}; inputoffset[1] = 00; inputoffset[2] = 00
inputpausep = {}; inputpausep[1] = -1; inputpausep[2] = -1
inputframep = {}; currentinputframep = {}
inputtrackp = {}; currentinputtrackp = {}
displayx	= {}; displayy	= {}; dpadx		= {}; dpady		= {}; buttonsx	= {}; buttonsy	= {}
buttoncolorp = {} -- Buttoncolorp[player][press/unpress][button]
gdpadgridwidth = {}
gbuttongridwidth = {}
buttongridp = {}
buttonpressp = {}

-- Buttons Press Player[player][button][offset for a bar comparing multiple buttons in one bar]
for i = 1, 2, 1 do
	buttonpressp[i] = {}
	for k = 1, 12, 1 do buttonpressp[i][k] = {}	end
	buttoncolorp[i] = {}
	for k = 1, 2, 1 do buttoncolorp[i][k] = {}  end
	inputtrackp[i] = {}
	currentinputtrackp[i] = {}
	for k = 1, 12, 1 do	inputtrackp[i][k] = {}	end
	inputframep[i] = {}
	currentinputframep[i] = {}
	for k = 1, 12, 1 do	inputframep[i][k] = {}	end
end

function inputframe()	
	for i = 1, 2, 1 do
		currentinputframep[i] = joypad.getwithmovie(i)
		currentinputtrackp[i] = joypad.getwithmovie(i)
	end

	for h = 1, 2, 1 do
		for i = totalinputframes,1, -1 do
			for k = 1, 12, 1 do
				inputframep[h][k][i+1]	= inputframep[h][k][i]
			end
		end
	end
end

function inputtrack1()	
	for i = totalinputframes,1, -1 do
		for k = 1, 12, 1 do
			inputtrackp[1][k][i+1]	= inputtrackp[1][k][i]
		end
	end
-- inputframe[player][inputnumber][frame] = true (pressed) or false (not pressed)
	inputtrackp[1][1][1]		= currentinputtrackp[1]["Up"]
	inputtrackp[1][2][1]		= currentinputtrackp[1]["Down"]
	inputtrackp[1][3][1]		= currentinputtrackp[1]["Left"] 
	inputtrackp[1][4][1]		= currentinputtrackp[1]["Right"]
	inputtrackp[1][5][1]		= currentinputtrackp[1]["A"]
	inputtrackp[1][6][1]		= currentinputtrackp[1]["B"]
	inputtrackp[1][7][1]		= currentinputtrackp[1]["X"]
	inputtrackp[1][8][1]		= currentinputtrackp[1]["Y"]
	inputtrackp[1][9][1]		= currentinputtrackp[1]["L"]
	inputtrackp[1][10][1]		= currentinputtrackp[1]["R"]
	inputtrackp[1][11][1]		= currentinputtrackp[1]["Start"]
	inputtrackp[1][12][1]		= currentinputtrackp[1]["Select"]
end

function inputtrack2()	
	for i = totalinputframes,1, -1 do
		for k = 1, 12, 1 do
			inputtrackp[2][k][i+1]	= inputtrackp[2][k][i]
		end
	end
-- inputframe[player][inputnumber][frame] = true (pressed) or false (not pressed)
	inputtrackp[2][1][1]		= currentinputtrackp[2]["Up"]
	inputtrackp[2][2][1]		= currentinputtrackp[2]["Down"]
	inputtrackp[2][3][1]		= currentinputtrackp[2]["Left"] 
	inputtrackp[2][4][1]		= currentinputtrackp[2]["Right"]
	inputtrackp[2][5][1]		= currentinputtrackp[2]["A"]
	inputtrackp[2][6][1]		= currentinputtrackp[2]["B"]
	inputtrackp[2][7][1]		= currentinputtrackp[2]["X"]
	inputtrackp[2][8][1]		= currentinputtrackp[2]["Y"]
	inputtrackp[2][9][1]		= currentinputtrackp[2]["L"]
	inputtrackp[2][10][1]		= currentinputtrackp[2]["R"]
	inputtrackp[2][11][1]		= currentinputtrackp[2]["Start"]
	inputtrackp[2][12][1]		= currentinputtrackp[2]["Select"]
end

function inputpresses()
	
-- inputframe[player][inputnumber][frame] = true (pressed) or false (not pressed)
	for i = 1, 2, 1 do	
		inputframep[i][1][1]		= currentinputframep[i]["Up"]
		inputframep[i][2][1]		= currentinputframep[i]["Down"]
		inputframep[i][3][1]		= currentinputframep[i]["Left"] 
		inputframep[i][4][1]		= currentinputframep[i]["Right"]
		inputframep[i][5][1]		= currentinputframep[i]["A"]
		inputframep[i][6][1]		= currentinputframep[i]["B"]
		inputframep[i][7][1]		= currentinputframep[i]["X"]
		inputframep[i][8][1]		= currentinputframep[i]["Y"]
		inputframep[i][9][1]		= currentinputframep[i]["L"]
		inputframep[i][10][1]		= currentinputframep[i]["R"]
		inputframep[i][11][1]		= currentinputframep[i]["Start"]
		inputframep[i][12][1]		= currentinputframep[i]["Select"]
	end
end

function drawbuttons()

	for i = 1, 2, 1 do
		for k = 1, 12, 1 do buttonpressp[i][k] = {}
			buttonpressp[i][k][1] = 0;	buttonpressp[i][k][2] = 0; buttonpressp[i][k][3] = 0
		end
	end
	
	local dpadgridwidth = {}
	local buttongridwidth = {}

	local inputtracklocalp = inputtrackp
	
	dpadgridwidth[1] = gdpadgridwidth[1]
	dpadgridwidth[2] = gdpadgridwidth[2]
	buttongridwidth[1] = gbuttongridwidth[1]
	buttongridwidth[2] = gbuttongridwidth[2]

-- Input Display
for i = 1, 2, 1 do

	local	colordisplayup 			= (inputframep[i][1][1] and buttoncolorp[i][2][1] or buttoncolorp[i][1][1]) 
	local	colordisplaydown 		= (inputframep[i][2][1] and buttoncolorp[i][2][2] or buttoncolorp[i][1][2])
	local	colordisplayleft 		= (inputframep[i][3][1] and buttoncolorp[i][2][3] or buttoncolorp[i][1][3])
	local	colordisplayright 		= (inputframep[i][4][1] and buttoncolorp[i][2][4] or buttoncolorp[i][1][4])
	local	colordisplaya			= (inputframep[i][5][1] and buttoncolorp[i][2][5] or buttoncolorp[i][1][5]) 
	local	colordisplayb			= (inputframep[i][6][1] and buttoncolorp[i][2][6] or buttoncolorp[i][1][6])
	local	colordisplayx			= (inputframep[i][7][1] and buttoncolorp[i][2][7] or buttoncolorp[i][1][7])
	local	colordisplayy			= (inputframep[i][8][1] and buttoncolorp[i][2][8] or buttoncolorp[i][1][8])
	local	colordisplayl			= (inputframep[i][9][1] and buttoncolorp[i][2][9] or buttoncolorp[i][1][9])
	local	colordisplayr			= (inputframep[i][10][1] and buttoncolorp[i][2][10] or buttoncolorp[i][1][10])
	local	colordisplaystart		= (inputframep[i][11][1] and buttoncolorp[i][2][11] or buttoncolorp[i][1][11])
	local	colordisplayselect		= (inputframep[i][12][1] and buttoncolorp[i][2][12] or buttoncolorp[i][1][12])

--Background: Transparent Black Box
	gui.drawBox(00+dpadx[i]+displayx[i], 	00+dpady[i]+displayy[i], 	dpadgridwidth[i]+11+dpadx[i]+displayx[i], 		08+dpady[i]+displayy[i],	0x90000000, 0x90000000)
	gui.drawBox(00+buttonsx[i]+displayx[i], 00+buttonsy[i]+displayy[i], buttongridwidth[i]+11+buttonsx[i]+displayx[i],  08+buttonsy[i]+displayy[i], 0x90000000, 0x90000000)

--Background Grid Lines (D-Pad)
	gui.drawBox(13+dpadx[i]+displayx[i], 00+dpady[i]+displayy[i], dpadgridwidth[i]+11+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i], 0x80181818, 0x80181818)
	gui.drawBox(13+dpadx[i]+displayx[i], 02+dpady[i]+displayy[i], dpadgridwidth[i]+11+dpadx[i]+displayx[i], 03+dpady[i]+displayy[i], 0x80303030, 0x80303030)
	gui.drawBox(13+dpadx[i]+displayx[i], 06+dpady[i]+displayy[i], dpadgridwidth[i]+11+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i], 0x80303030, 0x80303030)

--Background Grid Lines (Buttons)
	gui.drawBox(13+buttonsx[i]+displayx[i], 00+buttonsy[i]+displayy[i], buttongridwidth[i]+11+buttonsx[i]+displayx[i], 01+buttonsy[i]+displayy[i], 0x80181818, 0x80181818)
	gui.drawBox(13+buttonsx[i]+displayx[i], 02+buttonsy[i]+displayy[i], buttongridwidth[i]+11+buttonsx[i]+displayx[i], 03+buttonsy[i]+displayy[i], 0x80303030, 0x80303030)
	gui.drawBox(13+buttonsx[i]+displayx[i], 04+buttonsy[i]+displayy[i], buttongridwidth[i]+11+buttonsx[i]+displayx[i], 05+buttonsy[i]+displayy[i], 0x80181818, 0x80181818)
	gui.drawBox(13+buttonsx[i]+displayx[i], 06+buttonsy[i]+displayy[i], buttongridwidth[i]+11+buttonsx[i]+displayx[i], 07+buttonsy[i]+displayy[i], 0x80303030, 0x80303030)

--D-Pad
	gui.drawBox(05+dpadx[i]+displayx[i], 04+dpady[i]+displayy[i], 06+dpadx[i]+displayx[i], 05+dpady[i]+displayy[i], buttoncolorp[i][1][1], buttoncolorp[i][1][1])
	gui.drawBox(05+dpadx[i]+displayx[i], 02+dpady[i]+displayy[i], 06+dpadx[i]+displayx[i], 03+dpady[i]+displayy[i], colordisplayup, colordisplayup)
	gui.drawBox(05+dpadx[i]+displayx[i], 06+dpady[i]+displayy[i], 06+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i], colordisplaydown, colordisplaydown)
	gui.drawBox(03+dpadx[i]+displayx[i], 04+dpady[i]+displayy[i], 04+dpadx[i]+displayx[i], 05+dpady[i]+displayy[i], colordisplayleft, colordisplayleft)
	gui.drawBox(07+dpadx[i]+displayx[i], 04+dpady[i]+displayy[i], 08+dpadx[i]+displayx[i], 05+dpady[i]+displayy[i], colordisplayright, colordisplayright)

--Button Border (the light grey outline around the buttons themselves.
	gui.drawPixel(01+buttonsx[i]+displayx[i], 05+buttonsy[i]+displayy[i], buttonborder) 
	gui.drawPixel(04+buttonsx[i]+displayx[i], 08+buttonsy[i]+displayy[i], buttoncolorp[i][1][1]) 
	gui.drawLine(02+buttonsx[i]+displayx[i], 06+buttonsy[i]+displayy[i],03+buttonsx[i]+displayx[i], 06+buttonsy[i]+displayy[i], buttonborder) 
	gui.drawEllipse(01+buttonsx[i]+displayx[i], 02+buttonsy[i]+displayy[i], 4, 3, buttonborder, buttonborder) 
	gui.drawEllipse(02+buttonsx[i]+displayx[i], 01+buttonsy[i]+displayy[i], 3, 4, buttonborder, buttonborder) 
	gui.drawEllipse(03+buttonsx[i]+displayx[i], 00+buttonsy[i]+displayy[i], 3, 4, buttonborder, buttonborder) 
	gui.drawEllipse(04+buttonsx[i]+displayx[i], 00+buttonsy[i]+displayy[i], 3, 3, buttonborder, buttonborder) 

	gui.drawEllipse(04+buttonsx[i]+displayx[i], 05+buttonsy[i]+displayy[i], 4, 3, buttonborder, buttonborder) 
	gui.drawEllipse(05+buttonsx[i]+displayx[i], 04+buttonsy[i]+displayy[i], 3, 4, buttonborder, buttonborder) 
	gui.drawEllipse(06+buttonsx[i]+displayx[i], 03+buttonsy[i]+displayy[i], 3, 4, buttonborder, buttonborder) 
	gui.drawEllipse(07+buttonsx[i]+displayx[i], 03+buttonsy[i]+displayy[i], 3, 3, buttonborder, buttonborder) 

--Buttons
	gui.drawEllipse(07+buttonsx[i]+displayx[i], 03+buttonsy[i]+displayy[i], 2, 3, colordisplaya, colordisplaya) 
	gui.drawEllipse(04+buttonsx[i]+displayx[i], 05+buttonsy[i]+displayy[i], 2, 3, colordisplayb, colordisplayb) 
	gui.drawEllipse(04+buttonsx[i]+displayx[i], 00+buttonsy[i]+displayy[i], 2, 3, colordisplayx, colordisplayx) 
	gui.drawEllipse(01+buttonsx[i]+displayx[i], 02+buttonsy[i]+displayy[i], 2, 3, colordisplayy, colordisplayy) 


--Shoulder buttons
	gui.drawBox(02+dpadx[i]+displayx[i], 00+dpady[i]+displayy[i], 04+dpadx[i]+displayx[i], 00+dpady[i]+displayy[i], colordisplayl, colordisplayl)
	gui.drawBox(07+dpadx[i]+displayx[i], 00+dpady[i]+displayy[i], 09+dpadx[i]+displayx[i], 00+dpady[i]+displayy[i], colordisplayr, colordisplayr)

	gui.drawBox(01+dpadx[i]+displayx[i], 01+dpady[i]+displayy[i], 01+dpadx[i]+displayx[i], 01+dpady[i]+displayy[i], colordisplayl, colordisplayl)
	gui.drawBox(10+dpadx[i]+displayx[i], 01+dpady[i]+displayy[i], 10+dpadx[i]+displayx[i], 01+dpady[i]+displayy[i], colordisplayr, colordisplayr)

--Select
	gui.drawLine(01+dpadx[i]+displayx[i], 08+dpady[i]+displayy[i], 02+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i], colordisplayselect)
	gui.drawLine(02+dpadx[i]+displayx[i], 08+dpady[i]+displayy[i], 03+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i], colordisplayselect)

--Start
	gui.drawLine(08+dpadx[i]+displayx[i], 08+dpady[i]+displayy[i], 09+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i], colordisplaystart)
	gui.drawLine(09+dpadx[i]+displayx[i], 08+dpady[i]+displayy[i], 10+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i], colordisplaystart)


	for k = 1, dpadgridwidth[i], 1 do
		
		if k%05 == 1 then gui.drawLine(k+11+dpadx[i]+displayx[i], 00+dpady[i]+displayy[i], k+11+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i], 0xFF404040 + (k%25 == 1 and 0x00404040 or 0)) end

-- L and R
		buttonpressp[i][1][1] = (buttonpressp[i][1][1] + 1) * (inputtracklocalp[i][09][k+inputoffset[i]] and inputtracklocalp[i][10][k+inputoffset[i]] == false and 1 or 0)
		buttonpressp[i][1][2] = (buttonpressp[i][1][2] + 1) * (inputtracklocalp[i][10][k+inputoffset[i]] and inputtracklocalp[i][09][k+inputoffset[i]] == false and 1 or 0)
		buttonpressp[i][1][3] = (buttonpressp[i][1][3] + 1) * ( (inputtracklocalp[i][9][k+inputoffset[i]] and inputtracklocalp[i][10][k+inputoffset[i]]) and 1 or 0)

	--If (L is pressed and R isn't) and (either L wasn't pressed a tick earlier) or (R is being pressed and wasn't being pressed a tick earlier) or the grid ends, draw a square with L's color backwards with a length equal to the amount of time that only L was held without R)
		if (inputtracklocalp[i][09][k+inputoffset[i]] and inputtracklocalp[i][10][k+inputoffset[i]] == false) and (inputtracklocalp[i][09][k+inputoffset[i]+1] == false or (inputtracklocalp[i][10][k+inputoffset[i]] == false and inputtracklocalp[i][10][k+inputoffset[i]+1])  or k == dpadgridwidth[i]) then
			local colora = buttoncolorp[i][2][9] - 0x30000000
			gui.drawBox(k+11+dpadx[i]+displayx[i]-buttonpressp[i][1][1]+1, 00+dpady[i]+displayy[i], k+11+dpadx[i]+displayx[i], 01+dpady[i]+displayy[i],  colora, colora)
	--Same as previous If, except swap all cases of L and R
		elseif (inputtracklocalp[i][10][k+inputoffset[i]] and inputtracklocalp[i][09][k+inputoffset[i]] == false) and (inputtracklocalp[i][10][k+inputoffset[i]+1] == false or (inputtracklocalp[i][09][k+inputoffset[i]] == false and inputtracklocalp[i][09][k+inputoffset[i]+1])  or k == dpadgridwidth[i]) then
			local colorb = buttoncolorp[i][2][10] - 0x30000000
			gui.drawBox(k+11+dpadx[i]+displayx[i]-buttonpressp[i][1][2]+1, 00+dpady[i]+displayy[i], k+11+dpadx[i]+displayx[i], 01+dpady[i]+displayy[i],  colorb, colorb) 
	-- elseif Both L and R are pressed, and either L or R wasn't pressed a tick earlier or the grid runs out of room, draw a Square with both L and R colors mixed with a length equal to the amount of times both buttons were held.
		elseif (inputtracklocalp[i][10][k+inputoffset[i]] and inputtracklocalp[i][09][k+inputoffset[i]]) and 
		((inputtracklocalp[i][10][k+inputoffset[i]+1] == false or inputtracklocalp[i][09][k+inputoffset[i]+1] == false) or 
		k == dpadgridwidth[i]) then
			local colorc = buttoncolorp[i][2][9] - 0xFF000000 + buttoncolorp[i][2][10] - 0x30000000
			gui.drawBox(k+11+dpadx[i]+displayx[i]-buttonpressp[i][1][3]+1, 00+dpady[i]+displayy[i], k+11+dpadx[i]+displayx[i], 01+dpady[i]+displayy[i],  colorc, colorc) 		
		end

-- Up			
		buttonpressp[i][2][1] = (buttonpressp[i][2][1] + 1) * (inputtracklocalp[i][1][k+inputoffset[i]] and 1 or 0)
		if inputtracklocalp[i][1][k+inputoffset[i]] and (inputtracklocalp[i][1][k+inputoffset[i]+1] == false or k == dpadgridwidth[i]) then
			local color = buttoncolorp[i][2][2] - 0x30000000
			gui.drawBox(k+11+dpadx[i]+displayx[i]-buttonpressp[i][2][1]+1, 02+dpady[i]+displayy[i], k+11+dpadx[i]+displayx[i], 03+dpady[i]+displayy[i],  color, color) 
		end

-- Left and Right
		buttonpressp[i][3][1] = (buttonpressp[i][3][1] + 1) * (inputtracklocalp[i][3][k+inputoffset[i]] and 1 or 0)
		buttonpressp[i][3][2] = (buttonpressp[i][3][2] + 1) * (inputtracklocalp[i][4][k+inputoffset[i]] and 1 or 0)

		if inputtracklocalp[i][3][k+inputoffset[i]] and (inputtracklocalp[i][3][k+inputoffset[i]+1] == false or k == dpadgridwidth[i]) then
			local colora = buttoncolorp[i][2][3] - 0x50000000
			gui.drawBox(k+11+dpadx[i]+displayx[i]-buttonpressp[i][3][1]+1, 04+dpady[i]+displayy[i], k+11+dpadx[i]+displayx[i], 05+dpady[i]+displayy[i],  colora, colora)
		end
		if inputtracklocalp[i][4][k+inputoffset[i]] and (inputtracklocalp[i][4][k+inputoffset[i]+1] == false or k == dpadgridwidth[i]) then
			local colorb = buttoncolorp[i][2][4] - 0x50000000
			gui.drawBox(k+11+dpadx[i]+displayx[i]-buttonpressp[i][3][2]+1, 04+dpady[i]+displayy[i], k+11+dpadx[i]+displayx[i], 05+dpady[i]+displayy[i],  colorb, colorb) 
		end

-- Down
		buttonpressp[i][4][1] = (buttonpressp[i][4][1] + 1) * (inputtracklocalp[i][2][k+inputoffset[i]] and 1 or 0)
		if inputtracklocalp[i][2][k+inputoffset[i]] and (inputtracklocalp[i][2][k+inputoffset[i]+1] == false or k == dpadgridwidth[i]) then
			local color = buttoncolorp[i][2][2] - 0x30000000
			gui.drawBox(k+11+dpadx[i]+displayx[i]-buttonpressp[i][4][1]+1, 06+dpady[i]+displayy[i], k+11+dpadx[i]+displayx[i], 07+dpady[i]+displayy[i],  color, color) 
		end

	end

	for k = 1, buttongridwidth[i], 1 do

		if k%05 == 1 then gui.drawLine(k+11+buttonsx[i]+displayx[i], 00+buttonsy[i]+displayy[i], k+11+buttonsx[i]+displayx[i], 07+buttonsy[i]+displayy[i], 0xFF404040 + (k%25 == 1 and 0x00404040 or 0)) end

-- X
		buttonpressp[i][5][1] = (buttonpressp[i][5][1] + 1) * (inputtracklocalp[i][7][k+inputoffset[i]] and 1 or 0)
		if inputtracklocalp[i][7][k+inputoffset[i]] and (inputtracklocalp[i][7][k+inputoffset[i]+1] == false or k == dpadgridwidth[i]) then
			local color = buttoncolorp[i][1][7] - 0x30000000
			gui.drawBox(k+11+buttonsx[i]+displayx[i]-buttonpressp[i][5][1]+1, 00+buttonsy[i]+displayy[i], k+11+buttonsx[i]+displayx[i], 01+buttonsy[i]+displayy[i],  color, color) 
		end

-- Y
		buttonpressp[i][6][1] = (buttonpressp[i][6][1] + 1) * (inputtracklocalp[i][8][k+inputoffset[i]] and 1 or 0)
		if inputtracklocalp[i][8][k+inputoffset[i]] and (inputtracklocalp[i][8][k+inputoffset[i]+1] == false or k == dpadgridwidth[i]) then
			local color = buttoncolorp[i][1][8] - 0x30000000
			gui.drawBox(k+11+buttonsx[i]+displayx[i]-buttonpressp[i][6][1]+1, 02+buttonsy[i]+displayy[i], k+11+buttonsx[i]+displayx[i], 03+buttonsy[i]+displayy[i],  color, color) 
		end

-- A
		buttonpressp[i][7][1] = (buttonpressp[i][7][1] + 1) * (inputtracklocalp[i][5][k+inputoffset[i]] and 1 or 0)
		if inputtracklocalp[i][5][k+inputoffset[i]] and (inputtracklocalp[i][5][k+inputoffset[i]+1] == false or k == dpadgridwidth[i]) then
			local color = buttoncolorp[i][1][5] - 0x30000000
			gui.drawBox(k+11+buttonsx[i]+displayx[i]-buttonpressp[i][7][1]+1, 04+buttonsy[i]+displayy[i], k+11+buttonsx[i]+displayx[i], 05+buttonsy[i]+displayy[i],  color, color) 
		end

-- B
		buttonpressp[i][8][1] = (buttonpressp[i][8][1] + 1) * (inputtracklocalp[i][6][k+inputoffset[i]] and 1 or 0)
		if inputtracklocalp[i][6][k+inputoffset[i]] and (inputtracklocalp[i][6][k+inputoffset[i]+1] == false or k == dpadgridwidth[i]) then
			local color = buttoncolorp[i][1][6] - 0x30000000
			gui.drawBox(k+11+buttonsx[i]+displayx[i]-buttonpressp[i][8][1]+1, 06+buttonsy[i]+displayy[i], k+11+buttonsx[i]+displayx[i], 07+buttonsy[i]+displayy[i],  color, color) 
		end
	
	end
end
-- Input Display END

end


local function pausemenu()
	
	local menulength = 5
	local menuoffsetx = -16
	local menuoffsety = 24 + (-menulength * 4)
	
	if buttonp1down == 1 then
		menuselect = menuselect + 1
		if menuselect > menulength then
			menuselect = 1
		end
	elseif buttonp1up == 1 then
		menuselect = menuselect - 1
		if menuselect < 1 then
			menuselect = menulength
		end
	end

	if buttonp2down == 1 then
		menuselect = menuselect + 1
		if menuselect > menulength then
			menuselect = 1
		end
	elseif buttonp2up == 1 then
		menuselect = menuselect - 1
		if menuselect < 1 then
			menuselect = menulength
		end
	end

	local pausemenulabels = {}
	pausemenulabels[1]  = "Recover HP"
	pausemenulabels[2]  = "Hitboxes"
	pausemenulabels[3]  = "Combo Counter"
	pausemenulabels[4]  = "Damage Display"
	pausemenulabels[5]  = "Input Display"
	pausemenulabels[6]  = "Disable Lifebar Display"
	pausemenulabels[7]  = "Disable Vulcans"
	pausemenulabels[8]  = "Show Inputs"
	pausemenulabels[9]  = "Hide Damage"
	pausemenulabels[10] = "Character Select"
	pausemenulabels[11] = "Stage Select/Restart Match"
	
--	if menuselect == 8 then
--		memory.usememorydomain("APURAM")
--		if volume < 255 and (buttonp1right > 0 or buttonp2right > 0) then
--			volume = volume + 1
--			memory.write_u8(0x0C, volume)
--		elseif volume > 0 and (buttonp1left > 0 or buttonp2left > 0) then
--			volume = volume - 1
--			memory.write_u8(0x0C, volume)
--		end
--		gui.pixelText( menuoffsetx + 94, menuoffsety + 80 + (8*8), volume, 0xFFFF0000, 0x40000000)
--		memory.usememorydomain("WRAM")
--	end

	if buttonp1a == 1 then
		option[menuselect] = option[menuselect]	* -1
	end
	if buttonp2a == 1 then
		option[menuselect] = option[menuselect]	* -1
	end
	
	for i = 1,menulength, 1 do
		if menuselect == i then
			textcolor 	= 0xFF00AAFF
			textback	= 0x00000000
		else
			textcolor 	= 0xFFFFFFFF
			textback	= 0x00000000			
		end
		gui.pixelText( menuoffsetx + 112, menuoffsety + 80 + (i*8), pausemenulabels[i], textcolor, textback)
		if option[i] == 1 then
			gui.pixelText( menuoffsetx + 104, menuoffsety + 80 + (i*8), "O", 0xFFFF0000, 0x00000000)
		end

	if option[10] == 1 then 
		mainmemory.write_u8(0x000000, 0)
		characterselect[1] = 1
		option[10] = -1
	end

	if option[11] == 1 then 
		mainmemory.write_u8(0x000000, 0)
		characterselect[1] = 2
		option[11] = -1
	end
		
	end
end

local function settings()
	if option[1] == 1 then
		mainmemory.write_s16_le(0x1B70, 1807*16)
		mainmemory.write_s16_le(0x1B74, 1807*16)
	end
	if option[2] == 1 then
		mainmemory.write_s16_le(0x1B80, 300)
		mainmemory.write_s16_le(0x1B84, 300)		
	end	
--	if option[3] == 1 then
--		memory.usememorydomain("APURAM")
--		mainmemory.write_u8(0x000C, 0)
--		memory.usememorydomain("WRAM")
--	elseif option[3] == -1 then
--		memory.usememorydomain("APURAM")
--		if pause < 0 then
--			mainmemory.write_u8(0x000C, 128)
--		else
--			mainmemory.write_u8(0x000C, 255)
--		end
--		memory.usememorydomain("WRAM")	
--	end
	if option[3] == 1 then 
		mainmemory.write_u8(0xFF02, 2)
	elseif option[3] == -1 then
		mainmemory.write_u8(0xFF02, 0)	
	end

--	if option[4] == 1 then
--		
--	end
end

while true do
	gui.drawBox(0,0,0,0, 0x00000000, 0x00000000)
	globals()
	inputpress()
	inputframe()
	inputpresses()

	if inamatch then
--	if drawhitbox[1] == drawhitbox[2] + 2 or drawhitbox[1] == 0 and drawhitbox[2] == 62 then	
	if gamepause and inamatch and brightness == 7 then 
		pausemenu()
		gui.drawText( 102, 64, "Pause", 0xFFFF8000, 0x20000000) 
	end
	if option[3] == 01 then combocounter() end
	if option[1] == 01 then setHP() end
	if option[2] == 01 then playertest() end
	if option[4] == 01 then damagedisplay() end
	end

	inputdisplayoptions() 
			for i = 1, 2, 1 do
				inputpausep[i] = inputpausep[i] * (inputframep[i][12][1] == true and inputframep[i][12][2] == false and -1 or 1)
				if inputpausep[i] == 1 then
					inputoffset[i] = ((inputoffset[i] + (inputframep[i][10][1] and -1 or 0) + (inputframep[i][9][1] and 1 or 0))) 
					if inputoffset[i] > totalinputframes then
						inputoffset[i] = totalinputframes
					elseif inputoffset[i] < 0 then
						inputoffset[i] = 0
					end
				end
			end
			if inputpausep[1] == -1 then inputoffset[1] = 0; inputtrack1() end
			if inputpausep[2] == -1 then inputoffset[2] = 0; inputtrack2() end
	if option[5] == 01 then drawbuttons() end
	lateglobals()
	emu.frameadvance()
end
